/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.OvershootInterpolator;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import coil.request.ErrorResult;
import coil.request.ImageRequest;
import coil.request.SuccessResult;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.lib.interfaces.ConversationRatingBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.lib.models.ConversationRating;
import io.intercom.android.sdk.blocks.lib.models.ConversationRatingOption;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.components.IntercomPrimaryButton;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import io.intercom.android.sdk.utilities.commons.ScreenUtils;
import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class ConversationRatingCard
implements ConversationRatingBlock {
    private static final float SELECTED_RATING_SCALE = 1.2f;
    private static final float DESELECTED_RATING_SCALE = 1.0f;
    private static final float RATING_HORIZONTAL_PADDING = 17.0f;
    private static final float RATING_VERTICAL_PADDING = 14.0f;
    private static final float DIALOG_HORIZONTAL_MARGIN = 16.0f;
    private static final long ANIMATION_DURATION_MS = 200L;
    private final Api api;
    private final String conversationId;
    private final Provider<AppConfig> appConfigProvider;
    private final ColorFilter deselectedFilter;
    private final List<ImageView> ratingViews;
    private LinearLayout rootLayout;
    private ConversationRating conversationRating;
    private final View.OnClickListener ratingClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            int viewIndex = ConversationRatingCard.this.ratingViews.indexOf(v);
            if (viewIndex == -1 || ConversationRatingCard.this.ratingViews.size() != ConversationRatingCard.this.conversationRating.getOptions().size()) {
                return;
            }
            ConversationRatingCard.this.rateConversation(ConversationRatingCard.this.conversationRating, ConversationRatingCard.this.conversationRating.getOptions().get(viewIndex));
            ConversationRatingCard.this.updateSelectedRating();
        }
    };

    ConversationRatingCard(Api api, String conversationId2, Provider<AppConfig> appConfigProvider) {
        this.api = api;
        this.conversationId = conversationId2;
        this.appConfigProvider = appConfigProvider;
        this.ratingViews = new ArrayList<ImageView>();
        this.deselectedFilter = ColorUtils.newGreyscaleFilter();
    }

    @Override
    public View addConversationRatingBlock(ConversationRating conversationRating, BlockMetadata blockMetadata, ViewGroup parent) {
        return this.createConversationRatingBlock(conversationRating, parent);
    }

    private View createConversationRatingBlock(ConversationRating conversationRating, ViewGroup parent) {
        Context context = parent.getContext();
        this.ratingViews.clear();
        this.conversationRating = conversationRating;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.rootLayout = (LinearLayout)layoutInflater.inflate(R.layout.intercom_conversation_rating_block, parent, false);
        this.updateViewVisibility();
        IntercomPrimaryButton tellUsMoreButton = (IntercomPrimaryButton)this.rootLayout.findViewById(R.id.intercom_rating_tell_us_more_button);
        tellUsMoreButton.setText(context.getString(R.string.intercom_tell_us_more));
        tellUsMoreButton.setOnClick((Function0<Unit>)((Function0)() -> {
            this.showRemarkDialog(context);
            return null;
        }));
        this.setupRatingsLayout();
        this.updateSelectedRating();
        return this.rootLayout;
    }

    private void setupRatingsLayout() {
        LinearLayout ratingsLayout = (LinearLayout)this.rootLayout.findViewById(R.id.intercom_rating_options_layout);
        Context context = this.rootLayout.getContext();
        int verticalMargin = ScreenUtils.dpToPx(14.0f, context);
        int horizontalMargin = ScreenUtils.dpToPx(17.0f, context);
        for (int i = 0; i < this.conversationRating.getOptions().size(); ++i) {
            ConversationRatingOption option = this.conversationRating.getOptions().get(i);
            FrameLayout frameLayout = new FrameLayout(context);
            frameLayout.setClipChildren(false);
            frameLayout.setClipToPadding(false);
            frameLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            ImageView ratingView = new ImageView(context);
            int imageSizePx = context.getResources().getDimensionPixelSize(R.dimen.intercom_conversation_rating_size);
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(imageSizePx, imageSizePx, 17);
            layoutParams.setMargins(horizontalMargin, verticalMargin, horizontalMargin, verticalMargin);
            ratingView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            ratingView.setLongClickable(false);
            this.loadEmojiWithFallback(context, option.getUnicode(), ratingView);
            ratingView.setOnClickListener(this.ratingClickListener);
            frameLayout.addView((View)ratingView);
            ratingsLayout.addView((View)frameLayout);
            this.ratingViews.add(ratingView);
        }
    }

    private void updateViewVisibility() {
        if (this.rootLayout == null) {
            return;
        }
        boolean hasRating = this.conversationRating.getRatingIndex() != -1;
        boolean hasRemark = !TextUtils.isEmpty((CharSequence)this.conversationRating.getRemark());
        TextView rateYourConversationTextView = (TextView)this.rootLayout.findViewById(R.id.rate_your_conversation_text_view);
        rateYourConversationTextView.setVisibility(hasRemark ? 8 : 0);
        LinearLayout ratingsLayout = (LinearLayout)this.rootLayout.findViewById(R.id.intercom_rating_options_layout);
        ratingsLayout.setVisibility(hasRemark ? 8 : 0);
        IntercomPrimaryButton tellUsMoreButton = (IntercomPrimaryButton)this.rootLayout.findViewById(R.id.intercom_rating_tell_us_more_button);
        tellUsMoreButton.setVisibility(!hasRating || hasRemark ? 8 : 0);
        LinearLayout youRatedLayout = (LinearLayout)this.rootLayout.findViewById(R.id.intercom_you_rated_layout);
        youRatedLayout.setVisibility(hasRemark ? 0 : 8);
        ConversationRatingOption selectedOption = this.findSelectedOption();
        if (selectedOption != null) {
            ImageView imageView = (ImageView)this.rootLayout.findViewById(R.id.intercom_you_rated_image_view);
            this.loadEmojiWithFallback(imageView.getContext(), selectedOption.getUnicode(), imageView);
        }
    }

    @Nullable
    private ConversationRatingOption findSelectedOption() {
        for (ConversationRatingOption option : this.conversationRating.getOptions()) {
            if (!option.getIndex().equals(this.conversationRating.getRatingIndex())) continue;
            return option;
        }
        return null;
    }

    @VisibleForTesting
    void rateConversation(ConversationRating conversationRating, ConversationRatingOption conversationRatingOption) {
        if (conversationRating.getRatingIndex().equals(conversationRatingOption.getIndex())) {
            return;
        }
        conversationRating.setRatingIndex(conversationRatingOption.getIndex());
        this.api.rateConversation(this.conversationId, conversationRatingOption.getIndex());
        this.updateViewVisibility();
    }

    @VisibleForTesting
    void addRemarkToConversation(ConversationRating conversationRating, String remark) {
        if (!TextUtils.isEmpty((CharSequence)conversationRating.getRemark())) {
            return;
        }
        conversationRating.setRemark(remark);
        this.api.addConversationRatingRemark(this.conversationId, remark);
        this.updateViewVisibility();
    }

    private void updateSelectedRating() {
        if (this.conversationRating.getOptions().size() != this.ratingViews.size()) {
            return;
        }
        for (int i = 0; i < this.conversationRating.getOptions().size(); ++i) {
            ConversationRatingOption option = this.conversationRating.getOptions().get(i);
            ImageView ratingView = this.ratingViews.get(i);
            if (this.conversationRating.getRatingIndex() == -1) {
                this.selectView(1.0f, ratingView);
                continue;
            }
            if (this.conversationRating.getRatingIndex().equals(option.getIndex())) {
                this.selectView(1.2f, ratingView);
                continue;
            }
            this.deselectView(ratingView);
        }
    }

    private void showRemarkDialog(Context context) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(R.string.intercom_tell_us_more);
        LinearLayout container = new LinearLayout(context);
        container.setOrientation(1);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        int horizontalMargin = ScreenUtils.dpToPx(16.0f, context);
        lp.setMargins(horizontalMargin, 0, horizontalMargin, 0);
        final EditText input = new EditText(context);
        if (input.getBackground() != null) {
            input.getBackground().mutate().setColorFilter(this.appConfigProvider.get().getPrimaryColor(), PorterDuff.Mode.SRC_ATOP);
        }
        input.setLayoutParams((ViewGroup.LayoutParams)lp);
        container.addView((View)input);
        builder.setView((View)container);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String remark = input.getText().toString();
                ConversationRatingCard.this.addRemarkToConversation(ConversationRatingCard.this.conversationRating, remark);
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.cancel();
            }
        });
        final AlertDialog alert = builder.create();
        alert.show();
        input.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                if (hasFocus && alert.getWindow() != null) {
                    alert.getWindow().setSoftInputMode(5);
                }
            }
        });
        Button okayButton = alert.getButton(-1);
        okayButton.setTextColor(this.appConfigProvider.get().getPrimaryColor());
        Button cancelButton = alert.getButton(-2);
        cancelButton.setTextColor(this.appConfigProvider.get().getPrimaryColor());
    }

    private void selectView(float scale, ImageView ratingView) {
        ratingView.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(2.0f)).scaleX(scale).scaleY(scale).setDuration(200L).start();
        ratingView.clearColorFilter();
    }

    private void deselectView(ImageView ratingView) {
        ratingView.animate().setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).scaleX(1.0f).scaleY(1.0f).setDuration(200L).start();
        ratingView.setColorFilter(this.deselectedFilter);
    }

    private static String imageUrlForUnicode(String unicode) {
        return "https://js.intercomcdn.com/images/stickers/" + unicode + ".png";
    }

    @DrawableRes
    @VisibleForTesting
    static int getEmojiDrawableForUnicode(String unicode) {
        if (unicode == null) {
            return 0;
        }
        switch (unicode) {
            case "1f620": {
                return R.drawable.intercom_reaction_angry;
            }
            case "1f615": {
                return R.drawable.intercom_reaction_sad;
            }
            case "1f610": {
                return R.drawable.intercom_reaction_neutral;
            }
            case "1f603": {
                return R.drawable.intercom_reaction_happy;
            }
            case "1f929": {
                return R.drawable.intercom_reaction_star_struck;
            }
        }
        return 0;
    }

    private void loadEmojiWithFallback(Context context, final String unicode, final ImageView imageView) {
        String imageUrl = ConversationRatingCard.imageUrlForUnicode(unicode);
        ImageRequest imageRequest = new ImageRequest.Builder(context).data((Object)imageUrl).target(imageView).listener(new ImageRequest.Listener(){

            public void onStart(@NonNull ImageRequest imageRequest) {
            }

            public void onCancel(@NonNull ImageRequest imageRequest) {
            }

            public void onError(@NonNull ImageRequest imageRequest, @NonNull ErrorResult errorResult) {
                int drawableRes = ConversationRatingCard.getEmojiDrawableForUnicode(unicode);
                if (drawableRes != 0) {
                    imageView.setImageResource(drawableRes);
                }
            }

            public void onSuccess(@NonNull ImageRequest imageRequest, @NonNull SuccessResult successResult) {
            }
        }).build();
        IntercomCoilKt.loadIntercomImage(context, imageRequest);
    }
}

