/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.logger.LumberMill;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"extractErrorString", "", "errorObject", "Lio/intercom/android/sdk/api/ErrorObject;", "extractErrorFromElement", "errorElement", "Lcom/google/gson/JsonElement;", "extractErrorFromJsonArray", "jsonArray", "Lcom/google/gson/JsonArray;", "extractErrorFromJsonObject", "jsonObject", "Lcom/google/gson/JsonObject;", "intercom-sdk-base_release"})
public final class ErrorStringExtractorKt {
    @NotNull
    public static final String extractErrorString(@NotNull ErrorObject errorObject) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)errorObject, (String)"errorObject");
        Twig twig = LumberMill.getLogger();
        if (errorObject.hasErrorBody() && errorObject.getErrorBody() != null) {
            JsonObject jsonObject;
            try {
                JsonObject jsonObject2 = (JsonObject)Injector.get().getGson().fromJson(errorObject.getErrorBody(), JsonObject.class);
                if (jsonObject2 == null) {
                    return "Something went wrong";
                }
                jsonObject = jsonObject2;
            }
            catch (Exception e) {
                twig.e((Throwable)e);
                Object object = errorObject.getThrowable();
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    object = "Something went wrong";
                }
                return object;
            }
            JsonObject jsonObject3 = jsonObject;
            if (jsonObject3.has("error")) {
                JsonElement jsonElement = jsonObject3.get("error");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                string2 = ErrorStringExtractorKt.extractErrorFromElement(jsonElement);
            } else if (jsonObject3.has("errors")) {
                JsonArray jsonArray = jsonObject3.getAsJsonArray("errors");
                Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
                string2 = ErrorStringExtractorKt.extractErrorFromJsonArray(jsonArray);
            } else {
                string2 = "Something went wrong";
            }
        } else {
            string2 = "Something went wrong";
        }
        return string2;
    }

    private static final String extractErrorFromElement(JsonElement errorElement) {
        String string2;
        if (errorElement.isJsonPrimitive()) {
            String string3 = errorElement.getAsString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAsString(...)");
        } else if (errorElement.isJsonArray()) {
            JsonArray jsonArray = errorElement.getAsJsonArray();
            Intrinsics.checkNotNullExpressionValue((Object)jsonArray, (String)"getAsJsonArray(...)");
            string2 = ErrorStringExtractorKt.extractErrorFromJsonArray(jsonArray);
        } else if (errorElement.isJsonObject()) {
            JsonObject jsonObject = errorElement.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            string2 = ErrorStringExtractorKt.extractErrorFromJsonObject(jsonObject);
        } else {
            string2 = "Something went wrong";
        }
        return string2;
    }

    private static final String extractErrorFromJsonArray(JsonArray jsonArray) {
        return CollectionsKt.joinToString$default((Iterable)((Iterable)jsonArray), (CharSequence)" - ", null, null, (int)0, null, ErrorStringExtractorKt::extractErrorFromJsonArray$lambda$0, (int)30, null);
    }

    private static final String extractErrorFromJsonObject(JsonObject jsonObject) {
        String string2;
        if (jsonObject.has("message")) {
            String string3 = jsonObject.get("message").getAsString();
            Intrinsics.checkNotNull((Object)string3);
            string2 = string3;
        } else {
            string2 = "Something went wrong";
        }
        return string2;
    }

    private static final CharSequence extractErrorFromJsonArray$lambda$0(JsonElement it) {
        CharSequence charSequence;
        if (it.isJsonPrimitive()) {
            String string2 = it.getAsString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
            charSequence = string2;
        } else if (it.isJsonObject()) {
            JsonObject jsonObject = it.getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
            charSequence = ErrorStringExtractorKt.extractErrorFromJsonObject(jsonObject);
        } else {
            charSequence = "Something went wrong";
        }
        return charSequence;
    }
}

