/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.persistence;

import androidx.annotation.WorkerThread;
import com.google.gson.Gson;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.utilities.IoUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class JsonStorage {
    private static final Twig TWIG = LumberMill.getLogger();
    private final Gson gson;

    public JsonStorage(Gson gson) {
        this.gson = gson;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public <T> void loadThenDelete(File file, Class<T> clazz, LoadHandler<T> loadHandler) {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            loadHandler.onLoad(this.gson.fromJson((Reader)reader, clazz));
        }
        catch (Exception exception) {
        }
        finally {
            IoUtils.safelyDelete(file);
            IoUtils.closeQuietly(reader);
        }
    }

    @WorkerThread
    public <T> void loadFilesInDirectory(File directory, Class<T> clazz, LoadHandler<List<T>> loadHandler) {
        this.loadFilesInDirectory(directory, clazz, loadHandler, LoadFailureHandler.NONE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public <T> void loadFilesInDirectory(File directory, Class<T> clazz, LoadHandler<List<T>> loadHandler, LoadFailureHandler failureHandler) {
        FileReader reader = null;
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        ArrayList<Object> objects = new ArrayList<Object>(files.length);
        for (File file : files) {
            try {
                reader = new FileReader(file);
                objects.add(this.gson.fromJson((Reader)reader, clazz));
            }
            catch (Exception e) {
                try {
                    failureHandler.onLoadFailed(file, e);
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(reader);
                    throw throwable;
                }
                IoUtils.closeQuietly(reader);
                continue;
            }
            IoUtils.closeQuietly(reader);
        }
        loadHandler.onLoad(objects);
    }

    @WorkerThread
    public int getDirectoryFileCount(File directory) {
        String[] fileList = directory.list();
        return fileList == null ? 0 : fileList.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public void saveToFileAsJson(Object object, File file) {
        FileWriter writer = null;
        try {
            if (file.exists() && !file.delete()) {
                throw new RuntimeException("Couldn't delete existing file at " + file.getAbsolutePath());
            }
            File parentDir = file.getParentFile();
            if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                throw new RuntimeException("Couldn't create missing parent dir at " + parentDir.getAbsolutePath());
            }
            writer = new FileWriter(file);
            this.gson.toJson(object, (Appendable)writer);
        }
        catch (Exception e) {
            try {
                TWIG.internal("Couldn't save file to disk: " + e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(writer);
                throw throwable;
            }
            IoUtils.closeQuietly(writer);
        }
        IoUtils.closeQuietly(writer);
    }

    public static interface LoadHandler<T> {
        public void onLoad(T var1);
    }

    public static interface LoadFailureHandler {
        public static final LoadFailureHandler NONE = new LoadFailureHandler(){

            @Override
            public void onLoadFailed(File file, Exception e) {
            }
        };

        public void onLoadFailed(File var1, Exception var2);
    }
}

