/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_Attachments;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class Attachments
implements Parcelable {
    public static final Parcelable.Creator<Attachments> CREATOR = new Parcelable.Creator<Attachments>(){

        public Attachments createFromParcel(Parcel in) {
            String name = in.readString();
            String url = in.readString();
            String contentType = in.readString();
            String humanFileSize = in.readString();
            return Attachments.create(name, url, contentType, humanFileSize);
        }

        public Attachments[] newArray(int size) {
            return new Attachments[size];
        }
    };

    static Attachments create(String name, String url, String contentType, String humanFileSize) {
        return new AutoValue_Attachments(name, url, contentType, humanFileSize);
    }

    public abstract String getName();

    public abstract String getUrl();

    public abstract String getContentType();

    public abstract String getHumanFileSize();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getName());
        dest.writeString(this.getUrl());
        dest.writeString(this.getContentType());
        dest.writeString(this.getHumanFileSize());
    }

    public static final class Builder {
        @Nullable
        String name;
        @Nullable
        String url;
        @Nullable
        String content_type;
        @Nullable
        String human_file_size;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Attachments build() {
            return Attachments.create(NullSafety.valueOrEmpty(this.name), NullSafety.valueOrEmpty(this.url), NullSafety.valueOrEmpty(this.content_type), NullSafety.valueOrEmpty(this.human_file_size));
        }
    }
}

