/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.metrics;

import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.DeliveryOption;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.UsersResponse;
import io.intercom.android.sdk.utilities.extensions.PartExtensionsKt;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u0006\u0010\u0015\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lio/intercom/android/sdk/metrics/UnreadConversationsTracker;", "", "trackerProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/metrics/MetricTracker;", "<init>", "(Lio/intercom/android/sdk/Provider;)V", "trackedPartIds", "", "", "tracker", "getTracker", "()Lio/intercom/android/sdk/metrics/MetricTracker;", "track", "", "response", "Lio/intercom/android/sdk/models/UsersResponse;", "trackReceivedPart", "part", "Lio/intercom/android/sdk/models/Part;", "conversationId", "clear", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nUnreadConversationsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnreadConversationsTracker.kt\nio/intercom/android/sdk/metrics/UnreadConversationsTracker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1863#2,2:49\n*S KotlinDebug\n*F\n+ 1 UnreadConversationsTracker.kt\nio/intercom/android/sdk/metrics/UnreadConversationsTracker\n*L\n20#1:49,2\n*E\n"})
public final class UnreadConversationsTracker {
    @NotNull
    private final Provider<MetricTracker> trackerProvider;
    @NotNull
    private final Set<String> trackedPartIds;
    public static final int $stable = 8;

    public UnreadConversationsTracker(@NotNull Provider<MetricTracker> trackerProvider) {
        Intrinsics.checkNotNullParameter(trackerProvider, (String)"trackerProvider");
        this.trackerProvider = trackerProvider;
        this.trackedPartIds = new LinkedHashSet();
    }

    private final MetricTracker getTracker() {
        MetricTracker metricTracker = this.trackerProvider.get();
        Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"get(...)");
        return metricTracker;
    }

    public final void track(@NotNull UsersResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        List<Conversation> conversations = response.getUnreadConversations().getConversations();
        Intrinsics.checkNotNull(conversations);
        Iterable $this$forEach$iv = conversations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Conversation conversation = (Conversation)element$iv;
            boolean bl = false;
            Part part = conversation.lastPart();
            if (this.trackedPartIds.contains(part.getId())) continue;
            String string2 = part.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
            this.trackedPartIds.add(string2);
            this.trackReceivedPart(part, conversation.getId());
        }
    }

    private final void trackReceivedPart(Part part, String conversationId2) {
        boolean hasAttachments = part.hasAttachments();
        boolean isLinkCard = PartExtensionsKt.isLinkCard(part);
        String partId = part.getId();
        MessageStyle style = part.getMessageStyle();
        if (DeliveryOption.SUMMARY != part.getDeliveryOption()) {
            this.getTracker().receivedMessageFromFullWhenClosed(hasAttachments, isLinkCard, conversationId2, partId, style);
        } else if (part.isInitialMessage()) {
            this.getTracker().receivedMessageFromSnippetWhenClosed(hasAttachments, isLinkCard, conversationId2, partId, style);
        } else {
            this.getTracker().receivedReplyFromSnippetWhenClosed(hasAttachments, isLinkCard, conversationId2, partId);
        }
    }

    public final void clear() {
        this.trackedPartIds.clear();
    }
}

