/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.compose.ui.platform.ComposeView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.notification.InAppNotificationCardKt;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.overlay.ChatNotification;
import io.intercom.android.sdk.overlay.ComposeCompatibilityUtilKt;
import io.intercom.android.sdk.overlay.InAppNotification;
import io.intercom.android.sdk.utilities.AvatarUtils;

class ChatSnippet
extends ChatNotification {
    private TextView contentBody;

    public ChatSnippet(Context localisedContext, Conversation conversation, int position, int screenHeight, InAppNotification.Listener listener2, Provider<AppConfig> appConfigProvider) {
        super(localisedContext, conversation, position, screenHeight, listener2, appConfigProvider);
    }

    @Override
    protected ViewGroup inflateChatRootView(ViewGroup parent, LayoutInflater inflater) {
        ViewGroup root = (ViewGroup)inflater.inflate(R.layout.intercom_preview_chat_snippet_overlay, parent, false);
        this.contentBody = (TextView)root.findViewById(R.id.chathead_text_body);
        return root;
    }

    @Override
    protected void updateContentContainer(Part part) {
        this.setBodyText(part);
    }

    @Override
    protected View getContentContainer() {
        return this.overlayRoot.findViewById(R.id.chathead_text_body);
    }

    @Override
    public void update(Conversation conversation, Runnable updateEndAction) {
        this.conversation = conversation;
        View text = this.overlayRoot.findViewById(R.id.chathead_text_body);
        View textContainer = this.overlayRoot.findViewById(R.id.chathead_text_container);
        textContainer.setPivotX(0.0f);
        this.performReplyPulse(textContainer, text, updateEndAction);
    }

    @Override
    protected void updateViewDataDuringReplyPulse(int bottomPadding) {
        ComposeView ticketHeader;
        Part lastPart = this.conversation.lastPart();
        ImageView avatarView = (ImageView)this.overlayRoot.findViewById(R.id.chathead_avatar);
        AvatarUtils.loadAvatarIntoView(lastPart.getParticipant().getAvatar(), avatarView, (AppConfig)this.appConfigProvider.get());
        TextView headerTextView = (TextView)this.overlayRoot.findViewById(R.id.chathead_text_header);
        headerTextView.setText(this.getHeaderText());
        this.setBodyText(lastPart);
        FrameLayout parentCard = (FrameLayout)this.overlayRoot.findViewById(R.id.parent_card);
        if (parentCard != null) {
            // empty if block
        }
        if (!ComposeCompatibilityUtilKt.hideForLegacyActivity(ticketHeader = (ComposeView)this.overlayRoot.findViewById(R.id.ticket_header_compose_view))) {
            InAppNotificationCardKt.addTicketHeaderToCompose(ticketHeader, this.conversation);
            if (this.conversation.getTicket() != null) {
                headerTextView.setVisibility(8);
                ticketHeader.setVisibility(0);
            } else {
                headerTextView.setVisibility(0);
                ticketHeader.setVisibility(8);
            }
        } else {
            headerTextView.setVisibility(0);
        }
        ComposeView avatarComposeView = (ComposeView)this.overlayRoot.findViewById(R.id.chathead_avatar_compose_view);
        if (!ComposeCompatibilityUtilKt.hideForLegacyActivity(avatarComposeView)) {
            ComposeCompatibilityUtilKt.addAvatarIconToCompose(avatarComposeView, lastPart.getParticipant(), (AppConfig)this.appConfigProvider.get());
            avatarView.setVisibility(8);
            avatarComposeView.setVisibility(0);
        } else {
            avatarView.setVisibility(0);
        }
    }

    @Override
    void populateViewsWithData() {
        ComposeView composeView = (ComposeView)this.overlayRoot.findViewById(R.id.chat_snippet_compose_view);
        if (ComposeCompatibilityUtilKt.hideForLegacyActivity(composeView)) {
            this.setupLegacyNotification();
        } else {
            this.setupComposeNotification(composeView);
        }
    }

    private void setupComposeNotification(ComposeView composeView) {
        InAppNotificationCardKt.addInappNotificationCardToView(composeView, this.conversation);
        composeView.setVisibility(0);
        FrameLayout parentCard = (FrameLayout)this.overlayRoot.findViewById(R.id.parent_card);
        if (parentCard != null) {
            parentCard.setVisibility(8);
        }
    }

    private void setupLegacyNotification() {
        TextView headerTextView;
        FrameLayout parentCard = (FrameLayout)this.overlayRoot.findViewById(R.id.parent_card);
        if (parentCard != null) {
            parentCard.setVisibility(0);
        }
        if ((headerTextView = (TextView)this.overlayRoot.findViewById(R.id.chathead_text_header)) != null) {
            headerTextView.setText(this.getHeaderText());
        }
        this.setBodyText(this.conversation.lastPart());
        ImageView avatarView = (ImageView)this.overlayRoot.findViewById(R.id.chathead_avatar);
        if (avatarView != null) {
            AvatarUtils.loadAvatarIntoView(this.conversation.lastPart().getParticipant().getAvatar(), avatarView, (AppConfig)this.appConfigProvider.get());
        }
    }

    private void setBodyText(Part part) {
        if (part.getSummary().isEmpty()) {
            this.contentBody.setText((CharSequence)this.localisedContext.getString(R.string.intercom_image_attached));
        } else if (part.getEventData().getCustomStatePrefix() != null && !part.getEventData().getCustomStatePrefix().isEmpty()) {
            this.contentBody.setText((CharSequence)part.getEventData().getCustomStatePrefix());
        } else {
            this.contentBody.setText((CharSequence)part.getSummary());
        }
    }
}

