/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import androidx.annotation.Nullable;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.User;

public abstract class BaseResponse {
    private final Config config;
    private final boolean hasConversations;
    private final User user;

    protected BaseResponse(Builder builder) {
        this.config = builder.config == null ? new Config() : builder.config;
        this.hasConversations = builder.has_conversations;
        this.user = builder.user == null ? User.NULL : builder.user.build();
    }

    public Config getConfig() {
        return this.config;
    }

    public boolean hasConversations() {
        return this.hasConversations;
    }

    public User getUser() {
        return this.user;
    }

    static abstract class Builder {
        @Nullable
        Config config;
        @Nullable
        User.Builder user;
        boolean has_conversations;

        Builder() {
        }

        public abstract BaseResponse build();
    }
}

