/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.ui.components.composer;

import io.intercom.android.sdk.m5.conversation.ui.components.composer.WaveformElement;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0003R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/intercom/android/sdk/m5/conversation/ui/components/composer/WaveformBuffer;", "", "initialCapacity", "", "<init>", "(I)V", "capacity", "elements", "", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/WaveformElement;", "[Lio/intercom/android/sdk/m5/conversation/ui/components/composer/WaveformElement;", "head", "size", "addElement", "", "element", "getAllElements", "", "cleanupOldElements", "currentTime", "", "maxAge", "getCurrentSize", "resizeBuffer", "newCapacity", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nSoundWaveVisualization.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SoundWaveVisualization.kt\nio/intercom/android/sdk/m5/conversation/ui/components/composer/WaveformBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,549:1\n1#2:550\n*E\n"})
final class WaveformBuffer {
    private int capacity;
    @NotNull
    private WaveformElement[] elements;
    private int head;
    private int size;

    public WaveformBuffer(int initialCapacity) {
        this.capacity = initialCapacity;
        int n = 0;
        int n2 = this.capacity;
        WaveformElement[] waveformElementArray = new WaveformElement[n2];
        WaveformBuffer waveformBuffer = this;
        while (n < n2) {
            int n3 = n++;
            waveformElementArray[n3] = null;
        }
        waveformBuffer.elements = waveformElementArray;
    }

    public /* synthetic */ WaveformBuffer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 70;
        }
        this(n);
    }

    public final void addElement(@NotNull WaveformElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.elements[this.head] = element;
        this.head = (this.head + 1) % this.capacity;
        if (this.size < this.capacity) {
            int n = this.size;
            this.size = n + 1;
        }
    }

    @NotNull
    public final List<WaveformElement> getAllElements() {
        List result = new ArrayList();
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            WaveformElement it;
            int index = (this.head - this.size + i + this.capacity) % this.capacity;
            if (this.elements[index] == null) continue;
            boolean bl = false;
            result.add(it);
        }
        return result;
    }

    public final void cleanupOldElements(long currentTime, long maxAge) {
        int writeHead = (this.head - this.size + this.capacity) % this.capacity;
        int newSize = 0;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            int readIndex = (this.head - this.size + i + this.capacity) % this.capacity;
            WaveformElement element = this.elements[readIndex];
            if (element != null && currentTime - element.getTimestamp() <= maxAge) {
                if (readIndex != writeHead) {
                    this.elements[writeHead] = element;
                    this.elements[readIndex] = null;
                }
                writeHead = (writeHead + 1) % this.capacity;
                ++newSize;
                continue;
            }
            this.elements[readIndex] = null;
        }
        this.size = newSize;
        this.head = writeHead;
    }

    public final int getCurrentSize() {
        return this.size;
    }

    public final void resizeBuffer(int newCapacity) {
        if (newCapacity == this.capacity) {
            return;
        }
        WaveformElement[] oldElements = this.elements;
        int oldCapacity = this.capacity;
        int oldHead = this.head;
        int oldSize = this.size;
        this.capacity = newCapacity;
        int n = 0;
        int n2 = this.capacity;
        WaveformElement[] waveformElementArray = new WaveformElement[n2];
        WaveformBuffer waveformBuffer = this;
        while (n < n2) {
            int n3 = n++;
            waveformElementArray[n3] = null;
        }
        waveformBuffer.elements = waveformElementArray;
        this.head = 0;
        this.size = 0;
        int elementsToKeep = Math.min(oldSize, newCapacity);
        for (int i = 0; i < elementsToKeep; ++i) {
            WaveformElement element;
            int oldIndex = (oldHead - oldSize + i + oldCapacity) % oldCapacity;
            if (oldElements[oldIndex] == null) continue;
            boolean bl = false;
            this.addElement(element);
        }
    }

    public WaveformBuffer() {
        this(0, 1, null);
    }
}

