/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_SocialAccount;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class SocialAccount
implements Parcelable {
    public static final SocialAccount NULL = SocialAccount.create("", "");
    public static final Parcelable.Creator<SocialAccount> CREATOR = new Parcelable.Creator<SocialAccount>(){

        public SocialAccount createFromParcel(Parcel in) {
            String provider = in.readString();
            String profileUrl = in.readString();
            return SocialAccount.create(provider, profileUrl);
        }

        public SocialAccount[] newArray(int size) {
            return new SocialAccount[size];
        }
    };

    public static SocialAccount create(String provider, String profileUrl) {
        return new AutoValue_SocialAccount(provider, profileUrl);
    }

    public abstract String getProvider();

    public abstract String getProfileUrl();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getProvider());
        dest.writeString(this.getProfileUrl());
    }

    public static final class Builder {
        @Nullable
        String provider;
        @Nullable
        String profile_url;

        public SocialAccount build() {
            return SocialAccount.create(NullSafety.valueOrEmpty(this.provider), NullSafety.valueOrEmpty(this.profile_url));
        }
    }
}

