/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_Location;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class Location
implements Parcelable {
    public static final Parcelable.Creator<Location> CREATOR = new Parcelable.Creator<Location>(){

        public Location createFromParcel(Parcel in) {
            String cityName = in.readString();
            String countryName = in.readString();
            Integer timezoneOffset = in.readByte() == 0 ? null : Integer.valueOf(in.readInt());
            return Location.create(cityName, countryName, timezoneOffset);
        }

        public Location[] newArray(int size) {
            return new Location[size];
        }
    };

    public static Location create(String cityName, String countryName, @Nullable Integer timezoneOffset) {
        return new AutoValue_Location(cityName, countryName, timezoneOffset);
    }

    public abstract String getCityName();

    public abstract String getCountryName();

    @Nullable
    public abstract Integer getTimezoneOffset();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getCityName());
        dest.writeString(this.getCountryName());
        Integer timezoneOffset = this.getTimezoneOffset();
        if (timezoneOffset == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeInt(timezoneOffset.intValue());
        }
    }

    public static final class Builder {
        @Nullable
        String city_name;
        @Nullable
        String country_name;
        @Nullable
        Integer timezone_offset;

        public Location build() {
            return Location.create(NullSafety.valueOrEmpty(this.city_name), NullSafety.valueOrEmpty(this.country_name), this.timezone_offset);
        }
    }
}

