/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightbox;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.widget.AppCompatImageView;
import io.intercom.android.sdk.lightbox.LightBoxListener;

public class LightBoxImageView
extends AppCompatImageView {
    GestureDetector gestureDetector;
    LightBoxListener lightBoxListener;

    public LightBoxImageView(Context context) {
        super(context);
        this.init();
    }

    public LightBoxImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    void setLightBoxListener(LightBoxListener lightBoxListener) {
        this.lightBoxListener = lightBoxListener;
    }

    private void init() {
        this.gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureListener());
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return LightBoxImageView.this.gestureDetector.onTouchEvent(event);
            }
        });
    }

    private class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        GestureListener() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (LightBoxImageView.this.lightBoxListener != null) {
                LightBoxImageView.this.lightBoxListener.closeLightBox();
            }
            return super.onSingleTapConfirmed(e);
        }
    }
}

