/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.lib.models;

import android.os.Parcel;
import android.os.Parcelable;

public class BlockAttachment
implements Parcelable {
    private final String name;
    private final String url;
    private final String contentType;
    private final String humanFileSize;
    private final long size;
    private final int id;
    public static final Parcelable.Creator<BlockAttachment> CREATOR = new Parcelable.Creator<BlockAttachment>(){

        public BlockAttachment createFromParcel(Parcel in) {
            return new BlockAttachment(in);
        }

        public BlockAttachment[] newArray(int size) {
            return new BlockAttachment[size];
        }
    };

    public BlockAttachment() {
        this(new Builder());
    }

    public BlockAttachment(Builder builder) {
        this.name = builder.name == null ? "" : builder.name;
        this.url = builder.url == null ? "" : builder.url;
        this.contentType = builder.contentType == null ? "" : builder.contentType;
        this.humanFileSize = builder.humanFileSize == null ? "" : builder.humanFileSize;
        this.id = builder.id;
        this.size = builder.size;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHumanFileSize() {
        return this.humanFileSize;
    }

    public int getId() {
        return this.id;
    }

    public long getSize() {
        return this.size;
    }

    public Builder toBuilder() {
        return new Builder().withName(this.name).withUrl(this.url).withContentType(this.contentType).withHumanFileSize(this.humanFileSize).withId(this.id).withSize(this.size);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockAttachment that = (BlockAttachment)o;
        if (this.size != that.size) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        if (this.humanFileSize != null ? !this.humanFileSize.equals(that.humanFileSize) : that.humanFileSize == null) {
            return false;
        }
        return this.contentType != null ? this.contentType.equals(that.contentType) : that.contentType == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.contentType != null ? this.contentType.hashCode() : 0);
        result = 31 * result + (this.humanFileSize != null ? this.humanFileSize.hashCode() : 0);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + this.id;
        return result;
    }

    protected BlockAttachment(Parcel in) {
        this.name = in.readString();
        this.url = in.readString();
        this.contentType = in.readString();
        this.humanFileSize = in.readString();
        this.id = in.readInt();
        this.size = in.readLong();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeString(this.url);
        dest.writeString(this.contentType);
        dest.writeString(this.humanFileSize);
        dest.writeInt(this.id);
        dest.writeLong(this.size);
    }

    public static final class Builder {
        String name;
        String url;
        String contentType;
        String humanFileSize;
        long size;
        int id;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder withContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder withHumanFileSize(String humanFileSize) {
            this.humanFileSize = humanFileSize;
            return this;
        }

        public Builder withId(int id2) {
            this.id = id2;
            return this;
        }

        public Builder withSize(long size) {
            this.size = size;
            return this;
        }

        public BlockAttachment build() {
            return new BlockAttachment(this);
        }
    }
}

