/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.net.TrafficStats;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class TaggingSocketFactory
extends SocketFactory {
    private final SocketFactory defaultFactory;
    private final int threadStatsTag;

    public TaggingSocketFactory(SocketFactory defaultFactory, int threadStatsTag) {
        this.defaultFactory = defaultFactory;
        this.threadStatsTag = threadStatsTag;
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.withTag(this.defaultFactory.createSocket());
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.withTag(this.defaultFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return this.withTag(this.defaultFactory.createSocket(host, port, localHost, localPort));
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        return this.withTag(this.defaultFactory.createSocket(host, port));
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return this.withTag(this.defaultFactory.createSocket(address, port, localAddress, localPort));
    }

    private Socket withTag(Socket socket) throws IOException {
        TrafficStats.setThreadStatsTag((int)this.threadStatsTag);
        return socket;
    }
}

