/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import com.intercom.twig.Twig;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.AuthToken;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.IntercomContent;
import io.intercom.android.sdk.IntercomError;
import io.intercom.android.sdk.IntercomPushManager;
import io.intercom.android.sdk.IntercomSpace;
import io.intercom.android.sdk.IntercomStatusCallback;
import io.intercom.android.sdk.IntercomStatusCallbackKt;
import io.intercom.android.sdk.LateInitializationPreparer;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.UserAttributes;
import io.intercom.android.sdk.activities.IntercomCarouselActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.errorreporting.ErrorReporter;
import io.intercom.android.sdk.helpcenter.api.CollectionContentRequestCallback;
import io.intercom.android.sdk.helpcenter.api.CollectionRequestCallback;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApiWrapper;
import io.intercom.android.sdk.helpcenter.api.SearchRequestCallback;
import io.intercom.android.sdk.helpcenter.articles.IntercomArticleActivity;
import io.intercom.android.sdk.helpcenter.utils.HelpCenterUrlUtilsKt;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.ConversationScreenOpenerKt;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.m5.data.UnreadCountTracker;
import io.intercom.android.sdk.m5.navigation.IntercomRootActivityLauncher;
import io.intercom.android.sdk.m5.push.IntercomPushClientHandler;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.HostAppState;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.overlay.OverlayPresenter;
import io.intercom.android.sdk.survey.ui.IntercomSurveyActivity;
import io.intercom.android.sdk.ui.theme.ThemeManager;
import io.intercom.android.sdk.ui.theme.ThemeMode;
import io.intercom.android.sdk.utilities.ActivityFinisher;
import io.intercom.android.sdk.utilities.AttributeSanitiser;
import io.intercom.android.sdk.utilities.ValidatorUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u0084\u00012\u00020\u0001:\u0006\u0082\u0001\u0083\u0001\u0084\u0001B\u0099\u0001\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005\u0012\u0006\u0010\u0019\u001a\u00020\u001a\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\b\u0010#\u001a\u00020$H\u0002J\u0012\u0010%\u001a\u00020&2\b\b\u0002\u0010'\u001a\u00020(H\u0007J\u000e\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u00020&H\u0007J\u0010\u0010-\u001a\u00020&2\b\b\u0002\u0010.\u001a\u00020/J\u0012\u00100\u001a\u00020&2\b\u00101\u001a\u0004\u0018\u000102H\u0007J\u0018\u00103\u001a\u00020&2\u0006\u00101\u001a\u0002022\b\b\u0002\u0010.\u001a\u00020/J\u0018\u00104\u001a\u00020&2\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0002J\u0006\u00105\u001a\u00020$J\b\u00106\u001a\u0004\u0018\u000102J\b\u00107\u001a\u00020&H\u0002J\u000e\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020:J\u001e\u0010=\u001a\u00020&2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\b\b\u0002\u0010.\u001a\u00020/J\u0012\u0010A\u001a\u00020&2\b\u0010B\u001a\u0004\u0018\u00010CH\u0007J\u0018\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020C2\b\b\u0002\u0010.\u001a\u00020/J&\u0010D\u001a\u00020&2\u0014\u0010B\u001a\u0010\u0012\u0004\u0012\u00020:\u0012\u0006\u0012\u0004\u0018\u00010\u00010E2\u0006\u0010.\u001a\u00020/H\u0002J\u000e\u0010F\u001a\u00020&2\u0006\u0010G\u001a\u00020:J$\u0010F\u001a\u00020&2\b\u0010G\u001a\u0004\u0018\u00010:2\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0002\b\u0003\u0018\u00010EJ$\u0010I\u001a\u00020&2\b\u0010G\u001a\u0004\u0018\u00010:2\u0010\u0010J\u001a\f\u0012\u0004\u0012\u00020:\u0012\u0002\b\u00030EH\u0002J\b\u0010K\u001a\u00020&H\u0007J\u0006\u0010L\u001a\u00020&J\u0010\u0010L\u001a\u00020&2\b\u0010M\u001a\u0004\u0018\u00010:J\b\u0010N\u001a\u00020$H\u0002J\u0010\u0010O\u001a\u00020&2\u0006\u0010P\u001a\u00020:H\u0002J\b\u0010Q\u001a\u00020&H\u0007J\b\u0010R\u001a\u00020&H\u0007J\u001a\u0010S\u001a\u00020&2\u0010\u0010T\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010:\u0018\u00010?H\u0007J\u0012\u0010U\u001a\u00020&2\b\u0010V\u001a\u0004\u0018\u00010:H\u0007J\u0010\u0010W\u001a\u00020&2\u0006\u0010X\u001a\u00020:H\u0007J\u000e\u0010Y\u001a\u00020&2\u0006\u0010Z\u001a\u00020[J\u0010\u0010\\\u001a\u00020&2\b\u0010]\u001a\u0004\u0018\u00010^J\u0010\u0010_\u001a\u00020&2\b\u0010]\u001a\u0004\u0018\u00010^J\u0010\u0010`\u001a\u00020&2\b\u0010a\u001a\u0004\u0018\u00010bJ\u0006\u0010c\u001a\u00020&J\b\u0010d\u001a\u00020&H\u0007J\u0012\u0010d\u001a\u00020&2\b\u0010e\u001a\u0004\u0018\u00010fH\u0007J\u001c\u0010g\u001a\u00020&2\b\u0010h\u001a\u0004\u0018\u00010:2\b\u0010e\u001a\u0004\u0018\u00010fH\u0002J\b\u0010i\u001a\u00020&H\u0007J\u0006\u0010j\u001a\u00020&J\u000e\u0010n\u001a\u00020&2\u0006\u0010o\u001a\u00020pJ\u0010\u0010q\u001a\u00020&2\b\u0010o\u001a\u0004\u0018\u00010pJ\u0010\u0010r\u001a\u00020&2\u0006\u0010s\u001a\u00020:H\u0007J\u0010\u0010t\u001a\u00020&2\b\u0010u\u001a\u0004\u0018\u00010vJ\u001a\u0010w\u001a\u00020&2\b\u0010x\u001a\u0004\u0018\u00010:2\b\u0010y\u001a\u0004\u0018\u00010zJ\u001a\u0010{\u001a\u00020&2\b\u0010|\u001a\u0004\u0018\u00010:2\b\u0010}\u001a\u0004\u0018\u00010~J\u001c\u0010\u007f\u001a\u00020&2\t\u0010\u0080\u0001\u001a\u0004\u0018\u00010:2\t\u0010\u0081\u0001\u001a\u0004\u0018\u00010:R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010k\u001a\u00020[8F\u00a2\u0006\u0006\u001a\u0004\bl\u0010m\u00a8\u0006\u0085\u0001"}, d2={"Lio/intercom/android/sdk/Intercom;", "", "superDeDuper", "Lio/intercom/android/sdk/api/DeDuper;", "apiProvider", "Lio/intercom/android/sdk/Provider;", "Lio/intercom/android/sdk/api/Api;", "nexusClientProvider", "Lio/intercom/android/nexus/NexusClient;", "unreadCountTracker", "Lio/intercom/android/sdk/m5/data/UnreadCountTracker;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "errorReporter", "Lio/intercom/android/sdk/errorreporting/ErrorReporter;", "context", "Landroid/app/Application;", "overlayPresenter", "Lio/intercom/android/sdk/overlay/OverlayPresenter;", "appConfigProvider", "Lio/intercom/android/sdk/identity/AppConfig;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "userUpdater", "Lio/intercom/android/sdk/api/UserUpdater;", "resetManager", "Lio/intercom/android/sdk/ResetManager;", "twig", "Lcom/intercom/twig/Twig;", "activityFinisher", "Lio/intercom/android/sdk/utilities/ActivityFinisher;", "dataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "<init>", "(Lio/intercom/android/sdk/api/DeDuper;Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/m5/data/UnreadCountTracker;Lio/intercom/android/sdk/metrics/MetricTracker;Lio/intercom/android/sdk/errorreporting/ErrorReporter;Landroid/app/Application;Lio/intercom/android/sdk/overlay/OverlayPresenter;Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/identity/UserIdentity;Lio/intercom/android/sdk/Provider;Lio/intercom/android/sdk/ResetManager;Lcom/intercom/twig/Twig;Lio/intercom/android/sdk/utilities/ActivityFinisher;Lio/intercom/android/sdk/m5/data/IntercomDataLayer;)V", "shouldDisableErrorReporting", "", "present", "", "space", "Lio/intercom/android/sdk/IntercomSpace;", "presentContent", "content", "Lio/intercom/android/sdk/IntercomContent;", "registerUnidentifiedUser", "loginUnidentifiedUser", "intercomStatusCallback", "Lio/intercom/android/sdk/IntercomStatusCallback;", "registerIdentifiedUser", "userRegistration", "Lio/intercom/android/sdk/identity/Registration;", "loginIdentifiedUser", "registerNewIdentifiedUser", "isUserLoggedIn", "fetchLoggedInUserAttributes", "softRegister", "setUserHash", "userHash", "", "setUserJwt", "jwt", "setAuthTokens", "authTokens", "", "Lio/intercom/android/sdk/AuthToken;", "updateUser", "userAttributes", "Lio/intercom/android/sdk/UserAttributes;", "performUpdate", "", "logEvent", "name", "metaData", "logEventWithValidation", "metadata", "displayMessenger", "displayMessageComposer", "initialMessage", "noUserRegistered", "logErrorAndOpenInbox", "error", "displayConversationsList", "displayHelpCenter", "displayHelpCenterCollections", "collectionIds", "displayCarousel", "carouselId", "displaySurvey", "surveyId", "setBottomPadding", "bottomPadding", "", "setInAppMessageVisibility", "visibility", "Lio/intercom/android/sdk/Intercom$Visibility;", "setLauncherVisibility", "setThemeMode", "themeMode", "Lio/intercom/android/sdk/ui/theme/ThemeMode;", "hideIntercom", "handlePushMessage", "customStack", "Landroid/app/TaskStackBuilder;", "openIntercomChatPush", "pushDataString", "reset", "logout", "unreadConversationCount", "getUnreadConversationCount", "()I", "addUnreadConversationCountListener", "listener", "Lio/intercom/android/sdk/UnreadConversationCountListener;", "removeUnreadConversationCountListener", "displayArticle", "articleId", "fetchHelpCenterCollections", "collectionRequestCallback", "Lio/intercom/android/sdk/helpcenter/api/CollectionRequestCallback;", "fetchHelpCenterCollection", "collectionId", "collectionContentRequestCallback", "Lio/intercom/android/sdk/helpcenter/api/CollectionContentRequestCallback;", "searchHelpCenter", "searchTerm", "searchRequestCallback", "Lio/intercom/android/sdk/helpcenter/api/SearchRequestCallback;", "changeWorkspace", "apiKey", "appId", "Visibility", "LogLevel", "Companion", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIntercom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Intercom.kt\nio/intercom/android/sdk/Intercom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1343:1\n1#2:1344\n774#3:1345\n865#3,2:1346\n*S KotlinDebug\n*F\n+ 1 Intercom.kt\nio/intercom/android/sdk/Intercom\n*L\n501#1:1345\n501#1:1346,2\n*E\n"})
public final class Intercom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeDuper superDeDuper;
    @NotNull
    private final Provider<Api> apiProvider;
    @NotNull
    private final Provider<NexusClient> nexusClientProvider;
    @NotNull
    private final UnreadCountTracker unreadCountTracker;
    @NotNull
    private final MetricTracker metricTracker;
    @NotNull
    private final Application context;
    @NotNull
    private final OverlayPresenter overlayPresenter;
    @NotNull
    private final Provider<AppConfig> appConfigProvider;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final Provider<UserUpdater> userUpdater;
    @NotNull
    private final ResetManager resetManager;
    @NotNull
    private final Twig twig;
    @NotNull
    private final ActivityFinisher activityFinisher;
    @NotNull
    private final IntercomDataLayer dataLayer;
    public static final int $stable = 8;
    @JvmField
    @NotNull
    public static final Visibility VISIBLE = Visibility.VISIBLE;
    @JvmField
    @NotNull
    public static final Visibility GONE = Visibility.GONE;
    @NotNull
    public static final String PUSH_RECEIVER = "intercom_sdk";
    private static final Twig TWIG = LumberMill.getLogger();
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static Intercom instance;

    @VisibleForTesting
    public Intercom(@NotNull DeDuper superDeDuper, @NotNull Provider<Api> apiProvider, @NotNull Provider<NexusClient> nexusClientProvider, @NotNull UnreadCountTracker unreadCountTracker, @NotNull MetricTracker metricTracker, @NotNull ErrorReporter errorReporter, @NotNull Application context, @NotNull OverlayPresenter overlayPresenter, @NotNull Provider<AppConfig> appConfigProvider, @NotNull UserIdentity userIdentity, @NotNull Provider<UserUpdater> userUpdater, @NotNull ResetManager resetManager, @NotNull Twig twig, @NotNull ActivityFinisher activityFinisher, @NotNull IntercomDataLayer dataLayer) {
        Intrinsics.checkNotNullParameter((Object)superDeDuper, (String)"superDeDuper");
        Intrinsics.checkNotNullParameter(apiProvider, (String)"apiProvider");
        Intrinsics.checkNotNullParameter(nexusClientProvider, (String)"nexusClientProvider");
        Intrinsics.checkNotNullParameter((Object)unreadCountTracker, (String)"unreadCountTracker");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)overlayPresenter, (String)"overlayPresenter");
        Intrinsics.checkNotNullParameter(appConfigProvider, (String)"appConfigProvider");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter(userUpdater, (String)"userUpdater");
        Intrinsics.checkNotNullParameter((Object)resetManager, (String)"resetManager");
        Intrinsics.checkNotNullParameter((Object)twig, (String)"twig");
        Intrinsics.checkNotNullParameter((Object)activityFinisher, (String)"activityFinisher");
        Intrinsics.checkNotNullParameter((Object)dataLayer, (String)"dataLayer");
        this.superDeDuper = superDeDuper;
        this.apiProvider = apiProvider;
        this.nexusClientProvider = nexusClientProvider;
        this.unreadCountTracker = unreadCountTracker;
        this.metricTracker = metricTracker;
        this.context = context;
        this.overlayPresenter = overlayPresenter;
        this.appConfigProvider = appConfigProvider;
        this.userIdentity = userIdentity;
        this.userUpdater = userUpdater;
        this.resetManager = resetManager;
        this.twig = twig;
        this.activityFinisher = activityFinisher;
        this.dataLayer = dataLayer;
        IntercomPushManager.IntercomPushIntegrationType intercomPushIntegrationType = IntercomPushManager.getInstalledModuleType();
        if ((intercomPushIntegrationType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[intercomPushIntegrationType.ordinal()]) == 1) {
            this.twig.i("Enabling FCM for cloud messaging", new Object[0]);
            IntercomPushClientHandler.Companion.setUpNotificationChannels((Context)this.context);
            IntercomPushManager.initializeFcmService(this.context);
        } else {
            this.twig.internal("No FCM integration detected");
        }
        if (this.shouldDisableErrorReporting()) {
            errorReporter.disableExceptionHandler();
        } else {
            errorReporter.enableExceptionHandler();
        }
    }

    private final boolean shouldDisableErrorReporting() {
        return this.appConfigProvider.get().hasFeature("disable-error-reporting");
    }

    @JvmOverloads
    public final void present(@NotNull IntercomSpace space) {
        Intrinsics.checkNotNullParameter((Object)((Object)space), (String)"space");
        if (this.noUserRegistered()) {
            TWIG.e("Intercom was presented but there was no user registered on this device.Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).", new Object[0]);
        } else {
            Injector.get().getMetricTracker().presentAPICall(space);
            switch (WhenMappings.$EnumSwitchMapping$1[space.ordinal()]) {
                case 1: {
                    HelpCenterUrlUtilsKt.openCollections((Context)this.context, CollectionsKt.emptyList(), "api");
                    break;
                }
                case 2: {
                    IntercomRootActivityLauncher.INSTANCE.startHome((Context)this.context);
                    break;
                }
                case 3: {
                    IntercomRootActivityLauncher.INSTANCE.startMessages((Context)this.context);
                    break;
                }
                case 4: {
                    IntercomRootActivityLauncher.INSTANCE.startTickets((Context)this.context);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    public static /* synthetic */ void present$default(Intercom intercom, IntercomSpace intercomSpace, int n, Object object) {
        if ((n & 1) != 0) {
            intercomSpace = IntercomSpace.Home;
        }
        intercom.present(intercomSpace);
    }

    public final void presentContent(@NotNull IntercomContent content) {
        IntercomContent intercomContent;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (!Injector.isNotInitialised() && !this.noUserRegistered()) {
            Injector.get().getMetricTracker().presentContentAPICall(content);
        }
        if ((intercomContent = content) instanceof IntercomContent.Article) {
            this.context.startActivity(IntercomArticleActivity.Companion.buildIntent((Context)this.context, new IntercomArticleActivity.ArticleActivityArguments(((IntercomContent.Article)content).getId(), "api", false, false, 12, null)));
        } else if (intercomContent instanceof IntercomContent.Carousel) {
            this.context.startActivity(IntercomCarouselActivity.buildIntent((Context)this.context, ((IntercomContent.Carousel)content).getId()));
        } else if (intercomContent instanceof IntercomContent.Survey) {
            this.context.startActivity(IntercomSurveyActivity.Companion.buildIntent((Context)this.context, ((IntercomContent.Survey)content).getId()));
        } else if (intercomContent instanceof IntercomContent.HelpCenterCollections) {
            HelpCenterUrlUtilsKt.openCollections((Context)this.context, ((IntercomContent.HelpCenterCollections)content).getIds(), "api");
        } else if (intercomContent instanceof IntercomContent.Conversation) {
            ConversationScreenOpenerKt.openComposer$default((Context)this.context, "", true, null, ((IntercomContent.Conversation)content).getId(), 8, null);
        } else if (intercomContent instanceof IntercomContent.Ticket) {
            IntercomRootActivityLauncher.INSTANCE.startTicketDetails((Context)this.context, ((IntercomContent.Ticket)content).getId(), "from_programmatic");
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Deprecated(message="Use loginUnidentifiedUser instead.", replaceWith=@ReplaceWith(expression="loginUnidentifiedUser()", imports={}), level=DeprecationLevel.WARNING)
    public final void registerUnidentifiedUser() {
        this.loginUnidentifiedUser(IntercomStatusCallbackKt.getNoStatusCallback());
    }

    public final void loginUnidentifiedUser(@NotNull IntercomStatusCallback intercomStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)intercomStatusCallback, (String)"intercomStatusCallback");
        this.metricTracker.loginUnidentifiedUserAPICall();
        if (this.userIdentity.isUnidentified()) {
            this.twig.i("The unidentified user is already registered", new Object[0]);
            intercomStatusCallback.onSuccess();
            return;
        }
        if (this.userIdentity.isIdentified()) {
            this.twig.e("The identified user is already registered", new Object[0]);
            intercomStatusCallback.onFailure(new IntercomError(3002, "Failed to register user. We already have a registered user. If you are attempting to register a new user, call logout() before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)"));
            return;
        }
        this.resetManager.hardReset();
        this.userIdentity.registerUnidentifiedUser();
        this.nexusClientProvider.get().disconnect();
        boolean isBackgrounded = ((HostAppState)this.dataLayer.getHostAppState().getValue()).isBackgrounded();
        boolean newSession = !((HostAppState)this.dataLayer.getHostAppState().getValue()).getSessionStartedSinceLastBackgrounded();
        UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(newSession, isBackgrounded, true);
        this.userUpdater.get().updateUser(userUpdateRequest, intercomStatusCallback);
    }

    public static /* synthetic */ void loginUnidentifiedUser$default(Intercom intercom, IntercomStatusCallback intercomStatusCallback, int n, Object object) {
        if ((n & 1) != 0) {
            intercomStatusCallback = IntercomStatusCallbackKt.getNoStatusCallback();
        }
        intercom.loginUnidentifiedUser(intercomStatusCallback);
    }

    @Deprecated(message="Use loginIdentifiedUser with callback instead.", replaceWith=@ReplaceWith(expression="loginIdentifiedUser(userRegistration)", imports={}), level=DeprecationLevel.WARNING)
    public final void registerIdentifiedUser(@Nullable Registration userRegistration) {
        if (userRegistration == null) {
            this.metricTracker.registerIdentifiedUserAPICall();
            this.twig.e("The registration object passed is null. An example successful call is registerIdentifiedUser(Registration.create().withEmail(email));", new Object[0]);
            return;
        }
        this.loginIdentifiedUser(userRegistration, IntercomStatusCallbackKt.getNoStatusCallback());
    }

    public final void loginIdentifiedUser(@NotNull Registration userRegistration, @NotNull IntercomStatusCallback intercomStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)userRegistration, (String)"userRegistration");
        Intrinsics.checkNotNullParameter((Object)intercomStatusCallback, (String)"intercomStatusCallback");
        this.metricTracker.loginIdentifiedUserAPICall();
        String string2 = userRegistration.getUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserId(...)");
        if (((CharSequence)string2).length() == 0) {
            String string3 = userRegistration.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getEmail(...)");
            if (((CharSequence)string3).length() == 0) {
                this.twig.e("Failed to register user. You need to provide a user identifier, an email address, or both. ", new Object[0]);
                intercomStatusCallback.onFailure(new IntercomError(1007, "Failed to register user. You need to provide unique user identifier, an email address, or both."));
                return;
            }
        }
        if (!this.userIdentity.identityExists()) {
            if (this.userIdentity.isSoftReset() && this.userIdentity.softIdentityIsSameUser(userRegistration)) {
                this.softRegister();
                intercomStatusCallback.onSuccess();
            } else {
                this.registerNewIdentifiedUser(userRegistration, intercomStatusCallback);
            }
            return;
        }
        if (Intrinsics.areEqual((Object)userRegistration.getEmail(), (Object)this.userIdentity.getEmail()) && Intrinsics.areEqual((Object)userRegistration.getUserId(), (Object)this.userIdentity.getUserId())) {
            if (this.userIdentity.registrationHasAttributes(userRegistration)) {
                this.twig.i("We already have a registered user. Updating this user with the attributes provided.", new Object[0]);
                Object object = userRegistration.getAttributes();
                if (object == null || (object = ((UserAttributes)object).toMap()) == null) {
                    object = MapsKt.emptyMap();
                }
                this.performUpdate((Map<String, ? extends Object>)object, intercomStatusCallback);
            } else {
                this.twig.i("The user is already registered with the same email and user id, skipping API call", new Object[0]);
                intercomStatusCallback.onSuccess();
            }
        } else {
            this.twig.i("The user is already registered with a different email or user id", new Object[0]);
            this.registerNewIdentifiedUser(userRegistration, intercomStatusCallback);
        }
    }

    public static /* synthetic */ void loginIdentifiedUser$default(Intercom intercom, Registration registration, IntercomStatusCallback intercomStatusCallback, int n, Object object) {
        if ((n & 2) != 0) {
            intercomStatusCallback = IntercomStatusCallbackKt.getNoStatusCallback();
        }
        intercom.loginIdentifiedUser(registration, intercomStatusCallback);
    }

    private final void registerNewIdentifiedUser(Registration userRegistration, IntercomStatusCallback intercomStatusCallback) {
        UserUpdateRequest userUpdateRequest;
        UserUpdateRequest userUpdateRequest2;
        this.resetManager.hardReset();
        this.userIdentity.registerIdentifiedUser(userRegistration);
        this.nexusClientProvider.get().disconnect();
        boolean newSession = !((HostAppState)this.dataLayer.getHostAppState().getValue()).getSessionStartedSinceLastBackgrounded();
        boolean isInBackground = ((HostAppState)this.dataLayer.getHostAppState().getValue()).isBackgrounded();
        if (userRegistration.getAttributes() != null) {
            UserAttributes userAttributes = userRegistration.getAttributes();
            Intrinsics.checkNotNull((Object)userAttributes);
            userUpdateRequest2 = UserUpdateRequest.create(newSession, isInBackground, userAttributes.toMap(), true);
            Intrinsics.checkNotNull((Object)userUpdateRequest2);
            userUpdateRequest = userUpdateRequest2;
        } else {
            userUpdateRequest2 = UserUpdateRequest.create(newSession, isInBackground, true);
            Intrinsics.checkNotNull((Object)userUpdateRequest2);
            userUpdateRequest = userUpdateRequest2;
        }
        UserUpdateRequest update = userUpdateRequest;
        this.userUpdater.get().updateUser(update, intercomStatusCallback);
    }

    public final boolean isUserLoggedIn() {
        return this.userIdentity.identityExists();
    }

    @Nullable
    public final Registration fetchLoggedInUserAttributes() {
        UserIdentity userIdentity;
        UserIdentity userIdentity2;
        UserIdentity it = userIdentity2 = this.userIdentity;
        boolean bl = false;
        UserIdentity userIdentity3 = userIdentity = it.identityExists() ? userIdentity2 : null;
        if (userIdentity != null) {
            it = userIdentity;
            boolean bl2 = false;
            Registration registration = new Registration();
            CharSequence charSequence = it.getUserId();
            if (!(charSequence == null || charSequence.length() == 0)) {
                registration.withUserId(it.getUserId());
            }
            if (!((charSequence = (CharSequence)it.getEmail()) == null || charSequence.length() == 0)) {
                registration.withEmail(it.getEmail());
            }
            if (!((charSequence = (CharSequence)it.getAnonymousId()) == null || charSequence.length() == 0)) {
                registration.withUserId(it.getAnonymousId());
            }
            return registration;
        }
        return null;
    }

    private final void softRegister() {
        this.nexusClientProvider.get().connect(this.appConfigProvider.get().getRealTimeConfig(), true);
        this.userIdentity.softRestart();
        this.resetManager.clear();
        Runnable runnable = () -> Intercom.softRegister$lambda$2(this);
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable.run();
        } else {
            new Handler(Looper.getMainLooper()).post(runnable);
        }
    }

    public final void setUserHash(@NotNull String userHash) {
        Intrinsics.checkNotNullParameter((Object)userHash, (String)"userHash");
        this.metricTracker.setUserHashAPICall();
        if (((CharSequence)userHash).length() == 0) {
            this.twig.w("The user hash you sent us to verify was empty, we will not be able to authenticate your requests without a valid user hash.", new Object[0]);
        } else if (Intrinsics.areEqual((Object)this.userIdentity.getHmac(), (Object)userHash)) {
            this.twig.i("The user hash set matches the existing user identity hash value", new Object[0]);
        } else {
            if (this.userIdentity.softUserIdentityHmacDiffers(userHash)) {
                this.resetManager.hardReset();
            }
            this.userIdentity.setUserHash(userHash);
        }
    }

    public final void setUserJwt(@NotNull String jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        this.metricTracker.setUserJwtAPICall();
        if (((CharSequence)jwt).length() == 0) {
            this.twig.w("The JWT you sent us to verify was empty, we will not be able to authenticate your requests without a valid JWT.", new Object[0]);
        } else if (Intrinsics.areEqual((Object)this.userIdentity.getJwt(), (Object)jwt)) {
            this.twig.i("The JWT set matches the existing user identity JWT value", new Object[0]);
        } else {
            if (this.userIdentity.softUserIdentityJwtDiffers(jwt)) {
                this.resetManager.hardReset();
            }
            this.userIdentity.setJwt(jwt);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setAuthTokens(@NotNull List<AuthToken> authTokens, @NotNull IntercomStatusCallback intercomStatusCallback) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(authTokens, (String)"authTokens");
        Intrinsics.checkNotNullParameter((Object)intercomStatusCallback, (String)"intercomStatusCallback");
        this.metricTracker.authTokensAPICall();
        Iterable $this$filter$iv = authTokens;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AuthToken it = (AuthToken)element$iv$iv;
            boolean bl = false;
            if (!(((CharSequence)it.getName()).length() > 0 && ((CharSequence)it.getToken()).length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredAuthTokens = (List)destination$iv$iv;
        if (filteredAuthTokens.isEmpty()) {
            this.twig.e("All auth tokens in the map have empty keys or values.", new Object[0]);
            intercomStatusCallback.onFailure(new IntercomError(3003, "ERROR - Failed to set Auth Tokens. All keys or values passed were empty."));
        } else {
            this.apiProvider.get().setAuthTokens(filteredAuthTokens, intercomStatusCallback);
        }
    }

    public static /* synthetic */ void setAuthTokens$default(Intercom intercom, List list, IntercomStatusCallback intercomStatusCallback, int n, Object object) {
        if ((n & 2) != 0) {
            intercomStatusCallback = IntercomStatusCallbackKt.getNoStatusCallback();
        }
        intercom.setAuthTokens(list, intercomStatusCallback);
    }

    @Deprecated(message="Use updateUser with callback instead.", replaceWith=@ReplaceWith(expression="updateUser(userAttributes, statusCallback)", imports={}), level=DeprecationLevel.WARNING)
    public final void updateUser(@Nullable UserAttributes userAttributes) {
        this.metricTracker.updateUserAPICall();
        if (userAttributes == null) {
            LumberMill.getLogger().e("updateUser method failed: the UserAttributes object provided is null", new Object[0]);
        } else {
            this.updateUser(userAttributes, IntercomStatusCallbackKt.getNoStatusCallback());
        }
    }

    public final void updateUser(@NotNull UserAttributes userAttributes, @NotNull IntercomStatusCallback intercomStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)userAttributes, (String)"userAttributes");
        Intrinsics.checkNotNullParameter((Object)intercomStatusCallback, (String)"intercomStatusCallback");
        this.metricTracker.updateUserCallbackAPICall();
        Map<String, Object> map2 = userAttributes.toMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"toMap(...)");
        this.performUpdate(map2, intercomStatusCallback);
    }

    public static /* synthetic */ void updateUser$default(Intercom intercom, UserAttributes userAttributes, IntercomStatusCallback intercomStatusCallback, int n, Object object) {
        if ((n & 2) != 0) {
            intercomStatusCallback = IntercomStatusCallbackKt.getNoStatusCallback();
        }
        intercom.updateUser(userAttributes, intercomStatusCallback);
    }

    private final void performUpdate(Map<String, ? extends Object> userAttributes, IntercomStatusCallback intercomStatusCallback) {
        if (this.userIdentity.isUnidentified()) {
            AttributeSanitiser.anonymousSanitisation(userAttributes);
        }
        if (this.superDeDuper.shouldUpdateUser(userAttributes)) {
            this.superDeDuper.update(userAttributes);
            boolean isBackgrounded = ((HostAppState)this.dataLayer.getHostAppState().getValue()).isBackgrounded();
            UserUpdateRequest userUpdateRequest = UserUpdateRequest.create(false, isBackgrounded, userAttributes, false);
            this.userUpdater.get().updateUser(userUpdateRequest, intercomStatusCallback);
            this.twig.internal("dupe", "updated user");
        } else {
            intercomStatusCallback.onSuccess();
            this.twig.internal("dupe", "dropped dupe");
        }
    }

    public final void logEvent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.metricTracker.logEventAPICall();
        this.logEventWithValidation(name, MapsKt.emptyMap());
    }

    public final void logEvent(@Nullable String name, @Nullable Map<String, ?> metaData) {
        this.metricTracker.logEventMetadataAPICall();
        if (metaData == null) {
            this.twig.i("The metadata provided is null, logging event with no metadata", new Object[0]);
        } else if (metaData.isEmpty()) {
            this.twig.i("The metadata provided is empty, logging event with no metadata", new Object[0]);
        }
        Map<String, ?> map2 = metaData;
        Map map3 = map2 != null ? MapsKt.toMap(map2) : null;
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        this.logEventWithValidation(name, map3);
    }

    private final void logEventWithValidation(String name, Map<String, ?> metadata) {
        CharSequence charSequence = name;
        if (charSequence == null || charSequence.length() == 0) {
            this.twig.e("The event name is null or empty. We can't log an event with this string.", new Object[0]);
        } else {
            this.apiProvider.get().logEvent(name, metadata);
        }
    }

    @Deprecated(message="Use present() instead.")
    public final void displayMessenger() {
        this.metricTracker.displayMessengerAPICall();
        if (this.noUserRegistered()) {
            this.logErrorAndOpenInbox("The messenger was opened but there was no user registered on this device.Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).");
        } else {
            new LauncherOpenBehaviour().openMessenger((Context)this.context);
        }
    }

    public final void displayMessageComposer() {
        this.metricTracker.displayMessageComposerAPICall();
        this.displayMessageComposer("");
    }

    public final void displayMessageComposer(@Nullable String initialMessage) {
        CharSequence charSequence = initialMessage;
        if (!(charSequence == null || charSequence.length() == 0)) {
            this.metricTracker.displayMessageComposerInitialMessageAPICall();
        }
        if (this.noUserRegistered()) {
            this.logErrorAndOpenInbox("The messenger was opened but there was no user registered on this device. Please call registerUnidentifiedUser() or registerIdentifiedUser(Registration).");
        } else if (!this.appConfigProvider.get().isReceivedFromServer()) {
            this.logErrorAndOpenInbox("It appears your app has not received a successful response from Intercom. Please check if you are using the correct Android app ID and API Key from the Intercom settings.");
        } else if (!this.appConfigProvider.get().isInboundMessages()) {
            this.logErrorAndOpenInbox("It appears your app is not on a plan that allows message composing. As a fallback we are calling present(IntercomSpace.Messages)");
        } else {
            this.metricTracker.openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType.CUSTOM);
            Context context = (Context)this.context;
            String string2 = initialMessage;
            if (string2 == null) {
                string2 = "";
            }
            ConversationScreenOpenerKt.openComposer$default(context, string2, true, null, null, 24, null);
        }
    }

    private final boolean noUserRegistered() {
        return !this.userIdentity.identityExists() || this.userIdentity.isSoftReset();
    }

    private final void logErrorAndOpenInbox(String error) {
        this.twig.e(error, new Object[0]);
        this.present(IntercomSpace.Messages);
    }

    @Deprecated(message="Use present(IntercomSpace.Messages) instead.")
    public final void displayConversationsList() {
        this.metricTracker.displayConversationsListAPICall();
        this.metricTracker.openedMessengerConversationList(LauncherOpenBehaviour.LauncherType.CUSTOM);
        IntercomRootActivityLauncher.INSTANCE.startMessages((Context)this.context);
    }

    @Deprecated(message="Use present(IntercomSpace.HelpCenter) instead.")
    public final void displayHelpCenter() {
        this.metricTracker.displayHelpCenterAPICall();
        this.displayHelpCenterCollections(CollectionsKt.emptyList());
    }

    @Deprecated(message="Use presentContent(IntercomContent.HelpCenterCollections(ids)) instead.")
    public final void displayHelpCenterCollections(@Nullable List<String> collectionIds) {
        this.metricTracker.displayHelpCenterCollectionsAPICall();
        Context context = (Context)this.context;
        List<String> list = collectionIds;
        List list2 = list != null ? CollectionsKt.filterNotNull((Iterable)list) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        HelpCenterUrlUtilsKt.openCollections(context, list2, "api");
    }

    @Deprecated(message="Use presentContent(IntercomContent.Carousel(id)) instead.")
    public final void displayCarousel(@Nullable String carouselId) {
        this.metricTracker.displayCarouselAPICall();
        this.context.startActivity(IntercomCarouselActivity.buildIntent((Context)this.context, carouselId));
    }

    @Deprecated(message="Use presentContent(IntercomContent.Survey(id)) instead.")
    public final void displaySurvey(@NotNull String surveyId) {
        Intrinsics.checkNotNullParameter((Object)surveyId, (String)"surveyId");
        this.metricTracker.displaySurveyAPICall();
        this.context.startActivity(IntercomSurveyActivity.Companion.buildIntent((Context)this.context, surveyId));
    }

    public final void setBottomPadding(int bottomPadding) {
        this.metricTracker.setBottomPaddingAPICall();
        this.dataLayer.updateBottomPadding(bottomPadding);
    }

    public final void setInAppMessageVisibility(@Nullable Visibility visibility) {
        this.metricTracker.setInAppMessageVisibilityAPICall();
        if (visibility != null) {
            this.dataLayer.updateInAppNotificationsVisibility(visibility);
        } else {
            this.twig.i("The visibility provided is null, visibility won't be updated", new Object[0]);
        }
    }

    public final void setLauncherVisibility(@Nullable Visibility visibility) {
        this.metricTracker.setLauncherVisibilityAPICall();
        if (visibility != null) {
            this.dataLayer.updateLauncherVisibility(visibility);
        } else {
            this.twig.i("The visibility provided is null, visibility won't be updated", new Object[0]);
        }
    }

    public final void setThemeMode(@Nullable ThemeMode themeMode) {
        this.metricTracker.setThemeModeAPICall();
        if (themeMode != null) {
            ThemeManager.INSTANCE.setSessionOverride(themeMode);
            this.twig.i("Theme mode set to: " + themeMode + " (session only)", new Object[0]);
        } else {
            ThemeManager.INSTANCE.clearSessionOverride();
            this.twig.i("Theme mode cleared, using server-provided theme", new Object[0]);
        }
    }

    public final void hideIntercom() {
        this.metricTracker.hideIntercomAPICall();
        this.activityFinisher.finishActivities();
    }

    @Deprecated(message="Calling this API is no longer required. Intercom will directly open the chat screen when a push notification is clicked.")
    public final void handlePushMessage() {
        this.metricTracker.handlePushMessageAPICall();
        this.handlePushMessage(null);
    }

    @Deprecated(message="Calling this API is no longer required. Intercom will directly open the chat screen when a push notification is clicked.")
    public final void handlePushMessage(@Nullable TaskStackBuilder customStack) {
        SharedPreferences preferences;
        String pushDataString;
        CharSequence charSequence;
        if (customStack != null) {
            this.metricTracker.handlePushMessageCustomStackAPICall();
        }
        if ((charSequence = (CharSequence)(pushDataString = (preferences = this.context.getSharedPreferences("INTERCOM_SDK_PUSH_PREFS", 0)).getString("intercom_push_notification_path", ""))) == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.twig.internal("No Uri found");
        } else {
            this.openIntercomChatPush(pushDataString, customStack);
            preferences.edit().clear().apply();
        }
    }

    private final void openIntercomChatPush(String pushDataString, TaskStackBuilder customStack) {
        if (Intrinsics.areEqual((Object)pushDataString, (Object)"multiple_notifications")) {
            IntercomRootActivityLauncher.INSTANCE.startMessages((Context)this.context);
        } else {
            Intent conversationScreenIntent = ConversationScreenOpenerKt.getConversationIntent((Context)this.context, pushDataString);
            if (customStack != null) {
                customStack.addNextIntent(conversationScreenIntent);
                this.context.startActivities(customStack.getIntents());
            } else {
                this.context.startActivity(conversationScreenIntent);
            }
        }
        this.metricTracker.viewedPushNotification(pushDataString);
        IntercomPushClientHandler.Companion.clear((Context)this.context);
    }

    @Deprecated(message="call {@link #logout()} instead")
    public final void reset() {
        this.metricTracker.resetAPICall();
        this.logout();
    }

    public final void logout() {
        this.metricTracker.logoutAPICall();
        if (!this.userIdentity.isSoftReset()) {
            this.resetManager.softReset();
        }
    }

    public final int getUnreadConversationCount() {
        this.metricTracker.unreadConversationCountAPICall();
        return ((Set)this.dataLayer.getUnreadConversationIds().getValue()).size();
    }

    public final void addUnreadConversationCountListener(@NotNull UnreadConversationCountListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.metricTracker.addUnreadConversationCountListenerAPICall();
        UnreadCountTracker.addListener$default(this.unreadCountTracker, listener2, null, 2, null);
    }

    public final void removeUnreadConversationCountListener(@Nullable UnreadConversationCountListener listener2) {
        block0: {
            this.metricTracker.removeUnreadConversationCountListenerAPICall();
            UnreadConversationCountListener unreadConversationCountListener = listener2;
            if (unreadConversationCountListener == null) break block0;
            UnreadConversationCountListener unreadConversationCountListener2 = unreadConversationCountListener;
            UnreadCountTracker unreadCountTracker = this.unreadCountTracker;
            UnreadConversationCountListener p0 = unreadConversationCountListener2;
            boolean $i$f$removeUnreadConversationCountListener$stub_for_inlining = false;
            boolean bl = false;
            unreadCountTracker.removeListener(p0);
        }
    }

    @Deprecated(message="Use presentContent(IntercomContent.Article(id)) instead.")
    public final void displayArticle(@NotNull String articleId) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        this.metricTracker.displayArticleAPICall();
        Intent intent = IntercomArticleActivity.Companion.buildIntent((Context)this.context, new IntercomArticleActivity.ArticleActivityArguments(articleId, "api", false, false, 12, null));
        this.context.startActivity(intent);
    }

    public final void fetchHelpCenterCollections(@Nullable CollectionRequestCallback collectionRequestCallback) {
        this.metricTracker.fetchHelpCenterCollectionsAPICall();
        CollectionRequestCallback collectionRequestCallback2 = collectionRequestCallback;
        Intrinsics.checkNotNull((Object)collectionRequestCallback2);
        HelpCenterApiWrapper.INSTANCE.fetchHelpCenterCollections(this.metricTracker, collectionRequestCallback2);
    }

    public final void fetchHelpCenterCollection(@Nullable String collectionId, @Nullable CollectionContentRequestCallback collectionContentRequestCallback) {
        this.metricTracker.fetchHelpCenterCollectionAPICall();
        String string2 = collectionId;
        Intrinsics.checkNotNull((Object)string2);
        CollectionContentRequestCallback collectionContentRequestCallback2 = collectionContentRequestCallback;
        Intrinsics.checkNotNull((Object)collectionContentRequestCallback2);
        HelpCenterApiWrapper.INSTANCE.fetchHelpCenterCollection(this.metricTracker, string2, collectionContentRequestCallback2);
    }

    public final void searchHelpCenter(@Nullable String searchTerm, @Nullable SearchRequestCallback searchRequestCallback) {
        this.metricTracker.searchHelpCenterAPICall();
        String string2 = searchTerm;
        Intrinsics.checkNotNull((Object)string2);
        SearchRequestCallback searchRequestCallback2 = searchRequestCallback;
        Intrinsics.checkNotNull((Object)searchRequestCallback2);
        HelpCenterApiWrapper.INSTANCE.fetchHelpCenterResultsForSearchTerm(this.metricTracker, string2, searchRequestCallback2);
    }

    public final void changeWorkspace(@Nullable String apiKey, @Nullable String appId) {
        this.metricTracker.changeWorkspaceAPICall();
        if (apiKey != null && appId != null && ValidatorUtil.isValidAppIdParams(apiKey, appId)) {
            this.logout();
            Injector.get().changeWorkspace(apiKey, appId);
        } else {
            TWIG.e("Workspace has not been changed. Please make sure that you're passing in the correct app ID and API key", new Object[0]);
        }
    }

    @JvmOverloads
    public final void present() {
        Intercom.present$default(this, null, 1, null);
    }

    private static final void softRegister$lambda$2(Intercom this$0) {
        this$0.overlayPresenter.refreshStateBecauseUserIdentityIsNotInStoreYet();
    }

    @JvmStatic
    public static final synchronized void initialize(@Nullable Application application, @Nullable String apiKey, @Nullable String appId) {
        Companion.initialize(application, apiKey, appId);
    }

    @JvmStatic
    @Deprecated(message="Use initialize() instead. SDK will not communicate with Intercom until a user registration is made.")
    public static final synchronized void registerForLaterInitialisation(@Nullable Application application) {
        Companion.registerForLaterInitialisation(application);
    }

    @JvmStatic
    @Deprecated(message="Use initialize() instead. SDK will not communicate with Intercom until a user registration is made.")
    public static final void unregisterForLateInitialisation(@Nullable Application application) {
        Companion.unregisterForLateInitialisation(application);
    }

    @JvmStatic
    @NotNull
    public static final synchronized Intercom client() {
        return Companion.client();
    }

    @JvmStatic
    public static final void setLogLevel(@LogLevel int logLevel) {
        Companion.setLogLevel(logLevel);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u0015\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\u0012\u0010\u0016\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010\u0017\u001a\u00020\u000eH\u0007J\u0012\u0010\u0018\u001a\u00020\u00102\b\b\u0001\u0010\u0019\u001a\u00020\u001aH\u0007J \u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/intercom/android/sdk/Intercom$Companion;", "", "<init>", "()V", "VISIBLE", "Lio/intercom/android/sdk/Intercom$Visibility;", "GONE", "PUSH_RECEIVER", "", "TWIG", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "Lcom/intercom/twig/Twig;", "instance", "Lio/intercom/android/sdk/Intercom;", "initialize", "", "application", "Landroid/app/Application;", "apiKey", "appId", "registerForLaterInitialisation", "unregisterForLateInitialisation", "client", "setLogLevel", "logLevel", "", "create", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final synchronized void initialize(@Nullable Application application, @Nullable String apiKey, @Nullable String appId) {
            if (instance != null) {
                TWIG.i("Intercom has already been initialized", new Object[0]);
                return;
            }
            if (application != null && apiKey != null && appId != null && ValidatorUtil.isValidConstructorParams(application, apiKey, appId)) {
                instance = this.create(application, apiKey, appId);
                LateInitializationPreparer.getInstance().handlePastLifecycleEvents(application, Injector.get());
                Injector.get().getMetricTracker().initialiseAPICall();
                Injector.get().initializeIntercomEventsListeners();
            } else {
                TWIG.e("Intercom has been initialized incorrectly. Please make sure that you're passing in the correct app ID and API key", new Object[0]);
            }
        }

        @JvmStatic
        @Deprecated(message="Use initialize() instead. SDK will not communicate with Intercom until a user registration is made.")
        public final synchronized void registerForLaterInitialisation(@Nullable Application application) {
            if (instance != null) {
                TWIG.i("Intercom has already been initialized", new Object[0]);
                return;
            }
            if (application == null) {
                throw new NullPointerException("Cannot call registerForLaterInitialisation() with a null Application");
            }
            LateInitializationPreparer.getInstance().register(application);
        }

        @JvmStatic
        @Deprecated(message="Use initialize() instead. SDK will not communicate with Intercom until a user registration is made.")
        public final void unregisterForLateInitialisation(@Nullable Application application) {
            Injector.get().getMetricTracker().unRegisterForLateInitialisationAPICall();
            if (application == null) {
                throw new NullPointerException("Cannot call unregisterForLateInitialisation() with a null Application");
            }
            LateInitializationPreparer.getInstance().unregister(application);
        }

        @JvmStatic
        @NotNull
        public final synchronized Intercom client() {
            Intercom intercom = instance;
            if (intercom == null) {
                boolean bl = false;
                String string = "Intercom has been initialized incorrectly. Please make sure the first Intercom method you call is initialize() and that you're passing in the correct app ID and API key";
                throw new IllegalStateException(string.toString());
            }
            return intercom;
        }

        @JvmStatic
        public final void setLogLevel(@LogLevel int logLevel) {
            Injector.get().getMetricTracker().setLogLevelAPICall();
            LumberMill.setLogLevel(logLevel);
        }

        private final Intercom create(Application application, String apiKey, String appId) {
            Injector.initWithAppCredentials(application, apiKey, appId);
            Injector injector = Injector.get();
            IntercomDataLayer dataLayer = injector.getDataLayer();
            ThemeManager.INSTANCE.initialize();
            DeDuper deDuper = injector.getDeDuper();
            Intrinsics.checkNotNullExpressionValue((Object)deDuper, (String)"getDeDuper(...)");
            Provider<Api> provider = injector.getApiProvider();
            Intrinsics.checkNotNullExpressionValue(provider, (String)"getApiProvider(...)");
            Provider<NexusClient> provider2 = injector.getNexusClientProvider();
            Intrinsics.checkNotNullExpressionValue(provider2, (String)"getNexusClientProvider(...)");
            Intrinsics.checkNotNull((Object)dataLayer);
            UnreadCountTracker unreadCountTracker = new UnreadCountTracker(dataLayer);
            MetricTracker metricTracker = injector.getMetricTracker();
            Intrinsics.checkNotNullExpressionValue((Object)metricTracker, (String)"getMetricTracker(...)");
            ErrorReporter errorReporter = injector.getErrorReporter();
            Intrinsics.checkNotNullExpressionValue((Object)errorReporter, (String)"getErrorReporter(...)");
            OverlayPresenter overlayPresenter = injector.getOverlayPresenter();
            Intrinsics.checkNotNullExpressionValue((Object)overlayPresenter, (String)"getOverlayPresenter(...)");
            Provider<AppConfig> provider3 = injector.getAppConfigProvider();
            Intrinsics.checkNotNullExpressionValue(provider3, (String)"getAppConfigProvider(...)");
            UserIdentity userIdentity = injector.getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity, (String)"getUserIdentity(...)");
            Provider<UserUpdater> provider4 = injector.getUserUpdaterProvider();
            Intrinsics.checkNotNullExpressionValue(provider4, (String)"getUserUpdaterProvider(...)");
            ResetManager resetManager = injector.getResetManager();
            Intrinsics.checkNotNullExpressionValue((Object)resetManager, (String)"getResetManager(...)");
            Twig twig = LumberMill.getLogger();
            Intrinsics.checkNotNullExpressionValue((Object)twig, (String)"getLogger(...)");
            ActivityFinisher activityFinisher = injector.getActivityFinisher();
            Intrinsics.checkNotNullExpressionValue((Object)activityFinisher, (String)"getActivityFinisher(...)");
            return new Intercom(deDuper, provider, provider2, unreadCountTracker, metricTracker, errorReporter, application, overlayPresenter, provider3, userIdentity, provider4, resetManager, twig, activityFinisher, dataLayer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0002\b\u0002\b\u0086\u0002\u0018\u0000 \u00022\u00020\u0001:\u0001\u0002B\u0000\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/Intercom$LogLevel;", "", "Companion", "intercom-sdk-base_release"})
    public static @interface LogLevel {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;
        public static final int VERBOSE = 2;
        public static final int DEBUG = 3;
        public static final int INFO = 4;
        public static final int WARN = 5;
        public static final int ERROR = 6;
        public static final int ASSERT = 7;
        public static final int DISABLED = 8;

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/intercom/android/sdk/Intercom$LogLevel$Companion;", "", "<init>", "()V", "VERBOSE", "", "DEBUG", "INFO", "WARN", "ERROR", "ASSERT", "DISABLED", "intercom-sdk-base_release"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            public static final int VERBOSE = 2;
            public static final int DEBUG = 3;
            public static final int INFO = 4;
            public static final int WARN = 5;
            public static final int ERROR = 6;
            public static final int ASSERT = 7;
            public static final int DISABLED = 8;

            private Companion() {
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lio/intercom/android/sdk/Intercom$Visibility;", "", "<init>", "(Ljava/lang/String;I)V", "GONE", "VISIBLE", "intercom-sdk-base_release"})
    public static final class Visibility
    extends Enum<Visibility> {
        public static final /* enum */ Visibility GONE = new Visibility();
        public static final /* enum */ Visibility VISIBLE = new Visibility();
        private static final /* synthetic */ Visibility[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String value) {
            return Enum.valueOf(Visibility.class, value);
        }

        @NotNull
        public static EnumEntries<Visibility> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = visibilityArray = new Visibility[]{Visibility.GONE, Visibility.VISIBLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IntercomPushManager.IntercomPushIntegrationType.values().length];
            try {
                nArray[IntercomPushManager.IntercomPushIntegrationType.FCM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IntercomSpace.values().length];
            try {
                nArray[IntercomSpace.HelpCenter.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntercomSpace.Home.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntercomSpace.Messages.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IntercomSpace.Tickets.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

