/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.app.Notification;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.core.app.NotificationChannelCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.app.Person;
import androidx.core.content.pm.ShortcutInfoCompat;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.push.IntercomPushBitmapUtilsKt;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.m5.push.NotificationChannel;
import io.intercom.android.sdk.m5.push.NotificationPermissionCheckerKt;
import io.intercom.android.sdk.m5.push.ui.ConversationShortcutKt;
import io.intercom.android.sdk.m5.push.ui.ConversationStylePushUIKt;
import io.intercom.android.sdk.m5.push.ui.DeepLinkStylePushUIKt;
import io.intercom.android.sdk.m5.push.ui.IntercomPushConversation;
import io.intercom.android.sdk.models.HostAppState;
import io.intercom.android.sdk.utilities.GroupConversationTextFormatter;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0003\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ\"\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J;\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010!\u001a\u00020\"2\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b#J\u000e\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013JF\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050&2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002JB\u0010-\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002J\u0015\u0010.\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b/R*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u00060"}, d2={"Lio/intercom/android/sdk/m5/push/IntercomNotificationHandler;", "", "<init>", "()V", "conversations", "", "Lio/intercom/android/sdk/m5/push/ui/IntercomPushConversation;", "getConversations$intercom_sdk_base_release$annotations", "getConversations$intercom_sdk_base_release", "()Ljava/util/List;", "setConversations$intercom_sdk_base_release", "(Ljava/util/List;)V", "twig", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "Lcom/intercom/twig/Twig;", "processIntercomPushNotification", "", "context", "Landroid/content/Context;", "intercomPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData;", "customStack", "Landroid/app/TaskStackBuilder;", "timeProvider", "Lio/intercom/android/sdk/utilities/commons/TimeProvider;", "processIntercomPushNotification$intercom_sdk_base_release", "processDeepLinkPushNotification", "deepLinkPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData$DeepLinkPushData;", "processConversationPushNotification", "conversationPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData$ConversationPushData;", "isSilent", "", "processConversationPushNotification$intercom_sdk_base_release", "clear", "updateConversations", "Lkotlin/Pair;", "timestamp", "", "avatarBitmap", "Landroid/graphics/Bitmap;", "contentImageUri", "Landroid/net/Uri;", "getOrCreateConversation", "setUpNotificationChannels", "setUpNotificationChannels$intercom_sdk_base_release", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nIntercomNotificationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntercomNotificationHandler.kt\nio/intercom/android/sdk/m5/push/IntercomNotificationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,300:1\n1#2:301\n1#2:320\n1663#3,8:302\n1611#3,9:310\n1863#3:319\n1864#3:321\n1620#3:322\n*S KotlinDebug\n*F\n+ 1 IntercomNotificationHandler.kt\nio/intercom/android/sdk/m5/push/IntercomNotificationHandler\n*L\n246#1:320\n246#1:302,8\n246#1:310,9\n246#1:319\n246#1:321\n246#1:322\n*E\n"})
public final class IntercomNotificationHandler {
    @NotNull
    public static final IntercomNotificationHandler INSTANCE = new IntercomNotificationHandler();
    @NotNull
    private static List<IntercomPushConversation> conversations = CollectionsKt.emptyList();
    private static final Twig twig = LumberMill.getLogger();
    public static final int $stable = 8;

    private IntercomNotificationHandler() {
    }

    @NotNull
    public final List<IntercomPushConversation> getConversations$intercom_sdk_base_release() {
        return conversations;
    }

    public final void setConversations$intercom_sdk_base_release(@NotNull List<IntercomPushConversation> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        conversations = list;
    }

    @VisibleForTesting
    public static /* synthetic */ void getConversations$intercom_sdk_base_release$annotations() {
    }

    public final void processIntercomPushNotification$intercom_sdk_base_release(@NotNull Context context, @NotNull IntercomPushData intercomPushData, @Nullable TaskStackBuilder customStack, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intercomPushData, (String)"intercomPushData");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        IntercomPushData intercomPushData2 = intercomPushData;
        if (intercomPushData2 instanceof IntercomPushData.DeepLinkPushData) {
            this.processDeepLinkPushNotification(context, (IntercomPushData.DeepLinkPushData)intercomPushData, customStack);
        } else if (intercomPushData2 instanceof IntercomPushData.ConversationPushData) {
            IntercomNotificationHandler.processConversationPushNotification$intercom_sdk_base_release$default(this, context, (IntercomPushData.ConversationPushData)intercomPushData, customStack, false, timeProvider, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void processIntercomPushNotification$intercom_sdk_base_release$default(IntercomNotificationHandler intercomNotificationHandler, Context context, IntercomPushData intercomPushData, TaskStackBuilder taskStackBuilder, TimeProvider timeProvider, int n, Object object) {
        if ((n & 8) != 0) {
            timeProvider = TimeProvider.SYSTEM;
        }
        intercomNotificationHandler.processIntercomPushNotification$intercom_sdk_base_release(context, intercomPushData, taskStackBuilder, timeProvider);
    }

    private final void processDeepLinkPushNotification(Context context, IntercomPushData.DeepLinkPushData deepLinkPushData, TaskStackBuilder customStack) {
        twig.i("This is a push only message", new Object[0]);
        Injector.get().getMetricTracker().receivedPushOnlyNotification("instance_id:" + deepLinkPushData.getInstanceId(), deepLinkPushData.getInstanceId());
        IntercomPushBitmapUtilsKt.loadBitmaps$default(context, deepLinkPushData.getContentImageUrl(), null, null, (arg_0, arg_1) -> IntercomNotificationHandler.processDeepLinkPushNotification$lambda$0(context, deepLinkPushData, customStack, arg_0, arg_1), 12, null);
    }

    public final void processConversationPushNotification$intercom_sdk_base_release(@NotNull Context context, @NotNull IntercomPushData.ConversationPushData conversationPushData, @Nullable TaskStackBuilder customStack, boolean isSilent, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversationPushData, (String)"conversationPushData");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        if (((HostAppState)Injector.get().getDataLayer().getHostAppState().getValue()).isBackgrounded()) {
            twig.i("This is a background push message", new Object[0]);
            Injector.get().getMetricTracker().receivedPushNotification(conversationPushData.getConversationId());
            IntercomPushBitmapUtilsKt.loadBitmaps(context, conversationPushData.getMessageData() instanceof IntercomPushData.ConversationPushData.MessageData.Image ? ((IntercomPushData.ConversationPushData.MessageData.Image)conversationPushData.getMessageData()).getUrl() : "", conversationPushData.getAvatarUrl(), conversationPushData.getAuthorName(), (Function2<? super Bitmap, ? super Bitmap, Unit>)((Function2)(arg_0, arg_1) -> IntercomNotificationHandler.processConversationPushNotification$lambda$4(context, conversationPushData, timeProvider, isSilent, customStack, arg_0, arg_1)));
        } else {
            twig.i("Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.", new Object[0]);
        }
    }

    public static /* synthetic */ void processConversationPushNotification$intercom_sdk_base_release$default(IntercomNotificationHandler intercomNotificationHandler, Context context, IntercomPushData.ConversationPushData conversationPushData, TaskStackBuilder taskStackBuilder, boolean bl, TimeProvider timeProvider, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            timeProvider = TimeProvider.SYSTEM;
        }
        intercomNotificationHandler.processConversationPushNotification$intercom_sdk_base_release(context, conversationPushData, taskStackBuilder, bl, timeProvider);
    }

    public final synchronized void clear(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!((Collection)conversations).isEmpty()) {
            twig.i("Removing Intercom push notifications.", new Object[0]);
        }
        try {
            NotificationManagerCompat $this$clear_u24lambda_u245 = NotificationManagerCompat.from((Context)context);
            boolean bl = false;
            $this$clear_u24lambda_u245.cancelAll();
        }
        catch (NullPointerException e) {
            Object[] objectArray = new Object[]{e};
            twig.w("Failed to clear notifications due to unavailable NotificationManager service.", objectArray);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e};
            twig.w("Failed to clear notifications due to unexpected error.", objectArray);
        }
        conversations = CollectionsKt.emptyList();
    }

    private final synchronized Pair<IntercomPushConversation, List<IntercomPushConversation>> updateConversations(Context context, IntercomPushData.ConversationPushData conversationPushData, long timestamp, Bitmap avatarBitmap, Uri contentImageUri) {
        IntercomPushConversation conversation = this.getOrCreateConversation(context, conversations, conversationPushData, timestamp, avatarBitmap, contentImageUri);
        List updatedConversations = CollectionsKt.toMutableList((Collection)conversations);
        CollectionsKt.removeAll((List)updatedConversations, arg_0 -> IntercomNotificationHandler.updateConversations$lambda$6(conversation, arg_0));
        updatedConversations.add(conversation);
        conversations = updatedConversations;
        return TuplesKt.to((Object)conversation, (Object)updatedConversations);
    }

    /*
     * WARNING - void declaration
     */
    private final IntercomPushConversation getOrCreateConversation(Context context, List<IntercomPushConversation> conversations, IntercomPushData.ConversationPushData conversationPushData, long timestamp, Bitmap avatarBitmap, Uri contentImageUri) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list;
        Object v0;
        block8: {
            Iterable iterable = conversations;
            for (Object t : iterable) {
                IntercomPushConversation it = (IntercomPushConversation)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getConversationId(), (Object)conversationPushData.getConversationId())) continue;
                v0 = t;
                break block8;
            }
            v0 = null;
        }
        IntercomPushConversation intercomPushConversation = v0;
        if (intercomPushConversation == null) {
            CharSequence charSequence;
            String string2 = conversationPushData.getConversationId();
            CharSequence charSequence2 = conversationPushData.getAuthorName();
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                String string3 = string2;
                boolean bl = false;
                String string4 = context.getString(R.string.intercom_new_notifications);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                charSequence = string4;
                string2 = string3;
            } else {
                charSequence = charSequence2;
            }
            List list2 = CollectionsKt.listOf((Object)ConversationStylePushUIKt.toMessage(conversationPushData, timestamp, avatarBitmap, contentImageUri));
            String string5 = (String)charSequence;
            String string6 = string2;
            return new IntercomPushConversation(string6, string5, list2);
        }
        IntercomPushConversation conversation = intercomPushConversation;
        IntercomPushConversation.Message message = (IntercomPushConversation.Message)CollectionsKt.lastOrNull(conversation.getMessages());
        boolean bl = message != null ? message.isCurrentUser() : false;
        if (bl && !conversationPushData.isCurrentUser()) {
            list = CollectionsKt.listOf((Object)ConversationStylePushUIKt.toMessage(conversationPushData, timestamp, avatarBitmap, contentImageUri));
        } else {
            List list3;
            List $this$getOrCreateConversation_u24lambda_u249 = list3 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            $this$getOrCreateConversation_u24lambda_u249.addAll((Collection)conversation.getMessages());
            $this$getOrCreateConversation_u24lambda_u249.add(ConversationStylePushUIKt.toMessage(conversationPushData, timestamp, avatarBitmap, contentImageUri));
            list = CollectionsKt.build((List)list3);
        }
        List messages = list;
        Iterable $this$distinctBy$iv = messages;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            IntercomPushConversation.Message it = (IntercomPushConversation.Message)e$iv;
            boolean bl3 = false;
            Person person = it.getPerson();
            String key$iv = person != null ? person.getKey() : null;
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$mapNotNull = false;
        set$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Person it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            IntercomPushConversation.Message it = (IntercomPushConversation.Message)element$iv$iv;
            boolean bl5 = false;
            if (it.getPerson() == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List persons = (List)destination$iv$iv;
        String conversationTitle = persons.size() > 1 ? ((Object)GroupConversationTextFormatter.groupConversationTitle(String.valueOf(((Person)CollectionsKt.last((List)persons)).getName()), CollectionsKt.getLastIndex((List)persons), context)).toString() : conversation.getConversationTitle();
        return IntercomPushConversation.copy$default(conversation, null, conversationTitle, messages, 1, null);
    }

    public final void setUpNotificationChannels$intercom_sdk_base_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            NotificationChannelCompat notificationChannelCompat = new NotificationChannelCompat.Builder(NotificationChannel.CHAT_REPLIES_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_chat_replies_title)).setDescription(context.getString(R.string.intercom_notification_channel_chat_replies_description)).build();
            Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat, (String)"build(...)");
            NotificationChannelCompat replies = notificationChannelCompat;
            NotificationChannelCompat notificationChannelCompat2 = new NotificationChannelCompat.Builder(NotificationChannel.NEW_CHATS_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_new_chats_title)).setDescription(context.getString(R.string.intercom_notification_channel_new_chats_description)).build();
            Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat2, (String)"build(...)");
            NotificationChannelCompat newChats = notificationChannelCompat2;
            NotificationChannelCompat notificationChannelCompat3 = new NotificationChannelCompat.Builder(NotificationChannel.ACTIONS_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_actions_title)).setDescription(context.getString(R.string.intercom_notification_channel_actions_description)).build();
            Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat3, (String)"build(...)");
            NotificationChannelCompat actions = notificationChannelCompat3;
            NotificationManagerCompat $this$setUpNotificationChannels_u24lambda_u2412 = NotificationManagerCompat.from((Context)context);
            boolean bl = false;
            Object[] objectArray = new NotificationChannelCompat[]{replies, newChats, actions};
            $this$setUpNotificationChannels_u24lambda_u2412.createNotificationChannelsCompat(CollectionsKt.listOf((Object[])objectArray));
        }
        catch (NullPointerException e) {
            Object[] objectArray = new Object[]{e};
            twig.w("Failed to create notification channels due to unavailable NotificationManager service. This can happen during app initialization or in restricted environments. Notifications may not work until the service becomes available.", objectArray);
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e};
            twig.w("Failed to create notification channels due to unexpected error.", objectArray);
        }
    }

    private static final Unit processDeepLinkPushNotification$lambda$0(Context $context, IntercomPushData.DeepLinkPushData $deepLinkPushData, TaskStackBuilder $customStack, Bitmap contentBitmap, Bitmap bitmap) {
        Notification notification = DeepLinkStylePushUIKt.buildDeepLinkNotification($context, $deepLinkPushData, contentBitmap, $customStack);
        int n = $deepLinkPushData.getNotificationId();
        Twig twig = IntercomNotificationHandler.twig;
        Intrinsics.checkNotNullExpressionValue((Object)twig, (String)"twig");
        NotificationPermissionCheckerKt.showNotification($context, n, notification, twig);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit processConversationPushNotification$lambda$4(Context $context, IntercomPushData.ConversationPushData $conversationPushData, TimeProvider $timeProvider, boolean $isSilent, TaskStackBuilder $customStack, Bitmap contentBitmap, Bitmap avatarBitmap) {
        void $this$processConversationPushNotification_u24lambda_u244_u24lambda_u243;
        Map map2;
        Uri uri;
        IntercomNotificationHandler intercomNotificationHandler;
        IntercomNotificationHandler intercomNotificationHandler2 = INSTANCE;
        Context context = $context;
        IntercomPushData.ConversationPushData conversationPushData = $conversationPushData;
        long l = $timeProvider.currentTimeMillis();
        Bitmap bitmap = avatarBitmap;
        Bitmap bitmap2 = contentBitmap;
        if (bitmap2 != null) {
            void it;
            Bitmap bitmap3 = bitmap2;
            Bitmap bitmap4 = bitmap;
            long l2 = l;
            IntercomPushData.ConversationPushData conversationPushData2 = conversationPushData;
            Context context2 = context;
            intercomNotificationHandler = intercomNotificationHandler2;
            boolean bl = false;
            Uri uri2 = IntercomPushBitmapUtilsKt.getBitmapUri($context, (Bitmap)it);
            intercomNotificationHandler2 = intercomNotificationHandler;
            context = context2;
            conversationPushData = conversationPushData2;
            l = l2;
            bitmap = bitmap4;
            uri = uri2;
        } else {
            uri = null;
        }
        Pair<IntercomPushConversation, List<IntercomPushConversation>> pair = intercomNotificationHandler2.updateConversations(context, conversationPushData, l, bitmap, uri);
        IntercomPushConversation conversation = (IntercomPushConversation)pair.component1();
        List conversations = (List)pair.component2();
        Pair<List<ShortcutInfoCompat>, ShortcutInfoCompat> pair2 = ConversationShortcutKt.createTemporaryShortcut($context, conversation.getConversationId(), conversation.getConversationTitle(), avatarBitmap);
        List dynamicShortcuts = (List)pair2.component1();
        ShortcutInfoCompat temporaryShortcut = (ShortcutInfoCompat)pair2.component2();
        NotificationChannel notificationChannel = $conversationPushData.isNewConversation() ? NotificationChannel.NEW_CHATS_CHANNEL : NotificationChannel.CHAT_REPLIES_CHANNEL;
        Notification conversationNotification = ConversationStylePushUIKt.buildConversationStyleNotification($context, conversation, temporaryShortcut, $conversationPushData, notificationChannel, $isSilent, $customStack);
        Notification summaryNotification = conversations.size() > 1 ? ConversationStylePushUIKt.buildConversationStyleSummaryNotification($context, conversations, notificationChannel, $customStack) : null;
        Map map3 = map2 = MapsKt.createMapBuilder();
        intercomNotificationHandler = $context;
        boolean bl = false;
        $this$processConversationPushNotification_u24lambda_u244_u24lambda_u243.put($conversationPushData.getNotificationId(), conversationNotification);
        Notification notification = summaryNotification;
        if (notification != null) {
            Notification it = notification;
            boolean bl2 = false;
            $this$processConversationPushNotification_u24lambda_u244_u24lambda_u243.put(9999997, it);
        }
        Map map4 = MapsKt.build((Map)map2);
        Twig twig = IntercomNotificationHandler.twig;
        Intrinsics.checkNotNullExpressionValue((Object)twig, (String)"twig");
        NotificationPermissionCheckerKt.showNotifications((Context)intercomNotificationHandler, map4, twig);
        Twig twig2 = IntercomNotificationHandler.twig;
        Intrinsics.checkNotNullExpressionValue((Object)twig2, (String)"twig");
        ConversationShortcutKt.resetShortcuts($context, dynamicShortcuts, temporaryShortcut, twig2);
        return Unit.INSTANCE;
    }

    private static final boolean updateConversations$lambda$6(IntercomPushConversation $conversation, IntercomPushConversation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getConversationId(), (Object)$conversation.getConversationId());
    }
}

