/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.sheets;

import android.annotation.SuppressLint;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.sheets.SheetListener;
import io.intercom.android.sdk.sheets.SheetWebViewClient;
import io.intercom.android.sdk.sheets.SheetWebViewInterface;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class SheetWebViewPresenter {
    private final WebView webView;
    private final JavascriptRunner jsRunner;
    private final String sheetUrl;
    private final SheetListener listener;
    private final Injector injector;

    public SheetWebViewPresenter(WebView webView, JavascriptRunner jsRunner, String sheetUrl, SheetListener listener2, Injector injector) {
        this.webView = webView;
        this.jsRunner = jsRunner;
        this.sheetUrl = sheetUrl;
        this.listener = listener2;
        this.injector = injector;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setUpWebView() {
        this.webView.setVerticalScrollBarEnabled(false);
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setUserAgentString("IntercomMobileWebView");
        webSettings.setLoadWithOverviewMode(true);
        webSettings.setUseWideViewPort(true);
        webSettings.setDomStorageEnabled(true);
        webSettings.setCacheMode(1);
        SheetWebViewInterface sheetWebViewInterface = new SheetWebViewInterface(this.webView, this.injector.getGson(), this.injector.getMetricTracker(), this.injector.getApi(), this.listener);
        this.webView.addJavascriptInterface((Object)sheetWebViewInterface, "AndroidHost");
        this.webView.setWebViewClient((WebViewClient)new SheetWebViewClient(this.listener));
    }

    public void loadBundle(String data) {
        String postData;
        this.jsRunner.reset();
        try {
            postData = "intercom_data=" + URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return;
        }
        this.webView.postUrl(this.sheetUrl, postData.getBytes());
    }
}

