/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import com.google.gson.annotations.SerializedName;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.NullSafety;

public class User {
    public static final User NULL = new User();
    @SerializedName(value="intercom_id")
    private final String intercomId;
    @SerializedName(value="anonymous_id")
    private final String anonymousId;
    @SerializedName(value="user_id")
    private final String userId;
    @SerializedName(value="encrypted_user_id")
    private final String encryptedUserId;
    private final String email;

    public User() {
        this.intercomId = "";
        this.encryptedUserId = "";
        this.anonymousId = "";
        this.userId = "";
        this.email = "";
    }

    User(Builder builder) {
        this.intercomId = NullSafety.valueOrEmpty(builder.intercom_id);
        this.encryptedUserId = NullSafety.valueOrEmpty(builder.encrypted_user_id);
        this.anonymousId = NullSafety.valueOrEmpty(builder.anonymous_id);
        this.userId = NullSafety.valueOrEmpty(builder.user_id);
        this.email = NullSafety.valueOrEmpty(builder.email);
    }

    public String getIntercomId() {
        return this.intercomId;
    }

    public String getEncryptedUserId() {
        return this.encryptedUserId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAnonymousId() {
        return this.anonymousId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (!this.intercomId.equals(user.intercomId)) {
            return false;
        }
        if (!this.encryptedUserId.equals(user.encryptedUserId)) {
            return false;
        }
        if (!this.anonymousId.equals(user.anonymousId)) {
            return false;
        }
        if (!this.userId.equals(user.userId)) {
            return false;
        }
        return this.email.equals(user.email);
    }

    public int hashCode() {
        int result2 = this.intercomId.hashCode();
        result2 = 31 * result2 + this.encryptedUserId.hashCode();
        result2 = 31 * result2 + this.anonymousId.hashCode();
        result2 = 31 * result2 + this.userId.hashCode();
        result2 = 31 * result2 + this.email.hashCode();
        return result2;
    }

    public static final class Builder {
        String intercom_id;
        String encrypted_user_id;
        String anonymous_id;
        String user_id;
        String email;
        private Avatar.Builder avatar;

        public Builder withIntercomId(String intercomId) {
            this.intercom_id = intercomId;
            return this;
        }

        public Builder withEncryptedUserId(String encryptedUserId) {
            this.encrypted_user_id = encryptedUserId;
            return this;
        }

        public Builder withAnonymousId(String anonymousId) {
            this.anonymous_id = anonymousId;
            return this;
        }

        public Builder withUserId(String userId) {
            this.user_id = userId;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withAvatar(Avatar.Builder avatar) {
            this.avatar = avatar;
            return this;
        }

        public User build() {
            return new User(this);
        }
    }
}

