/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import android.text.format.DateUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.CurrentlyTypingState;
import io.intercom.android.sdk.m5.conversation.states.GroupingPosition;
import io.intercom.android.sdk.m5.conversation.states.PendingMessage;
import io.intercom.android.sdk.m5.conversation.states.TypingIndicatorType;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.tickets.TicketDetailReducerKt;
import io.intercom.android.sdk.tickets.TicketLaunchedFrom;
import io.intercom.android.sdk.utilities.extensions.ConversationExtensionsKt;
import io.intercom.android.sdk.utilities.extensions.PartExtensionsKt;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a&\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u001a$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012H\u0002\u001a\u001e\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a8\u0006\u001a"}, d2={"reduceMessages", "", "Lio/intercom/android/sdk/m5/conversation/states/ContentRow;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "shouldShowQuickReplies", "", "Lio/intercom/android/sdk/models/Part;", "isLastPart", "isAdminOrAltParticipant", "part", "reduceEvent", "hasPendingMessageAfter", "pendingMessages", "", "", "Lio/intercom/android/sdk/m5/conversation/states/PendingMessage;", "getGroupingPosition", "Lio/intercom/android/sdk/m5/conversation/states/GroupingPosition;", "allParts", "index", "", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nConversationPartsReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationPartsReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationPartsReducerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,253:1\n827#2:254\n855#2,2:255\n785#2:257\n796#2:258\n1872#2,2:259\n797#2,2:261\n1874#2:263\n799#2:264\n1485#2:265\n1510#2,3:266\n1513#2,3:276\n1863#2:279\n1557#2:280\n1628#2,3:281\n1567#2:284\n1598#2,4:285\n1864#2:289\n381#3,7:269\n1#4:290\n*S KotlinDebug\n*F\n+ 1 ConversationPartsReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationPartsReducerKt\n*L\n50#1:254\n50#1:255,2\n54#1:257\n54#1:258\n54#1:259,2\n54#1:261,2\n54#1:263\n54#1:264\n67#1:265\n67#1:266,3\n67#1:276,3\n73#1:279\n81#1:280\n81#1:281,3\n86#1:284\n86#1:285,4\n73#1:289\n67#1:269,7\n*E\n"})
public final class ConversationPartsReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContentRow> reduceMessages(@NotNull ConversationClientState clientState, @NotNull UserIdentity userIdentity, @NotNull AppConfig config) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Conversation conversation = clientState.getConversation();
        if (conversation == null) {
            return CollectionsKt.emptyList();
        }
        Conversation conversation2 = conversation;
        if (conversation2.getTicket() != null && !ConversationExtensionsKt.hasNonTicketParts(conversation2) && clientState.getPendingMessages().isEmpty()) {
            return CollectionsKt.listOf((Object)new ContentRow.BigTicketRow(TicketDetailReducerKt.computeTicketViewState$default(conversation2.getTicket(), userIdentity, null, new TicketLaunchedFrom.Conversation(conversation2.getTicket()), 4, null), conversation2.getTicket().getId()));
        }
        List $this$reduceMessages_u24lambda_u249 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object lastFilteredPart = null;
        Iterable iterable = conversation2.parts();
        boolean $i$f$filterNot = false;
        void var10_12 = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Part it = (Part)element$iv$iv;
            boolean bl2 = false;
            List<ReplyOption> list2 = it.getReplyOptions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getReplyOptions(...)");
            if (!((Collection)list2).isEmpty() && conversation2.getPreventEndUserReplies()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterIndexed = false;
        $this$filterNotTo$iv$iv = $this$filterIndexed$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        Iterator $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        Iterator bl2 = $this$forEachIndexed$iv$iv$iv.iterator();
        while (bl2.hasNext()) {
            void part;
            void element$iv$iv;
            int n;
            Object item$iv$iv$iv = bl2.next();
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl3 = false;
            Part part2 = (Part)element$iv$iv;
            int index = index$iv$iv;
            boolean bl4 = false;
            boolean bl5 = part.getMessageStyle() != MessageStyle.QUICK_REPLY || index == CollectionsKt.getLastIndex(conversation2.parts()) && !ConversationPartsReducerKt.hasPendingMessageAfter((Part)part, clientState.getPendingMessages());
            if (!bl5) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$reduceMessages_u24lambda_u249_u24lambda_u242 = $this$filterIndexed$iv = (List)destination$iv$iv;
        boolean $i$a$-apply-ConversationPartsReducerKt$reduceMessages$1$42 = false;
        lastFilteredPart = CollectionsKt.lastOrNull((List)$this$reduceMessages_u24lambda_u249_u24lambda_u242);
        $this$filterIndexed$iv = $this$filterIndexed$iv;
        boolean $i$f$groupBy = false;
        void $i$a$-apply-ConversationPartsReducerKt$reduceMessages$1$42 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Calendar cal;
            Part it = (Part)element$iv$iv;
            boolean bl6 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Calendar.getInstance(), (String)"getInstance(...)");
            cal.setTime(new Date(it.getCreatedAt() * (long)1000));
            Integer key$iv$iv = cal.get(6);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl7 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapIndexedTo$iv$iv;
            List list3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List it = (List)element$iv;
            boolean bl8 = false;
            boolean isToday = DateUtils.isToday((long)(((Part)CollectionsKt.first((List)it)).getCreatedAt() * (long)1000));
            if (!((Part)CollectionsKt.first((List)it)).isInitialMessage() || !PartExtensionsKt.isLinkCard((Part)CollectionsKt.first((List)it)) && !isToday) {
                $this$reduceMessages_u24lambda_u249.add(new ContentRow.DayDividerRow(((Part)CollectionsKt.first((List)it)).getCreatedAt()));
            }
            Iterable list$iv$iv = clientState.getPendingMessages().values();
            Collection collection = it;
            boolean $i$f$map22 = false;
            void key$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pending;
                PendingMessage index = (PendingMessage)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl9 = false;
                collection2.add(pending.getPart());
            }
            List allConcatParts = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            List $i$f$map22 = list3 = CollectionsKt.createListBuilder();
            collection = $this$reduceMessages_u24lambda_u249;
            boolean bl10 = false;
            Iterable $this$mapIndexed$iv = it;
            boolean $i$f$mapIndexed = false;
            Iterable value$iv$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                boolean bl11;
                void $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247;
                void part;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Part part3 = (Part)item$iv$iv;
                int n2 = n;
                Collection collection3 = destination$iv$iv3;
                boolean bl12 = false;
                if (clientState.getNewMessageId() != null && Intrinsics.areEqual((Object)clientState.getNewMessageId(), (Object)part.getId())) {
                    String string2 = part.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                    $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(new ContentRow.NewMessagesRow(string2));
                }
                if (part.isInitialMessage() && PartExtensionsKt.isLinkCard((Part)part)) {
                    bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(new ContentRow.AskedAboutRow((Part)part));
                } else if (part.isEvent().booleanValue()) {
                    bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(ConversationPartsReducerKt.reduceEvent((Part)part));
                } else if (part.getMessageStyle() == MessageStyle.POST) {
                    bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(new ContentRow.PostCardRow((Part)part, config.getName()));
                } else if (part.getMessageStyle() == MessageStyle.NOTE) {
                    bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(new ContentRow.NoteCardRow((Part)part, config.getName()));
                } else if (part.getMessageStyle() == MessageStyle.FIN_ANSWER) {
                    ContentRow.FinAnswerRow finAnswerRow = new ContentRow.FinAnswerRow((Part)part, ConversationPartsReducerKt.getGroupingPosition(allConcatParts, (int)index));
                    bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(finAnswerRow);
                } else if (PartExtensionsKt.isQuickReplyOnly((Part)part)) {
                    List<ReplyOption> list4 = part.getReplyOptions();
                    Intrinsics.checkNotNullExpressionValue(list4, (String)"getReplyOptions(...)");
                    String string3 = part.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
                    bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(new ContentRow.QuickRepliesRow(list4, string3));
                } else {
                    void var36_61;
                    boolean isAdminOrAltParticipant = ConversationPartsReducerKt.isAdminOrAltParticipant((Part)part, userIdentity);
                    Part part4 = (Part)lastFilteredPart;
                    boolean isLastPart = Intrinsics.areEqual((Object)part.getId(), (Object)(part4 != null ? part4.getId() : null)) && clientState.getPendingMessages().isEmpty() && !clientState.getFinStreamingData().isFinStreaming() && Intrinsics.areEqual((Object)clientState.getCurrentlyTypingState(), (Object)new CurrentlyTypingState(null, false, null, TypingIndicatorType.NONE, 7, null));
                    void $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245 = var36_61 = part;
                    boolean bl13 = false;
                    $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setParentConversation(conversation2);
                    List<String> list5 = clientState.getLoadingAttributeIdentifiers();
                    List<String> list6 = clientState.getFailedAttributeIdentifiers();
                    boolean bl14 = isAdminOrAltParticipant;
                    boolean bl15 = isLastPart;
                    void var44_69 = var36_61;
                    ContentRow.BubbleMessageRow.PartWrapper partWrapper = new ContentRow.BubbleMessageRow.PartWrapper((Part)var44_69, bl15, bl14, list6, list5);
                    GroupingPosition groupingPosition = ConversationPartsReducerKt.getGroupingPosition(allConcatParts, (int)index);
                    ContentRow.BubbleMessageRow messageRow = new ContentRow.BubbleMessageRow(partWrapper, groupingPosition, null, false, false, 16, null);
                    if (ConversationPartsReducerKt.shouldShowQuickReplies((Part)part, isLastPart, isAdminOrAltParticipant)) {
                        $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(messageRow);
                        List<ReplyOption> list7 = part.getReplyOptions();
                        Intrinsics.checkNotNullExpressionValue(list7, (String)"getReplyOptions(...)");
                        String string4 = part.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getId(...)");
                        bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(new ContentRow.QuickRepliesRow(list7, string4));
                    } else {
                        bl11 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(messageRow);
                    }
                }
                collection3.add(bl11);
            }
            List cfr_ignored_0 = (List)destination$iv$iv3;
            collection.addAll(CollectionsKt.build((List)list3));
        }
        return CollectionsKt.build((List)list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean shouldShowQuickReplies(Part $this$shouldShowQuickReplies, boolean isLastPart, boolean isAdminOrAltParticipant) {
        if (!isLastPart) return false;
        List<ReplyOption> list = $this$shouldShowQuickReplies.getReplyOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getReplyOptions(...)");
        if (((Collection)list).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        if (!isAdminOrAltParticipant) return false;
        return true;
    }

    public static final boolean isAdminOrAltParticipant(@NotNull Part part, @NotNull UserIdentity userIdentity) {
        Intrinsics.checkNotNullParameter((Object)part, (String)"part");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        return part.isAdmin() || !part.getParticipant().isUserWithId(userIdentity.getIntercomId());
    }

    private static final ContentRow reduceEvent(Part part) {
        ContentRow contentRow;
        MessageStyle messageStyle = part.getMessageStyle();
        switch (messageStyle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageStyle.ordinal()]) {
            case 1: {
                String string2 = part.getEventData().getStatus();
                String string3 = part.getEventData().getEventAsPlainText();
                long l = part.getCreatedAt();
                String string4 = part.getEventData().getCustomStateLabel();
                String string5 = part.getEventData().getCustomStatePrefix();
                String string6 = part.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getId(...)");
                contentRow = new ContentRow.TicketStatusRow(string2, string3, l, string4, string5, string6);
                break;
            }
            case 2: {
                String string7 = part.getEventData().getMergedConversationId();
                String string8 = part.getEventData().getDescription();
                String string9 = part.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getId(...)");
                String string10 = string9;
                contentRow = new ContentRow.MergedConversationRow(string8, string7, string10);
                break;
            }
            default: {
                String string11 = part.getEventData().getEventAsPlainText();
                Avatar avatar = Avatar.create(part.getEventData().getParticipant().getAvatar().getImageUrl(), part.getEventData().getParticipant().getInitial());
                Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"create(...)");
                String string12 = part.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getId(...)");
                contentRow = new ContentRow.EventRow(string11, avatar, string12);
            }
        }
        return contentRow;
    }

    private static final boolean hasPendingMessageAfter(Part part, Map<String, PendingMessage> pendingMessages) {
        Comparable comparable;
        Iterable iterable = pendingMessages.values();
        long l = part.getCreatedAt();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            PendingMessage it = (PendingMessage)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getPart().getCreatedAt());
            while (iterator.hasNext()) {
                PendingMessage it2 = (PendingMessage)iterator.next();
                $i$a$-maxOfOrNull-ConversationPartsReducerKt$hasPendingMessageAfter$1 = false;
                Comparable comparable3 = Long.valueOf(it2.getPart().getCreatedAt());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Comparable comparable4 = comparable;
        Long l2 = (Long)comparable4;
        if (l2 == null) {
            return false;
        }
        return l < l2;
    }

    @NotNull
    public static final GroupingPosition getGroupingPosition(@NotNull List<? extends Part> allParts, int index) {
        Intrinsics.checkNotNullParameter(allParts, (String)"allParts");
        return PartExtensionsKt.hasPreviousConcatPartNewStyle(allParts, index) && PartExtensionsKt.hasNextConcatPartNewStyle(allParts, index) ? GroupingPosition.MIDDLE : (PartExtensionsKt.hasPreviousConcatPartNewStyle(allParts, index) ? GroupingPosition.BOTTOM : (PartExtensionsKt.hasNextConcatPartNewStyle(allParts, index) ? GroupingPosition.TOP : GroupingPosition.STANDALONE));
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageStyle.values().length];
            try {
                nArray[MessageStyle.TICKET_STATE_UPDATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageStyle.MERGED_PRIMARY_CONVERSATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

