/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.gson.Gson;
import com.intercom.twig.Twig;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.sdk.AppIdentityInjector;
import io.intercom.android.sdk.LifecycleTracker;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.ExternalUploadApi;
import io.intercom.android.sdk.api.MessengerApi;
import io.intercom.android.sdk.api.SurveyApi;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.errorreporting.ErrorReporter;
import io.intercom.android.sdk.exceptions.IntercomIntegrationException;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.metrics.UnreadConversationsTracker;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.overlay.OverlayPresenter;
import io.intercom.android.sdk.tickets.create.data.TicketApi;
import io.intercom.android.sdk.user.UserUpdaterHelper;
import io.intercom.android.sdk.utilities.ActivityFinisher;
import io.intercom.android.sdk.utilities.FirstMessageUtilsKt;
import io.intercom.android.sdk.utilities.SystemSettings;
import io.intercom.android.sdk.utilities.UuidStringProvider;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.SupervisorKt;

public class Injector {
    @SuppressLint(value={"StaticFieldLeak"})
    @Nullable
    private static Injector instance;
    private static final Twig TWIG;
    private final Application application;
    private final UserIdentity userIdentity;
    private final ActivityFinisher activityFinisher = new ActivityFinisher();
    private final CoroutineScope applicationScope;
    private AppIdentityInjector appIdentityInjector;
    @Nullable
    private DeDuper superDeDuper;
    @Nullable
    private MetricsStore metricsStore;
    @Nullable
    private MetricTracker metricTracker;
    @Nullable
    private OpsMetricTracker opsMetricTracker;
    @Nullable
    private OverlayPresenter overlayPresenter;
    @Nullable
    private LifecycleTracker lifecycleTracker;
    @Nullable
    private UserUpdater userUpdater;
    @Nullable
    private ResetManager resetManager;
    @Nullable
    private Gson gson;
    @Nullable
    private ErrorReporter errorReporter;
    @Nullable
    private IntercomDataLayer dataLayer;
    @Nullable
    private UnreadConversationsTracker unreadConversationsTracker;
    @Nullable
    private UserUpdaterHelper userUpdaterHelper;
    private final Provider<AppConfig> appConfigProvider = new Provider<AppConfig>(){

        @Override
        public AppConfig get() {
            return (AppConfig)Injector.this.dataLayer.getConfig().getValue();
        }
    };
    private final Provider<NexusClient> nexusClientProvider = new Provider<NexusClient>(){

        @Override
        public NexusClient get() {
            return Injector.this.getNexusClient();
        }
    };
    private final Provider<UserUpdater> userUpdaterProvider = new Provider<UserUpdater>(){

        @Override
        public UserUpdater get() {
            return Injector.this.getUserUpdater();
        }
    };
    private final Provider<Api> apiProvider = new Provider<Api>(){

        @Override
        public Api get() {
            return Injector.this.getApi();
        }
    };
    private final Provider<UserIdentity> userIdentityProvider = new Provider<UserIdentity>(){

        @Override
        public UserIdentity get() {
            return Injector.this.getUserIdentity();
        }
    };
    private final Provider<MetricTracker> metricTrackerProvider = new Provider<MetricTracker>(){

        @Override
        public MetricTracker get() {
            return Injector.this.getMetricTracker();
        }
    };

    public static synchronized void initIfCachedCredentials(Application application) {
        if (instance != null) {
            return;
        }
        AppIdentity appIdentity = AppIdentity.loadFromDevice((Context)application);
        String apiKey = appIdentity.apiKey();
        String appId = appIdentity.appId();
        if (!appId.isEmpty() && !apiKey.isEmpty()) {
            Injector.initWithAppCredentials(application, apiKey, appId);
        }
    }

    public static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance != null) {
            return;
        }
        TWIG.internal("Injector", "Initializing");
        instance = new Injector(application, new UserIdentity((Context)application), apiKey, appId, null);
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance.getLifecycleTracker());
    }

    public synchronized void changeWorkspace(String apiKey, String appId) {
        TWIG.internal("Injector", "Switching workspace");
        this.getResetManager().hardReset();
        this.appIdentityInjector.destroy();
        this.appIdentityInjector = new AppIdentityInjector(this.getApplication(), apiKey, appId, null);
        this.appIdentityInjector.initializeEvents();
    }

    protected Injector(Application application, UserIdentity userIdentity, String apiKey, String appId, @Nullable String hostname) {
        this.application = application;
        this.userIdentity = userIdentity;
        this.appIdentityInjector = new AppIdentityInjector(application, apiKey, appId, hostname);
        this.applicationScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob(null));
    }

    public static synchronized boolean isNotInitialised() {
        return instance == null;
    }

    public static synchronized Injector get() {
        if (instance == null) {
            String message = "Intercom was not initialized correctly, Intercom.initialize() needs to be called in onCreate() in your Application class.";
            throw new IntercomIntegrationException(message);
        }
        return instance;
    }

    public void initializeIntercomEventsListeners() {
        FirstMessageUtilsKt.handleFirstMessageToast(this.applicationScope, LumberMill.getLogger(), (Context)this.application, this.getDataLayer());
        this.appIdentityInjector.initializeEvents();
    }

    public Application getApplication() {
        return this.application;
    }

    public Provider<AppConfig> getAppConfigProvider() {
        return this.appConfigProvider;
    }

    public AppIdentity getAppIdentity() {
        return this.appIdentityInjector.getAppIdentity();
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public synchronized IntercomDataLayer getDataLayer() {
        if (this.dataLayer == null) {
            this.dataLayer = new IntercomDataLayer((Context)this.application, this.applicationScope);
        }
        return this.dataLayer;
    }

    public synchronized UnreadConversationsTracker getUnreadConversationsTracker() {
        if (this.unreadConversationsTracker == null) {
            this.unreadConversationsTracker = new UnreadConversationsTracker(this.metricTrackerProvider);
        }
        return this.unreadConversationsTracker;
    }

    public synchronized UserUpdaterHelper getUserUpdaterHelper() {
        if (this.userUpdaterHelper == null) {
            this.userUpdaterHelper = new UserUpdaterHelper(this.userUpdaterProvider, this.getDataLayer(), this.userIdentityProvider);
        }
        return this.userUpdaterHelper;
    }

    public synchronized NexusClient getNexusClient() {
        return this.appIdentityInjector.getNexusClient();
    }

    public synchronized DeDuper getDeDuper() {
        if (this.superDeDuper == null) {
            SharedPreferences prefs = this.application.getSharedPreferences("INTERCOM_DEDUPER_PREFS", 0);
            this.superDeDuper = new DeDuper(this.appConfigProvider, prefs);
            this.superDeDuper.readPersistedCachedAttributes();
        }
        return this.superDeDuper;
    }

    public synchronized Api getApi() {
        return this.appIdentityInjector.getApi();
    }

    public synchronized HelpCenterApi getHelpCenterApi() {
        return this.appIdentityInjector.getHelpCenterApi();
    }

    public synchronized SurveyApi getSurveyApi() {
        return this.appIdentityInjector.getSurveyApi();
    }

    public synchronized TicketApi getTicketApi() {
        return this.appIdentityInjector.getTicketApi();
    }

    public synchronized MessengerApi getMessengerApi() {
        return this.appIdentityInjector.getMessengerApi();
    }

    public synchronized ExternalUploadApi getExternalUploadApi() {
        return this.appIdentityInjector.getExternalUploadApi();
    }

    public synchronized Gson getGson() {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }

    public synchronized MetricTracker getMetricTracker() {
        if (this.metricTracker == null) {
            this.metricTracker = new MetricTracker(this.userIdentity, this.getMetricsStore(), (Context)this.getApplication());
        }
        return this.metricTracker;
    }

    public synchronized MetricsStore getMetricsStore() {
        if (this.metricsStore == null) {
            this.metricsStore = new MetricsStore((Context)this.getApplication(), this.getApiProvider(), this.appConfigProvider);
        }
        return this.metricsStore;
    }

    public synchronized OpsMetricTracker getOpsMetricTracker() {
        if (this.opsMetricTracker == null) {
            this.opsMetricTracker = new OpsMetricTracker(this.getMetricsStore(), this.getTimeProvider(), UuidStringProvider.SYSTEM);
        }
        return this.opsMetricTracker;
    }

    public synchronized OverlayPresenter getOverlayPresenter() {
        if (this.overlayPresenter == null) {
            this.overlayPresenter = new OverlayPresenter(this.getApplication(), this.appConfigProvider, this.getMetricTracker(), this.userIdentity, this.getDataLayer(), this.getApiProvider());
        }
        return this.overlayPresenter;
    }

    public TimeProvider getTimeProvider() {
        return TimeProvider.SYSTEM;
    }

    public synchronized LifecycleTracker getLifecycleTracker() {
        if (this.lifecycleTracker == null) {
            this.lifecycleTracker = LifecycleTracker.create(this.getMetricsStore(), this.getErrorReporter(), this.getDeDuper(), this.getTimeProvider(), this.getResetManager(), SystemSettings.getTransitionScale((Context)this.application), this.getApiProvider(), this.getDataLayer(), this.getUserUpdaterHelper());
        }
        return this.lifecycleTracker;
    }

    public synchronized ErrorReporter getErrorReporter() {
        if (this.errorReporter == null) {
            this.errorReporter = ErrorReporter.create((Context)this.application, this.getGson(), this.apiProvider);
        }
        return this.errorReporter;
    }

    public synchronized UserUpdater getUserUpdater() {
        if (this.userUpdater == null) {
            this.userUpdater = new UserUpdater(this.getApiProvider(), this.getOpsMetricTracker(), this.getDataLayer());
        }
        return this.userUpdater;
    }

    public synchronized ResetManager getResetManager() {
        if (this.resetManager == null) {
            this.resetManager = new ResetManager(this.getApiProvider(), this.getUserIdentity(), this.getOverlayPresenter(), this.appConfigProvider, (Context)this.application, this.activityFinisher, this.getDataLayer(), this.getUnreadConversationsTracker());
        }
        return this.resetManager;
    }

    public Provider<UserUpdater> getUserUpdaterProvider() {
        return this.userUpdaterProvider;
    }

    public Provider<Api> getApiProvider() {
        return this.apiProvider;
    }

    public Provider<NexusClient> getNexusClientProvider() {
        return this.nexusClientProvider;
    }

    public ActivityFinisher getActivityFinisher() {
        return this.activityFinisher;
    }

    @VisibleForTesting
    static void setSharedInstance(Injector injector) {
        instance = injector;
    }

    static {
        TWIG = LumberMill.getLogger();
    }
}

