/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import android.os.Handler;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;

public class NexusClientMiddleware
implements Store.Middleware<State> {
    private final Provider<NexusClient> nexusClient;
    private final Provider<AppConfig> appConfigProvider;
    private final Handler handler;
    private final Runnable disconnectRunnable = new Runnable(){

        @Override
        public void run() {
            NexusClientMiddleware.this.client().disconnect();
        }
    };

    public NexusClientMiddleware(Provider<NexusClient> nexusClient, Provider<AppConfig> appConfigProvider2, Handler handler) {
        this.nexusClient = nexusClient;
        this.appConfigProvider = appConfigProvider2;
        this.handler = handler;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case APP_ENTERED_FOREGROUND: {
                this.connectWithConfig(this.appConfigProvider.get().getRealTimeConfig());
                break;
            }
            case APP_ENTERED_BACKGROUND: {
                this.scheduleDisconnect();
                break;
            }
            case SOFT_RESET: {
                this.disconnectImmediately();
                break;
            }
            case BASE_RESPONSE_RECEIVED: {
                NexusConfig config = ((BaseResponse)action.value()).getConfig().getRealTimeConfig();
                if (config.getEndpoints().isEmpty()) {
                    this.disconnectImmediately();
                    break;
                }
                if (store.select(Selectors.APP_IS_BACKGROUNDED).booleanValue()) break;
                this.connectWithConfig(config);
                break;
            }
        }
    }

    private void scheduleDisconnect() {
        this.handler.removeCallbacks(this.disconnectRunnable);
        this.handler.postDelayed(this.disconnectRunnable, this.appConfigProvider.get().getNewSessionThresholdMs());
    }

    private void connectWithConfig(NexusConfig config) {
        this.handler.removeCallbacks(this.disconnectRunnable);
        this.client().connect(config, true);
    }

    private void disconnectImmediately() {
        this.handler.removeCallbacks(this.disconnectRunnable);
        this.client().disconnect();
    }

    NexusClient client() {
        return this.nexusClient.get();
    }
}

