/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.text.Spanned;
import android.view.View;
import android.view.ViewGroup;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.lib.BlockAlignment;
import io.intercom.android.sdk.blocks.lib.interfaces.ParagraphBlock;
import io.intercom.android.sdk.blocks.lib.models.BlockMetadata;
import io.intercom.android.sdk.blocks.views.ParagraphView;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.AccessibilityUtils;
import io.intercom.android.sdk.utilities.BlockUtils;

class Paragraph
implements ParagraphBlock {
    private final StyleType style;
    private final Provider<AppConfig> appConfigProvider;

    Paragraph(StyleType style2, Provider<AppConfig> appConfigProvider2) {
        this.style = style2;
        this.appConfigProvider = appConfigProvider2;
    }

    @Override
    public View addParagraph(Spanned text, BlockAlignment alignment, BlockMetadata blockMetadata, ViewGroup parent) {
        ParagraphView textView = new ParagraphView(parent.getContext(), this.style, alignment, this.appConfigProvider.get(), blockMetadata);
        if (StyleType.PREVIEW == this.style) {
            textView.setText(text.toString());
        } else {
            textView.setText((CharSequence)text);
        }
        BlockUtils.setLayoutMarginsAndGravity((View)textView, alignment.getGravity(), blockMetadata.isLastObject());
        AccessibilityUtils.INSTANCE.removeClickAbilityAnnouncement((View)textView);
        return textView;
    }
}

