/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_Participant;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.utilities.NameUtils;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.Objects;

@AutoValue
public abstract class Participant
implements Parcelable {
    public static final String ADMIN_TYPE = "admin";
    public static final String USER_TYPE = "user";
    public static final Participant NULL = Participant.create("", "", "", "", Avatar.create("", ""), false);
    public static final Parcelable.Creator<Participant> CREATOR = new Parcelable.Creator<Participant>(){

        public Participant createFromParcel(Parcel in) {
            String id2 = in.readString();
            String name = in.readString();
            String type2 = in.readString();
            String email = in.readString();
            Avatar avatar = (Avatar)in.readValue(Avatar.class.getClassLoader());
            Boolean isBot = in.readByte() == 0;
            return Participant.create(id2, name, type2, email, avatar, isBot);
        }

        public Participant[] newArray(int size) {
            return new Participant[size];
        }
    };

    public static Participant create(String id2, String name, String type2, String email, Avatar avatar, Boolean isBot) {
        return new AutoValue_Participant(id2, name, type2, email, avatar, isBot);
    }

    public abstract String getId();

    public abstract String getName();

    public abstract String getType();

    public abstract String getEmail();

    public abstract Avatar getAvatar();

    public abstract Boolean isBot();

    public boolean isAdmin() {
        return ADMIN_TYPE.equals(this.getType());
    }

    @VisibleForTesting
    String nameOrEmail() {
        return this.getName().isEmpty() ? this.getEmail() : this.getName();
    }

    public String getForename() {
        return this.nameOrEmail().trim().split(" ")[0];
    }

    public boolean isUserWithId(@Nullable String userId) {
        return USER_TYPE.equals(this.getType()) && this.getId().equals(userId);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getId());
        dest.writeString(this.getName());
        dest.writeString(this.getType());
        dest.writeString(this.getEmail());
        dest.writeValue((Object)this.getAvatar());
        dest.writeByte((byte)(this.isBot() != false ? 1 : 0));
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        String type;
        @Nullable
        String email;
        @Nullable
        Avatar.Builder avatar;
        @Nullable
        Boolean is_bot;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return Objects.equals(this.id, builder.id) && Objects.equals(this.name, builder.name) && Objects.equals(this.type, builder.type) && Objects.equals(this.email, builder.email) && Objects.equals(this.avatar, builder.avatar) && Objects.equals(this.is_bot, builder.is_bot);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this.type, this.email, this.avatar, this.is_bot);
        }

        public Participant build() {
            String type2 = this.type == null ? Participant.USER_TYPE : this.type;
            String name = NullSafety.valueOrEmpty(this.name);
            String email = NullSafety.valueOrEmpty(this.email);
            String initial = NullSafety.valueOrEmpty(this.avatar != null ? this.avatar.initials : null).isEmpty() ? NameUtils.getInitial(name.isEmpty() ? email : name) : this.avatar.initials;
            Avatar avatar = this.avatar == null ? Avatar.create("", initial) : this.avatar.withInitials(initial).build();
            Boolean isBot = NullSafety.valueOrDefault(this.is_bot, false);
            return Participant.create(NullSafety.valueOrEmpty(this.id), name, type2, email, avatar, isBot);
        }

        public Builder withId(String id2) {
            this.id = id2;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withEmail(String email) {
            this.email = email;
            return this;
        }

        public Builder withType(String type2) {
            this.type = type2;
            return this;
        }

        public Builder withIsBot(boolean isBot) {
            this.is_bot = isBot;
            return this;
        }

        public Builder withAvatar(Avatar.Builder avatar) {
            this.avatar = avatar;
            return this;
        }
    }
}

