/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import androidx.annotation.NonNull;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.HostAppState;
import io.intercom.android.sdk.models.OverlayState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import java.util.Arrays;
import java.util.List;

public class ApiMiddleware
implements Store.Middleware<State> {
    private final Provider<Api> apiProvider;
    private final IntercomDataLayer dataLayer;

    public ApiMiddleware(Provider<Api> apiProvider, IntercomDataLayer dataLayer) {
        this.apiProvider = apiProvider;
        this.dataLayer = dataLayer;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case CONVERSATION_MARKED_AS_DISMISSED: {
                Conversation conversation = (Conversation)action.value();
                this.api().markConversationAsDismissed(conversation.getId());
                break;
            }
            case CONVERSATION_MARKED_AS_READ: {
                int inAppConversationCount = ((OverlayState)this.dataLayer.getOverlayState().getValue()).getConversations().size();
                if (inAppConversationCount != 1 || store.select(Selectors.UNREAD_COUNT) <= inAppConversationCount) break;
                this.api().getUnreadConversations();
                break;
            }
            case NEW_COMMENT_EVENT_RECEIVED: {
                String updatedConversationId = (String)action.value();
                this.fetchDataForCurrentScreen(store, updatedConversationId);
                break;
            }
            case FETCH_CONVERSATION_SUCCESS: {
                Conversation conversation = (Conversation)action.value();
                if (!this.shouldRecordOpenedInteraction(store, conversation)) break;
                this.api().recordInteractions(conversation.getId(), new String[]{"opened"});
                break;
            }
        }
    }

    private void fetchDataForCurrentScreen(Store<State> store, @NonNull String updatedConversationId) {
        if (this.shouldFetchUnreadConversations(store)) {
            this.api().getUnreadConversations();
        }
    }

    private boolean shouldFetchUnreadConversations(Store<State> store) {
        return ((OverlayState)this.dataLayer.getOverlayState().getValue()).getResumedHostActivity() != null || ((HostAppState)this.dataLayer.getHostAppState().getValue()).isBackgrounded();
    }

    private boolean shouldRecordOpenedInteraction(Store<State> store, Conversation conversation) {
        String activeConversationID = store.state().activeConversationState().getConversationId();
        List<String> validStatuses = Arrays.asList("delivered", "renotifying");
        return activeConversationID.equals(conversation.getId()) && validStatuses.contains(conversation.getNotificationStatus());
    }

    private Api api() {
        return this.apiProvider.get();
    }
}

