/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.ActivityLifecycleHandler;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.UserUpdater;
import io.intercom.android.sdk.errorreporting.ErrorReporter;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.IntercomRootActivity;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.HostAppState;
import io.intercom.android.sdk.push.IntercomLegacyPushClientHandler;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.sentry.SentrySessionManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.SimpleActivityLifecycleCallbacks;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class LifecycleTracker
extends SimpleActivityLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private final SystemNotificationManager systemNotificationManager;
    private final Set<Integer> startedActivities = new HashSet<Integer>();
    private final MetricsStore metricsStore;
    private final ErrorReporter errorReporter;
    private final DeDuper deDuper;
    private final TimeProvider timeProvider;
    private final UserUpdater userUpdater;
    final Store<State> store;
    private final ResetManager resetManager;
    private final ActivityLifecycleHandler handler;
    private final Twig twig = LumberMill.getLogger();
    private final Provider<Api> apiProvider;
    private final IntercomDataLayer dataLayer;

    static LifecycleTracker create(SystemNotificationManager systemNotificationManager, MetricsStore metricsStore, ErrorReporter errorReporter, DeDuper deDuper, TimeProvider timeProvider, UserUpdater userUpdater, Store<State> store, ResetManager resetManager, float transitionScale, Provider<Api> apiProvider, IntercomDataLayer dataLayer) {
        return new LifecycleTracker(systemNotificationManager, metricsStore, errorReporter, deDuper, timeProvider, userUpdater, store, resetManager, new ActivityLifecycleHandler(Looper.getMainLooper(), store, transitionScale, dataLayer), apiProvider, dataLayer);
    }

    @VisibleForTesting
    LifecycleTracker(SystemNotificationManager systemNotificationManager, MetricsStore metricsStore, ErrorReporter errorReporter, DeDuper deDuper, TimeProvider timeProvider, UserUpdater userUpdater, Store<State> store, ResetManager resetManager, ActivityLifecycleHandler handler, Provider<Api> apiProvider, IntercomDataLayer dataLayer) {
        this.systemNotificationManager = systemNotificationManager;
        this.metricsStore = metricsStore;
        this.errorReporter = errorReporter;
        this.deDuper = deDuper;
        this.timeProvider = timeProvider;
        this.userUpdater = userUpdater;
        this.store = store;
        this.resetManager = resetManager;
        this.handler = handler;
        this.apiProvider = apiProvider;
        this.dataLayer = dataLayer;
    }

    @Override
    public void onActivityStarted(Activity activity) {
        this.registerActivity(activity);
        this.handleExtras(activity);
        if (((HostAppState)this.dataLayer.getHostAppState().getValue()).isBackgrounded()) {
            this.store.dispatch(Actions.appEnteredForeground(this.timeProvider.currentTimeMillis()));
            this.dataLayer.appEnteredForeground();
            this.metricsStore.loadAndSendMetrics();
            this.errorReporter.sendSavedReport();
            if (activity instanceof IntercomRootActivity) {
                IntercomLegacyPushClientHandler.Companion.clear(this.systemNotificationManager, (Context)activity);
            }
        }
        SentrySessionManager.INSTANCE.onActivityStarted(activity);
    }

    @Override
    public void onActivityResumed(Activity activity) {
        this.handler.removeMessages(1, activity);
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(0, activity));
        this.handleExtras(activity);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(2, activity));
    }

    @Override
    public void onActivityStopped(Activity activity) {
        this.unregisterActivity(activity);
        this.handler.removeMessages(1, activity);
        this.handler.sendMessage(ActivityLifecycleHandler.getMessage(3, activity));
        if (this.hasApplicationBecomeBackgrounded(activity)) {
            if (this.resetManager.isSoftReset()) {
                this.resetManager.hardReset();
            }
            this.store.dispatch(Actions.appEnteredBackground(this.timeProvider.currentTimeMillis()));
            this.dataLayer.appEnteredBackground(this.timeProvider.currentTimeMillis());
            this.deDuper.reset();
            this.metricsStore.loadAndSendMetrics();
        }
        SentrySessionManager.INSTANCE.onActivityStopped(activity);
    }

    void registerActivities(Collection<Integer> hashCodes) {
        this.startedActivities.addAll(hashCodes);
    }

    private void registerActivity(Activity activity) {
        this.startedActivities.add(System.identityHashCode(activity));
        this.twig.i("Started observing " + activity, new Object[0]);
    }

    private void unregisterActivity(Activity activity) {
        this.startedActivities.remove(System.identityHashCode(activity));
        this.twig.i("Stopped observing " + activity, new Object[0]);
    }

    private boolean hasApplicationBecomeBackgrounded(Activity activity) {
        return this.isApplicationInBackground(activity) && !((HostAppState)this.dataLayer.getHostAppState().getValue()).isBackgrounded();
    }

    @VisibleForTesting
    boolean isApplicationInBackground(Activity activity) {
        return LifecycleTracker.isScreenLocked((Context)activity) || this.startedActivities.isEmpty() && !activity.isChangingConfigurations();
    }

    private static boolean isScreenLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void handleExtras(Activity activity) {
        Intent intent = activity.getIntent();
        if (intent == null) {
            return;
        }
        if (!intent.hasExtra("io.intercom.android.sdk.INTERCOM_PUSH_INSTANCE_ID")) {
            return;
        }
        String instanceId = intent.getStringExtra("io.intercom.android.sdk.INTERCOM_PUSH_INSTANCE_ID");
        if (!TextUtils.isEmpty((CharSequence)instanceId)) {
            this.twig.i("Activity started from Mobile Push: " + activity, new Object[0]);
            this.apiProvider.get().markPushAsOpened(instanceId);
            Injector.get().getMetricTracker().openedPushOnlyNotification(instanceId);
        }
        intent.removeExtra("io.intercom.android.sdk.INTERCOM_PUSH_INSTANCE_ID");
    }
}

