/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.SharedPreferences;
import androidx.annotation.ColorInt;
import com.google.gson.Gson;
import io.intercom.android.nexus.NexusConfig;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.AttachmentSettings;
import io.intercom.android.sdk.models.Config;
import io.intercom.android.sdk.models.ConfigModules;
import io.intercom.android.sdk.models.ConversationStateSyncSettings;
import io.intercom.android.sdk.utilities.ColorUtils;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\"\u001a\u0016\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0001\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\b2\b\b\u0001\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\b2\u0006\u0010\r\u001a\u00020\u0001H\u0000\"\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001a\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001c\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001d\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u001f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010 \u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\"\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010#\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010$\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010&\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010'\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010(\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010)\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010*\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010+\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010,\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010-\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"getAppConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "Lio/intercom/android/sdk/models/Config;", "defaultColor", "", "getConfigColor", "color", "", "Landroid/content/SharedPreferences;", "realTimeConfig", "Lio/intercom/android/nexus/NexusConfig;", "setAppConfig", "", "newAppConfig", "APP_NAME", "APP_INBOUND_MESSAGES", "APP_PRIMARY_COLOR", "APP_SECONDARY_COLOR", "APP_PRIMARY_COLOR_RENDER_DARK_TEXT", "APP_SECONDARY_COLOR_RENDER_DARK_TEXT", "APP_USER_UPDATE_CACHE_MAX_AGE_MS", "APP_RATE_LIMIT_PERIOD_MS", "APP_SOFT_RESET_TIMEOUT_MS", "APP_NEW_SESSION_THRESHOLD_MS", "APP_RATE_LIMIT_COUNT", "APP_AUDIO_ENABLED", "APP_METRICS_ENABLED", "APP_LOCALE", "APP_HELP_CENTER_LOCALE", "APP_RECEIVED_FROM_SERVER", "APP_BACKGROUND_REQUESTS_ENABLED", "APP_HELP_CENTER_URL", "APP_HELP_CENTER_URLS", "APP_FEATURES", "APP_LAUNCHER_LOGO_URL", "APP_TEAM_GREETING", "APP_IDENTITY_VERIFICATION_ENABLED", "APP_ACCESS_TEAMMATE_ENABLED", "APP_HELP_CENTER_REQUIRE_SEARCH", "APP_PREVENT_MULTIPLE_INBOUND_CONVERSATIONS_ENABLED", "APP_HAS_OPEN_CONVERSATIONS", "APP_HUB_HEADER_CONFIG", "NEW_PUSH_UI_DISABLED", "APP_ATTACHMENT_SETTINGS", "APP_ARTICLE_AUTO_REACTION_ENABLED", "FIN_DICTATION_UI_ENABLED", "intercom-sdk-base_release"})
public final class AppConfigKt {
    @NotNull
    private static final String APP_NAME = "app_name";
    @NotNull
    private static final String APP_INBOUND_MESSAGES = "app_inbound_messages";
    @NotNull
    private static final String APP_PRIMARY_COLOR = "app_primary_color";
    @NotNull
    private static final String APP_SECONDARY_COLOR = "app_secondary_color";
    @NotNull
    private static final String APP_PRIMARY_COLOR_RENDER_DARK_TEXT = "app_primary_color_render_dark_text";
    @NotNull
    private static final String APP_SECONDARY_COLOR_RENDER_DARK_TEXT = "app_secondary_color_render_dark_text";
    @NotNull
    private static final String APP_USER_UPDATE_CACHE_MAX_AGE_MS = "app_user_update_cache_max_age_ms";
    @NotNull
    private static final String APP_RATE_LIMIT_PERIOD_MS = "app_rate_limit_period_ms";
    @NotNull
    private static final String APP_SOFT_RESET_TIMEOUT_MS = "app_soft_reset_timeout_ms";
    @NotNull
    private static final String APP_NEW_SESSION_THRESHOLD_MS = "new_session_threshold_ms";
    @NotNull
    private static final String APP_RATE_LIMIT_COUNT = "app_rate_limit_count";
    @NotNull
    private static final String APP_AUDIO_ENABLED = "app_audio_enabled";
    @NotNull
    private static final String APP_METRICS_ENABLED = "app_metrics_enabled";
    @NotNull
    private static final String APP_LOCALE = "app_locale";
    @NotNull
    private static final String APP_HELP_CENTER_LOCALE = "help_center_locale";
    @NotNull
    private static final String APP_RECEIVED_FROM_SERVER = "app_received_from_server";
    @NotNull
    private static final String APP_BACKGROUND_REQUESTS_ENABLED = "app_background_requests_enabled";
    @NotNull
    private static final String APP_HELP_CENTER_URL = "help_center_url";
    @NotNull
    private static final String APP_HELP_CENTER_URLS = "help_center_urls";
    @NotNull
    private static final String APP_FEATURES = "features";
    @NotNull
    private static final String APP_LAUNCHER_LOGO_URL = "app_launcher_logo_url";
    @NotNull
    private static final String APP_TEAM_GREETING = "app_team_greeting";
    @NotNull
    private static final String APP_IDENTITY_VERIFICATION_ENABLED = "app_identity_verification_enabled";
    @NotNull
    private static final String APP_ACCESS_TEAMMATE_ENABLED = "access_to_teammate_enabled";
    @NotNull
    private static final String APP_HELP_CENTER_REQUIRE_SEARCH = "help_center_require_search";
    @NotNull
    private static final String APP_PREVENT_MULTIPLE_INBOUND_CONVERSATIONS_ENABLED = "prevent_multiple_inbound_conversations_enabled";
    @NotNull
    private static final String APP_HAS_OPEN_CONVERSATIONS = "has_open_conversations";
    @NotNull
    private static final String APP_HUB_HEADER_CONFIG = "hub_config";
    @NotNull
    private static final String NEW_PUSH_UI_DISABLED = "new_push_ui_disabled";
    @NotNull
    private static final String APP_ATTACHMENT_SETTINGS = "app_attachment_settings";
    @NotNull
    private static final String APP_ARTICLE_AUTO_REACTION_ENABLED = "article_auto_reaction_enabled";
    @NotNull
    private static final String FIN_DICTATION_UI_ENABLED = "fin_dictation_ui_enabled";

    @NotNull
    public static final AppConfig getAppConfig(@NotNull Config $this$getAppConfig, @ColorInt int defaultColor) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppConfig, (String)"<this>");
        int primaryColor = AppConfigKt.getConfigColor($this$getAppConfig.getPrimaryColor(), defaultColor);
        int secondaryColor = AppConfigKt.getConfigColor($this$getAppConfig.getSecondaryColor(), defaultColor);
        return new AppConfig($this$getAppConfig.getName(), primaryColor, secondaryColor, ColorUtils.darkenColor(secondaryColor), $this$getAppConfig.isPrimaryColorRenderDarkText(), $this$getAppConfig.isSecondaryColorRenderDarkText(), $this$getAppConfig.isInboundMessages(), $this$getAppConfig.getRateLimitCount(), $this$getAppConfig.getRateLimitPeriod(), $this$getAppConfig.getUserUpdateCacheMaxAge(), $this$getAppConfig.getNewSessionThreshold(), $this$getAppConfig.getSoftResetTimeout(), $this$getAppConfig.isMetricsEnabled(), $this$getAppConfig.isAudioEnabled(), $this$getAppConfig.getLocale(), $this$getAppConfig.getHelpCenterLocale(), true, $this$getAppConfig.isBackgroundRequestsEnabled(), $this$getAppConfig.getHelpCenterUrl(), $this$getAppConfig.getHelpCenterUrls(), $this$getAppConfig.getFeatures(), $this$getAppConfig.getLauncherLogoUrl(), $this$getAppConfig.getTeamGreeting(), $this$getAppConfig.getIdentityVerificationEnabled(), $this$getAppConfig.getAccessToTeammateEnabled(), $this$getAppConfig.getHelpCenterRequireSearch(), $this$getAppConfig.getPreventMultipleInboundConversationsEnabled(), $this$getAppConfig.getHasOpenConversations(), $this$getAppConfig.getModules(), $this$getAppConfig.getRealTimeConfig(), $this$getAppConfig.isAndroidNewPushUiDisabled(), $this$getAppConfig.getAttachmentSettings(), $this$getAppConfig.isArticleAutoReactionEnabled(), $this$getAppConfig.isFinDictationUiEnabled(), $this$getAppConfig.getConversationStateSyncSettings());
    }

    private static final int getConfigColor(String color2, int defaultColor) {
        String string2 = color2;
        return string2 == null ? defaultColor : ColorUtils.parseColor(string2);
    }

    @NotNull
    public static final AppConfig getAppConfig(@NotNull SharedPreferences $this$getAppConfig, @ColorInt int defaultColor, @NotNull NexusConfig realTimeConfig) {
        String string2;
        String string3;
        Set set;
        Set set2;
        String string4;
        Intrinsics.checkNotNullParameter((Object)$this$getAppConfig, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)realTimeConfig, (String)"realTimeConfig");
        int primaryColor = $this$getAppConfig.getInt(APP_PRIMARY_COLOR, defaultColor);
        int secondaryColor = $this$getAppConfig.getInt(APP_SECONDARY_COLOR, primaryColor);
        Gson gson = new Gson();
        String string5 = $this$getAppConfig.getString(APP_NAME, "");
        if (string5 == null) {
            string5 = "";
        }
        int n = ColorUtils.darkenColor(secondaryColor);
        boolean bl = $this$getAppConfig.getBoolean(APP_PRIMARY_COLOR_RENDER_DARK_TEXT, false);
        boolean bl2 = $this$getAppConfig.getBoolean(APP_SECONDARY_COLOR_RENDER_DARK_TEXT, false);
        boolean bl3 = $this$getAppConfig.getBoolean(APP_INBOUND_MESSAGES, false);
        int n2 = $this$getAppConfig.getInt(APP_RATE_LIMIT_COUNT, 100);
        long l = $this$getAppConfig.getLong(APP_RATE_LIMIT_PERIOD_MS, TimeUnit.SECONDS.toMillis(60L));
        long l2 = $this$getAppConfig.getLong(APP_USER_UPDATE_CACHE_MAX_AGE_MS, TimeUnit.SECONDS.toMillis(300L));
        long l3 = $this$getAppConfig.getLong(APP_NEW_SESSION_THRESHOLD_MS, TimeUnit.SECONDS.toMillis(20L));
        long l4 = $this$getAppConfig.getLong(APP_SOFT_RESET_TIMEOUT_MS, TimeUnit.SECONDS.toMillis(1L));
        boolean bl4 = $this$getAppConfig.getBoolean(APP_METRICS_ENABLED, true);
        boolean bl5 = $this$getAppConfig.getBoolean(APP_AUDIO_ENABLED, true);
        String string6 = $this$getAppConfig.getString(APP_LOCALE, "");
        if (string6 == null) {
            string6 = "";
        }
        if ((string4 = $this$getAppConfig.getString(APP_HELP_CENTER_LOCALE, "")) == null) {
            string4 = "";
        }
        boolean bl6 = $this$getAppConfig.getBoolean(APP_RECEIVED_FROM_SERVER, false);
        boolean bl7 = $this$getAppConfig.getBoolean(APP_BACKGROUND_REQUESTS_ENABLED, true);
        String string7 = $this$getAppConfig.getString(APP_HELP_CENTER_URL, "");
        if (string7 == null) {
            string7 = "";
        }
        if ((set2 = $this$getAppConfig.getStringSet(APP_HELP_CENTER_URLS, SetsKt.emptySet())) == null) {
            set2 = SetsKt.emptySet();
        }
        if ((set = $this$getAppConfig.getStringSet(APP_FEATURES, SetsKt.emptySet())) == null) {
            set = SetsKt.emptySet();
        }
        if ((string3 = $this$getAppConfig.getString(APP_LAUNCHER_LOGO_URL, "")) == null) {
            string3 = "";
        }
        if ((string2 = $this$getAppConfig.getString(APP_TEAM_GREETING, "")) == null) {
            string2 = "";
        }
        boolean bl8 = $this$getAppConfig.getBoolean(APP_IDENTITY_VERIFICATION_ENABLED, false);
        boolean bl9 = $this$getAppConfig.getBoolean(APP_ACCESS_TEAMMATE_ENABLED, true);
        boolean bl10 = $this$getAppConfig.getBoolean(APP_HELP_CENTER_REQUIRE_SEARCH, false);
        boolean bl11 = $this$getAppConfig.getBoolean(APP_PREVENT_MULTIPLE_INBOUND_CONVERSATIONS_ENABLED, false);
        boolean bl12 = $this$getAppConfig.getBoolean(APP_HAS_OPEN_CONVERSATIONS, false);
        ConfigModules configModules = (ConfigModules)gson.fromJson($this$getAppConfig.getString(APP_HUB_HEADER_CONFIG, null), ConfigModules.class);
        boolean bl13 = $this$getAppConfig.getBoolean(NEW_PUSH_UI_DISABLED, false);
        Object object = gson.fromJson($this$getAppConfig.getString(APP_ATTACHMENT_SETTINGS, gson.toJson((Object)AttachmentSettings.Companion.getDEFAULT())), AttachmentSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return new AppConfig(string5, primaryColor, secondaryColor, n, bl, bl2, bl3, n2, l, l2, l3, l4, bl4, bl5, string6, string4, bl6, bl7, string7, set2, set, string3, string2, bl8, bl9, bl10, bl11, bl12, configModules, realTimeConfig, bl13, (AttachmentSettings)object, $this$getAppConfig.getBoolean(APP_ARTICLE_AUTO_REACTION_ENABLED, true), $this$getAppConfig.getBoolean(FIN_DICTATION_UI_ENABLED, false), ConversationStateSyncSettings.Companion.getDEFAULT());
    }

    public static final void setAppConfig(@NotNull SharedPreferences $this$setAppConfig, @NotNull AppConfig newAppConfig) {
        Intrinsics.checkNotNullParameter((Object)$this$setAppConfig, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newAppConfig, (String)"newAppConfig");
        Gson gson = new Gson();
        AppConfig $this$setAppConfig_u24lambda_u240 = newAppConfig;
        boolean bl = false;
        $this$setAppConfig.edit().putString(APP_NAME, $this$setAppConfig_u24lambda_u240.getName()).putString(APP_LOCALE, $this$setAppConfig_u24lambda_u240.getLocale()).putString(APP_HELP_CENTER_LOCALE, $this$setAppConfig_u24lambda_u240.getHelpCenterLocale()).putString(APP_LAUNCHER_LOGO_URL, $this$setAppConfig_u24lambda_u240.getLauncherLogoUrl()).putString(APP_TEAM_GREETING, $this$setAppConfig_u24lambda_u240.getTeamGreeting()).putInt(APP_PRIMARY_COLOR, $this$setAppConfig_u24lambda_u240.getPrimaryColor()).putInt(APP_SECONDARY_COLOR, $this$setAppConfig_u24lambda_u240.getSecondaryColor()).putInt(APP_RATE_LIMIT_COUNT, $this$setAppConfig_u24lambda_u240.getRateLimitCount()).putLong(APP_USER_UPDATE_CACHE_MAX_AGE_MS, $this$setAppConfig_u24lambda_u240.getUserUpdateCacheMaxAgeMs()).putLong(APP_RATE_LIMIT_PERIOD_MS, $this$setAppConfig_u24lambda_u240.getRateLimitPeriodMs()).putLong(APP_NEW_SESSION_THRESHOLD_MS, $this$setAppConfig_u24lambda_u240.getNewSessionThresholdMs()).putLong(APP_SOFT_RESET_TIMEOUT_MS, $this$setAppConfig_u24lambda_u240.getSoftResetTimeoutMs()).putBoolean(APP_INBOUND_MESSAGES, $this$setAppConfig_u24lambda_u240.isInboundMessages()).putBoolean(APP_AUDIO_ENABLED, $this$setAppConfig_u24lambda_u240.isAudioEnabled()).putBoolean(APP_METRICS_ENABLED, $this$setAppConfig_u24lambda_u240.isMetricsEnabled()).putBoolean(APP_RECEIVED_FROM_SERVER, $this$setAppConfig_u24lambda_u240.isReceivedFromServer()).putBoolean(APP_BACKGROUND_REQUESTS_ENABLED, $this$setAppConfig_u24lambda_u240.isBackgroundRequestsEnabled()).putBoolean(APP_PRIMARY_COLOR_RENDER_DARK_TEXT, $this$setAppConfig_u24lambda_u240.isPrimaryColorRenderDarkText()).putBoolean(APP_SECONDARY_COLOR_RENDER_DARK_TEXT, $this$setAppConfig_u24lambda_u240.isSecondaryColorRenderDarkText()).putString(APP_HELP_CENTER_URL, $this$setAppConfig_u24lambda_u240.getHelpCenterUrl()).putStringSet(APP_HELP_CENTER_URLS, $this$setAppConfig_u24lambda_u240.getHelpCenterUrls()).putStringSet(APP_FEATURES, $this$setAppConfig_u24lambda_u240.getFeatures()).putBoolean(APP_ACCESS_TEAMMATE_ENABLED, $this$setAppConfig_u24lambda_u240.isAccessToTeammateEnabled()).putBoolean(APP_HELP_CENTER_REQUIRE_SEARCH, $this$setAppConfig_u24lambda_u240.isHelpCenterRequireSearchEnabled()).putBoolean(APP_PREVENT_MULTIPLE_INBOUND_CONVERSATIONS_ENABLED, $this$setAppConfig_u24lambda_u240.isPreventMultipleInboundConversationsEnabled()).putBoolean(APP_HAS_OPEN_CONVERSATIONS, $this$setAppConfig_u24lambda_u240.getHasOpenConversations()).putString(APP_HUB_HEADER_CONFIG, gson.toJson((Object)$this$setAppConfig_u24lambda_u240.getConfigModules())).putString(APP_ATTACHMENT_SETTINGS, gson.toJson((Object)$this$setAppConfig_u24lambda_u240.getAttachmentSettings())).putBoolean(APP_ARTICLE_AUTO_REACTION_ENABLED, $this$setAppConfig_u24lambda_u240.getArticleAutoReactionEnabled()).putBoolean(FIN_DICTATION_UI_ENABLED, $this$setAppConfig_u24lambda_u240.getFinDictationUiEnabled()).putBoolean(NEW_PUSH_UI_DISABLED, $this$setAppConfig_u24lambda_u240.getNewPushUiDisabled()).apply();
    }
}

