/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import androidx.core.content.FileProvider;
import androidx.exifinterface.media.ExifInterface;
import io.intercom.android.sdk.IntercomFileProviderKt;
import io.intercom.android.sdk.m5.conversation.ui.components.composer.MediaData;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0000\u001a,\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a4\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0012"}, d2={"getMediaData", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;", "Landroid/net/Uri;", "context", "Landroid/content/Context;", "generateThumbnailForVideo", "", "getImageData", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media$Image;", "contentResolver", "Landroid/content/ContentResolver;", "fileName", "", "mimeType", "size", "", "getVideoData", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media$Video;", "intercom-sdk-base_release"})
public final class URIExtensionsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final MediaData.Media getMediaData(@NotNull Uri $this$getMediaData, @NotNull Context context, boolean generateThumbnailForVideo) {
        MediaData.Media media;
        Intrinsics.checkNotNullParameter((Object)$this$getMediaData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query($this$getMediaData, null, null, null, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                MediaData.Media media2;
                String string2;
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                cursor2.moveToFirst();
                String fileName = cursor2.getString(cursor2.getColumnIndexOrThrow("_display_name"));
                if (cursor2.getColumnIndex("mime_type") != -1) {
                    string2 = cursor2.getString(cursor2.getColumnIndexOrThrow("mime_type"));
                } else {
                    Intrinsics.checkNotNull((Object)fileName);
                    string2 = StringsKt.contains$default((CharSequence)fileName, (CharSequence)".jpg", (boolean)false, (int)2, null) ? "image/jpg" : (StringsKt.contains$default((CharSequence)fileName, (CharSequence)".mp4", (boolean)false, (int)2, null) ? "video/mp4" : "");
                }
                String mimeType = string2;
                long size = cursor2.getLong(cursor2.getColumnIndexOrThrow("_size"));
                Intrinsics.checkNotNull((Object)mimeType);
                if (StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"video", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNull((Object)fileName);
                    media2 = URIExtensionsKt.getVideoData($this$getMediaData, context, fileName, mimeType, size, generateThumbnailForVideo);
                } else if (StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"image", (boolean)false, (int)2, null)) {
                    Intrinsics.checkNotNull((Object)contentResolver);
                    Intrinsics.checkNotNull((Object)fileName);
                    media2 = URIExtensionsKt.getImageData($this$getMediaData, contentResolver, fileName, mimeType, size);
                } else {
                    Intrinsics.checkNotNull((Object)fileName);
                    media2 = new MediaData.Media.Other(mimeType, size, fileName, $this$getMediaData);
                }
                MediaData.Media media3 = media2;
                media = media3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            media = null;
        }
        return media;
    }

    public static /* synthetic */ MediaData.Media getMediaData$default(Uri uri, Context context, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return URIExtensionsKt.getMediaData(uri, context, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MediaData.Media.Image getImageData(Uri $this$getImageData, ContentResolver contentResolver, String fileName, String mimeType, long size) {
        int height = 0;
        int width = 0;
        InputStream inputStream = contentResolver.openInputStream($this$getImageData);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                ExifInterface exif = new ExifInterface(it);
                int heightAttribute = exif.getAttributeInt("ImageLength", 480);
                int widthAttribute = exif.getAttributeInt("ImageWidth", 640);
                int orientation = exif.getAttributeInt("Orientation", 1);
                boolean shouldSwap = orientation == 6 || orientation == 8;
                height = shouldSwap ? widthAttribute : heightAttribute;
                width = shouldSwap ? heightAttribute : widthAttribute;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return new MediaData.Media.Image(mimeType, width, height, size, fileName, $this$getImageData);
    }

    @NotNull
    public static final MediaData.Media.Video getVideoData(@NotNull Uri $this$getVideoData, @NotNull Context context, @NotNull String fileName, @NotNull String mimeType, long size, boolean generateThumbnailForVideo) {
        MediaData.Media.Image image;
        Integer n;
        int height;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$getVideoData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        MediaMetadataRetriever retriever = new MediaMetadataRetriever();
        retriever.setDataSource(context, $this$getVideoData);
        String string2 = retriever.extractMetadata(9);
        long duration = string2 != null && (object2 = StringsKt.toLongOrNull((String)string2)) != null ? (Long)object2 : 0L;
        object2 = retriever.extractMetadata(18);
        int width = object2 != null && (object = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object : 0;
        object = retriever.extractMetadata(19);
        int n2 = height = object != null && (n = StringsKt.toIntOrNull((String)object)) != null ? n : 0;
        if (generateThumbnailForVideo) {
            int thumbnailHeight;
            String thumbnailName = "thumbnail_" + StringsKt.substringBefore$default((String)fileName, (String)".", null, (int)2, null) + ".jpg";
            Pair pair = height > width ? TuplesKt.to((Object)320, (Object)240) : TuplesKt.to((Object)240, (Object)320);
            int minThumbnailHeight = ((Number)pair.component1()).intValue();
            int minThumbnailWidth = ((Number)pair.component2()).intValue();
            int thumbnailWidth = Math.max(width / 2, minThumbnailWidth);
            Bitmap bitmap = retriever.getScaledFrameAtTime(0L, 2, thumbnailWidth, thumbnailHeight = Math.max(height / 2, minThumbnailHeight));
            if (bitmap != null) {
                Bitmap it = bitmap;
                boolean bl = false;
                File imageFolder = new File(context.getExternalCacheDir(), "images");
                imageFolder.mkdir();
                File file = new File(imageFolder, thumbnailName);
                FileOutputStream outputStream = new FileOutputStream(file);
                it.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
                outputStream.flush();
                outputStream.close();
                Uri thumbnailUri = FileProvider.getUriForFile((Context)context, (String)IntercomFileProviderKt.fileProviderAuthority(context), (File)file);
                Intrinsics.checkNotNull((Object)thumbnailUri);
                Uri uri = thumbnailUri;
                long l = file.length();
                int n3 = it.getWidth();
                int n4 = it.getHeight();
                image = new MediaData.Media.Image("image/jpg", n3, n4, l, thumbnailName, uri);
            } else {
                image = null;
            }
        } else {
            image = null;
        }
        MediaData.Media.Image thumbnail = image;
        retriever.close();
        return new MediaData.Media.Video(mimeType, width, height, size, fileName, $this$getVideoData, duration, thumbnail);
    }
}

