/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter.articles;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.content.res.ColorStateList;
import android.os.Bundle;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.Group;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import androidx.lifecycle.ViewModelStoreOwner;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.articles.ArticleWebViewClient;
import io.intercom.android.sdk.databinding.IntercomFragmentHelpCenterArticleBinding;
import io.intercom.android.sdk.helpcenter.api.HelpCenterApi;
import io.intercom.android.sdk.helpcenter.articles.ArticleActivity;
import io.intercom.android.sdk.helpcenter.articles.ArticleFragment;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewModel;
import io.intercom.android.sdk.helpcenter.articles.ArticleViewState;
import io.intercom.android.sdk.helpcenter.webview.HelpCenterWebViewInterface;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.extensions.ViewExtensionsKt;
import io.intercom.android.sdk.views.IntercomShimmerLayout;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0015H\u0002J\b\u0010\u001b\u001a\u00020\u0015H\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u0015H\u0002J\b\u0010#\u001a\u00020\u0015H\u0002J\b\u0010$\u001a\u00020\u0015H\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006%"}, d2={"Lio/intercom/android/sdk/helpcenter/articles/ArticleFragment;", "Landroidx/fragment/app/Fragment;", "<init>", "()V", "_binding", "Lio/intercom/android/sdk/databinding/IntercomFragmentHelpCenterArticleBinding;", "binding", "getBinding", "()Lio/intercom/android/sdk/databinding/IntercomFragmentHelpCenterArticleBinding;", "arguments", "Lio/intercom/android/sdk/helpcenter/articles/ArticleActivity$ArticleActivityArguments;", "getArguments", "()Lio/intercom/android/sdk/helpcenter/articles/ArticleActivity$ArticleActivityArguments;", "arguments$delegate", "Lkotlin/Lazy;", "viewModel", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel;", "getViewModel", "()Lio/intercom/android/sdk/helpcenter/articles/ArticleViewModel;", "viewModel$delegate", "onViewCreated", "", "view", "Landroid/view/View;", "savedInstanceState", "Landroid/os/Bundle;", "requestData", "subscribeToStates", "renderErrors", "error", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState$Error;", "renderContent", "content", "Lio/intercom/android/sdk/helpcenter/articles/ArticleViewState$Content;", "setCookies", "setInsets", "initViews", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nArticleFragment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArticleFragment.kt\nio/intercom/android/sdk/helpcenter/articles/ArticleFragment\n+ 2 View.kt\nandroidx/core/view/ViewKt\n*L\n1#1,218:1\n163#2,2:219\n*S KotlinDebug\n*F\n+ 1 ArticleFragment.kt\nio/intercom/android/sdk/helpcenter/articles/ArticleFragment\n*L\n179#1:219,2\n*E\n"})
public final class ArticleFragment
extends Fragment {
    @Nullable
    private IntercomFragmentHelpCenterArticleBinding _binding;
    @NotNull
    private final Lazy arguments$delegate = LazyKt.lazy(() -> ArticleFragment.arguments_delegate$lambda$0(this));
    @NotNull
    private final Lazy viewModel$delegate = LazyKt.lazy(() -> ArticleFragment.viewModel_delegate$lambda$2(this));
    public static final int $stable = 8;

    public ArticleFragment() {
        super(R.layout.intercom_fragment_help_center_article);
    }

    private final IntercomFragmentHelpCenterArticleBinding getBinding() {
        IntercomFragmentHelpCenterArticleBinding intercomFragmentHelpCenterArticleBinding = this._binding;
        if (intercomFragmentHelpCenterArticleBinding == null) {
            String string2 = "Required value was null.";
            throw new IllegalStateException(string2.toString());
        }
        return intercomFragmentHelpCenterArticleBinding;
    }

    private final ArticleActivity.ArticleActivityArguments getArguments() {
        Lazy lazy = this.arguments$delegate;
        return (ArticleActivity.ArticleActivityArguments)lazy.getValue();
    }

    private final ArticleViewModel getViewModel() {
        Lazy lazy = this.viewModel$delegate;
        return (ArticleViewModel)lazy.getValue();
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        this.initViews();
        this.setInsets();
        this.subscribeToStates();
        this.requestData();
    }

    private final void requestData() {
        this.getViewModel().fragmentLoaded(this.getArguments().getArticleId());
    }

    private final void subscribeToStates() {
        LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)((LifecycleOwner)this)).launchWhenStarted((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ArticleFragment this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ArticleFragment.access$getViewModel(this.this$0).getState().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ ArticleFragment this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(ArticleViewState it, Continuation<? super Unit> $completion) {
                                ArticleViewState articleViewState = it;
                                if (!Intrinsics.areEqual((Object)articleViewState, (Object)ArticleViewState.Initial.INSTANCE)) {
                                    if (articleViewState instanceof ArticleViewState.Content) {
                                        ArticleFragment.access$renderContent(this.this$0, (ArticleViewState.Content)it);
                                    } else if (articleViewState instanceof ArticleViewState.Error) {
                                        ArticleFragment.access$renderErrors(this.this$0, (ArticleViewState.Error)it);
                                    } else {
                                        throw new NoWhenBranchMatchedException();
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    private final void renderErrors(ArticleViewState.Error error) {
        TextView textView;
        IntercomFragmentHelpCenterArticleBinding $this$renderErrors_u24lambda_u245 = this.getBinding();
        boolean bl = false;
        IntercomShimmerLayout intercomShimmerLayout = $this$renderErrors_u24lambda_u245.articleLoadingView;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)intercomShimmerLayout), (String)"articleLoadingView");
        ViewExtensionsKt.hide((View)intercomShimmerLayout);
        LinearLayout linearLayout = $this$renderErrors_u24lambda_u245.articleContents;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"articleContents");
        ViewExtensionsKt.hide((View)linearLayout);
        TextView textView2 = $this$renderErrors_u24lambda_u245.articleErrorTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"articleErrorTextView");
        ViewExtensionsKt.show((View)textView2);
        $this$renderErrors_u24lambda_u245.articleErrorTextView.setText(error.getMessage());
        TextView $this$renderErrors_u24lambda_u245_u24lambda_u244 = textView = $this$renderErrors_u24lambda_u245.articleRetryButton;
        boolean bl2 = false;
        $this$renderErrors_u24lambda_u245_u24lambda_u244.setVisibility(error.getRetryButtonVisibility());
        $this$renderErrors_u24lambda_u245_u24lambda_u244.setOnClickListener(arg_0 -> ArticleFragment.renderErrors$lambda$5$lambda$4$lambda$3(this, arg_0));
        $this$renderErrors_u24lambda_u245_u24lambda_u244.setBackgroundTintList(ColorStateList.valueOf((int)ColorUtils.buttonBackgroundColorVariant(error.getRetryButtonPrimaryColor())));
        $this$renderErrors_u24lambda_u245_u24lambda_u244.setTextColor(error.getRetryButtonPrimaryColor());
    }

    private final void renderContent(ArticleViewState.Content content) {
        IntercomFragmentHelpCenterArticleBinding $this$renderContent_u24lambda_u247 = this.getBinding();
        boolean bl = false;
        Group group = $this$renderContent_u24lambda_u247.articleErrorViews;
        Intrinsics.checkNotNullExpressionValue((Object)group, (String)"articleErrorViews");
        ViewExtensionsKt.hide((View)group);
        $this$renderContent_u24lambda_u247.articleReactions.getRoot().setVisibility(content.getReactionState().getReactionComponentVisibility());
        $this$renderContent_u24lambda_u247.articleTeamHelp.setVisibility(content.getReactionState().getReactionComponentVisibility());
        $this$renderContent_u24lambda_u247.articleReactionsDivider.setVisibility(content.getReactionState().getReactionComponentVisibility());
        switch (WhenMappings.$EnumSwitchMapping$0[content.getWebViewStatus().ordinal()]) {
            case 1: {
                IntercomShimmerLayout intercomShimmerLayout = $this$renderContent_u24lambda_u247.articleLoadingView;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)intercomShimmerLayout), (String)"articleLoadingView");
                ViewExtensionsKt.show((View)intercomShimmerLayout);
                LinearLayout linearLayout = $this$renderContent_u24lambda_u247.articleContents;
                Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"articleContents");
                ViewExtensionsKt.hide((View)linearLayout);
                $this$renderContent_u24lambda_u247.articleWebView.setWebViewClient((WebViewClient)new ArticleWebViewClient(content.getArticleUrl(), this.getViewModel(), Injector.get().getAppConfigProvider().get().getHelpCenterUrls()));
                this.setCookies();
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"MobileClientDisplayType", (Object)"AndroidIntercomHeaderless"), TuplesKt.to((Object)"MobileClient", (Object)"AndroidIntercomWebView"), TuplesKt.to((Object)"MobileClientReactionsHidden", (Object)"true")};
                Map headers = MapsKt.mapOf((Pair[])pairArray);
                $this$renderContent_u24lambda_u247.articleWebView.loadUrl(content.getArticleUrl(), headers);
                break;
            }
            case 2: {
                IntercomShimmerLayout intercomShimmerLayout = $this$renderContent_u24lambda_u247.articleLoadingView;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)intercomShimmerLayout), (String)"articleLoadingView");
                ViewExtensionsKt.show((View)intercomShimmerLayout);
                LinearLayout linearLayout = $this$renderContent_u24lambda_u247.articleContents;
                Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"articleContents");
                ViewExtensionsKt.hide((View)linearLayout);
                break;
            }
            case 3: {
                IntercomShimmerLayout intercomShimmerLayout = $this$renderContent_u24lambda_u247.articleLoadingView;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)intercomShimmerLayout), (String)"articleLoadingView");
                ViewExtensionsKt.hide((View)intercomShimmerLayout);
                LinearLayout linearLayout = $this$renderContent_u24lambda_u247.articleContents;
                Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"articleContents");
                ViewExtensionsKt.show((View)linearLayout);
                $this$renderContent_u24lambda_u247.articleWebView.evaluateJavascript("window.alexandriaArticleContentId", arg_0 -> ArticleFragment.renderContent$lambda$7$lambda$6(this, arg_0));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        $this$renderContent_u24lambda_u247.articleTeamHelp.setVisibility(content.getReactionState().getTeamHelpVisibility());
        $this$renderContent_u24lambda_u247.articleTeamHelp.setNeedsChatBubble(true);
        $this$renderContent_u24lambda_u247.articleTeamHelp.setTeamPresenceState(content.getTeamPresenceState());
        if (content.getReactionState().getShouldScrollToBottom()) {
            $this$renderContent_u24lambda_u247.articleReactions.motionLayout.setTransitionListener(new MotionLayout.TransitionListener($this$renderContent_u24lambda_u247){
                final /* synthetic */ IntercomFragmentHelpCenterArticleBinding $this_with;
                {
                    this.$this_with = $receiver;
                }

                public void onTransitionStarted(MotionLayout p0, int p1, int p2) {
                }

                public void onTransitionChange(MotionLayout p0, int p1, int p2, float p3) {
                }

                public void onTransitionCompleted(MotionLayout p0, int p1) {
                    this.$this_with.articleScrollview.post(() -> renderContent.1.2.onTransitionCompleted$lambda$0(this.$this_with, this));
                }

                public void onTransitionTrigger(MotionLayout p0, int p1, boolean p2, float p3) {
                }

                private static final void onTransitionCompleted$lambda$0(IntercomFragmentHelpCenterArticleBinding $this_with, renderContent.1.2 this$0) {
                    $this_with.articleScrollview.smoothScrollTo(0, $this_with.articleTeamHelp.getBottom());
                    $this_with.articleReactions.motionLayout.removeTransitionListener((MotionLayout.TransitionListener)this$0);
                }
            });
        }
        $this$renderContent_u24lambda_u247.articleReactions.motionLayout.transitionToState(content.getReactionState().getTransitionState());
    }

    private final void setCookies() {
        Injector $this$setCookies_u24lambda_u248 = Injector.get();
        boolean bl = false;
        String key = "intercom-session-" + $this$setCookies_u24lambda_u248.getAppIdentity().appId();
        String string2 = $this$setCookies_u24lambda_u248.getUserIdentity().getEncryptedUserId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getEncryptedUserId(...)");
        String value = string2;
        CookieManager.getInstance().setCookie($this$setCookies_u24lambda_u248.getAppConfigProvider().get().getHelpCenterUrl(), key + '=' + value);
    }

    private final void setInsets() {
        IntercomFragmentHelpCenterArticleBinding $this$setInsets_u24lambda_u2410 = this.getBinding();
        boolean bl = false;
        ViewCompat.setOnApplyWindowInsetsListener((View)((View)$this$setInsets_u24lambda_u2410.articleParentView), ArticleFragment::setInsets$lambda$10$lambda$9);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private final void initViews() {
        this._binding = IntercomFragmentHelpCenterArticleBinding.bind(this.requireView());
        IntercomFragmentHelpCenterArticleBinding $this$initViews_u24lambda_u2415 = this.getBinding();
        boolean bl = false;
        $this$initViews_u24lambda_u2415.articleToolbar.setNavigationOnClickListener(arg_0 -> ArticleFragment.initViews$lambda$15$lambda$11(this, arg_0));
        $this$initViews_u24lambda_u2415.articleWebView.getSettings().setJavaScriptEnabled(true);
        HelpCenterWebViewInterface helpCenterWebViewInterface = new HelpCenterWebViewInterface($this$initViews_u24lambda_u2415.articleWebView, Injector.get().getGson(), Injector.get().getMetricTracker(), Injector.get().getApiProvider().get(), this.getArguments().isFromSearchBrowse());
        $this$initViews_u24lambda_u2415.articleWebView.addJavascriptInterface((Object)helpCenterWebViewInterface, "AndroidHost");
        $this$initViews_u24lambda_u2415.articleReactions.intercomReactionHappy.setOnClickListener(arg_0 -> ArticleFragment.initViews$lambda$15$lambda$12(this, arg_0));
        $this$initViews_u24lambda_u2415.articleReactions.intercomReactionNeutral.setOnClickListener(arg_0 -> ArticleFragment.initViews$lambda$15$lambda$13(this, arg_0));
        $this$initViews_u24lambda_u2415.articleReactions.intercomReactionSad.setOnClickListener(arg_0 -> ArticleFragment.initViews$lambda$15$lambda$14(this, arg_0));
    }

    private static final ArticleActivity.ArticleActivityArguments arguments_delegate$lambda$0(ArticleFragment this$0) {
        Intent intent = this$0.requireActivity().getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"getIntent(...)");
        return ArticleActivity.Companion.getArguments(intent);
    }

    private static final Unit viewModel_delegate$lambda$2$lambda$1(ArticleFragment this$0, int it) {
        this$0.getBinding().articleScrollview.scrollTo(0, it);
        return Unit.INSTANCE;
    }

    private static final ArticleViewModel viewModel_delegate$lambda$2(ArticleFragment this$0) {
        FragmentActivity fragmentActivity = this$0.requireActivity();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentActivity, (String)"requireActivity(...)");
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)fragmentActivity;
        HelpCenterApi helpCenterApi = Injector.get().getHelpCenterApi();
        Intrinsics.checkNotNullExpressionValue((Object)helpCenterApi, (String)"getHelpCenterApi(...)");
        return ArticleViewModel.Companion.create(viewModelStoreOwner, helpCenterApi, Injector.get().getAppConfigProvider().get().getHelpCenterUrl(), this$0.getArguments().getMetricPlace(), this$0.getArguments().isFromSearchBrowse(), this$0.getArguments().getShouldHideReactions(), (Function1<? super Integer, Unit>)((Function1)arg_0 -> ArticleFragment.viewModel_delegate$lambda$2$lambda$1(this$0, arg_0)));
    }

    private static final void renderErrors$lambda$5$lambda$4$lambda$3(ArticleFragment this$0, View it) {
        this$0.requestData();
    }

    private static final void renderContent$lambda$7$lambda$6(ArticleFragment this$0, String value) {
        ArticleViewModel articleViewModel = this$0.getViewModel();
        Intrinsics.checkNotNull((Object)value);
        articleViewModel.articleContentIdFetched(StringsKt.removeSurrounding((String)value, (CharSequence)"\""));
    }

    /*
     * WARNING - void declaration
     */
    private static final WindowInsetsCompat setInsets$lambda$10$lambda$9(View v, WindowInsetsCompat insets) {
        void bottom$iv;
        void right$iv;
        void top$iv;
        void left$iv;
        void $this$updatePadding$iv;
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        Insets insets2 = insets.getInsets(WindowInsetsCompat.Type.systemBars() | WindowInsetsCompat.Type.displayCutout());
        Intrinsics.checkNotNullExpressionValue((Object)insets2, (String)"getInsets(...)");
        Insets bars = insets2;
        View view = v;
        int n = bars.left;
        int n2 = bars.top;
        int n3 = bars.right;
        int n4 = bars.bottom;
        boolean $i$f$updatePadding = false;
        $this$updatePadding$iv.setPadding((int)left$iv, (int)top$iv, (int)right$iv, (int)bottom$iv);
        return WindowInsetsCompat.CONSUMED;
    }

    private static final void initViews$lambda$15$lambda$11(ArticleFragment this$0, View it) {
        block0: {
            FragmentActivity fragmentActivity = this$0.getActivity();
            if (fragmentActivity == null) break block0;
            fragmentActivity.onBackPressed();
        }
    }

    private static final void initViews$lambda$15$lambda$12(ArticleFragment this$0, View it) {
        this$0.getViewModel().happyReactionTapped();
    }

    private static final void initViews$lambda$15$lambda$13(ArticleFragment this$0, View it) {
        this$0.getViewModel().neutralReactionTapped();
    }

    private static final void initViews$lambda$15$lambda$14(ArticleFragment this$0, View it) {
        this$0.getViewModel().sadReactionTapped();
    }

    public static final /* synthetic */ ArticleViewModel access$getViewModel(ArticleFragment $this) {
        return $this.getViewModel();
    }

    public static final /* synthetic */ void access$renderContent(ArticleFragment $this, ArticleViewState.Content content) {
        $this.renderContent(content);
    }

    public static final /* synthetic */ void access$renderErrors(ArticleFragment $this, ArticleViewState.Error error) {
        $this.renderErrors(error);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArticleViewState.WebViewStatus.values().length];
            try {
                nArray[ArticleViewState.WebViewStatus.Idle.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArticleViewState.WebViewStatus.Loading.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArticleViewState.WebViewStatus.Ready.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

