/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities.extensions;

import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001a\u001a\u0010\b\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u001a\u0010\u000b\u001a\u00020\u0004*\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\f\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\f\u0010\r\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\u0014\u0010\u0010\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a\f\u0010\u0012\u001a\u00020\u0004*\u00020\u0006H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u0004*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"textBlockTypes", "", "Lio/intercom/android/sdk/blocks/lib/BlockType;", "shouldConcatenate", "", "part", "Lio/intercom/android/sdk/models/Part;", "nextPart", "hasNextConcatPartNewStyle", "index", "", "hasPreviousConcatPartNewStyle", "hasTextBlock", "isAttributeCollector", "isLinkCard", "isQuickReplyOnly", "isSingleBlockPartOfType", "type", "isTypingPart", "nextPartFromSameParticipant", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nPartExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PartExtensions.kt\nio/intercom/android/sdk/utilities/extensions/PartExtensionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1755#2,3:65\n*S KotlinDebug\n*F\n+ 1 PartExtensions.kt\nio/intercom/android/sdk/utilities/extensions/PartExtensionsKt\n*L\n16#1:65,3\n*E\n"})
public final class PartExtensionsKt {
    @NotNull
    private static final List<BlockType> textBlockTypes;

    public static final boolean hasTextBlock(@NotNull Part $this$hasTextBlock) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasTextBlock, (String)"<this>");
            List<Block> list = $this$hasTextBlock.getBlocks();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getBlocks(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Block it = (Block)element$iv;
                    boolean bl2 = false;
                    if (!textBlockTypes.contains((Object)it.getType())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean nextPartFromSameParticipant(@NotNull Part $this$nextPartFromSameParticipant, @NotNull Part nextPart) {
        Intrinsics.checkNotNullParameter((Object)$this$nextPartFromSameParticipant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)nextPart, (String)"nextPart");
        return Intrinsics.areEqual((Object)$this$nextPartFromSameParticipant.getParticipantId(), (Object)nextPart.getParticipantId());
    }

    public static final boolean isTypingPart(@NotNull Part $this$isTypingPart) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypingPart, (String)"<this>");
        return $this$isTypingPart.getMessageStyle() == MessageStyle.ADMIN_IS_TYPING_STYLE;
    }

    public static final boolean isAttributeCollector(@NotNull Part $this$isAttributeCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$isAttributeCollector, (String)"<this>");
        return $this$isAttributeCollector.getMessageStyle() == MessageStyle.ATTRIBUTE_COLLECTOR && !((Collection)$this$isAttributeCollector.getForm().getAttributes()).isEmpty();
    }

    public static final boolean isLinkCard(@NotNull Part $this$isLinkCard) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkCard, (String)"<this>");
        return PartExtensionsKt.isSingleBlockPartOfType($this$isLinkCard, BlockType.LINK) && MessageStyle.CHAT == $this$isLinkCard.getMessageStyle();
    }

    public static final boolean isQuickReplyOnly(@NotNull Part $this$isQuickReplyOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuickReplyOnly, (String)"<this>");
        List<ReplyOption> list = $this$isQuickReplyOnly.getReplyOptions();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getReplyOptions(...)");
        return !((Collection)list).isEmpty() && $this$isQuickReplyOnly.getBlocks().isEmpty();
    }

    private static final boolean isSingleBlockPartOfType(Part $this$isSingleBlockPartOfType, BlockType type2) {
        return $this$isSingleBlockPartOfType.getBlocks().size() == 1 && $this$isSingleBlockPartOfType.getBlocks().get(0).getType() == type2;
    }

    private static final boolean shouldConcatenate(Part part, Part nextPart) {
        return PartExtensionsKt.nextPartFromSameParticipant(part, nextPart) && Math.abs(nextPart.getCreatedAt() - part.getCreatedAt()) < TimeUnit.MINUTES.toSeconds(3L) && !PartExtensionsKt.isTypingPart(part) && !PartExtensionsKt.isTypingPart(nextPart) && !PartExtensionsKt.isLinkCard(part) && !PartExtensionsKt.isLinkCard(nextPart) && part.isEvent() == false && nextPart.isEvent() == false && !PartExtensionsKt.isAttributeCollector(part) && !PartExtensionsKt.isAttributeCollector(nextPart) && !PartExtensionsKt.isQuickReplyOnly(part) && !PartExtensionsKt.isQuickReplyOnly(nextPart) && part.getMessageStyle() != MessageStyle.POST && nextPart.getMessageStyle() != MessageStyle.POST && part.getMessageStyle() != MessageStyle.NOTE && nextPart.getMessageStyle() != MessageStyle.NOTE;
    }

    public static final boolean hasPreviousConcatPartNewStyle(@NotNull List<? extends Part> $this$hasPreviousConcatPartNewStyle, int index) {
        Intrinsics.checkNotNullParameter($this$hasPreviousConcatPartNewStyle, (String)"<this>");
        return (1 <= index ? index <= CollectionsKt.getLastIndex($this$hasPreviousConcatPartNewStyle) : false) && PartExtensionsKt.shouldConcatenate($this$hasPreviousConcatPartNewStyle.get(index - 1), $this$hasPreviousConcatPartNewStyle.get(index));
    }

    public static final boolean hasNextConcatPartNewStyle(@NotNull List<? extends Part> $this$hasNextConcatPartNewStyle, int index) {
        Intrinsics.checkNotNullParameter($this$hasNextConcatPartNewStyle, (String)"<this>");
        return (0 <= index ? index < CollectionsKt.getLastIndex($this$hasNextConcatPartNewStyle) : false) && PartExtensionsKt.shouldConcatenate($this$hasNextConcatPartNewStyle.get(index), $this$hasNextConcatPartNewStyle.get(index + 1));
    }

    static {
        BlockType[] blockTypeArray = new BlockType[]{BlockType.PARAGRAPH, BlockType.HEADING, BlockType.SUBHEADING};
        textBlockTypes = CollectionsKt.listOf((Object[])blockTypeArray);
    }
}

