/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import androidx.compose.runtime.internal.StabilityInferred;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.helpcenter.articles.ArticleMetadata;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.m5.conversation.reducers.ComposerStateReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ComposerSuggestionsReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ConversationPartsReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.ErrorReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.HeaderReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.IntroPartsReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.LoadingStateReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducerKt;
import io.intercom.android.sdk.m5.conversation.states.BottomBarUiState;
import io.intercom.android.sdk.m5.conversation.states.BottomSheetState;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.ConversationUiState;
import io.intercom.android.sdk.m5.conversation.states.FloatingIndicatorState;
import io.intercom.android.sdk.m5.conversation.states.FooterNoticeState;
import io.intercom.android.sdk.m5.conversation.states.GroupingPosition;
import io.intercom.android.sdk.m5.conversation.states.NetworkState;
import io.intercom.android.sdk.m5.conversation.states.PendingMessage;
import io.intercom.android.sdk.m5.conversation.states.TeamPresenceState;
import io.intercom.android.sdk.m5.conversation.states.TopAppBarUiState;
import io.intercom.android.sdk.m5.conversation.states.TypingIndicatorType;
import io.intercom.android.sdk.m5.conversation.utils.BackgroundShader;
import io.intercom.android.sdk.m5.data.IntercomDataLayer;
import io.intercom.android.sdk.models.ActiveBot;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.AvatarDetails;
import io.intercom.android.sdk.models.BotIntro;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.FooterNotice;
import io.intercom.android.sdk.models.OpenMessengerResponse;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.StreamingPart;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.commons.TimeProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B9\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer;", "", "config", "Lkotlin/Function0;", "Lio/intercom/android/sdk/identity/AppConfig;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "timeProvider", "Lio/intercom/android/sdk/utilities/commons/TimeProvider;", "intercomDataLayer", "Lio/intercom/android/sdk/m5/data/IntercomDataLayer;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lio/intercom/android/sdk/utilities/commons/TimeProvider;Lio/intercom/android/sdk/m5/data/IntercomDataLayer;)V", "computeUiState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "computeUiState$intercom_sdk_base_release", "isBotIntroEmpty", "", "toArticlePart", "Lio/intercom/android/sdk/models/Part;", "Lio/intercom/android/sdk/helpcenter/articles/ArticleMetadata;", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nConversationReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,214:1\n1557#2:215\n1628#2,3:216\n1872#2,3:219\n1755#2,3:222\n1557#2:225\n1628#2,3:226\n*S KotlinDebug\n*F\n+ 1 ConversationReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationReducer\n*L\n132#1:215\n132#1:216,3\n136#1:219,3\n159#1:222,3\n188#1:225\n188#1:226,3\n*E\n"})
public final class ConversationReducer {
    @NotNull
    private final Function0<AppConfig> config;
    @NotNull
    private final Function0<UserIdentity> userIdentity;
    @NotNull
    private final TimeProvider timeProvider;
    @NotNull
    private final IntercomDataLayer intercomDataLayer;
    public static final int $stable = 8;

    public ConversationReducer(@NotNull Function0<AppConfig> config, @NotNull Function0<? extends UserIdentity> userIdentity, @NotNull TimeProvider timeProvider, @NotNull IntercomDataLayer intercomDataLayer) {
        Intrinsics.checkNotNullParameter(config, (String)"config");
        Intrinsics.checkNotNullParameter(userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        Intrinsics.checkNotNullParameter((Object)intercomDataLayer, (String)"intercomDataLayer");
        this.config = config;
        this.userIdentity = userIdentity;
        this.timeProvider = timeProvider;
        this.intercomDataLayer = intercomDataLayer;
    }

    public /* synthetic */ ConversationReducer(Function0 function0, Function0 function02, TimeProvider timeProvider, IntercomDataLayer intercomDataLayer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = 2.INSTANCE;
        }
        if ((n & 4) != 0) {
            TimeProvider timeProvider2 = TimeProvider.SYSTEM;
            Intrinsics.checkNotNullExpressionValue((Object)timeProvider2, (String)"SYSTEM");
            timeProvider = timeProvider2;
        }
        if ((n & 8) != 0) {
            IntercomDataLayer intercomDataLayer2 = Injector.get().getDataLayer();
            Intrinsics.checkNotNullExpressionValue((Object)intercomDataLayer2, (String)"getDataLayer(...)");
            intercomDataLayer = intercomDataLayer2;
        }
        this((Function0<AppConfig>)function0, (Function0<? extends UserIdentity>)function02, timeProvider, intercomDataLayer);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConversationUiState computeUiState$intercom_sdk_base_release(@NotNull ConversationClientState clientState) {
        ConversationUiState conversationUiState;
        Object object;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Conversation conversation = clientState.getConversation();
        String conversationId2 = clientState.getConversationId();
        NetworkResponse<Object> lastNetworkCall = clientState.getLastNetworkCall();
        boolean isLoadingExistingConversation = conversation == null && conversationId2 != null;
        boolean isNewConversation = conversation == null && conversationId2 == null;
        boolean isStartedFromArticle = clientState.getArticleMetadata() != null;
        boolean isBotIntroEmpty = this.isBotIntroEmpty(clientState);
        boolean shouldShowOnlyArticleCard = isNewConversation && isStartedFromArticle && isBotIntroEmpty;
        boolean waitingForOpenResponse = isNewConversation && clientState.getOpenMessengerResponse() == null;
        TeamPresenceState teamPresenceState = TeamPresenceReducerKt.reduceTeamPresenceState(clientState.getConversation(), clientState.getOpenMessengerResponse());
        TopAppBarUiState topAppBarUiState = HeaderReducerKt.reduceTopAppBarUiState(isNewConversation, !clientState.getPendingMessages().isEmpty(), clientState.getConversation(), (object = clientState.getOpenMessengerResponse()) != null && (object = ((OpenMessengerResponse)object).getNewConversationData()) != null ? ((OpenMessengerResponse.NewConversationData)object).getHeader() : null, (AppConfig)this.config.invoke(), clientState.getUnreadConversationsCount(), clientState.getUnreadTicketsCount(), clientState.getLaunchMode());
        BackgroundShader.None background = BackgroundShader.None.INSTANCE;
        if (isLoadingExistingConversation && lastNetworkCall != null && !(lastNetworkCall instanceof NetworkResponse.Success)) {
            conversationUiState = ErrorReducerKt.reduceError(lastNetworkCall, topAppBarUiState);
        } else if (isLoadingExistingConversation || waitingForOpenResponse) {
            conversationUiState = LoadingStateReducerKt.reduceLoadingState(topAppBarUiState, background);
        } else {
            Object object2;
            Object streamingPart;
            PendingMessage.FailedImageUploadData failedImageUploadData;
            Object object3;
            PendingMessage pending;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object4;
            Object it;
            NetworkState networkState = clientState.getNetworkState();
            BottomSheetState bottomSheetState = clientState.getBottomSheetState();
            BottomBarUiState bottomBarUiState = ComposerStateReducerKt.reduceComposerState(clientState, (AppConfig)this.config.invoke(), isNewConversation);
            Object object5 = CollectionsKt.createListBuilder();
            List $this$computeUiState_u24lambda_u248 = object5;
            boolean bl = false;
            if (!StringsKt.isBlank((CharSequence)teamPresenceState.getTeamIntro())) {
                $this$computeUiState_u24lambda_u248.add(new ContentRow.TeamIntroRow(teamPresenceState.getTeamIntro()));
            }
            if (!StringsKt.isBlank((CharSequence)teamPresenceState.getSpecialNotice())) {
                $this$computeUiState_u24lambda_u248.add(new ContentRow.SpecialNoticeRow(teamPresenceState.getSpecialNotice()));
            }
            if (shouldShowOnlyArticleCard && clientState.getArticleMetadata() != null) {
                $this$computeUiState_u24lambda_u248.add(new ContentRow.AskedAboutRow(this.toArticlePart(clientState.getArticleMetadata())));
            }
            if (isNewConversation) {
                $this$computeUiState_u24lambda_u248.addAll((Collection)IntroPartsReducerKt.reduceIntroParts(clientState, (BotIntro)this.intercomDataLayer.getBotIntro().getValue(), this.timeProvider));
            }
            $this$computeUiState_u24lambda_u248.addAll((Collection)ConversationPartsReducerKt.reduceMessages(clientState, (UserIdentity)this.userIdentity.invoke(), (AppConfig)this.config.invoke()));
            if (isNewConversation && clientState.getPendingMessages().isEmpty()) {
                Object object6 = clientState.getOpenMessengerResponse();
                if (object6 != null && (object6 = ((OpenMessengerResponse)object6).getComposerSuggestions()) != null) {
                    it = object6;
                    boolean bl2 = false;
                    ContentRow contentRow = ComposerSuggestionsReducerKt.reduceComposerSuggestions((ComposerSuggestions)it);
                    if (contentRow != null) {
                        ContentRow composerSuggestionsRow = contentRow;
                        boolean bl3 = false;
                        $this$computeUiState_u24lambda_u248.add(composerSuggestionsRow);
                    }
                }
            }
            if ((object4 = clientState.getConversation()) == null || (object4 = ((Conversation)object4).parts()) == null) {
                object4 = CollectionsKt.emptyList();
            }
            Iterable iterable = clientState.getPendingMessages().values();
            Collection collection = (Collection)object4;
            boolean $i$f$map = false;
            it = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                PendingMessage pendingMessage = (PendingMessage)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl4 = false;
                collection2.add(pending.getPart());
            }
            List allConcatParts = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
            Object object7 = clientState.getConversation();
            int partsSize = object7 != null && (object7 = ((Conversation)object7).parts()) != null ? object7.size() : 0;
            Iterable $this$forEachIndexed$iv = clientState.getPendingMessages().values();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it2;
                int item$iv$iv;
                if ((item$iv$iv = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                pending = (PendingMessage)item$iv;
                int index = item$iv$iv;
                boolean bl5 = false;
                int lastConcatPartsIndex = partsSize + index;
                ContentRow.MessageRow.PartWrapper partWrapper = new ContentRow.MessageRow.PartWrapper(it2.getPart(), index == clientState.getPendingMessages().size() - 1, ConversationPartsReducerKt.isAdminOrAltParticipant(it2.getPart(), (UserIdentity)this.userIdentity.invoke()), null, 8, null);
                object3 = ConversationPartsReducerKt.getGroupingPosition(allConcatParts, lastConcatPartsIndex);
                boolean bl6 = it2.isFailed();
                failedImageUploadData = it2.getFailedImageUploadData();
                ContentRow.BubbleMessageRow messageRow = new ContentRow.BubbleMessageRow(partWrapper, (GroupingPosition)((Object)object3), failedImageUploadData, bl6, true);
                $this$computeUiState_u24lambda_u248.add(messageRow);
            }
            if (conversation != null) {
                boolean hasStreamedPart;
                block27: {
                    boolean bl7;
                    Iterable $this$any$iv = conversation.parts();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl7 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Part part = (Part)element$iv;
                            boolean bl8 = false;
                            String string2 = part.getUuid();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUuid(...)");
                            if (!(!StringsKt.isBlank((CharSequence)string2) && Intrinsics.areEqual((Object)part.getUuid(), (Object)clientState.getFinStreamingData().getClientAssignedUUID()))) continue;
                            bl7 = true;
                            break block27;
                        }
                        bl7 = hasStreamedPart = false;
                    }
                }
                if (clientState.getFinStreamingData().isFinStreaming() && !hasStreamedPart) {
                    ActiveBot activeBot = ((TeamPresence)this.intercomDataLayer.getTeamPresence().getValue()).getActiveBot();
                    Object object8 = activeBot;
                    if (object8 != null && (object8 = ((ActiveBot)object8).getStreamingPart()) != null) {
                        streamingPart = object8;
                        boolean bl9 = false;
                        ContentRow.FinStreamingRow finStreamingRow = new ContentRow.FinStreamingRow(clientState.getFinStreamingData().getBlocks(), (StreamingPart)streamingPart);
                        $this$computeUiState_u24lambda_u248.add(finStreamingRow);
                    }
                }
            }
            if (clientState.getCurrentlyTypingState().getUserType() != TypingIndicatorType.NONE) {
                $this$computeUiState_u24lambda_u248.add(new ContentRow.TypingIndicatorRow(clientState.getCurrentlyTypingState()));
            }
            if ((object2 = conversation) != null && (object2 = ((Conversation)object2).getFooterNotice()) != null) {
                List list;
                Object object9;
                Object it3 = object2;
                boolean bl10 = false;
                List list2 = $this$computeUiState_u24lambda_u248;
                String string3 = ((FooterNotice)it3).getTitle();
                String string4 = ((FooterNotice)it3).getSubtitle();
                if (string4 == null) {
                    string4 = "";
                }
                if ((object9 = ((FooterNotice)it3).getAvatarDetails()) != null && (object9 = ((AvatarDetails)object9).getAvatars()) != null) {
                    Collection<AvatarWrapper> collection3;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    streamingPart = (Iterable)object9;
                    String string5 = string4;
                    String string6 = string3;
                    object3 = list2;
                    boolean $i$f$map2 = false;
                    failedImageUploadData = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                        void avatar;
                        Avatar.Builder builder = (Avatar.Builder)item$iv$iv;
                        collection3 = destination$iv$iv2;
                        boolean bl11 = false;
                        Avatar avatar2 = avatar.build();
                        Intrinsics.checkNotNullExpressionValue((Object)avatar2, (String)"build(...)");
                        collection3.add(new AvatarWrapper(avatar2, false, null, null, null, false, false, 126, null));
                    }
                    collection3 = (List)destination$iv$iv2;
                    list2 = object3;
                    string3 = string6;
                    string4 = string5;
                    list = collection3;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List list3 = list;
                String string7 = string4;
                String string8 = string3;
                FooterNoticeState footerNoticeState = new FooterNoticeState(string8, string7, list3);
                list2.add(new ContentRow.FooterNoticeRow(footerNoticeState));
            }
            List list = CollectionsKt.build((List)object5);
            object5 = clientState.getFloatingIndicatorState();
            conversationUiState = new ConversationUiState.Content(topAppBarUiState, list, bottomBarUiState, networkState, bottomSheetState, background, (FloatingIndicatorState)object5, teamPresenceState);
        }
        return conversationUiState;
    }

    private final boolean isBotIntroEmpty(ConversationClientState clientState) {
        Object object;
        Object object2;
        Collection collection;
        return ((BotIntro)this.intercomDataLayer.getBotIntro().getValue()).getBlocks().isEmpty() && ((collection = (Collection)((object2 = clientState.getOpenMessengerResponse()) != null && (object2 = ((OpenMessengerResponse)object2).getNewConversationData()) != null ? ((OpenMessengerResponse.NewConversationData)object2).getParts() : null)) == null || collection.isEmpty()) && ((collection = (Collection)((object = clientState.getOpenMessengerResponse()) != null && (object = ((OpenMessengerResponse)object).getComposerSuggestions()) != null ? ((ComposerSuggestions)object).getSuggestions() : null)) == null || collection.isEmpty());
    }

    private final Part toArticlePart(ArticleMetadata $this$toArticlePart) {
        Part part = new Part.Builder().withIsInitialMessage(true).withBlocks(CollectionsKt.listOf((Object)new Block.Builder().withArticleId($this$toArticlePart.getId()).withTitle($this$toArticlePart.getTitle()))).build();
        Intrinsics.checkNotNullExpressionValue((Object)part, (String)"build(...)");
        return part;
    }

    public ConversationReducer() {
        this(null, null, null, null, 15, null);
    }
}

