/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.content.Context;
import android.os.Build;
import android.text.format.DateFormat;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.UtilsKt;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\n\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0014\u0010\u000b\u001a\u00020\u0007*\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\f\u0010\f\u001a\u00020\u0007*\u00020\u0001H\u0000\u001a\f\u0010\r\u001a\u00020\u0007*\u00020\u0001H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0007*\u00020\u0001H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0007*\u00020\u0001H\u0000\u00a8\u0006\u0010"}, d2={"getDifferenceInDays", "", "date", "Ljava/util/Date;", "getDifferenceInHours", "getDifferenceInMinutes", "getFormattedTime", "", "context", "Landroid/content/Context;", "formattedDateForDayDivider", "formattedDateFromLong", "millisecondsToFormatTime", "toISOFormat", "toISOFormatApi26", "toISOFormatPreApi26", "intercom-sdk-base_release"})
public final class TimeFormatterExtKt {
    @NotNull
    public static final String formattedDateFromLong(long $this$formattedDateFromLong, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$formattedDateFromLong <= 0L) {
            return "";
        }
        Date date = new Date($this$formattedDateFromLong * (long)1000);
        return TimeFormatterExtKt.getFormattedTime(context, date);
    }

    @NotNull
    public static final String formattedDateForDayDivider(long $this$formattedDateForDayDivider, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ($this$formattedDateForDayDivider <= 0L) {
            return "";
        }
        Date date = new Date($this$formattedDateForDayDivider * (long)1000);
        Locale locale = UtilsKt.getLocaleCompat(context);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DateFormat.getBestDateTimePattern((Locale)locale, (String)"MMMM d"), locale);
        String string2 = simpleDateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String millisecondsToFormatTime(long $this$millisecondsToFormatTime) {
        long seconds = $this$millisecondsToFormatTime / (long)1000 % (long)60;
        long minutes = $this$millisecondsToFormatTime / (long)1000 / (long)60 % (long)60;
        String string2 = "%02d:%02d";
        Object[] objectArray = new Object[]{minutes, seconds};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    @NotNull
    public static final String toISOFormat(long $this$toISOFormat) {
        return Build.VERSION.SDK_INT >= 26 ? TimeFormatterExtKt.toISOFormatApi26($this$toISOFormat) : TimeFormatterExtKt.toISOFormatPreApi26($this$toISOFormat);
    }

    @NotNull
    public static final String toISOFormatApi26(long $this$toISOFormatApi26) {
        Instant instant = Instant.ofEpochMilli($this$toISOFormatApi26 * (long)1000);
        String string2 = DateTimeFormatter.ISO_INSTANT.format(instant);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @NotNull
    public static final String toISOFormatPreApi26(long $this$toISOFormatPreApi26) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.ENGLISH);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string2 = simpleDateFormat.format($this$toISOFormatPreApi26 * (long)1000);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private static final String getFormattedTime(Context context, Date date) {
        long diffInMin = TimeFormatterExtKt.getDifferenceInMinutes(date);
        long diffInHours = TimeFormatterExtKt.getDifferenceInHours(date);
        long diffInDays = TimeFormatterExtKt.getDifferenceInDays(date);
        long diffInWeeks = diffInDays / (long)7;
        String displayDate = diffInWeeks > 0L ? ((Object)Phrase.from(context, R.string.intercom_time_week_ago).put("delta", String.valueOf(diffInWeeks)).format()).toString() : (diffInDays > 0L ? ((Object)Phrase.from(context, R.string.intercom_time_day_ago).put("delta", String.valueOf(diffInDays)).format()).toString() : (diffInHours > 0L ? ((Object)Phrase.from(context, R.string.intercom_time_hour_ago).put("delta", String.valueOf(diffInHours)).format()).toString() : (diffInMin >= 1L ? ((Object)Phrase.from(context, R.string.intercom_time_minute_ago).put("delta", String.valueOf(diffInMin)).format()).toString() : ((Object)context.getText(R.string.intercom_time_just_now)).toString())));
        return displayDate;
    }

    private static final long getDifferenceInMinutes(Date date) {
        return TimeUnit.MILLISECONDS.toMinutes(System.currentTimeMillis() - date.getTime());
    }

    private static final long getDifferenceInHours(Date date) {
        return TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - date.getTime());
    }

    private static final long getDifferenceInDays(Date date) {
        return TimeUnit.MILLISECONDS.toDays(System.currentTimeMillis() - date.getTime());
    }
}

