/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.states.ContentRow;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.PendingMessage;
import io.intercom.android.sdk.m5.conversation.states.SharpCornersShape;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.MessageStyle;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.tickets.TicketDetailReducerKt;
import io.intercom.android.sdk.tickets.TicketLaunchedFrom;
import io.intercom.android.sdk.utilities.extensions.ConversationExtensionsKt;
import io.intercom.android.sdk.utilities.extensions.PartExtensionsKt;
import io.intercom.android.sdk.views.compose.MessageRowKt;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a$\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00042\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0004H\u0002\u001a&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a8\u0006\u0018"}, d2={"getSharpCornersShape", "Lio/intercom/android/sdk/m5/conversation/states/SharpCornersShape;", "parts", "", "Lio/intercom/android/sdk/models/Part;", "index", "", "isAdminOrAltParticipant", "", "hasPendingMessageAfter", "part", "pendingMessages", "", "", "Lio/intercom/android/sdk/m5/conversation/states/PendingMessage;", "reduceEvent", "Lio/intercom/android/sdk/m5/conversation/states/ContentRow;", "reduceMessages", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nConversationPartsReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConversationPartsReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationPartsReducerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,193:1\n827#2:194\n855#2,2:195\n785#2:197\n796#2:198\n1872#2,2:199\n797#2,2:201\n1874#2:203\n799#2:204\n1485#2:205\n1510#2,3:206\n1513#2,3:216\n1863#2:219\n1557#2:220\n1628#2,3:221\n1567#2:224\n1598#2,4:225\n1864#2:229\n381#3,7:209\n1#4:230\n*S KotlinDebug\n*F\n+ 1 ConversationPartsReducer.kt\nio/intercom/android/sdk/m5/conversation/reducers/ConversationPartsReducerKt\n*L\n49#1:194\n49#1:195,2\n53#1:197\n53#1:198\n53#1:199,2\n53#1:201,2\n53#1:203\n53#1:204\n60#1:205\n60#1:206,3\n60#1:216,3\n66#1:219\n70#1:220\n70#1:221,3\n74#1:224\n74#1:225,4\n66#1:229\n60#1:209,7\n*E\n"})
public final class ConversationPartsReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ContentRow> reduceMessages(@NotNull ConversationClientState clientState, @NotNull UserIdentity userIdentity, @NotNull AppConfig config) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv;
        void $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv;
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)userIdentity, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Conversation conversation = clientState.getConversation();
        if (conversation == null) {
            return CollectionsKt.emptyList();
        }
        Conversation conversation2 = conversation;
        if (conversation2.getTicket() != null && !ConversationExtensionsKt.hasNonTicketParts(conversation2) && clientState.getPendingMessages().isEmpty()) {
            return CollectionsKt.listOf((Object)new ContentRow.BigTicketRow(TicketDetailReducerKt.computeTicketViewState$default(conversation2.getTicket(), userIdentity, null, new TicketLaunchedFrom.Conversation(conversation2.getTicket()), 4, null)));
        }
        List $this$reduceMessages_u24lambda_u249 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object lastFilteredPart = null;
        Iterable iterable = conversation2.parts();
        boolean $i$f$filterNot = false;
        void var10_12 = $this$filterNot$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Part it = (Part)element$iv$iv;
            boolean bl2 = false;
            List<ReplyOption> list2 = it.getReplyOptions();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getReplyOptions(...)");
            if (!((Collection)list2).isEmpty() && conversation2.getPreventEndUserReplies()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterIndexed = false;
        $this$filterNotTo$iv$iv = $this$filterIndexed$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        Iterator $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        Iterator bl2 = $this$forEachIndexed$iv$iv$iv.iterator();
        while (bl2.hasNext()) {
            void part;
            void element$iv$iv;
            int n;
            Object item$iv$iv$iv = bl2.next();
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl3 = false;
            Part part2 = (Part)element$iv$iv;
            int index = index$iv$iv;
            boolean bl4 = false;
            if (!(part.getMessageStyle() != MessageStyle.QUICK_REPLY || index == CollectionsKt.getLastIndex(conversation2.parts()) && !ConversationPartsReducerKt.hasPendingMessageAfter((Part)part, clientState.getPendingMessages()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List $this$reduceMessages_u24lambda_u249_u24lambda_u242 = $this$filterIndexed$iv = (List)destination$iv$iv;
        boolean $i$a$-apply-ConversationPartsReducerKt$reduceMessages$1$42 = false;
        lastFilteredPart = CollectionsKt.lastOrNull((List)$this$reduceMessages_u24lambda_u249_u24lambda_u242);
        $this$filterIndexed$iv = $this$filterIndexed$iv;
        boolean $i$f$groupBy = false;
        void $i$a$-apply-ConversationPartsReducerKt$reduceMessages$1$42 = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Calendar cal;
            Part it = (Part)element$iv$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNullExpressionValue((Object)Calendar.getInstance(), (String)"getInstance(...)");
            cal.setTime(new Date(it.getCreatedAt() * (long)1000));
            Integer key$iv$iv = cal.get(6);
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl6 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapIndexedTo$iv$iv;
            List list3;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List it = (List)element$iv;
            boolean bl7 = false;
            $this$reduceMessages_u24lambda_u249.add(new ContentRow.DayDividerRow(((Part)CollectionsKt.first((List)it)).getCreatedAt()));
            Iterable element$iv$iv = clientState.getPendingMessages().values();
            Collection collection = it;
            boolean $i$f$map22 = false;
            void cal = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pending;
                PendingMessage answer$iv$iv$iv = (PendingMessage)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl8 = false;
                collection2.add(pending.getPart());
            }
            List allConcatParts = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv2));
            List $i$f$map22 = list3 = CollectionsKt.createListBuilder();
            collection = $this$reduceMessages_u24lambda_u249;
            boolean bl9 = false;
            Iterable $this$mapIndexed$iv = it;
            boolean $i$f$mapIndexed = false;
            Iterable $i$f$getOrPut = $this$mapIndexed$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247;
                void part;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Part part3 = (Part)item$iv$iv;
                int n2 = n;
                Collection collection3 = destination$iv$iv3;
                boolean bl10 = false;
                if (clientState.getNewMessageId() != null && Intrinsics.areEqual((Object)clientState.getNewMessageId(), (Object)part.getId())) {
                    $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(ContentRow.NewMessagesRow.INSTANCE);
                }
                if (part.isInitialMessage() && PartExtensionsKt.isLinkCard((Part)part)) {
                    $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(new ContentRow.AskedAboutRow((Part)part));
                } else {
                    Boolean bl11 = part.isEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)bl11, (String)"isEvent(...)");
                    if (bl11.booleanValue()) {
                        $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247.add(ConversationPartsReducerKt.reduceEvent((Part)part));
                    } else {
                        void $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245;
                        String string2;
                        String string3;
                        boolean isLastPart;
                        void index;
                        boolean isAdminOrAltParticipant = part.isAdmin() || !part.getParticipant().isUserWithId(userIdentity.getIntercomId());
                        boolean showAvatarIfAvailable = part.getMessageStyle() != MessageStyle.QUICK_REPLY && !PartExtensionsKt.hasNextConcatPart(allConcatParts, (int)index);
                        boolean isGrouped = PartExtensionsKt.hasNextConcatPart(allConcatParts, (int)index);
                        Part part4 = (Part)lastFilteredPart;
                        boolean bl12 = isLastPart = Intrinsics.areEqual((Object)part.getId(), (Object)(part4 != null ? part4.getId() : null)) && clientState.getPendingMessages().isEmpty() && !clientState.getFinStreamingData().isFinStreaming();
                        Integer statusString = isLastPart && !isAdminOrAltParticipant ? (Intrinsics.areEqual((Object)(string3 = part.getSeenByAdmin()), (Object)"seen") ? Integer.valueOf(R.string.intercom_message_seen) : (Intrinsics.areEqual((Object)string3, (Object)"unseen") ? Integer.valueOf(R.string.intercom_message_unseen) : null)) : null;
                        String string4 = string2 = part;
                        void var41_69 = $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247;
                        boolean bl13 = false;
                        $this$reduceMessages_u24lambda_u249_u24lambda_u248_u24lambda_u247_u24lambda_u246_u24lambda_u245.setParentConversation(conversation2);
                        string3 = string2;
                        string2 = config.getName();
                        string4 = clientState.getFailedAttributeIdentifier();
                        SharpCornersShape sharpCornersShape = ConversationPartsReducerKt.getSharpCornersShape(allConcatParts, (int)index, isAdminOrAltParticipant);
                        boolean bl14 = !isAdminOrAltParticipant && isLastPart && Intrinsics.areEqual((Object)conversation2.getUiFlags().getShowLastPartMeta(), (Object)false) || PartExtensionsKt.isQuickReplyOnly((Part)part) && part.getBlocks().isEmpty();
                        ContentRow.MessageRow.PartWrapper partWrapper = new ContentRow.MessageRow.PartWrapper((Part)((Object)string3), isLastPart, statusString, isAdminOrAltParticipant, showAvatarIfAvailable, string2, false, isGrouped, sharpCornersShape, null, string4, bl14, 512, null);
                        var41_69.add(new ContentRow.MessageRow(partWrapper));
                    }
                }
                collection3.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv3;
            collection.addAll(CollectionsKt.build((List)list3));
        }
        return CollectionsKt.build((List)list);
    }

    private static final ContentRow reduceEvent(Part part) {
        ContentRow contentRow;
        if (part.getMessageStyle() == MessageStyle.TICKET_STATE_UPDATED) {
            contentRow = new ContentRow.TicketStatusRow(part.getEventData().getStatus(), part.getEventData().getEventAsPlainText(), part.getCreatedAt(), part.getEventData().getCustomStateLabel(), part.getEventData().getCustomStatePrefix());
        } else if (part.getMessageStyle() == MessageStyle.MERGED_PRIMARY_CONVERSATION) {
            String string2 = part.getEventData().getMergedConversationId();
            String string3 = part.getEventData().getDescription();
            contentRow = new ContentRow.MergedConversationRow(string3, string2);
        } else {
            String string4 = part.getEventData().getEventAsPlainText();
            Avatar avatar = Avatar.create(part.getEventData().getParticipant().getAvatar().getImageUrl(), part.getEventData().getParticipant().getInitial());
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"create(...)");
            contentRow = new ContentRow.EventRow(string4, avatar);
        }
        return contentRow;
    }

    private static final boolean hasPendingMessageAfter(Part part, Map<String, PendingMessage> pendingMessages) {
        Comparable comparable;
        Iterable iterable = pendingMessages.values();
        long l = part.getCreatedAt();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            PendingMessage it = (PendingMessage)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getPart().getCreatedAt());
            while (iterator.hasNext()) {
                PendingMessage it2 = (PendingMessage)iterator.next();
                $i$a$-maxOfOrNull-ConversationPartsReducerKt$hasPendingMessageAfter$1 = false;
                Comparable comparable3 = Long.valueOf(it2.getPart().getCreatedAt());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Comparable comparable4 = comparable;
        Long l2 = (Long)comparable4;
        if (l2 == null) {
            return false;
        }
        return l < l2;
    }

    @NotNull
    public static final SharpCornersShape getSharpCornersShape(@NotNull List<? extends Part> parts, int index, boolean isAdminOrAltParticipant) {
        SharpCornersShape sharpCornersShape;
        Intrinsics.checkNotNullParameter(parts, (String)"parts");
        Part part = (Part)CollectionsKt.getOrNull(parts, (int)index);
        boolean bl = part != null ? MessageRowKt.hasTextBlock(part) : false;
        if (bl) {
            boolean bl2 = PartExtensionsKt.hasPreviousConcatPart(parts, index) && isAdminOrAltParticipant;
            boolean bl3 = PartExtensionsKt.hasNextConcatPart(parts, index) && isAdminOrAltParticipant;
            boolean bl4 = PartExtensionsKt.hasPreviousConcatPart(parts, index) && !isAdminOrAltParticipant;
            boolean bl5 = PartExtensionsKt.hasNextConcatPart(parts, index) && !isAdminOrAltParticipant;
            sharpCornersShape = new SharpCornersShape(bl2, bl4, bl5, bl3);
        } else {
            sharpCornersShape = new SharpCornersShape(false, false, false, false, 15, null);
        }
        return sharpCornersShape;
    }
}

