/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.models.AiAnswerInfo;
import io.intercom.android.sdk.models.AiMood;
import io.intercom.android.sdk.models.Attachments;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.EventData;
import io.intercom.android.sdk.models.Form;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.Source;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;

public class Part
implements Parcelable {
    public static final String POST_MESSAGE_STYLE = "post";
    public static final String NOTE_MESSAGE_STYLE = "note";
    public static final String QUICK_REPLY_STYLE = "quick_reply";
    public static final String ATTRIBUTE_COLLECTOR_STYLE = "attribute_collector";
    public static final String LEGACY_ANNOUNCEMENT_STYLE = "announcement";
    public static final String LEGACY_SMALL_ANNOUNCEMENT_STYLE = "small-announcement";
    public static final String CHAT_MESSAGE_STYLE = "chat";
    public static final String TICKET_UPDATED_MESSAGE_STYLE = "ticket_state_updated";
    public static final String PARTICIPANT_ADDED_MESSAGE_STYLE = "participant_added";
    public static final String BIG_TICKET_STYLE = "big_ticket";
    public static final String ADMIN_IS_TYPING_STYLE = "admin_is_typing_style";
    public static final String DAY_DIVIDER_STYLE = "day_divider_style";
    public static final String LOADING_LAYOUT = "loading_layout_style";
    public static final String TEMPORARY_EXPECTATIONS_LAYOUT = "temporary_expectations_style";
    public static final String COMPOSER_SUGGESTIONS_STYLE = "composer_suggestions_style";
    public static final String TEAM_PRESENCE_STYLE = "team_presence_style";
    public static final String FIN_ANSWER_STYLE = "fin_answer";
    private final String id;
    private final List<Attachments> attachments;
    private final String summary;
    private final ReactionReply reactionReply;
    private final boolean isInitialMessage;
    private final long createdAt;
    private final boolean participantIsAdmin;
    private final String messageStyle;
    private final DeliveryOption deliveryOption;
    private final List<Block> blocks;
    private final EventData eventData;
    private final List<ReplyOption> replyOptions;
    private final Form form;
    private String clientAssignedUuid;
    private final List<Source> sources;
    private final AiAnswerInfo aiAnswerInfo;
    private String participantId;
    private String seenByAdmin;
    private Conversation parentConversation;
    private MessageState messageState;
    private Participant participant;
    private boolean displayDelivered;
    private boolean entranceAnimation;
    private ComposerSuggestions composerSuggestions;
    @Nullable
    private AiMood aiMood;
    public static final Part NULL = new Part(new Builder());
    public static final Parcelable.Creator<Part> CREATOR = new Parcelable.Creator<Part>(){

        public Part createFromParcel(Parcel in) {
            return new Part(in);
        }

        public Part[] newArray(int size) {
            return new Part[size];
        }
    };

    public Part() {
        this(new Builder());
    }

    private Part(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID().toString() : builder.id;
        this.participantId = NullSafety.valueOrEmpty(builder.participant_id);
        this.participantIsAdmin = builder.participant_is_admin;
        this.summary = NullSafety.valueOrEmpty(builder.summary);
        this.createdAt = builder.created_at;
        this.messageStyle = Part.convertLegacyMessageStyle(builder.message_style);
        this.deliveryOption = Part.convertDeliveryOption(builder.delivery_option);
        this.blocks = new ArrayList<Block>();
        if (builder.body != null) {
            for (Block.Builder blockBuilder : builder.body) {
                this.blocks.add(blockBuilder.build());
            }
        }
        this.reactionReply = builder.reactions_reply == null ? ReactionReply.NULL : builder.reactions_reply.build();
        this.seenByAdmin = builder.seen_by_admin == null ? "hide" : builder.seen_by_admin;
        this.attachments = new ArrayList<Attachments>();
        if (builder.attachments != null) {
            for (Attachments.Builder attachmentBuilder : builder.attachments) {
                this.attachments.add(attachmentBuilder.build());
            }
        }
        this.eventData = builder.event_data == null ? EventData.NULL : builder.event_data.build();
        this.parentConversation = new Conversation();
        this.participant = Participant.NULL;
        this.displayDelivered = false;
        this.entranceAnimation = false;
        this.isInitialMessage = builder.is_initial_message;
        this.messageState = MessageState.NORMAL;
        this.replyOptions = new ArrayList<ReplyOption>();
        if (builder.reply_options != null) {
            for (ReplyOption.Builder option : builder.reply_options) {
                this.replyOptions.add(option.build());
            }
        }
        this.form = builder.form == null ? new Form("", Collections.emptyList()) : builder.form;
        this.composerSuggestions = builder.composer_suggestions == null ? ComposerSuggestions.NULL : builder.composer_suggestions.build();
        this.clientAssignedUuid = NullSafety.valueOrEmpty(builder.client_assigned_uuid);
        this.sources = new ArrayList<Source>();
        if (builder.sources != null) {
            this.sources.addAll(builder.sources);
        }
        this.aiAnswerInfo = builder.ai_answer_info == null ? new AiAnswerInfo("", "") : builder.ai_answer_info;
        this.aiMood = builder.mood;
    }

    private Part(String id2, List<Attachments> attachments, String summary, ReactionReply reactionReply, boolean isInitialMessage, long createdAt, boolean participantIsAdmin, String messageStyle, DeliveryOption deliveryOption, List<Block> blocks, EventData eventData, List<ReplyOption> replyOptions, Form form, String clientAssignedUuid, List<Source> sources, AiAnswerInfo aiAnswerInfo, String participantId, String seenByAdmin, Conversation parentConversation, MessageState messageState, Participant participant, boolean displayDelivered, boolean entranceAnimation, ComposerSuggestions composerSuggestions, @Nullable AiMood aiMood) {
        this.id = id2;
        this.attachments = attachments;
        this.summary = summary;
        this.reactionReply = reactionReply;
        this.isInitialMessage = isInitialMessage;
        this.createdAt = createdAt;
        this.participantIsAdmin = participantIsAdmin;
        this.messageStyle = messageStyle;
        this.deliveryOption = deliveryOption;
        this.blocks = blocks;
        this.eventData = eventData;
        this.replyOptions = replyOptions;
        this.form = form;
        this.clientAssignedUuid = clientAssignedUuid;
        this.sources = sources;
        this.aiAnswerInfo = aiAnswerInfo;
        this.participantId = participantId;
        this.seenByAdmin = seenByAdmin;
        this.parentConversation = parentConversation;
        this.messageState = messageState;
        this.participant = participant;
        this.displayDelivered = displayDelivered;
        this.entranceAnimation = entranceAnimation;
        this.composerSuggestions = composerSuggestions;
        this.aiMood = aiMood;
    }

    private static DeliveryOption convertDeliveryOption(@Nullable String option) {
        if (option == null) {
            return DeliveryOption.SUMMARY;
        }
        try {
            return DeliveryOption.valueOf(option.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return DeliveryOption.SUMMARY;
        }
    }

    public DeliveryOption getDeliveryOption() {
        return this.deliveryOption;
    }

    public String getId() {
        return this.id;
    }

    public String getParticipantId() {
        return this.participantId;
    }

    public boolean isAdmin() {
        return this.participantIsAdmin;
    }

    public boolean isUser() {
        return !this.isAdmin();
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Attachments> getAttachments() {
        return this.attachments;
    }

    public List<ReplyOption> getReplyOptions() {
        return this.replyOptions;
    }

    public Form getForm() {
        return this.form;
    }

    public List<Source> getSources() {
        return this.sources;
    }

    public AiAnswerInfo getAiAnswerInfo() {
        return this.aiAnswerInfo;
    }

    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    public String getMessageStyle() {
        return this.messageStyle;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getSummary() {
        return this.summary;
    }

    public ReactionReply getReactionReply() {
        return this.reactionReply;
    }

    public String getSeenByAdmin() {
        return this.participantIsAdmin ? "hide" : this.seenByAdmin;
    }

    @Nullable
    public AiMood getAiMood() {
        return this.aiMood;
    }

    public void setSeenByAdmin(String seenByAdmin) {
        this.seenByAdmin = seenByAdmin;
    }

    public Participant getParticipant() {
        return this.participant;
    }

    public void setParticipant(Participant participant) {
        this.participant = participant;
        this.participantId = participant.getId();
    }

    @Deprecated(message="This was added for use in tickets. With conversation rewrite, we should use {@link ContentRow.MessageRow.PartWrapper )} instead to add in data that we require from the parent conversation object.")
    public Conversation getParentConversation() {
        return this.parentConversation;
    }

    public void setParentConversation(Conversation conversation) {
        this.parentConversation = conversation;
    }

    public boolean isDisplayDelivered() {
        return this.displayDelivered;
    }

    public void setDisplayDelivered(boolean displayDelivered) {
        this.displayDelivered = displayDelivered;
    }

    public boolean hasEntranceAnimation() {
        return this.entranceAnimation;
    }

    public void setEntranceAnimation(boolean entranceAnimation) {
        this.entranceAnimation = entranceAnimation;
    }

    public MessageState getMessageState() {
        return this.messageState;
    }

    public void setMessageState(MessageState messageState) {
        this.messageState = messageState;
    }

    public boolean isInitialMessage() {
        return this.isInitialMessage;
    }

    public boolean isReply() {
        return !this.isInitialMessage;
    }

    public ComposerSuggestions getComposerSuggestions() {
        return this.composerSuggestions;
    }

    public void setComposerSuggestions(ComposerSuggestions composerSuggestions) {
        this.composerSuggestions = composerSuggestions;
    }

    public String getUuid() {
        return this.clientAssignedUuid;
    }

    public EventData getEventData() {
        return this.eventData;
    }

    public Boolean isEvent() {
        return !this.eventData.getEventAsPlainText().isEmpty();
    }

    public Boolean isQuickReplyOnly() {
        return this.replyOptions.size() > 0 && this.blocks.size() == 0;
    }

    static String convertLegacyMessageStyle(@Nullable String legacyStyle) {
        if (LEGACY_ANNOUNCEMENT_STYLE.equals(legacyStyle)) {
            return POST_MESSAGE_STYLE;
        }
        if (LEGACY_SMALL_ANNOUNCEMENT_STYLE.equals(legacyStyle)) {
            return NOTE_MESSAGE_STYLE;
        }
        if (ADMIN_IS_TYPING_STYLE.equals(legacyStyle)) {
            return ADMIN_IS_TYPING_STYLE;
        }
        if (DAY_DIVIDER_STYLE.equals(legacyStyle)) {
            return DAY_DIVIDER_STYLE;
        }
        if (LOADING_LAYOUT.equals(legacyStyle)) {
            return LOADING_LAYOUT;
        }
        if (QUICK_REPLY_STYLE.equals(legacyStyle)) {
            return QUICK_REPLY_STYLE;
        }
        if (ATTRIBUTE_COLLECTOR_STYLE.equals(legacyStyle)) {
            return ATTRIBUTE_COLLECTOR_STYLE;
        }
        if (COMPOSER_SUGGESTIONS_STYLE.equals(legacyStyle)) {
            return COMPOSER_SUGGESTIONS_STYLE;
        }
        if (TEMPORARY_EXPECTATIONS_LAYOUT.equals(legacyStyle)) {
            return TEMPORARY_EXPECTATIONS_LAYOUT;
        }
        if (TICKET_UPDATED_MESSAGE_STYLE.equals(legacyStyle)) {
            return TICKET_UPDATED_MESSAGE_STYLE;
        }
        if (BIG_TICKET_STYLE.equals(legacyStyle)) {
            return BIG_TICKET_STYLE;
        }
        if (TEAM_PRESENCE_STYLE.equals(legacyStyle)) {
            return TEAM_PRESENCE_STYLE;
        }
        if (FIN_ANSWER_STYLE.equals(legacyStyle)) {
            return FIN_ANSWER_STYLE;
        }
        return CHAT_MESSAGE_STYLE;
    }

    private Part(Parcel in) {
        this.id = in.readString();
        this.participantId = in.readString();
        this.participantIsAdmin = in.readByte() != 0;
        this.blocks = new ArrayList<Block>();
        in.readList(this.blocks, Block.class.getClassLoader());
        this.attachments = new ArrayList<Attachments>();
        in.readList(this.attachments, Attachments.class.getClassLoader());
        this.replyOptions = new ArrayList<ReplyOption>();
        in.readList(this.replyOptions, ReplyOption.class.getClassLoader());
        this.messageStyle = in.readString();
        this.createdAt = in.readLong();
        this.summary = in.readString();
        boolean isNullReaction = in.readByte() == 0;
        this.reactionReply = isNullReaction ? ReactionReply.NULL : (ReactionReply)in.readValue(ReactionReply.class.getClassLoader());
        this.seenByAdmin = in.readString();
        this.participant = (Participant)in.readValue(Participant.class.getClassLoader());
        this.eventData = (EventData)in.readValue(EventData.class.getClassLoader());
        this.isInitialMessage = in.readByte() != 0;
        this.deliveryOption = Part.convertDeliveryOption(in.readString());
        this.form = (Form)in.readValue(Form.class.getClassLoader());
        this.composerSuggestions = (ComposerSuggestions)in.readValue(ComposerSuggestions.class.getClassLoader());
        this.sources = new ArrayList<Source>();
        in.readList(this.sources, Source.class.getClassLoader());
        this.aiAnswerInfo = (AiAnswerInfo)in.readValue(AiAnswerInfo.class.getClassLoader());
        int aiMoodOrdinal = in.readInt();
        this.aiMood = aiMoodOrdinal == -1 ? null : AiMood.values()[aiMoodOrdinal];
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.participantId);
        dest.writeByte((byte)(this.participantIsAdmin ? 1 : 0));
        dest.writeList(this.blocks);
        dest.writeList(this.attachments);
        dest.writeList(this.replyOptions);
        dest.writeString(this.messageStyle);
        dest.writeLong(this.createdAt);
        dest.writeString(this.summary);
        if (ReactionReply.isNull(this.reactionReply)) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeValue((Object)this.reactionReply);
        }
        dest.writeString(this.seenByAdmin);
        dest.writeValue((Object)this.participant);
        dest.writeValue((Object)this.eventData);
        dest.writeByte((byte)(this.isInitialMessage ? 1 : 0));
        dest.writeString(this.deliveryOption.name());
        dest.writeValue((Object)this.form);
        dest.writeValue((Object)this.composerSuggestions);
        dest.writeList(this.sources);
        dest.writeValue((Object)this.aiAnswerInfo);
        dest.writeInt(this.aiMood != null ? this.aiMood.ordinal() : -1);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof Part) {
            Part otherPart = (Part)o;
            return (this.id.equals(otherPart.id) && this.form.equals(otherPart.form) || !this.clientAssignedUuid.equals("") && this.clientAssignedUuid.equals(otherPart.clientAssignedUuid)) && this.seenByAdmin.equals(otherPart.seenByAdmin);
        }
        return false;
    }

    public static boolean shouldConcatenate(Part part, Part nextPart) {
        if (DAY_DIVIDER_STYLE.equals(part.getMessageStyle()) || part.isLinkCard() || part.isEvent().booleanValue() || nextPart.isEvent().booleanValue() || nextPart.isQuickReplyOnly().booleanValue()) {
            return false;
        }
        long timeDifference = Math.abs(nextPart.getCreatedAt() - part.getCreatedAt());
        return timeDifference < TimeUnit.MINUTES.toSeconds(3L) && Part.nextPartFromSameParticipant(part, nextPart) && nextPart.getCreatedAt() != 0L;
    }

    private static boolean nextPartFromSameParticipant(Part part, Part nextPart) {
        return part.getParticipantId().equals(nextPart.getParticipantId());
    }

    public boolean isMessagePart() {
        return POST_MESSAGE_STYLE.equals(this.messageStyle) || NOTE_MESSAGE_STYLE.equals(this.messageStyle) || CHAT_MESSAGE_STYLE.equals(this.messageStyle);
    }

    public boolean isLinkCard() {
        return this.isSingleBlockPartOfType(BlockType.LINK) && CHAT_MESSAGE_STYLE.equals(this.messageStyle);
    }

    public boolean isLinkList() {
        return this.isSingleBlockPartOfType(BlockType.LINKLIST) && CHAT_MESSAGE_STYLE.equals(this.messageStyle);
    }

    public boolean isSingleBlockPartOfType(BlockType type) {
        return this.blocks.size() == 1 && this.blocks.get(0).getType() == type;
    }

    public Block getLinkBlock() {
        return this.blocks.get(0);
    }

    public boolean isGifOnlyPart() {
        return this.blocks.size() == 1 && !TextUtils.isEmpty((CharSequence)this.blocks.get(0).getAttribution());
    }

    public boolean isSendingPart() {
        return this.getMessageState().equals((Object)MessageState.SENDING);
    }

    public Part withSeenByAdmin(String seenByAdmin) {
        return new Part(this.id, this.attachments, this.summary, this.reactionReply, this.isInitialMessage, this.createdAt, this.participantIsAdmin, this.messageStyle, this.deliveryOption, this.blocks, this.eventData, this.replyOptions, this.form, this.clientAssignedUuid, this.sources, this.aiAnswerInfo, this.participantId, seenByAdmin, this.parentConversation, this.messageState, this.participant, this.displayDelivered, this.entranceAnimation, this.composerSuggestions, this.aiMood);
    }

    public static final class Builder {
        @Nullable
        String id;
        @Nullable
        String participant_id;
        @Nullable
        List<Block.Builder> body;
        @Nullable
        List<Attachments.Builder> attachments;
        @Nullable
        String message_style;
        @Nullable
        String summary;
        @Nullable
        ReactionReply.Builder reactions_reply;
        @Nullable
        String delivery_option;
        @Nullable
        String seen_by_admin;
        @Nullable
        EventData.Builder event_data;
        @Nullable
        List<ReplyOption.Builder> reply_options;
        @Nullable
        Form form;
        @Nullable
        ComposerSuggestions.Builder composer_suggestions;
        @Nullable
        String client_assigned_uuid;
        @Nullable
        List<Source> sources;
        @Nullable
        AiAnswerInfo ai_answer_info;
        boolean participant_is_admin;
        long created_at;
        boolean is_initial_message;
        @Nullable
        AiMood mood;

        public Builder withId(String partId) {
            this.id = partId;
            return this;
        }

        public Builder withIsInitialMessage(Boolean isInitialMessage) {
            this.is_initial_message = isInitialMessage;
            return this;
        }

        public Builder withEventData(EventData.Builder eventData) {
            this.event_data = eventData;
            return this;
        }

        public Builder withStyle(String style2) {
            this.message_style = style2;
            return this;
        }

        public Builder withSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder withCreatedAt(long createdAt) {
            this.created_at = createdAt;
            return this;
        }

        public Builder withParticipantIsAdmin(boolean participantIsAdmin) {
            this.participant_is_admin = participantIsAdmin;
            return this;
        }

        public Builder withBlocks(List<Block.Builder> blocks) {
            this.body = blocks;
            return this;
        }

        public Builder withReplyOptions(List<ReplyOption.Builder> replyOptions) {
            this.reply_options = replyOptions;
            return this;
        }

        public Builder withForm(Form form) {
            this.form = form;
            return this;
        }

        public Builder withSources(List<Source> sources) {
            this.sources = sources;
            return this;
        }

        public Builder withAiAnswerInfo(AiAnswerInfo aiAnswerInfo) {
            this.ai_answer_info = aiAnswerInfo;
            return this;
        }

        public Builder withComposerSuggestions(ComposerSuggestions.Builder composerSuggestions) {
            this.composer_suggestions = composerSuggestions;
            return this;
        }

        public Builder withClientAssignedUuid(String clientAssignedUuid) {
            this.client_assigned_uuid = clientAssignedUuid;
            return this;
        }

        public Builder withAttachments(List<Attachments.Builder> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder withAiMood(AiMood aiMood) {
            this.mood = aiMood;
            return this;
        }

        public Part build() {
            return new Part(this);
        }
    }

    public static enum DeliveryOption {
        FULL,
        SUMMARY,
        BADGE;

    }

    public static enum MessageState {
        SENDING,
        FAILED,
        UPLOAD_FAILED,
        NORMAL;

    }
}

