/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.tickets;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.ErrorState;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.tickets.TicketDetailReducerKt;
import io.intercom.android.sdk.tickets.TicketDetailState;
import io.intercom.android.sdk.tickets.TicketDetailViewModel;
import io.intercom.android.sdk.tickets.TicketLaunchedFrom;
import io.intercom.android.sdk.tickets.create.data.TicketRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020 H\u0014R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/intercom/android/sdk/tickets/TicketDetailViewModel;", "Landroidx/lifecycle/ViewModel;", "launchedFrom", "Lio/intercom/android/sdk/tickets/TicketLaunchedFrom;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "user", "Lio/intercom/android/sdk/identity/UserIdentity;", "bus", "Lcom/squareup/otto/Bus;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "repository", "Lio/intercom/android/sdk/tickets/create/data/TicketRepository;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lio/intercom/android/sdk/tickets/TicketLaunchedFrom;Lio/intercom/android/sdk/models/TeamPresence;Lio/intercom/android/sdk/identity/UserIdentity;Lcom/squareup/otto/Bus;Lio/intercom/android/sdk/metrics/MetricTracker;Lio/intercom/android/sdk/tickets/create/data/TicketRepository;Lkotlinx/coroutines/CoroutineDispatcher;)V", "_stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/tickets/TicketDetailState;", "activeAdminsAvatars", "", "Lio/intercom/android/sdk/m5/components/avatar/AvatarWrapper;", "getActiveAdminsAvatars", "()Ljava/util/List;", "stateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "ticket", "Lio/intercom/android/sdk/models/Ticket;", "conversationSuccess", "", "event", "Lio/intercom/android/sdk/models/events/ConversationEvent;", "fetchTicketDetail", "ticketId", "", "onCleared", "Companion", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nTicketDetailViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TicketDetailViewModel.kt\nio/intercom/android/sdk/tickets/TicketDetailViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1549#2:118\n1620#2,3:119\n*S KotlinDebug\n*F\n+ 1 TicketDetailViewModel.kt\nio/intercom/android/sdk/tickets/TicketDetailViewModel\n*L\n47#1:118\n47#1:119,3\n*E\n"})
public final class TicketDetailViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TicketLaunchedFrom launchedFrom;
    @NotNull
    private final TeamPresence teamPresence;
    @NotNull
    private final UserIdentity user;
    @NotNull
    private final Bus bus;
    @NotNull
    private final MetricTracker metricTracker;
    @NotNull
    private final TicketRepository repository;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @Nullable
    private Ticket ticket;
    @NotNull
    private final MutableStateFlow<TicketDetailState> _stateFlow;
    @NotNull
    private final StateFlow<TicketDetailState> stateFlow;

    public TicketDetailViewModel(@NotNull TicketLaunchedFrom launchedFrom, @NotNull TeamPresence teamPresence, @NotNull UserIdentity user, @NotNull Bus bus, @NotNull MetricTracker metricTracker, @NotNull TicketRepository repository, @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkNotNullParameter((Object)launchedFrom, (String)"launchedFrom");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        this.launchedFrom = launchedFrom;
        this.teamPresence = teamPresence;
        this.user = user;
        this.bus = bus;
        this.metricTracker = metricTracker;
        this.repository = repository;
        this.dispatcher = dispatcher;
        this._stateFlow = StateFlowKt.MutableStateFlow((Object)TicketDetailState.Initial.INSTANCE);
        this.stateFlow = (StateFlow)this._stateFlow;
        this.bus.register((Object)this);
        TicketLaunchedFrom ticketLaunchedFrom = this.launchedFrom;
        if (ticketLaunchedFrom instanceof TicketLaunchedFrom.Conversation) {
            Ticket it = ((TicketLaunchedFrom.Conversation)this.launchedFrom).getTicket();
            boolean bl = false;
            this.ticket = it;
            this._stateFlow.setValue((Object)TicketDetailReducerKt.computeTicketViewState(it, this.user, this.getActiveAdminsAvatars(), this.launchedFrom));
            Integer n = it.getTicketTypeId();
            String string2 = it.getConversationId();
            if (string2 == null) {
                string2 = "";
            }
            this.metricTracker.viewedTicketDetails(n, string2, it.getCurrentStatus().getType());
        } else if (ticketLaunchedFrom instanceof TicketLaunchedFrom.TicketsList) {
            this.fetchTicketDetail(((TicketLaunchedFrom.TicketsList)this.launchedFrom).getTicketId());
        }
    }

    public /* synthetic */ TicketDetailViewModel(TicketLaunchedFrom ticketLaunchedFrom, TeamPresence teamPresence, UserIdentity userIdentity, Bus bus, MetricTracker metricTracker, TicketRepository ticketRepository, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            TeamPresence teamPresence2 = Injector.get().getStore().state().teamPresence();
            Intrinsics.checkNotNullExpressionValue((Object)teamPresence2, (String)"get().store.state().teamPresence()");
            teamPresence = teamPresence2;
        }
        if ((n & 4) != 0) {
            UserIdentity userIdentity2 = Injector.get().getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity2, (String)"get().userIdentity");
            userIdentity = userIdentity2;
        }
        if ((n & 8) != 0) {
            Bus bus2 = Injector.get().getBus();
            Intrinsics.checkNotNullExpressionValue((Object)bus2, (String)"get().bus");
            bus = bus2;
        }
        if ((n & 0x10) != 0) {
            MetricTracker metricTracker2 = Injector.get().getMetricTracker();
            Intrinsics.checkNotNullExpressionValue((Object)metricTracker2, (String)"get().metricTracker");
            metricTracker = metricTracker2;
        }
        if ((n & 0x20) != 0) {
            ticketRepository = new TicketRepository(null, null, null, null, 15, null);
        }
        if ((n & 0x40) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        this(ticketLaunchedFrom, teamPresence, userIdentity, bus, metricTracker, ticketRepository, coroutineDispatcher);
    }

    @NotNull
    public final StateFlow<TicketDetailState> getStateFlow() {
        return this.stateFlow;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AvatarWrapper> getActiveAdminsAvatars() {
        void $this$mapTo$iv$iv;
        List<Participant> list = this.teamPresence.getActiveAdmins();
        Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence.activeAdmins");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Participant participant = (Participant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Avatar avatar = it.getAvatar();
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"it.avatar");
            Boolean bl2 = it.isBot();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.isBot");
            collection.add(new AvatarWrapper(avatar, bl2, null, false, false, 28, null));
        }
        return (List)destination$iv$iv;
    }

    private final void fetchTicketDetail(String ticketId) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, ticketId, null){
            Object L$0;
            int label;
            final /* synthetic */ TicketDetailViewModel this$0;
            final /* synthetic */ String $ticketId;
            {
                this.this$0 = $receiver;
                this.$ticketId = $ticketId;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        TicketDetailViewModel.access$get_stateFlow$p(this.this$0).setValue((Object)TicketDetailState.Loading.INSTANCE);
                        var3_3 = TicketDetailViewModel.access$get_stateFlow$p(this.this$0);
                        this.L$0 = var3_3;
                        this.label = 1;
                        v0 = TicketDetailViewModel.access$getRepository$p(this.this$0).fetchTicketDetail(this.$ticketId, (Continuation<? super NetworkResponse<Ticket>>)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        var3_3 = (MutableStateFlow)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if ((response = (NetworkResponse)v0) instanceof NetworkResponse.ClientError != false ? true : response instanceof NetworkResponse.ServerError) {
                            v1 = new TicketDetailState.Error(new ErrorState.WithoutCTA(0, 0, null, 7, null));
                        } else if (response instanceof NetworkResponse.NetworkError) {
                            v1 = new TicketDetailState.Error(new ErrorState.WithCTA(0, 0, null, 0, (Function0)new Function0<Unit>(this.this$0, this.$ticketId){
                                final /* synthetic */ TicketDetailViewModel this$0;
                                final /* synthetic */ String $ticketId;
                                {
                                    this.this$0 = $receiver;
                                    this.$ticketId = $ticketId;
                                    super(0);
                                }

                                public final void invoke() {
                                    TicketDetailViewModel.access$fetchTicketDetail(this.this$0, this.$ticketId);
                                }
                            }, 15, null));
                        } else if (response instanceof NetworkResponse.Success) {
                            v1 = TicketDetailReducerKt.computeTicketViewState((Ticket)((NetworkResponse.Success)response).getBody(), TicketDetailViewModel.access$getUser$p(this.this$0), TicketDetailViewModel.access$getActiveAdminsAvatars(this.this$0), TicketDetailViewModel.access$getLaunchedFrom$p(this.this$0));
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        var3_3.setValue((Object)v1);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Subscribe
    public final void conversationSuccess(@NotNull ConversationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Ticket ticket = this.ticket;
        if (Intrinsics.areEqual((Object)event.getResponse().getId(), (Object)(ticket != null ? ticket.getConversationId() : null))) {
            Ticket ticket2 = event.getResponse().getTicket();
            Intrinsics.checkNotNullExpressionValue((Object)ticket2, (String)"event.response.ticket");
            this._stateFlow.setValue((Object)TicketDetailReducerKt.computeTicketViewState(ticket2, this.user, this.getActiveAdminsAvatars(), this.launchedFrom));
        }
    }

    protected void onCleared() {
        super.onCleared();
        this.bus.unregister((Object)this);
    }

    public static final /* synthetic */ MutableStateFlow access$get_stateFlow$p(TicketDetailViewModel $this) {
        return $this._stateFlow;
    }

    public static final /* synthetic */ TicketRepository access$getRepository$p(TicketDetailViewModel $this) {
        return $this.repository;
    }

    public static final /* synthetic */ void access$fetchTicketDetail(TicketDetailViewModel $this, String ticketId) {
        $this.fetchTicketDetail(ticketId);
    }

    public static final /* synthetic */ UserIdentity access$getUser$p(TicketDetailViewModel $this) {
        return $this.user;
    }

    public static final /* synthetic */ List access$getActiveAdminsAvatars(TicketDetailViewModel $this) {
        return $this.getActiveAdminsAvatars();
    }

    public static final /* synthetic */ TicketLaunchedFrom access$getLaunchedFrom$p(TicketDetailViewModel $this) {
        return $this.launchedFrom;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/intercom/android/sdk/tickets/TicketDetailViewModel$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/tickets/TicketDetailViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "launchedFrom", "Lio/intercom/android/sdk/tickets/TicketLaunchedFrom;", "factory", "io/intercom/android/sdk/tickets/TicketDetailViewModel$Companion$factory$1", "(Lio/intercom/android/sdk/tickets/TicketLaunchedFrom;)Lio/intercom/android/sdk/tickets/TicketDetailViewModel$Companion$factory$1;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TicketDetailViewModel create(@NotNull ViewModelStoreOwner owner, @NotNull TicketLaunchedFrom launchedFrom) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)launchedFrom, (String)"launchedFrom");
            return (TicketDetailViewModel)new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory(launchedFrom)).get(TicketDetailViewModel.class);
        }

        private final factory.1 factory(TicketLaunchedFrom launchedFrom) {
            return new ViewModelProvider.Factory(launchedFrom){
                final /* synthetic */ TicketLaunchedFrom $launchedFrom;
                {
                    this.$launchedFrom = $launchedFrom;
                }

                @NotNull
                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    return (T)((Object)new TicketDetailViewModel(this.$launchedFrom, null, null, null, null, null, null, 126, null));
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

