/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.annotation.TargetApi;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.compose.runtime.internal.StabilityInferred;
import coil.request.ImageRequest;
import coil.transform.CircleCropTransformation;
import coil.transform.Transformation;
import com.intercom.commons.utilities.ScreenUtils;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.push.PushAvatarUtils;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.push.SystemNotificationFactory;
import io.intercom.android.sdk.utilities.BitmapUtilsKt;
import io.intercom.android.sdk.utilities.IntercomCoilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0013J \u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019JZ\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192:\u0010\u001f\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b(#\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b!\u0012\b\b\"\u0012\u0004\b\b($\u0012\u0004\u0012\u00020\u00130 J \u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u000e\u0010'\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lio/intercom/android/sdk/push/SystemNotificationManager;", "", "androidNotificationManager", "Landroid/app/NotificationManager;", "(Landroid/app/NotificationManager;)V", "systemNotificationFactory", "Lio/intercom/android/sdk/push/SystemNotificationFactory;", "(Landroid/app/NotificationManager;Lio/intercom/android/sdk/push/SystemNotificationFactory;)V", "receivedPayloads", "", "Lio/intercom/android/sdk/push/PushPayload;", "getReceivedPayloads$annotations", "()V", "getReceivedPayloads", "()Ljava/util/List;", "twig", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "clear", "", "createNotification", "payload", "context", "Landroid/content/Context;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "createPushOnlyNotification", "deleteNotificationChannels", "downloadContentImage", "Landroid/graphics/Bitmap;", "downloadImages", "onComplete", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "avatar", "content", "generateAvatar", "setUpNotificationChannels", "setUpNotificationChannelsIfSupported", "Companion", "intercom-sdk-base_release"})
@StabilityInferred(parameters=0)
public final class SystemNotificationManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotificationManager androidNotificationManager;
    @NotNull
    private final SystemNotificationFactory systemNotificationFactory;
    @NotNull
    private final List<PushPayload> receivedPayloads;
    private final Twig twig;
    public static final int $stable = 8;
    private static final int NOTIFICATION_ID = 9999997;
    private static final float LARGE_ICON_SIZE_IN_DP = 48.0f;
    @NotNull
    public static final String CHAT_REPLIES_CHANNEL = "intercom_chat_replies_channel";
    @NotNull
    public static final String NEW_CHATS_CHANNEL = "intercom_new_chats_channel";
    @NotNull
    public static final String ACTIONS_CHANNEL = "intercom_actions_channel";

    @VisibleForTesting
    public SystemNotificationManager(@NotNull NotificationManager androidNotificationManager, @NotNull SystemNotificationFactory systemNotificationFactory) {
        Intrinsics.checkNotNullParameter((Object)androidNotificationManager, (String)"androidNotificationManager");
        Intrinsics.checkNotNullParameter((Object)systemNotificationFactory, (String)"systemNotificationFactory");
        this.androidNotificationManager = androidNotificationManager;
        this.systemNotificationFactory = systemNotificationFactory;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(ArrayList())");
        this.receivedPayloads = list;
        this.twig = LumberMill.getLogger();
    }

    @NotNull
    public final List<PushPayload> getReceivedPayloads() {
        return this.receivedPayloads;
    }

    @VisibleForTesting
    public static /* synthetic */ void getReceivedPayloads$annotations() {
    }

    public SystemNotificationManager(@NotNull NotificationManager androidNotificationManager) {
        Intrinsics.checkNotNullParameter((Object)androidNotificationManager, (String)"androidNotificationManager");
        this(androidNotificationManager, new SystemNotificationFactory());
    }

    public final void setUpNotificationChannelsIfSupported(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 26) {
            this.setUpNotificationChannels(context);
        }
    }

    public final void deleteNotificationChannels() {
        if (Build.VERSION.SDK_INT >= 26) {
            this.androidNotificationManager.deleteNotificationChannel(CHAT_REPLIES_CHANNEL);
            this.androidNotificationManager.deleteNotificationChannel(NEW_CHATS_CHANNEL);
            this.androidNotificationManager.deleteNotificationChannel(ACTIONS_CHANNEL);
        }
    }

    @TargetApi(value=26)
    private final void setUpNotificationChannels(Context context) {
        NotificationChannel replies = new NotificationChannel(CHAT_REPLIES_CHANNEL, (CharSequence)context.getString(R.string.intercom_notification_channel_chat_replies_title), 4);
        replies.setDescription(context.getString(R.string.intercom_notification_channel_chat_replies_description));
        NotificationChannel newChats = new NotificationChannel(NEW_CHATS_CHANNEL, (CharSequence)context.getString(R.string.intercom_notification_channel_new_chats_title), 4);
        newChats.setDescription(context.getString(R.string.intercom_notification_channel_new_chats_description));
        NotificationChannel actions = new NotificationChannel(ACTIONS_CHANNEL, (CharSequence)context.getString(R.string.intercom_notification_channel_actions_title), 4);
        actions.setDescription(context.getString(R.string.intercom_notification_channel_actions_description));
        Object[] objectArray = new NotificationChannel[]{replies, newChats, actions};
        this.androidNotificationManager.createNotificationChannels(CollectionsKt.listOf((Object[])objectArray));
    }

    public final void clear() {
        if (!((Collection)this.receivedPayloads).isEmpty()) {
            this.twig.i("Removing Intercom push notifications.", new Object[0]);
        }
        this.androidNotificationManager.cancel(9999997);
        this.receivedPayloads.clear();
    }

    public final void createPushOnlyNotification(@NotNull PushPayload payload, @NotNull Context context, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        this.downloadImages(payload, context, appConfig, (Function2<? super Bitmap, ? super Bitmap, Unit>)((Function2)new Function2<Bitmap, Bitmap, Unit>(this, payload, context, appConfig){
            final /* synthetic */ SystemNotificationManager this$0;
            final /* synthetic */ PushPayload $payload;
            final /* synthetic */ Context $context;
            final /* synthetic */ AppConfig $appConfig;
            {
                this.this$0 = $receiver;
                this.$payload = $payload;
                this.$context = $context;
                this.$appConfig = $appConfig;
                super(2);
            }

            public final void invoke(@Nullable Bitmap bitmap, @Nullable Bitmap contentImage) {
                Notification notification = SystemNotificationManager.access$getSystemNotificationFactory$p(this.this$0).createPushOnlyNotification(this.$payload, this.$context, this.$appConfig, contentImage);
                String pushOnlyConversationId = this.$payload.getPushOnlyConversationId();
                SystemNotificationManager.access$getAndroidNotificationManager$p(this.this$0).notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), notification);
            }
        }));
    }

    public final void createNotification(@NotNull PushPayload payload, @NotNull Context context, @NotNull AppConfig appConfig) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        if (this.receivedPayloads.contains(payload)) {
            return;
        }
        this.receivedPayloads.add(payload);
        if (this.receivedPayloads.size() == 1) {
            this.downloadImages(payload, context, appConfig, (Function2<? super Bitmap, ? super Bitmap, Unit>)((Function2)new Function2<Bitmap, Bitmap, Unit>(this, payload, context, appConfig){
                final /* synthetic */ SystemNotificationManager this$0;
                final /* synthetic */ PushPayload $payload;
                final /* synthetic */ Context $context;
                final /* synthetic */ AppConfig $appConfig;
                {
                    this.this$0 = $receiver;
                    this.$payload = $payload;
                    this.$context = $context;
                    this.$appConfig = $appConfig;
                    super(2);
                }

                public final void invoke(@Nullable Bitmap avatarImage, @Nullable Bitmap contentImage) {
                    Notification notification = SystemNotificationManager.access$getSystemNotificationFactory$p(this.this$0).createSingleNotification(this.$payload, this.$context, this.$appConfig, avatarImage, contentImage);
                    SystemNotificationManager.access$getAndroidNotificationManager$p(this.this$0).notify(9999997, notification);
                }
            }));
        } else {
            Notification notification = this.systemNotificationFactory.createGroupedNotification(this.receivedPayloads, context, appConfig);
            this.androidNotificationManager.notify(9999997, notification);
        }
    }

    public final void downloadImages(@NotNull PushPayload payload, @NotNull Context context, @NotNull AppConfig appConfig, @NotNull Function2<? super Bitmap, ? super Bitmap, Unit> onComplete) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter(onComplete, (String)"onComplete");
        Ref.ObjectRef contentImage = new Ref.ObjectRef();
        Ref.ObjectRef avatarImage = new Ref.ObjectRef();
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(onComplete, (Ref.ObjectRef<Bitmap>)avatarImage, (Ref.ObjectRef<Bitmap>)contentImage, this, payload, context, appConfig, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<Bitmap, Bitmap, Unit> $onComplete;
            final /* synthetic */ Ref.ObjectRef<Bitmap> $avatarImage;
            final /* synthetic */ Ref.ObjectRef<Bitmap> $contentImage;
            final /* synthetic */ SystemNotificationManager this$0;
            final /* synthetic */ PushPayload $payload;
            final /* synthetic */ Context $context;
            final /* synthetic */ AppConfig $appConfig;
            {
                this.$onComplete = $onComplete;
                this.$avatarImage = $avatarImage;
                this.$contentImage = $contentImage;
                this.this$0 = $receiver;
                this.$payload = $payload;
                this.$context = $context;
                this.$appConfig = $appConfig;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$launch = (CoroutineScope)this.L$0;
                        contentImageJob = BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$contentImage, this.this$0, this.$payload, this.$context, this.$appConfig, null){
                            int label;
                            final /* synthetic */ Ref.ObjectRef<Bitmap> $contentImage;
                            final /* synthetic */ SystemNotificationManager this$0;
                            final /* synthetic */ PushPayload $payload;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ AppConfig $appConfig;
                            {
                                this.$contentImage = $contentImage;
                                this.this$0 = $receiver;
                                this.$payload = $payload;
                                this.$context = $context;
                                this.$appConfig = $appConfig;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$contentImage.element = this.this$0.downloadContentImage(this.$payload, this.$context, this.$appConfig);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        avatarImageJob = BuildersKt.launch$default((CoroutineScope)$this$launch, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$avatarImage, this.this$0, this.$payload, this.$context, this.$appConfig, null){
                            int label;
                            final /* synthetic */ Ref.ObjectRef<Bitmap> $avatarImage;
                            final /* synthetic */ SystemNotificationManager this$0;
                            final /* synthetic */ PushPayload $payload;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ AppConfig $appConfig;
                            {
                                this.$avatarImage = $avatarImage;
                                this.this$0 = $receiver;
                                this.$payload = $payload;
                                this.$context = $context;
                                this.$appConfig = $appConfig;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.$avatarImage.element = this.this$0.generateAvatar(this.$payload, this.$context, this.$appConfig);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        this.L$0 = avatarImageJob;
                        this.label = 1;
                        v0 = contentImageJob.join((Continuation)this);
                        ** if (v0 != var5_2) goto lbl15
lbl14:
                        // 1 sources

                        return var5_2;
lbl15:
                        // 1 sources

                        ** GOTO lbl22
                    }
                    case 1: {
                        avatarImageJob = (Job)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl22:
                        // 2 sources

                        this.L$0 = null;
                        this.label = 2;
                        v1 = avatarImageJob.join((Continuation)this);
                        ** if (v1 != var5_2) goto lbl27
lbl26:
                        // 1 sources

                        return var5_2;
lbl27:
                        // 1 sources

                        ** GOTO lbl40
                    }
                    case 2: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                        }
                        catch (Throwable var3_5) {
                            throw var3_5;
                        }
                        finally {
                            this.$onComplete.invoke(this.$avatarImage.element, this.$contentImage.element);
                        }
lbl40:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value2;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Nullable
    public final Bitmap downloadContentImage(@NotNull PushPayload payload, @NotNull Context context, @NotNull AppConfig appConfig) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        int iconSize = ScreenUtils.dpToPx((float)48.0f, (Context)context);
        CharSequence charSequence = payload.getContentImageUrl();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            ImageRequest imageRequest = new ImageRequest.Builder(context).dispatcher(Dispatchers.getIO()).data((Object)payload.getContentImageUrl()).build();
            Drawable drawable2 = IntercomCoilKt.loadIntercomImageBlocking(context, imageRequest);
            if (drawable2 == null) {
                drawable2 = (Drawable)new BitmapDrawable(context.getResources(), PushAvatarUtils.getNotificationDefaultBitmap(context, appConfig));
            }
            Drawable drawable3 = drawable2;
            bitmap = BitmapUtilsKt.drawableToBitmap(drawable3, iconSize, iconSize);
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    @Nullable
    public final Bitmap generateAvatar(@NotNull PushPayload payload, @NotNull Context context, @NotNull AppConfig appConfig) {
        Bitmap bitmap;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        if (TextUtils.isEmpty((CharSequence)payload.getImageUrl()) && !TextUtils.isEmpty((CharSequence)payload.getAuthorName())) {
            bitmap = PushAvatarUtils.getNotificationInitialsBitmap(context, payload.getAuthorName(), appConfig);
        } else {
            Bitmap bitmap2;
            BitmapDrawable defaultDrawable = new BitmapDrawable(context.getResources(), PushAvatarUtils.getNotificationDefaultBitmap(context, appConfig));
            try {
                Drawable drawable2;
                int iconSize = ScreenUtils.dpToPx((float)48.0f, (Context)context);
                Transformation[] transformationArray = new Transformation[]{(Transformation)new CircleCropTransformation()};
                ImageRequest imageRequest = new ImageRequest.Builder(context).error((Drawable)defaultDrawable).transformations(transformationArray).data((Object)payload.getImageUrl()).dispatcher(Dispatchers.getIO()).size(iconSize, iconSize).build();
                Drawable drawable3 = drawable2 = IntercomCoilKt.loadIntercomImageBlocking(context, imageRequest);
                Intrinsics.checkNotNull((Object)drawable3);
                bitmap2 = BitmapUtilsKt.drawableToBitmap(drawable3, iconSize, iconSize);
            }
            catch (Exception e) {
                this.twig.d("Failed to retrieve the notification image", new Object[0]);
                bitmap2 = defaultDrawable.getBitmap();
            }
            bitmap = bitmap2;
        }
        return bitmap;
    }

    public static final /* synthetic */ SystemNotificationFactory access$getSystemNotificationFactory$p(SystemNotificationManager $this) {
        return $this.systemNotificationFactory;
    }

    public static final /* synthetic */ NotificationManager access$getAndroidNotificationManager$p(SystemNotificationManager $this) {
        return $this.androidNotificationManager;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/intercom/android/sdk/push/SystemNotificationManager$Companion;", "", "()V", "ACTIONS_CHANNEL", "", "CHAT_REPLIES_CHANNEL", "LARGE_ICON_SIZE_IN_DP", "", "NEW_CHATS_CHANNEL", "NOTIFICATION_ID", "", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

