/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.push;

import android.app.Notification;
import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.VisibleForTesting;
import androidx.core.app.NotificationChannelCompat;
import androidx.core.app.NotificationManagerCompat;
import androidx.core.app.Person;
import androidx.core.content.pm.ShortcutInfoCompat;
import com.intercom.commons.utilities.TimeProvider;
import com.intercom.twig.Twig;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.push.IntercomPushBitmapUtilsKt;
import io.intercom.android.sdk.m5.push.IntercomPushData;
import io.intercom.android.sdk.m5.push.NotificationChannel;
import io.intercom.android.sdk.m5.push.NotificationPermissionCheckerKt;
import io.intercom.android.sdk.m5.push.ui.ConversationShortcutKt;
import io.intercom.android.sdk.m5.push.ui.ConversationStylePushUIKt;
import io.intercom.android.sdk.m5.push.ui.DeepLinkStylePushUIKt;
import io.intercom.android.sdk.m5.push.ui.IntercomPushConversation;
import io.intercom.android.sdk.utilities.GroupConversationTextFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J8\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J1\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0018\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J'\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010#\u001a\u00020$2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b%J\u0015\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b'J<\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040)2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/intercom/android/sdk/m5/push/IntercomNotificationHandler;", "", "()V", "conversations", "", "Lio/intercom/android/sdk/m5/push/ui/IntercomPushConversation;", "getConversations$intercom_sdk_base_release$annotations", "getConversations$intercom_sdk_base_release", "()Ljava/util/List;", "setConversations$intercom_sdk_base_release", "(Ljava/util/List;)V", "twig", "Lcom/intercom/twig/Twig;", "kotlin.jvm.PlatformType", "clear", "", "context", "Landroid/content/Context;", "getOrCreateConversation", "conversationPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData$ConversationPushData;", "timestamp", "", "avatarBitmap", "Landroid/graphics/Bitmap;", "processConversationPushNotification", "isSilent", "", "timeProvider", "Lcom/intercom/commons/utilities/TimeProvider;", "processConversationPushNotification$intercom_sdk_base_release", "processDeepLinkPushNotification", "deepLinkPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData$DeepLinkPushData;", "processIntercomPushNotification", "intercomPushData", "Lio/intercom/android/sdk/m5/push/IntercomPushData;", "processIntercomPushNotification$intercom_sdk_base_release", "setUpNotificationChannels", "setUpNotificationChannels$intercom_sdk_base_release", "updateConversations", "Lkotlin/Pair;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nIntercomNotificationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntercomNotificationHandler.kt\nio/intercom/android/sdk/m5/push/IntercomNotificationHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1#2:253\n1#2:272\n1655#3,8:254\n1603#3,9:262\n1855#3:271\n1856#3:273\n1612#3:274\n*S KotlinDebug\n*F\n+ 1 IntercomNotificationHandler.kt\nio/intercom/android/sdk/m5/push/IntercomNotificationHandler\n*L\n215#1:272\n215#1:254,8\n215#1:262,9\n215#1:271\n215#1:273\n215#1:274\n*E\n"})
public final class IntercomNotificationHandler {
    @NotNull
    public static final IntercomNotificationHandler INSTANCE = new IntercomNotificationHandler();
    @NotNull
    private static List<IntercomPushConversation> conversations = CollectionsKt.emptyList();
    private static final Twig twig = LumberMill.getLogger();

    private IntercomNotificationHandler() {
    }

    @NotNull
    public final List<IntercomPushConversation> getConversations$intercom_sdk_base_release() {
        return conversations;
    }

    public final void setConversations$intercom_sdk_base_release(@NotNull List<IntercomPushConversation> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        conversations = list;
    }

    @VisibleForTesting
    public static /* synthetic */ void getConversations$intercom_sdk_base_release$annotations() {
    }

    public final void processIntercomPushNotification$intercom_sdk_base_release(@NotNull Context context, @NotNull IntercomPushData intercomPushData, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intercomPushData, (String)"intercomPushData");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        IntercomPushData intercomPushData2 = intercomPushData;
        if (intercomPushData2 instanceof IntercomPushData.DeepLinkPushData) {
            this.processDeepLinkPushNotification(context, (IntercomPushData.DeepLinkPushData)intercomPushData);
        } else if (intercomPushData2 instanceof IntercomPushData.ConversationPushData) {
            IntercomNotificationHandler.processConversationPushNotification$intercom_sdk_base_release$default(this, context, (IntercomPushData.ConversationPushData)intercomPushData, false, timeProvider, 4, null);
        }
    }

    public static /* synthetic */ void processIntercomPushNotification$intercom_sdk_base_release$default(IntercomNotificationHandler intercomNotificationHandler, Context context, IntercomPushData intercomPushData, TimeProvider timeProvider, int n, Object object) {
        if ((n & 4) != 0) {
            TimeProvider timeProvider2 = TimeProvider.SYSTEM;
            Intrinsics.checkNotNullExpressionValue((Object)timeProvider2, (String)"SYSTEM");
            timeProvider = timeProvider2;
        }
        intercomNotificationHandler.processIntercomPushNotification$intercom_sdk_base_release(context, intercomPushData, timeProvider);
    }

    private final void processDeepLinkPushNotification(Context context, IntercomPushData.DeepLinkPushData deepLinkPushData) {
        twig.i("This is a push only message", new Object[0]);
        Injector.get().getMetricTracker().receivedPushOnlyNotification("instance_id:" + deepLinkPushData.getInstanceId(), deepLinkPushData.getInstanceId());
        IntercomPushBitmapUtilsKt.loadContentBitmap(context, deepLinkPushData.getContentImageUrl(), (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(context, deepLinkPushData){
            final /* synthetic */ Context $context;
            final /* synthetic */ IntercomPushData.DeepLinkPushData $deepLinkPushData;
            {
                this.$context = $context;
                this.$deepLinkPushData = $deepLinkPushData;
                super(1);
            }

            public final void invoke(@Nullable Bitmap contentBitmap) {
                Notification notification = DeepLinkStylePushUIKt.buildDeepLinkNotification(this.$context, this.$deepLinkPushData, contentBitmap);
                NotificationPermissionCheckerKt.showNotification(this.$context, this.$deepLinkPushData.getNotificationId(), notification);
            }
        }));
    }

    public final void processConversationPushNotification$intercom_sdk_base_release(@NotNull Context context, @NotNull IntercomPushData.ConversationPushData conversationPushData, boolean isSilent, @NotNull TimeProvider timeProvider) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)conversationPushData, (String)"conversationPushData");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        if (Injector.get().getStore().state().hostAppState().isBackgrounded()) {
            twig.i("This is a background push message", new Object[0]);
            Injector.get().getMetricTracker().receivedPushNotification(conversationPushData.getConversationId());
            IntercomPushBitmapUtilsKt.loadAvatarBitmap(context, conversationPushData.getAvatarUrl(), conversationPushData.getAuthorName(), (Function1<? super Bitmap, Unit>)((Function1)new Function1<Bitmap, Unit>(timeProvider, context, conversationPushData, isSilent){
                final /* synthetic */ TimeProvider $timeProvider;
                final /* synthetic */ Context $context;
                final /* synthetic */ IntercomPushData.ConversationPushData $conversationPushData;
                final /* synthetic */ boolean $isSilent;
                {
                    this.$timeProvider = $timeProvider;
                    this.$context = $context;
                    this.$conversationPushData = $conversationPushData;
                    this.$isSilent = $isSilent;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@Nullable Bitmap avatarBitmap) {
                    void $this$invoke_u24lambda_u241;
                    Map map2;
                    IntercomNotificationHandler intercomNotificationHandler = IntercomNotificationHandler.INSTANCE;
                    long l = this.$timeProvider.currentTimeMillis();
                    Pair pair = IntercomNotificationHandler.access$updateConversations(intercomNotificationHandler, this.$context, this.$conversationPushData, l, avatarBitmap);
                    IntercomPushConversation conversation = (IntercomPushConversation)pair.component1();
                    List conversations = (List)pair.component2();
                    Pair<List<ShortcutInfoCompat>, ShortcutInfoCompat> pair2 = ConversationShortcutKt.createTemporaryShortcut(this.$context, conversation.getConversationId(), conversation.getConversationTitle());
                    List dynamicShortcuts = (List)pair2.component1();
                    ShortcutInfoCompat temporaryShortcut = (ShortcutInfoCompat)pair2.component2();
                    NotificationChannel notificationChannel = this.$conversationPushData.isNewConversation() ? NotificationChannel.NEW_CHATS_CHANNEL : NotificationChannel.CHAT_REPLIES_CHANNEL;
                    Notification conversationNotification = ConversationStylePushUIKt.buildConversationStyleNotification(this.$context, conversation, temporaryShortcut, notificationChannel, this.$isSilent);
                    Notification summaryNotification = conversations.size() > 1 ? ConversationStylePushUIKt.buildConversationStyleSummaryNotification(this.$context, conversations, notificationChannel) : null;
                    IntercomPushData.ConversationPushData conversationPushData = this.$conversationPushData;
                    Map map3 = map2 = MapsKt.createMapBuilder();
                    Context context = this.$context;
                    boolean bl = false;
                    $this$invoke_u24lambda_u241.put(conversationPushData.getNotificationId(), conversationNotification);
                    Notification notification = summaryNotification;
                    if (notification != null) {
                        Notification it = notification;
                        boolean bl2 = false;
                        $this$invoke_u24lambda_u241.put(9999997, it);
                    }
                    NotificationPermissionCheckerKt.showNotifications(context, MapsKt.build((Map)map2));
                    ConversationShortcutKt.resetShortcuts(this.$context, dynamicShortcuts);
                }
            }));
        } else {
            twig.i("Intercom message received but not displayed in notification bar. This happened because the host app was in the foreground.", new Object[0]);
        }
    }

    public static /* synthetic */ void processConversationPushNotification$intercom_sdk_base_release$default(IntercomNotificationHandler intercomNotificationHandler, Context context, IntercomPushData.ConversationPushData conversationPushData, boolean bl, TimeProvider timeProvider, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            TimeProvider timeProvider2 = TimeProvider.SYSTEM;
            Intrinsics.checkNotNullExpressionValue((Object)timeProvider2, (String)"SYSTEM");
            timeProvider = timeProvider2;
        }
        intercomNotificationHandler.processConversationPushNotification$intercom_sdk_base_release(context, conversationPushData, bl, timeProvider);
    }

    public final synchronized void clear(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!((Collection)conversations).isEmpty()) {
            twig.i("Removing Intercom push notifications.", new Object[0]);
        }
        NotificationManagerCompat $this$clear_u24lambda_u240 = NotificationManagerCompat.from((Context)context);
        boolean bl = false;
        $this$clear_u24lambda_u240.cancelAll();
        conversations = CollectionsKt.emptyList();
    }

    private final synchronized Pair<IntercomPushConversation, List<IntercomPushConversation>> updateConversations(Context context, IntercomPushData.ConversationPushData conversationPushData, long timestamp, Bitmap avatarBitmap) {
        IntercomPushConversation conversation = this.getOrCreateConversation(context, conversations, conversationPushData, timestamp, avatarBitmap);
        List updatedConversations = CollectionsKt.toMutableList((Collection)conversations);
        CollectionsKt.removeAll((List)updatedConversations, (Function1)((Function1)new Function1<IntercomPushConversation, Boolean>(conversation){
            final /* synthetic */ IntercomPushConversation $conversation;
            {
                this.$conversation = $conversation;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IntercomPushConversation it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getConversationId(), (Object)this.$conversation.getConversationId());
            }
        }));
        updatedConversations.add(conversation);
        conversations = updatedConversations;
        return TuplesKt.to((Object)conversation, (Object)updatedConversations);
    }

    /*
     * WARNING - void declaration
     */
    private final IntercomPushConversation getOrCreateConversation(Context context, List<IntercomPushConversation> conversations, IntercomPushData.ConversationPushData conversationPushData, long timestamp, Bitmap avatarBitmap) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list;
        Object v0;
        block6: {
            Iterable iterable = conversations;
            for (Object t : iterable) {
                IntercomPushConversation it = (IntercomPushConversation)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getConversationId(), (Object)conversationPushData.getConversationId())) continue;
                v0 = t;
                break block6;
            }
            v0 = null;
        }
        IntercomPushConversation intercomPushConversation = v0;
        if (intercomPushConversation == null) {
            return new IntercomPushConversation(conversationPushData.getConversationId(), conversationPushData.getAuthorName(), CollectionsKt.listOf((Object)ConversationStylePushUIKt.toMessage(conversationPushData, timestamp, avatarBitmap)));
        }
        IntercomPushConversation conversation = intercomPushConversation;
        IntercomPushConversation.Message message = (IntercomPushConversation.Message)CollectionsKt.lastOrNull(conversation.getMessages());
        boolean bl = message != null ? message.isCurrentUser() : false;
        if (bl && !conversationPushData.isCurrentUser()) {
            list = CollectionsKt.listOf((Object)ConversationStylePushUIKt.toMessage(conversationPushData, timestamp, avatarBitmap));
        } else {
            List list2;
            List $this$getOrCreateConversation_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            $this$getOrCreateConversation_u24lambda_u242.addAll((Collection)conversation.getMessages());
            $this$getOrCreateConversation_u24lambda_u242.add(ConversationStylePushUIKt.toMessage(conversationPushData, timestamp, avatarBitmap));
            list = CollectionsKt.build((List)list2);
        }
        List messages = list;
        Iterable $this$distinctBy$iv = messages;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            IntercomPushConversation.Message it = (IntercomPushConversation.Message)e$iv;
            boolean bl3 = false;
            Person person = it.getPerson();
            String key$iv = person != null ? person.getKey() : null;
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$mapNotNull = false;
        set$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Person it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl4 = false;
            IntercomPushConversation.Message it = (IntercomPushConversation.Message)element$iv$iv;
            boolean bl5 = false;
            if (it.getPerson() == null) continue;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List persons = (List)destination$iv$iv;
        String conversationTitle = ((Object)GroupConversationTextFormatter.groupConversationTitle(conversationPushData.getAuthorName(), CollectionsKt.getLastIndex((List)persons), context)).toString();
        return IntercomPushConversation.copy$default(conversation, null, conversationTitle, messages, 1, null);
    }

    public final void setUpNotificationChannels$intercom_sdk_base_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        NotificationChannelCompat notificationChannelCompat = new NotificationChannelCompat.Builder(NotificationChannel.CHAT_REPLIES_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_chat_replies_title)).setDescription(context.getString(R.string.intercom_notification_channel_chat_replies_description)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat, (String)"Builder(CHAT_REPLIES_CHA\u2026\n                .build()");
        NotificationChannelCompat replies = notificationChannelCompat;
        NotificationChannelCompat notificationChannelCompat2 = new NotificationChannelCompat.Builder(NotificationChannel.NEW_CHATS_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_new_chats_title)).setDescription(context.getString(R.string.intercom_notification_channel_new_chats_description)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat2, (String)"Builder(NEW_CHATS_CHANNE\u2026\n                .build()");
        NotificationChannelCompat newChats = notificationChannelCompat2;
        NotificationChannelCompat notificationChannelCompat3 = new NotificationChannelCompat.Builder(NotificationChannel.ACTIONS_CHANNEL.getChannelName(), 4).setName((CharSequence)context.getString(R.string.intercom_notification_channel_actions_title)).setDescription(context.getString(R.string.intercom_notification_channel_actions_description)).build();
        Intrinsics.checkNotNullExpressionValue((Object)notificationChannelCompat3, (String)"Builder(ACTIONS_CHANNEL.\u2026\n                .build()");
        NotificationChannelCompat actions = notificationChannelCompat3;
        NotificationManagerCompat $this$setUpNotificationChannels_u24lambda_u245 = NotificationManagerCompat.from((Context)context);
        boolean bl = false;
        Object[] objectArray = new NotificationChannelCompat[]{replies, newChats, actions};
        $this$setUpNotificationChannels_u24lambda_u245.createNotificationChannelsCompat(CollectionsKt.listOf((Object[])objectArray));
    }

    public static final /* synthetic */ Pair access$updateConversations(IntercomNotificationHandler $this, Context context, IntercomPushData.ConversationPushData conversationPushData, long timestamp, Bitmap avatarBitmap) {
        return $this.updateConversations(context, conversationPushData, timestamp, avatarBitmap);
    }
}

