/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.tickets.create.model;

import android.os.Bundle;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.unit.Dp;
import androidx.lifecycle.AbstractSavedStateViewModelFactory;
import androidx.lifecycle.SavedStateHandle;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistryOwner;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.TicketAttribute;
import io.intercom.android.sdk.blocks.lib.models.TicketType;
import io.intercom.android.sdk.helpcenter.utils.networking.NetworkResponse;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.conversation.ui.components.composer.MediaData;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.models.Upload;
import io.intercom.android.sdk.survey.QuestionState;
import io.intercom.android.sdk.survey.SurveyViewModelKt;
import io.intercom.android.sdk.survey.ValidationError;
import io.intercom.android.sdk.survey.model.SurveyCustomization;
import io.intercom.android.sdk.survey.model.SurveyData;
import io.intercom.android.sdk.survey.ui.models.Answer;
import io.intercom.android.sdk.survey.ui.questiontype.AnswerClickData;
import io.intercom.android.sdk.tickets.create.data.TicketAttributeRequest;
import io.intercom.android.sdk.tickets.create.data.TicketRepository;
import io.intercom.android.sdk.tickets.create.model.CreateTicketViewModelKt;
import io.intercom.android.sdk.ui.common.StringProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 K2\u00020\u0001:\u0004JKLMBI\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u001eH\u0002J\b\u0010*\u001a\u00020\u0016H\u0002J\u0012\u0010+\u001a\u00020,2\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020100H\u0002J\u0010\u00102\u001a\u00020\u001e2\u0006\u00103\u001a\u00020\u0005H\u0002J\u0010\u00104\u001a\u00020%2\u0006\u00105\u001a\u000206H\u0002J\u001e\u00107\u001a\u00020%2\u0006\u00105\u001a\u0002062\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000509H\u0002J\u0010\u0010:\u001a\u00020,2\b\u0010;\u001a\u0004\u0018\u00010<J\u0006\u0010=\u001a\u00020,J\u0006\u0010>\u001a\u00020,J\u000e\u0010?\u001a\u00020,2\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020,2\u0006\u0010@\u001a\u00020AJ\b\u0010C\u001a\u00020,H\u0002J\u0016\u0010D\u001a\u00020,2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020'00H\u0002J\u001c\u0010F\u001a\u00020,2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020I\u0012\u0004\u0012\u00020,0HH\u0002R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00130\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001fR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel;", "Landroidx/lifecycle/ViewModel;", "ticketRepository", "Lio/intercom/android/sdk/tickets/create/data/TicketRepository;", "conversationId", "", "userIdentity", "Lio/intercom/android/sdk/identity/UserIdentity;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "(Lio/intercom/android/sdk/tickets/create/data/TicketRepository;Ljava/lang/String;Lio/intercom/android/sdk/identity/UserIdentity;Lio/intercom/android/sdk/identity/AppConfig;Lkotlinx/coroutines/CoroutineDispatcher;Lio/intercom/android/sdk/metrics/MetricTracker;Landroidx/lifecycle/SavedStateHandle;)V", "_effect", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect;", "_uiState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState;", "effect", "Lkotlinx/coroutines/flow/SharedFlow;", "getEffect", "()Lkotlinx/coroutines/flow/SharedFlow;", "ticketData", "Lio/intercom/android/sdk/blocks/lib/models/TicketType;", "ticketTypeId", "", "Ljava/lang/Integer;", "uiState", "Lkotlinx/coroutines/flow/StateFlow;", "getUiState", "()Lkotlinx/coroutines/flow/StateFlow;", "canRetryFileLimitExceededError", "", "mediaItem", "Lio/intercom/android/sdk/survey/ui/models/Answer$MediaAnswer$MediaItem;", "index", "maxSelection", "convertToUiState", "createTicket", "", "compositionAwareScope", "Lkotlinx/coroutines/CoroutineScope;", "getAttributeRequest", "", "Lio/intercom/android/sdk/tickets/create/data/TicketAttributeRequest;", "getPlaceholderText", "type", "isFileSizeExceeded", "data", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;", "isUnsupportedFileType", "supportedFileType", "", "onAnswerClicked", "answerClickData", "Lio/intercom/android/sdk/survey/ui/questiontype/AnswerClickData;", "onAnswerUpdated", "onBottomSheetDismissed", "onDeleteFileClicked", "fileClickData", "Lio/intercom/android/sdk/survey/ui/questiontype/AnswerClickData$FileClickData;", "onRetryFileClicked", "updateCtaState", "uploadFileAttachments", "mediaItems", "withState", "operation", "Lkotlin/Function1;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Content;", "BottomSheetState", "Companion", "CreateTicketFormUiState", "TicketSideEffect", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nCreateTicketViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateTicketViewModel.kt\nio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,602:1\n1855#2:603\n1856#2:605\n154#3:604\n*S KotlinDebug\n*F\n+ 1 CreateTicketViewModel.kt\nio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel\n*L\n107#1:603\n107#1:605\n166#1:604\n*E\n"})
public final class CreateTicketViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TicketRepository ticketRepository;
    @NotNull
    private final String conversationId;
    @NotNull
    private final UserIdentity userIdentity;
    @NotNull
    private final AppConfig config;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final MetricTracker metricTracker;
    @Nullable
    private final TicketType ticketData;
    @Nullable
    private final Integer ticketTypeId;
    @NotNull
    private final MutableStateFlow<CreateTicketFormUiState> _uiState;
    @NotNull
    private final StateFlow<CreateTicketFormUiState> uiState;
    @NotNull
    private final MutableSharedFlow<TicketSideEffect> _effect;
    @NotNull
    private final SharedFlow<TicketSideEffect> effect;

    public CreateTicketViewModel(@NotNull TicketRepository ticketRepository, @NotNull String conversationId, @NotNull UserIdentity userIdentity2, @NotNull AppConfig config, @NotNull CoroutineDispatcher dispatcher, @NotNull MetricTracker metricTracker, @NotNull SavedStateHandle savedStateHandle) {
        Intrinsics.checkNotNullParameter((Object)ticketRepository, (String)"ticketRepository");
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)userIdentity2, (String)"userIdentity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        this.ticketRepository = ticketRepository;
        this.conversationId = conversationId;
        this.userIdentity = userIdentity2;
        this.config = config;
        this.dispatcher = dispatcher;
        this.metricTracker = metricTracker;
        this.ticketData = (TicketType)savedStateHandle.get("ticketData");
        this.ticketTypeId = (Integer)savedStateHandle.get("ticketTypeId");
        this._uiState = StateFlowKt.MutableStateFlow((Object)this.convertToUiState());
        this.uiState = FlowKt.asStateFlow(this._uiState);
        this._effect = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
        this.effect = FlowKt.asSharedFlow(this._effect);
        this.metricTracker.viewedCreateTicketForm(this.ticketTypeId, this.conversationId);
    }

    public /* synthetic */ CreateTicketViewModel(TicketRepository ticketRepository, String string2, UserIdentity userIdentity2, AppConfig appConfig2, CoroutineDispatcher coroutineDispatcher, MetricTracker metricTracker, SavedStateHandle savedStateHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ticketRepository = new TicketRepository(null, null, null, 7, null);
        }
        if ((n & 2) != 0) {
            String string3 = Injector.get().getStore().state().activeConversationState().getConversationId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get().store.state()\n    \u2026ionState().conversationId");
            string2 = string3;
        }
        if ((n & 4) != 0) {
            UserIdentity userIdentity3 = Injector.get().getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity3, (String)"get().userIdentity");
            userIdentity2 = userIdentity3;
        }
        if ((n & 8) != 0) {
            AppConfig appConfig3 = Injector.get().getAppConfigProvider().get();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig3, (String)"get().appConfigProvider.get()");
            appConfig2 = appConfig3;
        }
        if ((n & 0x10) != 0) {
            coroutineDispatcher = Dispatchers.getIO();
        }
        if ((n & 0x20) != 0) {
            MetricTracker metricTracker2 = Injector.get().getMetricTracker();
            Intrinsics.checkNotNullExpressionValue((Object)metricTracker2, (String)"get().metricTracker");
            metricTracker = metricTracker2;
        }
        this(ticketRepository, string2, userIdentity2, appConfig2, coroutineDispatcher, metricTracker, savedStateHandle);
    }

    @NotNull
    public final StateFlow<CreateTicketFormUiState> getUiState() {
        return this.uiState;
    }

    @NotNull
    public final SharedFlow<TicketSideEffect> getEffect() {
        return this.effect;
    }

    private final CreateTicketFormUiState convertToUiState() {
        List models;
        block27: {
            models = new ArrayList();
            Collection collection = models;
            Object object = CollectionsKt.listOf((Object)new Block.Builder().withType(BlockType.PARAGRAPH.getSerializedName()).withText("Email"));
            int n = R.string.intercom_placeholder_email_input;
            SurveyData.Step.Question.QuestionValidation.ValidationType validationType = SurveyData.Step.Question.QuestionValidation.ValidationType.EMAIL;
            CharSequence charSequence = this.userIdentity.getEmail();
            boolean bl = charSequence == null || StringsKt.isBlank((CharSequence)charSequence);
            Object $this$convertToUiState_u24lambda_u240 = object = new QuestionState(new SurveyData.Step.Question.ShortTextQuestionModel("-1", (List)object, true, null, validationType, null, bl, n, 8, null), SurveyViewModelKt.toSurveyUiColors(new SurveyCustomization(null, null, 3, null)));
            boolean bl2 = false;
            String string2 = this.userIdentity.getEmail();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"userIdentity.email");
            if (!StringsKt.isBlank((CharSequence)string2)) {
                String string3 = this.userIdentity.getEmail();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"userIdentity.email");
                ((QuestionState)$this$convertToUiState_u24lambda_u240).setAnswer(new Answer.SingleAnswer(string3));
            }
            collection.add(object);
            Object object2 = this.ticketData;
            if (object2 == null || (object2 = ((TicketType)object2).getAttributes()) == null) break block27;
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TicketAttribute it = (TicketAttribute)element$iv;
                boolean bl3 = false;
                int placeholderText = this.getPlaceholderText(it.getType());
                switch (it.getType()) {
                    case "list": {
                        Collection collection2 = models;
                        Object object3 = String.valueOf(it.getId());
                        List list = CollectionsKt.listOf((Object)new Block.Builder().withType(BlockType.PARAGRAPH.getSerializedName()).withText(it.getName()));
                        boolean bl4 = it.getRequired();
                        Object object4 = it.getOptions();
                        collection2.add(new QuestionState(new SurveyData.Step.Question.DropDownQuestionModel((String)object3, list, bl4, (List)object4, null, placeholderText, 16, null), SurveyViewModelKt.toSurveyUiColors(new SurveyCustomization(null, null, 3, null))));
                        break;
                    }
                    case "datetime": {
                        ((Collection)models).add(new QuestionState(new SurveyData.Step.Question.DatePickerQuestionModel(String.valueOf(it.getId()), CollectionsKt.listOf((Object)new Block.Builder().withType(BlockType.PARAGRAPH.getSerializedName()).withText(it.getName())), it.getRequired()), SurveyViewModelKt.toSurveyUiColors(new SurveyCustomization(null, null, 3, null))));
                        break;
                    }
                    case "boolean": {
                        Collection collection2 = models;
                        Object object3 = new String[]{"True", "False"};
                        collection2.add(new QuestionState(new SurveyData.Step.Question.SingleChoiceQuestionModel(String.valueOf(it.getId()), CollectionsKt.listOf((Object)new Block.Builder().withType(BlockType.PARAGRAPH.getSerializedName()).withText(it.getName())), it.getRequired(), CollectionsKt.listOf((Object[])object3), false), SurveyViewModelKt.toSurveyUiColors(new SurveyCustomization(null, null, 3, null))));
                        break;
                    }
                    case "string": 
                    case "integer": 
                    case "float": {
                        QuestionState questionState;
                        Object object4;
                        boolean bl4;
                        List list;
                        Object object3;
                        Collection collection2 = models;
                        if (Intrinsics.areEqual((Object)it.getIdentifier(), (Object)"multiline")) {
                            object3 = String.valueOf(it.getId());
                            list = CollectionsKt.listOf((Object)new Block.Builder().withType(BlockType.PARAGRAPH.getSerializedName()).withText(it.getName()));
                            bl4 = it.getRequired();
                            object4 = CreateTicketViewModelKt.access$getInputType(it.getType());
                            int $this$dp$iv = 120;
                            boolean $i$f$getDp = false;
                            float f = Dp.constructor-impl((float)$this$dp$iv);
                            QuestionState questionState2 = new QuestionState(new SurveyData.Step.Question.LongTextQuestionModel((String)object3, list, bl4, null, (SurveyData.Step.Question.QuestionValidation.ValidationType)((Object)object4), null, f, 0, placeholderText, 136, null), SurveyViewModelKt.toSurveyUiColors(new SurveyCustomization(null, null, 3, null)));
                            questionState = questionState2;
                        } else {
                            object3 = String.valueOf(it.getId());
                            list = CollectionsKt.listOf((Object)new Block.Builder().withType(BlockType.PARAGRAPH.getSerializedName()).withText(it.getName()));
                            bl4 = it.getRequired();
                            object4 = CreateTicketViewModelKt.access$getInputType(it.getType());
                            QuestionState questionState3 = new QuestionState(new SurveyData.Step.Question.ShortTextQuestionModel((String)object3, list, bl4, null, (SurveyData.Step.Question.QuestionValidation.ValidationType)((Object)object4), null, false, placeholderText, 72, null), SurveyViewModelKt.toSurveyUiColors(new SurveyCustomization(null, null, 3, null)));
                            questionState = questionState3;
                        }
                        object3 = questionState;
                        collection2.add(object3);
                        break;
                    }
                    case "files": {
                        Collection collection2 = models;
                        String string4 = String.valueOf(it.getId());
                        List list = CollectionsKt.listOf((Object)new Block.Builder().withType(BlockType.PARAGRAPH.getSerializedName()).withText(it.getName()));
                        StringProvider stringProvider = Intrinsics.areEqual((Object)it.getIdentifier(), (Object)"single") ? (StringProvider)new StringProvider.ActualString("") : (StringProvider)new StringProvider.StringRes(R.string.intercom_file_max_limit, CollectionsKt.listOf((Object)TuplesKt.to((Object)"limit", (Object)"10")));
                        boolean bl5 = it.getRequired();
                        int n2 = Intrinsics.areEqual((Object)it.getIdentifier(), (Object)"single") ? 1 : 10;
                        Set<String> set = this.config.getFileUploadSupportedFileTypes();
                        Intrinsics.checkNotNullExpressionValue(set, (String)"config.fileUploadSupportedFileTypes");
                        collection2.add(new QuestionState(new SurveyData.Step.Question.UploadFileQuestionModel(string4, (List<Block.Builder>)list, stringProvider, bl5, n2, set), SurveyViewModelKt.toSurveyUiColors(new SurveyCustomization(null, null, 3, null))));
                    }
                }
            }
        }
        TicketType ticketType = this.ticketData;
        Intrinsics.checkNotNull((Object)ticketType);
        return new CreateTicketFormUiState.Content(ticketType.getName(), models, false, false, null, 28, null);
    }

    public final void createTicket(@Nullable CoroutineScope compositionAwareScope) {
        this.metricTracker.submittedCreateTicketForm(this.ticketTypeId, this.conversationId);
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this, compositionAwareScope){
            final /* synthetic */ CreateTicketViewModel this$0;
            final /* synthetic */ CoroutineScope $compositionAwareScope;
            {
                this.this$0 = $receiver;
                this.$compositionAwareScope = $compositionAwareScope;
                super(1);
            }

            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this.this$0), (CoroutineContext)((CoroutineContext)CreateTicketViewModel.access$getDispatcher$p(this.this$0)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(content, this.this$0, this.$compositionAwareScope, null){
                    int label;
                    final /* synthetic */ CreateTicketFormUiState.Content $content;
                    final /* synthetic */ CreateTicketViewModel this$0;
                    final /* synthetic */ CoroutineScope $compositionAwareScope;
                    {
                        this.$content = $content;
                        this.this$0 = $receiver;
                        this.$compositionAwareScope = $compositionAwareScope;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        block12: {
                            var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$forEach$iv = this.$content.getQuestions();
                                    $i$f$forEach = false;
                                    for (Object element$iv : $this$forEach$iv) {
                                        it = (QuestionState)element$iv;
                                        $i$a$-forEach-CreateTicketViewModel$createTicket$1$1$1 = false;
                                        it.validate();
                                    }
                                    $this$all$iv = this.$content.getQuestions();
                                    $i$f$all = false;
                                    if (!($this$all$iv instanceof Collection) || !((Collection)$this$all$iv).isEmpty()) ** GOTO lbl18
                                    v0 = true;
                                    ** GOTO lbl25
lbl18:
                                    // 2 sources

                                    for (E element$iv : $this$all$iv) {
                                        it = (QuestionState)element$iv;
                                        $i$a$-all-CreateTicketViewModel$createTicket$1$1$didValidationPass$1 = false;
                                        if (it.getValidationError() instanceof ValidationError.NoValidationError) continue;
                                        v0 = false;
                                        ** GOTO lbl25
                                    }
                                    v0 = didValidationPass = true;
lbl25:
                                    // 3 sources

                                    if (didValidationPass) ** GOTO lbl47
                                    $this$first$iv = this.$content.getQuestions();
                                    $i$f$first = false;
                                    element$iv = $this$first$iv.iterator();
                                    while (element$iv.hasNext()) {
                                        element$iv = element$iv.next();
                                        it = (QuestionState)element$iv;
                                        $i$a$-first-CreateTicketViewModel$createTicket$1$1$2 = false;
                                        if (!(it.getValidationError() instanceof ValidationError.NoValidationError == false)) continue;
                                        ** GOTO lbl36
                                    }
                                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
lbl36:
                                    // 1 sources

                                    $this$first$iv = element$iv;
                                    var4_9 = this.$compositionAwareScope;
                                    it = (QuestionState)$this$first$iv;
                                    $i$a$-let-CreateTicketViewModel$createTicket$1$1$3 = false;
                                    v1 = var4_9;
                                    if (v1 != null) {
                                        $this$invokeSuspend_u24lambda_u244_u24lambda_u243 = v1;
                                        $i$a$-run-CreateTicketViewModel$createTicket$1$1$3$1 = false;
                                        it.bringIntoView($this$invokeSuspend_u24lambda_u244_u24lambda_u243);
                                    }
                                    return Unit.INSTANCE;
lbl47:
                                    // 1 sources

                                    CreateTicketViewModel.access$withState(this.this$0, (Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this.this$0){
                                        final /* synthetic */ CreateTicketViewModel this$0;
                                        {
                                            this.this$0 = $receiver;
                                            super(1);
                                        }

                                        public final void invoke(@NotNull CreateTicketFormUiState.Content it) {
                                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                            CreateTicketViewModel.access$get_uiState$p(this.this$0).setValue((Object)CreateTicketFormUiState.Content.copy$default(it, null, null, true, false, null, 27, null));
                                        }
                                    });
                                    $this$first$iv = CreateTicketViewModel.access$getUserIdentity$p(this.this$0).getEmail();
                                    if ($this$first$iv == null || StringsKt.isBlank((CharSequence)$this$first$iv) != false) {
                                        v2 = CreateTicketViewModel.access$getTicketRepository$p(this.this$0);
                                        v3 = ((QuestionState)CollectionsKt.first(this.$content.getQuestions())).getAnswer();
                                        Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type io.intercom.android.sdk.survey.ui.models.Answer.SingleAnswer");
                                        v2.updateUser(((Answer.SingleAnswer)v3).getAnswer());
                                    }
                                    v4 = CreateTicketViewModel.access$getTicketRepository$p(this.this$0);
                                    v5 = CreateTicketViewModel.access$getConversationId$p(this.this$0);
                                    v6 = CreateTicketViewModel.access$getTicketData$p(this.this$0);
                                    Intrinsics.checkNotNull((Object)v6);
                                    this.label = 1;
                                    v7 = v4.createTicket(v5, v6.getId(), CreateTicketViewModel.access$getAttributeRequest(this.this$0), (Continuation<? super NetworkResponse<Ticket>>)((Continuation)this));
                                    if (v7 == var9_2) {
                                        return var9_2;
                                    }
                                    ** GOTO lbl66
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v7 = $result;
lbl66:
                                    // 2 sources

                                    response = (NetworkResponse)v7;
                                    if (!(var3_6 instanceof NetworkResponse.Success)) break;
                                    this.label = 2;
                                    v8 = CreateTicketViewModel.access$get_effect$p(this.this$0).emit((Object)TicketSideEffect.Finish.INSTANCE, (Continuation)this);
                                    if (v8 == var9_2) {
                                        return var9_2;
                                    }
                                    break block12;
                                }
                                case 2: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v8 = $result;
                                    break block12;
                                }
                            }
                            CreateTicketViewModel.access$withState(this.this$0, (Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this.this$0){
                                final /* synthetic */ CreateTicketViewModel this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull CreateTicketFormUiState.Content it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    CreateTicketViewModel.access$get_uiState$p(this.this$0).setValue((Object)CreateTicketFormUiState.Content.copy$default(it, null, null, false, false, null, 27, null));
                                }
                            });
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }));
    }

    public static /* synthetic */ void createTicket$default(CreateTicketViewModel createTicketViewModel, CoroutineScope coroutineScope, int n, Object object) {
        if ((n & 1) != 0) {
            coroutineScope = null;
        }
        createTicketViewModel.createTicket(coroutineScope);
    }

    public final void onAnswerUpdated() {
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this){
            final /* synthetic */ CreateTicketViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this.this$0), (CoroutineContext)((CoroutineContext)CreateTicketViewModel.access$getDispatcher$p(this.this$0)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(content, this.this$0, null){
                    int label;
                    final /* synthetic */ CreateTicketFormUiState.Content $content;
                    final /* synthetic */ CreateTicketViewModel this$0;
                    {
                        this.$content = $content;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void $this$filterTo$iv$iv;
                                ResultKt.throwOnFailure((Object)object);
                                Iterable $this$filter$iv = this.$content.getQuestions();
                                boolean $i$f$filter = false;
                                Iterable iterable = $this$filter$iv;
                                Collection destination$iv$iv = new ArrayList<E>();
                                boolean $i$f$filterTo = false;
                                for (T element$iv$iv : $this$filterTo$iv$iv) {
                                    QuestionState it = (QuestionState)element$iv$iv;
                                    boolean bl = false;
                                    if (!(it.getQuestionModel() instanceof SurveyData.Step.Question.UploadFileQuestionModel)) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                Iterable $this$forEach$iv = (List)destination$iv$iv;
                                CreateTicketViewModel createTicketViewModel = this.this$0;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    QuestionState questionState = (QuestionState)element$iv;
                                    boolean bl = false;
                                    SurveyData.Step.Question.QuestionModel questionModel = questionState.getQuestionModel();
                                    Intrinsics.checkNotNull((Object)questionModel, (String)"null cannot be cast to non-null type io.intercom.android.sdk.survey.model.SurveyData.Step.Question.UploadFileQuestionModel");
                                    SurveyData.Step.Question.UploadFileQuestionModel fileQuestionModel = (SurveyData.Step.Question.UploadFileQuestionModel)questionModel;
                                    Answer answer2 = questionState.getAnswer();
                                    if (!(answer2 instanceof Answer.MediaAnswer)) continue;
                                    Iterable $this$forEachIndexed$iv = ((Answer.MediaAnswer)answer2).getMediaItems();
                                    boolean $i$f$forEachIndexed = false;
                                    int index$iv = 0;
                                    for (T item$iv : $this$forEachIndexed$iv) {
                                        void mediaItem;
                                        Object[] objectArray;
                                        int n;
                                        if ((n = index$iv++) < 0) {
                                            CollectionsKt.throwIndexOverflow();
                                        }
                                        Answer.MediaAnswer.MediaItem mediaItem2 = (Answer.MediaAnswer.MediaItem)item$iv;
                                        int index = n;
                                        boolean bl2 = false;
                                        if (index >= fileQuestionModel.getMaxSelection()) {
                                            objectArray = new StringProvider.StringRes[]{new StringProvider.StringRes(R.string.intercom_upload_failed, null, 2, null), new StringProvider.StringRes(R.string.intercom_upload_max_files_allowed, CollectionsKt.listOf((Object)TuplesKt.to((Object)"limit", (Object)String.valueOf(fileQuestionModel.getMaxSelection()))))};
                                            mediaItem.setUploadStatus(new Answer.MediaAnswer.FileUploadStatus.Error(new Answer.MediaAnswer.FileUploadError.FileLimitExceeded(CollectionsKt.listOf((Object[])objectArray))));
                                            continue;
                                        }
                                        if (CreateTicketViewModel.access$isUnsupportedFileType(createTicketViewModel, mediaItem.getData(), fileQuestionModel.getSupportedFileType())) {
                                            mediaItem.setUploadStatus(new Answer.MediaAnswer.FileUploadStatus.Error(new Answer.MediaAnswer.FileUploadError.UnsupportedFileType(CollectionsKt.listOf((Object)new StringProvider.StringRes(R.string.intercom_upload_failed, null, 2, null)))));
                                            continue;
                                        }
                                        if (CreateTicketViewModel.access$isFileSizeExceeded(createTicketViewModel, mediaItem.getData())) {
                                            objectArray = new StringProvider.StringRes[]{new StringProvider.StringRes(R.string.intercom_upload_failed, null, 2, null), new StringProvider.StringRes(R.string.intercom_upload_max_files_size, CollectionsKt.listOf((Object)TuplesKt.to((Object)"limit", (Object)String.valueOf(CreateTicketViewModel.access$getConfig$p(createTicketViewModel).getUploadSizeLimit() / (long)0x100000))))};
                                            mediaItem.setUploadStatus(new Answer.MediaAnswer.FileUploadStatus.Error(new Answer.MediaAnswer.FileUploadError.FileTooLarge(CollectionsKt.listOf((Object[])objectArray))));
                                            continue;
                                        }
                                        if (Intrinsics.areEqual((Object)mediaItem.getUploadStatus(), (Object)Answer.MediaAnswer.FileUploadStatus.None.INSTANCE)) {
                                            mediaItem.setUploadStatus(Answer.MediaAnswer.FileUploadStatus.Queued.INSTANCE);
                                            continue;
                                        }
                                        if (!CreateTicketViewModel.access$canRetryFileLimitExceededError(createTicketViewModel, (Answer.MediaAnswer.MediaItem)mediaItem, index, fileQuestionModel.getMaxSelection())) continue;
                                        mediaItem.setUploadStatus(Answer.MediaAnswer.FileUploadStatus.Queued.INSTANCE);
                                    }
                                    CreateTicketViewModel.access$uploadFileAttachments(createTicketViewModel, ((Answer.MediaAnswer)answer2).getMediaItems());
                                    questionState.validate();
                                }
                                CreateTicketViewModel.access$updateCtaState(this.this$0);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }));
    }

    private final boolean isUnsupportedFileType(MediaData.Media data, Set<String> supportedFileType) {
        String[] stringArray = new String[]{"/"};
        String format = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)data.getMimeType(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        return !supportedFileType.contains(format);
    }

    private final boolean isFileSizeExceeded(MediaData.Media data) {
        return (long)data.getSize() > this.config.getUploadSizeLimit();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canRetryFileLimitExceededError(Answer.MediaAnswer.MediaItem mediaItem, int index, int maxSelection) {
        if (!(mediaItem.getUploadStatus() instanceof Answer.MediaAnswer.FileUploadStatus.Error)) return false;
        Answer.MediaAnswer.FileUploadStatus fileUploadStatus = mediaItem.getUploadStatus();
        Intrinsics.checkNotNull((Object)fileUploadStatus, (String)"null cannot be cast to non-null type io.intercom.android.sdk.survey.ui.models.Answer.MediaAnswer.FileUploadStatus.Error");
        if (!(((Answer.MediaAnswer.FileUploadStatus.Error)fileUploadStatus).getError() instanceof Answer.MediaAnswer.FileUploadError.FileLimitExceeded)) return false;
        if (index >= maxSelection) return false;
        return true;
    }

    private final void withState(Function1<? super CreateTicketFormUiState.Content, Unit> operation) {
        if (this._uiState.getValue() instanceof CreateTicketFormUiState.Content) {
            Object object = this._uiState.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.intercom.android.sdk.tickets.create.model.CreateTicketViewModel.CreateTicketFormUiState.Content");
            operation.invoke((Object)((CreateTicketFormUiState.Content)object));
        }
    }

    private final List<TicketAttributeRequest> getAttributeRequest() {
        List list = new ArrayList();
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>((List<TicketAttributeRequest>)list){
            final /* synthetic */ List<TicketAttributeRequest> $list;
            {
                this.$list = $list;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Iterable $this$filter$iv = content.getQuestions();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    QuestionState it = (QuestionState)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it.getQuestionModel().getId(), (Object)"-1"))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                List<TicketAttributeRequest> list = this.$list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    QuestionState it = (QuestionState)element$iv;
                    boolean bl = false;
                    Object answerForServer = CreateTicketViewModelKt.access$formatAnswerForServer(it);
                    if (Intrinsics.areEqual((Object)answerForServer, (Object)Unit.INSTANCE)) continue;
                    ((Collection)list).add(new TicketAttributeRequest(it.getQuestionModel().getId(), answerForServer));
                }
            }
        }));
        return list;
    }

    private final int getPlaceholderText(String type) {
        int n;
        switch (type) {
            case "integer": {
                n = R.string.intercom_placeholder_numerical_inputs;
                break;
            }
            case "email": {
                n = R.string.intercom_placeholder_email_input;
                break;
            }
            case "float": {
                n = R.string.intercom_placeholder_numerical_inputs;
                break;
            }
            case "list": {
                n = R.string.intercom_please_select;
                break;
            }
            default: {
                n = R.string.intercom_placeholder_text_inputs;
            }
        }
        return n;
    }

    public final void onRetryFileClicked(@NotNull AnswerClickData.FileClickData fileClickData) {
        Intrinsics.checkNotNullParameter((Object)fileClickData, (String)"fileClickData");
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this, fileClickData){
            final /* synthetic */ CreateTicketViewModel this$0;
            final /* synthetic */ AnswerClickData.FileClickData $fileClickData;
            {
                this.this$0 = $receiver;
                this.$fileClickData = $fileClickData;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                T element$iv3;
                Answer.MediaAnswer answer2;
                QuestionState questionState;
                block3: {
                    void $this$first$iv;
                    T element$iv22;
                    block2: {
                        void $this$first$iv2;
                        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                        Iterable iterable = content.getQuestions();
                        AnswerClickData.FileClickData fileClickData = this.$fileClickData;
                        boolean $i$f$first = false;
                        for (T element$iv22 : $this$first$iv2) {
                            QuestionState it = (QuestionState)element$iv22;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getQuestionModel().getId(), (Object)fileClickData.getQuestionId())) continue;
                            break block2;
                        }
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    questionState = (QuestionState)element$iv22;
                    Answer answer3 = questionState.getAnswer();
                    Intrinsics.checkNotNull((Object)answer3, (String)"null cannot be cast to non-null type io.intercom.android.sdk.survey.ui.models.Answer.MediaAnswer");
                    answer2 = (Answer.MediaAnswer)answer3;
                    Iterable $i$f$first = answer2.getMediaItems();
                    AnswerClickData.FileClickData fileClickData = this.$fileClickData;
                    boolean $i$f$first2 = false;
                    for (T element$iv3 : $this$first$iv) {
                        Answer.MediaAnswer.MediaItem it = (Answer.MediaAnswer.MediaItem)element$iv3;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)fileClickData.getClickedItem())) continue;
                        break block3;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                Answer.MediaAnswer.MediaItem mediaItem = (Answer.MediaAnswer.MediaItem)element$iv3;
                mediaItem.setUploadStatus(Answer.MediaAnswer.FileUploadStatus.None.INSTANCE);
                questionState.setAnswer(new Answer.MediaAnswer(answer2.getMediaItems()));
                this.this$0.onAnswerUpdated();
                this.this$0.onBottomSheetDismissed();
            }
        }));
    }

    public final void onDeleteFileClicked(@NotNull AnswerClickData.FileClickData fileClickData) {
        Intrinsics.checkNotNullParameter((Object)fileClickData, (String)"fileClickData");
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>(fileClickData, this){
            final /* synthetic */ AnswerClickData.FileClickData $fileClickData;
            final /* synthetic */ CreateTicketViewModel this$0;
            {
                this.$fileClickData = $fileClickData;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                T element$iv2;
                block1: {
                    void $this$first$iv;
                    Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                    Iterable iterable = content.getQuestions();
                    AnswerClickData.FileClickData fileClickData = this.$fileClickData;
                    boolean $i$f$first = false;
                    for (T element$iv2 : $this$first$iv) {
                        QuestionState it = (QuestionState)element$iv2;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getQuestionModel().getId(), (Object)fileClickData.getQuestionId())) continue;
                        break block1;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                QuestionState questionState = (QuestionState)element$iv2;
                Answer answer2 = questionState.getAnswer();
                Intrinsics.checkNotNull((Object)answer2, (String)"null cannot be cast to non-null type io.intercom.android.sdk.survey.ui.models.Answer.MediaAnswer");
                Answer.MediaAnswer answer3 = (Answer.MediaAnswer)answer2;
                questionState.setAnswer(new Answer.MediaAnswer(CollectionsKt.minus((Iterable)answer3.getMediaItems(), (Object)this.$fileClickData.getClickedItem())));
                this.this$0.onAnswerUpdated();
                this.this$0.onBottomSheetDismissed();
            }
        }));
    }

    private final void updateCtaState() {
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this){
            final /* synthetic */ CreateTicketViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                Object it;
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                Iterable $this$filter$iv = content.getQuestions();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (QuestionState)element$iv$iv;
                    boolean bl = false;
                    if (!(((QuestionState)it).getQuestionModel() instanceof SurveyData.Step.Question.UploadFileQuestionModel)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List uploadFileQuestionModel = (List)destination$iv$iv;
                for (QuestionState questionState : uploadFileQuestionModel) {
                    boolean bl;
                    block5: {
                        questionState.validate();
                        if (!(questionState.getAnswer() instanceof Answer.MediaAnswer)) continue;
                        Answer answer2 = questionState.getAnswer();
                        Intrinsics.checkNotNull((Object)answer2, (String)"null cannot be cast to non-null type io.intercom.android.sdk.survey.ui.models.Answer.MediaAnswer");
                        Answer.MediaAnswer mediaAnswer = (Answer.MediaAnswer)answer2;
                        Iterable $this$any$iv = mediaAnswer.getMediaItems();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (Answer.MediaAnswer.MediaItem)element$iv;
                                boolean bl2 = false;
                                if (!(!(((Answer.MediaAnswer.MediaItem)it).getUploadStatus() instanceof Answer.MediaAnswer.FileUploadStatus.Success))) continue;
                                bl = true;
                                break block5;
                            }
                            bl = false;
                        }
                    }
                    if (!bl) continue;
                    CreateTicketViewModel.access$get_uiState$p(this.this$0).setValue((Object)CreateTicketFormUiState.Content.copy$default(content, null, null, false, false, null, 23, null));
                    return;
                }
                CreateTicketViewModel.access$get_uiState$p(this.this$0).setValue((Object)CreateTicketFormUiState.Content.copy$default(content, null, null, false, true, null, 23, null));
            }
        }));
    }

    private final void uploadFileAttachments(List<Answer.MediaAnswer.MediaItem> mediaItems) {
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(mediaItems, this, null){
            int label;
            final /* synthetic */ List<Answer.MediaAnswer.MediaItem> $mediaItems;
            final /* synthetic */ CreateTicketViewModel this$0;
            {
                this.$mediaItems = $mediaItems;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        Answer.MediaAnswer.MediaItem it;
                        Iterable $this$filterTo$iv$iv;
                        ResultKt.throwOnFailure((Object)object);
                        Iterable $this$filter$iv = this.$mediaItems;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        for (T element$iv$iv : $this$filterTo$iv$iv) {
                            it = (Answer.MediaAnswer.MediaItem)element$iv$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getUploadStatus(), (Object)Answer.MediaAnswer.FileUploadStatus.Queued.INSTANCE)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        Iterable $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$map = false;
                        $this$filterTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            it = (Answer.MediaAnswer.MediaItem)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            it.setUploadStatus(Answer.MediaAnswer.FileUploadStatus.Uploading.INSTANCE);
                            collection.add(it);
                        }
                        List itemsToUpload = (List)destination$iv$iv;
                        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this.this$0), (CoroutineContext)((CoroutineContext)CreateTicketViewModel.access$getDispatcher$p(this.this$0)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<Answer.MediaAnswer.MediaItem>)itemsToUpload, this.this$0, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            int label;
                            final /* synthetic */ List<Answer.MediaAnswer.MediaItem> $itemsToUpload;
                            final /* synthetic */ CreateTicketViewModel this$0;
                            {
                                this.$itemsToUpload = $itemsToUpload;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)var1_1);
                                        var2_3 = this.$itemsToUpload;
                                        var3_4 = this.this$0;
                                        $i$f$forEach = false;
                                        var5_6 = $this$forEach$iv.iterator();
lbl9:
                                        // 2 sources

                                        while (var5_6.hasNext()) {
                                            element$iv = var5_6.next();
                                            mediaItem = (Answer.MediaAnswer.MediaItem)element$iv;
                                            $i$a$-forEach-CreateTicketViewModel$uploadFileAttachments$1$1$1 = false;
                                            this.L$0 = var3_4;
                                            this.L$1 = var5_6;
                                            this.L$2 = mediaItem;
                                            this.label = 1;
                                            v0 = CreateTicketViewModel.access$getTicketRepository$p(var3_4).uploadFile(mediaItem.getData(), (Continuation<? super NetworkResponse<Upload.Builder>>)this);
                                            if (v0 == var10_2) {
                                                return var10_2;
                                            }
                                            ** GOTO lbl30
                                        }
                                        break;
                                    }
                                    case 1: {
                                        $i$f$forEach = false;
                                        $i$a$-forEach-CreateTicketViewModel$uploadFileAttachments$1$1$1 = false;
                                        mediaItem = (Answer.MediaAnswer.MediaItem)this.L$2;
                                        var5_6 = (Iterator<T>)this.L$1;
                                        var3_4 = (CreateTicketViewModel)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl30:
                                        // 2 sources

                                        if (((response = (NetworkResponse)v0) instanceof NetworkResponse.ClientError != false ? true : response instanceof NetworkResponse.NetworkError) != false ? true : response instanceof NetworkResponse.ServerError) {
                                            mediaItem.setUploadStatus(new Answer.MediaAnswer.FileUploadStatus.Error(new Answer.MediaAnswer.FileUploadError.UploadFailed(CollectionsKt.listOf((Object)new StringProvider.StringRes(R.string.intercom_upload_failed, null, 2, null)))));
                                        } else if (response instanceof NetworkResponse.Success) {
                                            mediaItem.setUploadStatus(new Answer.MediaAnswer.FileUploadStatus.Success(((Upload.Builder)((NetworkResponse.Success)response).getBody()).build().getId()));
                                        }
                                        CreateTicketViewModel.access$updateCtaState(var3_4);
                                        ** GOTO lbl9
                                    }
                                }
                                return Unit.INSTANCE;
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public final void onAnswerClicked(@Nullable AnswerClickData answerClickData) {
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this, answerClickData){
            final /* synthetic */ CreateTicketViewModel this$0;
            final /* synthetic */ AnswerClickData $answerClickData;
            {
                this.this$0 = $receiver;
                this.$answerClickData = $answerClickData;
                super(1);
            }

            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                CreateTicketViewModel.access$get_uiState$p(this.this$0).setValue((Object)(this.$answerClickData instanceof AnswerClickData.FileClickData ? (CreateTicketFormUiState)CreateTicketFormUiState.Content.copy$default(content, null, null, false, false, new BottomSheetState(true, this.$answerClickData), 15, null) : (CreateTicketFormUiState)CreateTicketFormUiState.Content.copy$default(content, null, null, false, false, new BottomSheetState(false, null), 15, null)));
            }
        }));
    }

    public final void onBottomSheetDismissed() {
        this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)((Function1)new Function1<CreateTicketFormUiState.Content, Unit>(this){
            final /* synthetic */ CreateTicketViewModel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull CreateTicketFormUiState.Content content) {
                Intrinsics.checkNotNullParameter((Object)content, (String)"content");
                CreateTicketViewModel.access$get_uiState$p(this.this$0).setValue((Object)CreateTicketFormUiState.Content.copy$default(content, null, null, false, false, new BottomSheetState(false, null), 15, null));
            }
        }));
    }

    public static final /* synthetic */ CoroutineDispatcher access$getDispatcher$p(CreateTicketViewModel $this) {
        return $this.dispatcher;
    }

    public static final /* synthetic */ void access$withState(CreateTicketViewModel $this, Function1 operation) {
        $this.withState((Function1<? super CreateTicketFormUiState.Content, Unit>)operation);
    }

    public static final /* synthetic */ MutableStateFlow access$get_uiState$p(CreateTicketViewModel $this) {
        return $this._uiState;
    }

    public static final /* synthetic */ UserIdentity access$getUserIdentity$p(CreateTicketViewModel $this) {
        return $this.userIdentity;
    }

    public static final /* synthetic */ TicketRepository access$getTicketRepository$p(CreateTicketViewModel $this) {
        return $this.ticketRepository;
    }

    public static final /* synthetic */ String access$getConversationId$p(CreateTicketViewModel $this) {
        return $this.conversationId;
    }

    public static final /* synthetic */ TicketType access$getTicketData$p(CreateTicketViewModel $this) {
        return $this.ticketData;
    }

    public static final /* synthetic */ List access$getAttributeRequest(CreateTicketViewModel $this) {
        return $this.getAttributeRequest();
    }

    public static final /* synthetic */ MutableSharedFlow access$get_effect$p(CreateTicketViewModel $this) {
        return $this._effect;
    }

    public static final /* synthetic */ void access$updateCtaState(CreateTicketViewModel $this) {
        $this.updateCtaState();
    }

    public static final /* synthetic */ boolean access$isUnsupportedFileType(CreateTicketViewModel $this, MediaData.Media data, Set supportedFileType) {
        return $this.isUnsupportedFileType(data, supportedFileType);
    }

    public static final /* synthetic */ boolean access$isFileSizeExceeded(CreateTicketViewModel $this, MediaData.Media data) {
        return $this.isFileSizeExceeded(data);
    }

    public static final /* synthetic */ AppConfig access$getConfig$p(CreateTicketViewModel $this) {
        return $this.config;
    }

    public static final /* synthetic */ boolean access$canRetryFileLimitExceededError(CreateTicketViewModel $this, Answer.MediaAnswer.MediaItem mediaItem, int index, int maxSelection) {
        return $this.canRetryFileLimitExceededError(mediaItem, index, maxSelection);
    }

    public static final /* synthetic */ void access$uploadFileAttachments(CreateTicketViewModel $this, List mediaItems) {
        $this.uploadFileAttachments(mediaItems);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$BottomSheetState;", "", "showBottomSheet", "", "answerClickData", "Lio/intercom/android/sdk/survey/ui/questiontype/AnswerClickData;", "(ZLio/intercom/android/sdk/survey/ui/questiontype/AnswerClickData;)V", "getAnswerClickData", "()Lio/intercom/android/sdk/survey/ui/questiontype/AnswerClickData;", "getShowBottomSheet", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intercom-sdk-base_release"})
    public static final class BottomSheetState {
        private final boolean showBottomSheet;
        @Nullable
        private final AnswerClickData answerClickData;

        public BottomSheetState(boolean showBottomSheet, @Nullable AnswerClickData answerClickData) {
            this.showBottomSheet = showBottomSheet;
            this.answerClickData = answerClickData;
        }

        public /* synthetic */ BottomSheetState(boolean bl, AnswerClickData answerClickData, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                answerClickData = null;
            }
            this(bl, answerClickData);
        }

        public final boolean getShowBottomSheet() {
            return this.showBottomSheet;
        }

        @Nullable
        public final AnswerClickData getAnswerClickData() {
            return this.answerClickData;
        }

        public final boolean component1() {
            return this.showBottomSheet;
        }

        @Nullable
        public final AnswerClickData component2() {
            return this.answerClickData;
        }

        @NotNull
        public final BottomSheetState copy(boolean showBottomSheet, @Nullable AnswerClickData answerClickData) {
            return new BottomSheetState(showBottomSheet, answerClickData);
        }

        public static /* synthetic */ BottomSheetState copy$default(BottomSheetState bottomSheetState, boolean bl, AnswerClickData answerClickData, int n, Object object) {
            if ((n & 1) != 0) {
                bl = bottomSheetState.showBottomSheet;
            }
            if ((n & 2) != 0) {
                answerClickData = bottomSheetState.answerClickData;
            }
            return bottomSheetState.copy(bl, answerClickData);
        }

        @NotNull
        public String toString() {
            return "BottomSheetState(showBottomSheet=" + this.showBottomSheet + ", answerClickData=" + this.answerClickData + ')';
        }

        public int hashCode() {
            int n = this.showBottomSheet ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + (this.answerClickData == null ? 0 : this.answerClickData.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BottomSheetState)) {
                return false;
            }
            BottomSheetState bottomSheetState = (BottomSheetState)other;
            if (this.showBottomSheet != bottomSheetState.showBottomSheet) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.answerClickData, (Object)bottomSheetState.answerClickData);
        }

        public BottomSheetState() {
            this(false, null, 3, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\r"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "registryOwner", "Landroidx/savedstate/SavedStateRegistryOwner;", "args", "Landroid/os/Bundle;", "factory", "Landroidx/lifecycle/AbstractSavedStateViewModelFactory;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CreateTicketViewModel create(@NotNull ViewModelStoreOwner owner, @NotNull SavedStateRegistryOwner registryOwner, @Nullable Bundle args2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)registryOwner, (String)"registryOwner");
            return (CreateTicketViewModel)new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory(registryOwner, args2)).get(CreateTicketViewModel.class);
        }

        public static /* synthetic */ CreateTicketViewModel create$default(Companion companion, ViewModelStoreOwner viewModelStoreOwner, SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, int n, Object object) {
            if ((n & 4) != 0) {
                bundle = null;
            }
            return companion.create(viewModelStoreOwner, savedStateRegistryOwner, bundle);
        }

        @NotNull
        public final AbstractSavedStateViewModelFactory factory(@NotNull SavedStateRegistryOwner owner, @Nullable Bundle args2) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new AbstractSavedStateViewModelFactory(owner, args2){

                @NotNull
                protected <T extends ViewModel> T create(@NotNull String key, @NotNull Class<T> modelClass, @NotNull SavedStateHandle handle) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
                    return (T)((Object)new CreateTicketViewModel(null, null, null, null, null, null, handle, 63, null));
                }
            };
        }

        public static /* synthetic */ AbstractSavedStateViewModelFactory factory$default(Companion companion, SavedStateRegistryOwner savedStateRegistryOwner, Bundle bundle, int n, Object object) {
            if ((n & 2) != 0) {
                bundle = null;
            }
            return companion.factory(savedStateRegistryOwner, bundle);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState;", "", "()V", "Content", "Error", "Initial", "Loading", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Content;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Error;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Initial;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Loading;", "intercom-sdk-base_release"})
    @StabilityInferred(parameters=0)
    public static abstract class CreateTicketFormUiState {
        public static final int $stable;

        private CreateTicketFormUiState() {
        }

        public /* synthetic */ CreateTicketFormUiState(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003JA\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Content;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState;", "title", "", "questions", "", "Lio/intercom/android/sdk/survey/QuestionState;", "showCreatingTicketProgress", "", "enableCta", "bottomSheetState", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$BottomSheetState;", "(Ljava/lang/String;Ljava/util/List;ZZLio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$BottomSheetState;)V", "getBottomSheetState", "()Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$BottomSheetState;", "getEnableCta", "()Z", "getQuestions", "()Ljava/util/List;", "getShowCreatingTicketProgress", "getTitle", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Content
        extends CreateTicketFormUiState {
            @NotNull
            private final String title;
            @NotNull
            private final List<QuestionState> questions;
            private final boolean showCreatingTicketProgress;
            private final boolean enableCta;
            @NotNull
            private final BottomSheetState bottomSheetState;
            public static final int $stable = 8;

            public Content(@NotNull String title, @NotNull List<QuestionState> questions, boolean showCreatingTicketProgress, boolean enableCta, @NotNull BottomSheetState bottomSheetState) {
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(questions, (String)"questions");
                Intrinsics.checkNotNullParameter((Object)bottomSheetState, (String)"bottomSheetState");
                super(null);
                this.title = title;
                this.questions = questions;
                this.showCreatingTicketProgress = showCreatingTicketProgress;
                this.enableCta = enableCta;
                this.bottomSheetState = bottomSheetState;
            }

            public /* synthetic */ Content(String string2, List list, boolean bl, boolean bl2, BottomSheetState bottomSheetState, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    bl = false;
                }
                if ((n & 8) != 0) {
                    bl2 = true;
                }
                if ((n & 0x10) != 0) {
                    bottomSheetState = new BottomSheetState(false, null, 3, null);
                }
                this(string2, list, bl, bl2, bottomSheetState);
            }

            @NotNull
            public final String getTitle() {
                return this.title;
            }

            @NotNull
            public final List<QuestionState> getQuestions() {
                return this.questions;
            }

            public final boolean getShowCreatingTicketProgress() {
                return this.showCreatingTicketProgress;
            }

            public final boolean getEnableCta() {
                return this.enableCta;
            }

            @NotNull
            public final BottomSheetState getBottomSheetState() {
                return this.bottomSheetState;
            }

            @NotNull
            public final String component1() {
                return this.title;
            }

            @NotNull
            public final List<QuestionState> component2() {
                return this.questions;
            }

            public final boolean component3() {
                return this.showCreatingTicketProgress;
            }

            public final boolean component4() {
                return this.enableCta;
            }

            @NotNull
            public final BottomSheetState component5() {
                return this.bottomSheetState;
            }

            @NotNull
            public final Content copy(@NotNull String title, @NotNull List<QuestionState> questions, boolean showCreatingTicketProgress, boolean enableCta, @NotNull BottomSheetState bottomSheetState) {
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Intrinsics.checkNotNullParameter(questions, (String)"questions");
                Intrinsics.checkNotNullParameter((Object)bottomSheetState, (String)"bottomSheetState");
                return new Content(title, questions, showCreatingTicketProgress, enableCta, bottomSheetState);
            }

            public static /* synthetic */ Content copy$default(Content content, String string2, List list, boolean bl, boolean bl2, BottomSheetState bottomSheetState, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = content.title;
                }
                if ((n & 2) != 0) {
                    list = content.questions;
                }
                if ((n & 4) != 0) {
                    bl = content.showCreatingTicketProgress;
                }
                if ((n & 8) != 0) {
                    bl2 = content.enableCta;
                }
                if ((n & 0x10) != 0) {
                    bottomSheetState = content.bottomSheetState;
                }
                return content.copy(string2, list, bl, bl2, bottomSheetState);
            }

            @NotNull
            public String toString() {
                return "Content(title=" + this.title + ", questions=" + this.questions + ", showCreatingTicketProgress=" + this.showCreatingTicketProgress + ", enableCta=" + this.enableCta + ", bottomSheetState=" + this.bottomSheetState + ')';
            }

            public int hashCode() {
                int result2 = this.title.hashCode();
                result2 = result2 * 31 + ((Object)this.questions).hashCode();
                int n = this.showCreatingTicketProgress ? 1 : 0;
                if (n != 0) {
                    n = 1;
                }
                result2 = result2 * 31 + n;
                int n2 = this.enableCta ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                result2 = result2 * 31 + n2;
                result2 = result2 * 31 + this.bottomSheetState.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Content)) {
                    return false;
                }
                Content content = (Content)other;
                if (!Intrinsics.areEqual((Object)this.title, (Object)content.title)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.questions, content.questions)) {
                    return false;
                }
                if (this.showCreatingTicketProgress != content.showCreatingTicketProgress) {
                    return false;
                }
                if (this.enableCta != content.enableCta) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.bottomSheetState, (Object)content.bottomSheetState);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Error;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState;", "()V", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Error
        extends CreateTicketFormUiState {
            @NotNull
            public static final Error INSTANCE = new Error();
            public static final int $stable;

            private Error() {
                super(null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Initial;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState;", "()V", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Initial
        extends CreateTicketFormUiState {
            @NotNull
            public static final Initial INSTANCE = new Initial();
            public static final int $stable;

            private Initial() {
                super(null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState$Loading;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$CreateTicketFormUiState;", "()V", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Loading
        extends CreateTicketFormUiState {
            @NotNull
            public static final Loading INSTANCE = new Loading();
            public static final int $stable;

            private Loading() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect;", "", "()V", "Finish", "None", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect$Finish;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect$None;", "intercom-sdk-base_release"})
    public static abstract class TicketSideEffect {
        private TicketSideEffect() {
        }

        public /* synthetic */ TicketSideEffect(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect$Finish;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect;", "()V", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class Finish
        extends TicketSideEffect {
            @NotNull
            public static final Finish INSTANCE = new Finish();
            public static final int $stable;

            private Finish() {
                super(null);
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect$None;", "Lio/intercom/android/sdk/tickets/create/model/CreateTicketViewModel$TicketSideEffect;", "()V", "intercom-sdk-base_release"})
        @StabilityInferred(parameters=0)
        public static final class None
        extends TicketSideEffect {
            @NotNull
            public static final None INSTANCE = new None();
            public static final int $stable;

            private None() {
                super(null);
            }
        }
    }
}

