/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.BaseResponse;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;

public class UserIdentityMiddleware
implements Store.Middleware<State> {
    private final Provider<UserIdentity> userIdentityProvider;

    public UserIdentityMiddleware(Provider<UserIdentity> userIdentityProvider) {
        this.userIdentityProvider = userIdentityProvider;
    }

    @Override
    public void dispatch(Store<State> store2, Action<?> action, Store.NextDispatcher next) {
        next.dispatch(action);
        switch (action.type()) {
            case BASE_RESPONSE_RECEIVED: {
                BaseResponse response = (BaseResponse)action.value();
                this.userIdentityProvider.get().update(response.getUser());
                break;
            }
            case SOFT_RESET: {
                this.userIdentityProvider.get().softReset();
                break;
            }
            case HARD_RESET: {
                this.userIdentityProvider.get().hardReset();
                break;
            }
        }
    }
}

