/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.appcompat.app.AlertDialog;
import androidx.collection.ArrayMap;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.intercom.commons.utilities.TimeProvider;
import com.intercom.input.gallery.GalleryImage;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.nexus.NexusClient;
import io.intercom.android.nexus.NexusEvent;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.LightboxOpeningImageClickListener;
import io.intercom.android.sdk.blocks.LinkOpeningButtonClickListener;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.blocks.function.TimestampAdder;
import io.intercom.android.sdk.blocks.lib.BlockType;
import io.intercom.android.sdk.blocks.lib.Blocks;
import io.intercom.android.sdk.blocks.lib.BlocksViewHolder;
import io.intercom.android.sdk.blocks.lib.models.Author;
import io.intercom.android.sdk.blocks.lib.models.Block;
import io.intercom.android.sdk.blocks.lib.models.BlockAttachment;
import io.intercom.android.sdk.conversation.ConversationPartAdapter;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.conversation.SuggestionsClickListener;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.conversation.attribute.AttributeAnimateEndListener;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.helpcenter.articles.ArticleStatsArguments;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.TopActionBar;
import io.intercom.android.sdk.m5.conversation.reducers.HeaderReducerKt;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducer;
import io.intercom.android.sdk.m5.conversation.states.ConversationHeader;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.models.ActiveBot;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.BotIntro;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.ReplyOption;
import io.intercom.android.sdk.models.Suggestion;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.FormSubmitSuccessEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.NewTriggerConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import io.intercom.android.sdk.models.events.UploadEvent;
import io.intercom.android.sdk.models.events.failure.FormSubmitFailedEvent;
import io.intercom.android.sdk.models.events.failure.NewConversationFailedEvent;
import io.intercom.android.sdk.models.events.failure.ReplyFailedEvent;
import io.intercom.android.sdk.models.events.failure.UploadFailedEvent;
import io.intercom.android.sdk.models.events.realtime.UserContentSeenByAdminEvent;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.tickets.IntercomTicketActivity;
import io.intercom.android.sdk.tickets.TicketProgressRow;
import io.intercom.android.sdk.utilities.KeyboardUtils;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.views.AdminIsTypingView;
import io.intercom.android.sdk.views.AttributeCollectorCardView;
import io.intercom.android.sdk.views.BaseAttributeView;
import io.intercom.android.sdk.views.decoration.ConversationItemDecoration;
import io.intercom.android.sdk.views.holder.QuickReplyClickListener;
import io.intercom.android.sdk.views.holder.TeamPresenceState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;

class ConversationContentPresenter
implements QuickReplyClickListener,
SuggestionsClickListener {
    private static final String IMAGE_MIME_TYPE = "image";
    private static final long PART_DISPLAY_DELIVERED_TIMEOUT = TimeUnit.MINUTES.toMillis(1L);
    private final Part loadingPart = new Part.Builder().withStyle("loading_layout_style").build();
    private final TimestampAdder timestampAdder = TimestampAdder.create();
    final List<Part> sendingParts = new ArrayList<Part>();
    private final Map<String, AdminIsTypingView> isTypingViews = new ArrayMap();
    private Host host;
    private RecyclerView conversationList;
    private final TicketProgressRow ticketProgressRow;
    private final TopActionBar topActionBar;
    private final ConversationPartAdapter adapter;
    private final LinearLayoutManager layoutManager;
    private final List<Part> parts;
    private final SoundPlayer soundPlayer;
    private final Blocks blocks;
    private final BlocksViewHolder blocksUserViewHolder;
    private final BlocksViewHolder blocksAnnouncementViewHolder;
    private final BlocksViewHolder blocksAdminViewHolder;
    private final BlocksViewHolder blocksLinkViewHolder;
    private final BlocksViewHolder blocksConversationRatingViewHolder;
    private final BlocksViewHolder blocksPreviewViewHolder;
    private final BlocksViewHolder blocksLinkListHolder;
    private Provider<AppConfig> appConfigProvider;
    private final TeamPresence teamPresence;
    private final MetricTracker metricTracker;
    private final UploadingImageCache uploadingImageCache;
    private final Api api;
    private final UserIdentity userIdentity;
    private final OpsMetricTracker opsMetricTracker;
    private final Context context;
    private final Bus bus;
    private final Store<State> store;
    private final NexusClient nexusClient;
    private String conversationId;
    @Nullable
    private BotIntro botIntro;
    private ArticleStatsArguments articleStatsArguments;
    private Runnable replyDeliveredUpdater;
    private Function1<Boolean, Unit> updateStatusBarColor;

    static ConversationContentPresenter create(Host host, RecyclerView conversationList, TicketProgressRow ticketProgressRow, TopActionBar topActionBar, ConversationPartAdapter adapter2, Provider<AppConfig> appConfigProvider2, Api api2, List<Part> parts, String conversationId, SoundPlayer soundPlayer, Blocks blocks, UserIdentity userIdentity2, OpsMetricTracker opsMetricTracker, Activity activity, Store store2, NexusClient nexusClient, ArticleStatsArguments articleArgs, Function1<Boolean, Unit> updateStatusBarColor) {
        Injector injector2 = Injector.get();
        LinearLayoutManager layoutManager = new LinearLayoutManager(conversationList.getContext());
        UploadingImageCache uploadingImageCache = new UploadingImageCache();
        ViewHolderGenerator generator = new ViewHolderGenerator(uploadingImageCache, api2, appConfigProvider2, conversationId, new LightboxOpeningImageClickListener(api2), new LinkOpeningButtonClickListener(api2), injector2.getGson(), injector2.getBus(), injector2.getMetricTracker(), (Context)activity);
        return new ConversationContentPresenter(host, conversationList, ticketProgressRow, topActionBar, adapter2, layoutManager, parts, soundPlayer, blocks, generator, userIdentity2, api2, opsMetricTracker, uploadingImageCache, (Context)activity, conversationId, injector2.getMetricTracker(), injector2.getBus(), store2, nexusClient, appConfigProvider2, articleArgs, injector2.getStore().state().teamPresence(), updateStatusBarColor);
    }

    @VisibleForTesting
    ConversationContentPresenter(Host host, RecyclerView conversationList, TicketProgressRow ticketProgressRow, TopActionBar topActionBar, ConversationPartAdapter adapter2, LinearLayoutManager layoutManager, List<Part> parts, SoundPlayer soundPlayer, Blocks blocks, ViewHolderGenerator generator, UserIdentity userIdentity2, Api api2, OpsMetricTracker opsMetricTracker, UploadingImageCache uploadingImageCache, Context context, String conversationId, MetricTracker metricTracker, Bus bus, Store store2, NexusClient nexusClient, Provider<AppConfig> appConfigProvider2, ArticleStatsArguments articleArgs, TeamPresence teamPresence, Function1<Boolean, Unit> updateStatusBarColor) {
        this.host = host;
        this.conversationList = conversationList;
        this.ticketProgressRow = ticketProgressRow;
        this.topActionBar = topActionBar;
        this.adapter = adapter2;
        this.layoutManager = layoutManager;
        this.parts = parts;
        this.soundPlayer = soundPlayer;
        this.blocks = blocks;
        this.userIdentity = userIdentity2;
        this.api = api2;
        this.opsMetricTracker = opsMetricTracker;
        this.uploadingImageCache = uploadingImageCache;
        this.context = context;
        this.conversationId = conversationId;
        this.metricTracker = metricTracker;
        this.bus = bus;
        this.store = store2;
        this.nexusClient = nexusClient;
        this.appConfigProvider = appConfigProvider2;
        this.articleStatsArguments = articleArgs;
        this.teamPresence = teamPresence;
        this.blocksUserViewHolder = generator.getUserHolder();
        this.blocksAnnouncementViewHolder = generator.getContainerCardHolder();
        this.blocksAdminViewHolder = generator.getAdminHolder();
        this.blocksLinkViewHolder = generator.getLinkHolder();
        this.blocksConversationRatingViewHolder = generator.getConversationRatingHolder();
        this.blocksPreviewViewHolder = generator.getPreviewHolder();
        this.blocksLinkListHolder = generator.getLinkListHolder();
        this.updateStatusBarColor = updateStatusBarColor;
        adapter2.setQuickReplyClickListener(this);
        adapter2.setSuggesstionsClickListener(this);
    }

    public void setup() {
        this.opsMetricTracker.trackEvent("finish", "time-to-process-action-load-conversation-ms");
        this.conversationList.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.conversationList.setAdapter((RecyclerView.Adapter)this.adapter);
        this.conversationList.addItemDecoration((RecyclerView.ItemDecoration)new ConversationItemDecoration(this.conversationList.getContext(), this.parts));
        ((SimpleItemAnimator)this.conversationList.getItemAnimator()).setSupportsChangeAnimations(false);
        this.conversationList.setNestedScrollingEnabled(true);
        this.conversationList.setVisibility(0);
        this.ticketProgressRow.setVisible(false);
    }

    public void smoothScrollToTop() {
        this.conversationList.smoothScrollToPosition(0);
    }

    private void smoothScrollToBottom() {
        this.conversationList.smoothScrollToPosition(this.adapter.getCount() - 1);
    }

    public void scrollToTop() {
        this.conversationList.scrollToPosition(0);
    }

    public void scrollToBottom() {
        this.conversationList.scrollToPosition(this.adapter.getCount() - 1);
    }

    public boolean isAtBottom() {
        return !this.conversationList.canScrollVertically(1);
    }

    public void onNewPartReceived(Conversation conversation) {
        boolean shouldScrollToBottom;
        for (AdminIsTypingView isTypingView : this.isTypingViews.values()) {
            if (isTypingView == null) continue;
            isTypingView.cancelTypingAnimation();
        }
        boolean bl = shouldScrollToBottom = this.hasTicket(conversation) == false || this.hasTicket(conversation) != false && this.nonTicketPartsSize(conversation) > 1;
        if (shouldScrollToBottom) {
            this.smoothScrollToBottom();
        }
    }

    public void showErrorView() {
        this.hideLoadingIndicator();
        this.conversationList.setVisibility(8);
    }

    public void showLoadingView() {
        this.showLoadingIndicator();
        this.conversationList.setVisibility(0);
    }

    public void showContentView() {
        this.hideLoadingIndicator();
        this.conversationList.setVisibility(0);
    }

    private void showLoadingIndicator() {
        this.parts.add(0, this.loadingPart);
        this.adapter.notifyItemInserted(0);
    }

    private void hideLoadingIndicator() {
        int index = this.parts.indexOf(this.loadingPart);
        if (index >= 0) {
            this.parts.remove(index);
            this.adapter.notifyItemRemoved(index);
        }
    }

    private int positionOfPart(int position, String partId) {
        if (position >= 0 && position < this.parts.size()) {
            Part sendingPart = this.parts.get(position);
            if (sendingPart.getId().equals(partId)) {
                return position;
            }
            return this.positionOfPartById(partId);
        }
        return -1;
    }

    private int positionOfPartById(String partId) {
        for (int i = this.parts.size() - 1; i >= 0; --i) {
            if (!this.parts.get(i).getId().equals(partId)) continue;
            return i;
        }
        return -1;
    }

    private void markAsFailed(int position, String partId, boolean uploadFailed) {
        int partPosition = this.positionOfPart(position, partId);
        if (partPosition >= 0) {
            Part failedPart = this.parts.get(partPosition);
            View partView = this.adapter.getViewForPart(failedPart).getChildAt(0);
            if (partView instanceof UploadProgressListener) {
                UploadProgressListener listener2 = (UploadProgressListener)partView;
                listener2.uploadStopped();
            }
            failedPart.setMessageState(uploadFailed ? Part.MessageState.UPLOAD_FAILED : Part.MessageState.FAILED);
            this.adapter.notifyDataSetChanged();
        }
    }

    @Subscribe
    public void newConversationFailure(NewConversationFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), false);
    }

    @Subscribe
    public void replyFailure(ReplyFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), event.isUpload());
        this.soundPlayer.playReplyFailedSound();
    }

    @Subscribe
    public void uploadFailure(UploadFailedEvent event) {
        this.markAsFailed(event.getPosition(), event.getPartId(), true);
        this.soundPlayer.playReplyFailedSound();
    }

    @Subscribe
    public void formSubmitFailed(FormSubmitFailedEvent event) {
        int partPosition = this.positionOfPartById(event.getPartId());
        if (partPosition < 0) {
            return;
        }
        ViewGroup partView = this.adapter.getViewForPart(this.parts.get(partPosition));
        if (partView != null && partView.getChildCount() > 0) {
            int count = partView.getChildCount();
            for (int index = 0; index < count; ++index) {
                View view = partView.getChildAt(index);
                String errorMessage = this.context.getResources().getString(R.string.intercom_something_went_wrong_try_again);
                BaseAttributeView attributeView = (BaseAttributeView)view;
                String identifier = attributeView.getAttribute().getIdentifier();
                if (!identifier.equals(event.getAttributeIdentifier())) continue;
                attributeView.displayEmptyState();
                attributeView.displayErrorState(errorMessage);
                break;
            }
        }
    }

    @Subscribe
    public void formSubmitSuccess(FormSubmitSuccessEvent event) {
        ViewParent parent;
        int partPosition = this.positionOfPartById(event.getPartId());
        if (partPosition < 0) {
            return;
        }
        ViewGroup partView = this.adapter.getViewForPart(this.parts.get(partPosition));
        if (partView != null && partView.getParent() != null && (parent = partView.getParent()) instanceof AttributeCollectorCardView) {
            AttributeCollectorCardView collectorView = (AttributeCollectorCardView)parent;
            if (collectorView.isExpanded()) {
                collectorView.animateBack(new AttributeAnimateEndListener(event.getConversation(), this.bus));
                KeyboardUtils.hideKeyboard((View)collectorView);
                this.host.onFormSubmitted();
            } else {
                ConversationEvent conversationEvent = new ConversationEvent.Builder(event.getConversation()).isAttributeUpdated(true).build();
                this.bus.post((Object)conversationEvent);
            }
        }
    }

    @VisibleForTesting
    void addViewForPart(Part part) {
        if ("quick_reply".equals(part.getMessageStyle()) || "composer_suggestions_style".equals(part.getMessageStyle())) {
            return;
        }
        List<Block> blockParts = part.getBlocks();
        Participant author = part.getParticipant();
        if (author.isUserWithId(this.userIdentity.getIntercomId())) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksUserViewHolder));
        } else if ("post".equals(part.getMessageStyle()) || "note".equals(part.getMessageStyle())) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAnnouncementViewHolder));
        } else if (part.isLinkCard()) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksLinkViewHolder));
        } else if (part.isSingleBlockPartOfType(BlockType.CONVERSATIONRATING)) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksConversationRatingViewHolder));
        } else if (part.isSingleBlockPartOfType(BlockType.LINKLIST)) {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksLinkListHolder));
        } else if ("attribute_collector".equals(part.getMessageStyle())) {
            LinearLayout rootAttributeLayout = new LinearLayout(this.context);
            rootAttributeLayout.setOrientation(1);
            this.adapter.setViewForPart(part, (ViewGroup)rootAttributeLayout);
        } else {
            this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(blockParts, this.blocksAdminViewHolder));
        }
        if (this.hasMessengerCardBlock(blockParts)) {
            ArrayList<ViewGroup> views = new ArrayList<ViewGroup>();
            for (Block block : blockParts) {
                views.add((ViewGroup)this.blocks.createBlocks(Collections.singletonList(block), this.blocksAdminViewHolder));
            }
            this.adapter.setLegacyBlocksForPart(part, views);
        }
    }

    private boolean hasMessengerCardBlock(List<Block> blockParts) {
        for (Block block : blockParts) {
            if (block.getType() != BlockType.MESSENGERCARD) continue;
            return true;
        }
        return false;
    }

    private void displaySendingPart(Part part) {
        this.soundPlayer.playReplySentSound();
        ArrayList<Part> currentParts = new ArrayList<Part>(this.parts);
        Part lastPart = null;
        if (!this.parts.isEmpty()) {
            lastPart = this.parts.get(this.parts.size() - 1);
        }
        if (lastPart != null && lastPart.getMessageStyle().equals("admin_is_typing_style")) {
            this.parts.add(this.parts.size() - 1, part);
        } else {
            this.parts.add(part);
        }
        this.adapter.setViewForPart(part, (ViewGroup)this.blocks.createBlocks(part.getBlocks(), this.blocksPreviewViewHolder));
        this.adapter.isBigTicketCardVisible = false;
        this.showTicketProgressRowIfNeeded();
        this.updateAdapterWithAnimations(currentParts, this.parts);
        this.smoothScrollToBottom();
    }

    public synchronized void onAdminStartedTyping(AdminIsTypingEvent event) {
        String adminId = event.getAdminId();
        if (this.isTypingViews.containsKey(adminId)) {
            this.isTypingViews.get(adminId).renewTypingAnimation();
            return;
        }
        Part isTypingPart = new Part.Builder().withParticipantIsAdmin(true).withStyle("admin_is_typing_style").build();
        Participant participant = this.host.getConversation().getParticipant(adminId);
        if (participant == Participant.NULL) {
            participant = Participant.create(adminId, event.getAdminName(), "admin", "", Avatar.create(event.getAdminAvatarUrl(), ""), event.getIsBot());
        }
        isTypingPart.setParticipant(participant);
        isTypingPart.setEntranceAnimation(true);
        boolean wasAtBottom = this.isAtBottom();
        this.parts.add(isTypingPart);
        Context context = this.conversationList.getContext();
        LinearLayout container = (LinearLayout)View.inflate((Context)context, (int)R.layout.intercom_blocks_admin_layout, null);
        AdminIsTypingView view = new AdminIsTypingView(context);
        view.setListener(view1 -> this.onAdminStoppedTyping(adminId, isTypingPart.getId()));
        container.addView((View)view);
        this.isTypingViews.put(adminId, view);
        this.adapter.setViewForPart(isTypingPart, (ViewGroup)container);
        this.adapter.notifyDataSetChanged();
        if (wasAtBottom) {
            this.smoothScrollToBottom();
        }
    }

    void onAdminStoppedTyping(String adminId, String partId) {
        this.isTypingViews.remove(adminId);
        int position = this.positionOfPart(this.parts.size() - 1, partId);
        if (position >= 0) {
            this.parts.remove(position);
            this.adapter.notifyDataSetChanged();
        }
    }

    public void fetchConversation(final String conversationId) {
        if (!conversationId.isEmpty()) {
            this.opsMetricTracker.trackEvent("start", "time-to-complete-request-load-conversation-ms");
            this.conversationId = conversationId;
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    ConversationContentPresenter.this.api.getConversation(conversationId, null);
                }
            });
        }
    }

    public void onPartClicked(Part part) {
        if (part.getMessageState() == Part.MessageState.FAILED) {
            this.showRetryDialog(part);
        } else if (part.getMessageState() == Part.MessageState.UPLOAD_FAILED) {
            this.retryFailedUpload(part);
        }
    }

    private void retryFailedUpload(Part part) {
        UploadProgressListener listener2;
        int position = this.positionOfPart(this.parts.size() - 1, part.getId());
        if (position >= 0) {
            listener2 = (UploadProgressListener)this.adapter.getViewForPart(this.parts.get(position)).getChildAt(0);
            listener2.uploadStarted();
        } else {
            listener2 = new UploadProgressListener(){

                @Override
                public void uploadStarted() {
                }

                @Override
                public void uploadNotice(byte percentUploaded) {
                }

                @Override
                public void uploadSmoothEnd() {
                }

                @Override
                public void uploadStopped() {
                }
            };
        }
        part.setMessageState(Part.MessageState.SENDING);
        this.parts.remove(this.parts.indexOf(part));
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        this.api.uploadFile(part.getUpload(), position, part.getId(), this.uploadingImageCache, listener2, this.context);
    }

    private void showRetryDialog(Part part) {
        new AlertDialog.Builder(this.conversationList.getContext()).setTitle(R.string.intercom_inbox_error_state_title).setMessage(R.string.intercom_failed_delivery).setPositiveButton(R.string.intercom_retry, (dialog, which) -> this.retryTapped(part)).show();
    }

    void retryTapped(Part part) {
        part.setMessageState(Part.MessageState.SENDING);
        this.parts.remove(part);
        this.parts.add(part);
        this.adapter.notifyDataSetChanged();
        List<Block> partBlocks = part.getBlocks();
        int size = partBlocks.size();
        ArrayList<Block.Builder> blockBuilders = new ArrayList<Block.Builder>(partBlocks.size());
        for (int i = 0; i < size; ++i) {
            blockBuilders.add(partBlocks.get(i).toBuilder());
        }
        this.sendPart(blockBuilders);
    }

    private Part addSendingPart(List<Block.Builder> blocks) {
        Part part = this.createSendingPart(blocks);
        this.sendingParts.add(part);
        this.displaySendingPart(part);
        return part;
    }

    private Part createSendingPart(List<Block.Builder> blocks) {
        Part part = new Part.Builder().withCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis())).withStyle("chat").withBlocks(blocks).build();
        part.setMessageState(Part.MessageState.SENDING);
        part.setParticipant(this.getUserParticipant());
        part.setEntranceAnimation(true);
        return part;
    }

    void addComposerSuggestionsPart(ComposerSuggestions composerSuggestions) {
        Part lastPart;
        if (composerSuggestions.getSuggestions().isEmpty()) {
            return;
        }
        Part composerSuggestionsPart = this.createComposerSuggestionsPart(composerSuggestions);
        boolean isPartUpdated = false;
        if (!this.parts.isEmpty() && "composer_suggestions_style".equals((lastPart = this.parts.get(this.parts.size() - 1)).getMessageStyle())) {
            this.parts.remove(lastPart);
            isPartUpdated = true;
        }
        this.parts.add(composerSuggestionsPart);
        if (isPartUpdated) {
            this.adapter.notifyItemChanged(this.parts.indexOf(composerSuggestionsPart));
        } else {
            this.adapter.notifyItemInserted(this.parts.indexOf(composerSuggestionsPart));
        }
    }

    private Part createComposerSuggestionsPart(ComposerSuggestions composerSuggestions) {
        Part composerSuggestionsPart = new Part.Builder().withCreatedAt(TimeUnit.MILLISECONDS.toSeconds(TimeProvider.SYSTEM.currentTimeMillis())).withStyle("composer_suggestions_style").build();
        composerSuggestionsPart.setComposerSuggestions(composerSuggestions);
        return composerSuggestionsPart;
    }

    Participant getUserParticipant() {
        String intercomId = this.userIdentity.getIntercomId();
        Participant user = this.host.getConversation().getParticipant(intercomId);
        if (user == Participant.NULL) {
            return new Participant.Builder().withId(intercomId).build();
        }
        return user;
    }

    public void sendPart(List<Block.Builder> blockBuilders) {
        this.opsMetricTracker.trackEvent("finish", "time-to-process-action-send-part-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-complete-request-send-part-ms");
        Part part = this.addSendingPart(blockBuilders);
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.startConversationOnServer(blockBuilders, part.getId());
        } else {
            this.api.replyToConversation(this.conversationId, blockBuilders, this.parts.size() - 1, part.getId(), false);
        }
    }

    @Subscribe
    public void uploadSuccess(UploadEvent event) {
        String tempPartId = event.getTempPartId();
        int partPosition = this.positionOfPart(event.getTempPartPosition(), tempPartId);
        if (partPosition < 0) {
            return;
        }
        Part part = this.parts.get(partPosition);
        if (part.getBlocks().isEmpty() || !tempPartId.equals(part.getId())) {
            return;
        }
        List<Block.Builder> blocks = this.createBlocksForUpload(event, part.getBlocks().get(0));
        if (TextUtils.isEmpty((CharSequence)this.conversationId)) {
            this.startConversationOnServer(blocks, tempPartId);
        } else {
            this.api.replyToConversation(this.conversationId, blocks, partPosition, part.getId(), true);
        }
    }

    private void startConversationOnServer(List<Block.Builder> blocks, String partId) {
        String botIntroVersion = null;
        if (this.botIntro != null) {
            botIntroVersion = this.botIntro.getId();
        }
        this.api.startNewConversation(blocks, this.parts.size() - 1, partId, this.store.select(Selectors.COMPOSER_SUGGESTIONS).getSuggestions(), botIntroVersion, this.articleStatsArguments, this.store.state().botBehaviourId());
    }

    private List<Block.Builder> createBlocksForUpload(UploadEvent event, Block localFileBlock) {
        if (event.getUpload().getContentType().contains(IMAGE_MIME_TYPE)) {
            return Collections.singletonList(localFileBlock.toBuilder().withType(BlockType.IMAGE.getSerializedName()).withUrl(event.getUpload().getPublicUrl()));
        }
        List<BlockAttachment> attachments = localFileBlock.getAttachments();
        if (attachments.isEmpty()) {
            return Collections.emptyList();
        }
        BlockAttachment tempAttachment = attachments.get(0);
        tempAttachment = tempAttachment.toBuilder().withSize(event.getSize()).withId(event.getUpload().getId()).withUrl(event.getUpload().getPublicUrl()).build();
        Block.Builder builder = localFileBlock.toBuilder().withAttachments(Collections.singletonList(tempAttachment)).withType(BlockType.ATTACHMENTLIST.getSerializedName());
        return Collections.singletonList(builder);
    }

    public void uploadImage(List<Block.Builder> blocks, GalleryImage galleryImage) {
        Part part = this.addSendingPart(blocks);
        part.setUpload(galleryImage);
        this.api.uploadFile(galleryImage, this.parts.size() - 1, part.getId(), this.uploadingImageCache, (UploadProgressListener)this.adapter.getViewForPart(part).getChildAt(0), this.context);
    }

    public void onNewConversation(NewConversationEvent event) {
        this.updateSendPartOpsMetric();
        Conversation conversation = event.getConversation();
        this.parts.clear();
        this.addTemporaryExpectationsBannerIfNeeded(false);
        this.addTeamPresencePart();
        this.setUpTopActionBar(event.getConversation());
        this.parts.addAll(event.getConversation().getParts());
        for (Part part : this.parts) {
            this.addViewForPart(part);
        }
        this.conversationId = conversation.getId();
        this.adapter.setConversationId(this.conversationId);
        this.sendingParts.clear();
        this.adapter.notifyDataSetChanged();
    }

    public void onReplyDelivered(ReplyEvent event) {
        this.updateSendPartOpsMetric();
        Part part = event.getResponse();
        int position = this.positionOfPart(event.getPosition(), event.getPartId());
        if (position >= 0 && this.parts.get(position).isSendingPart()) {
            this.sendingParts.remove(this.parts.remove(position));
        }
        if (!this.parts.contains(part)) {
            this.addViewForPart(part);
            part.setDisplayDelivered(true);
            Part lastPart = this.parts.get(this.parts.size() - 1);
            if (lastPart.getMessageStyle().equals("admin_is_typing_style")) {
                this.parts.add(this.parts.size() - 1, part);
            } else {
                this.parts.add(part);
            }
            this.adapter.notifyDataSetChanged();
        }
        this.conversationList.removeCallbacks(this.replyDeliveredUpdater);
        this.replyDeliveredUpdater = () -> {
            part.setDisplayDelivered(false);
            this.adapter.notifyDataSetChanged();
        };
        this.conversationList.postDelayed(this.replyDeliveredUpdater, PART_DISPLAY_DELIVERED_TIMEOUT);
    }

    private void updateSendPartOpsMetric() {
        this.opsMetricTracker.trackEvent("finish", "time-to-complete-request-send-part-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-render-result-send-part-ms");
        this.conversationList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ConversationContentPresenter.this.opsMetricTracker.trackEvent("finish", "time-to-render-result-send-part-ms");
                ViewUtils.removeGlobalLayoutListener((View)ConversationContentPresenter.this.conversationList, this);
            }
        });
    }

    public void onConversationFetched(ConversationEvent event, boolean initialLoad) {
        this.opsMetricTracker.trackEvent("finish", "time-to-complete-request-load-conversation-ms");
        this.opsMetricTracker.trackEvent("start", "time-to-render-result-load-conversation-ms");
        Conversation conversation = event.getResponse();
        ArrayList<Part> currentParts = new ArrayList<Part>(this.parts);
        this.parts.clear();
        if (initialLoad) {
            this.conversationList.startAnimation(AnimationUtils.loadAnimation((Context)this.conversationList.getContext(), (int)R.anim.intercom_conversation_slide_in));
        }
        this.setUpTopActionBar(conversation);
        this.addTemporaryExpectationsBannerIfNeeded(false);
        if (this.hasTicket(conversation).booleanValue()) {
            this.addBigTicketCard(conversation);
            this.setupTicketProgressRow(conversation.getTicket());
        }
        if (this.hasNonTicketParts(conversation)) {
            this.addTeamPresencePart(false, conversation);
            this.processConversationParts(conversation);
            this.adapter.isBigTicketCardVisible = false;
            this.showTicketProgressRowIfNeeded();
        } else {
            this.adapter.isBigTicketCardVisible = true;
        }
        this.removeSendingPartsIfNeeded();
        this.timestampAdder.addDayDividers(this.parts);
        this.updateAdapterWithAnimations(currentParts, this.parts);
        this.conversationList.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                ConversationContentPresenter.this.opsMetricTracker.trackEvent("finish", "time-to-render-result-load-conversation-ms");
                ViewUtils.removeGlobalLayoutListener((View)ConversationContentPresenter.this.conversationList, this);
            }
        });
    }

    private List<Avatar> getGroupConversationAvatars(List<Participant> participants) {
        ArrayList<Avatar> avatars = new ArrayList<Avatar>();
        for (Participant participant : participants) {
            avatars.add(participant.getAvatar());
        }
        return avatars;
    }

    private void updateAdapterWithAnimations(List<Part> currentParts, List<Part> newParts) {
        int index = this.getFirstDifferentPartIndex(currentParts, newParts);
        if (index > -1) {
            int added;
            this.adapter.notifyItemRangeChanged(0, index);
            int removed = currentParts.size() - index;
            if (removed > 0) {
                this.adapter.notifyItemRangeRemoved(index, removed);
            }
            if ((added = newParts.size() - index) > 0) {
                this.adapter.notifyItemRangeInserted(index, added);
            }
        }
    }

    private int getFirstDifferentPartIndex(List<Part> currentParts, List<Part> newParts) {
        List<Part> tempParts = currentParts;
        if (newParts.size() < currentParts.size()) {
            tempParts = newParts;
        }
        int index = -1;
        for (int i = 0; i < tempParts.size(); ++i) {
            index = i;
            if (!currentParts.get(i).getMessageStyle().equals(newParts.get(i).getMessageStyle())) break;
        }
        if (tempParts.size() - 1 == index) {
            ++index;
        }
        return index;
    }

    private void processConversationParts(Conversation conversation) {
        for (int i = 0; i < conversation.getParts().size(); ++i) {
            Part part = conversation.getParts().get(i);
            part.setParentConversation(conversation);
            if (i < conversation.getParts().size() - 1 && "quick_reply".equals(part.getMessageStyle())) continue;
            if (this.adapter.getViewForPart(part) == null || part.hasAttachments()) {
                this.addViewForPart(part);
            }
            this.parts.add(part);
        }
    }

    private void setupTicketProgressRow(Ticket ticket) {
        if (ticket != Ticket.Companion.getNULL()) {
            this.ticketProgressRow.setOnClick((Function0<Unit>)((Function0)() -> {
                Intent intent = new Intent(this.context, IntercomTicketActivity.class);
                this.context.startActivity(intent);
                return null;
            }));
            this.ticketProgressRow.setName(ticket.getTitle());
            this.ticketProgressRow.setStatus(ticket.getCurrentStatus().getTitle());
        }
    }

    private void showTicketProgressRowIfNeeded() {
        if (!this.ticketProgressRow.getName().equals("") && !this.ticketProgressRow.getVisible()) {
            this.ticketProgressRow.setVisible(true);
            this.addConversationListTopPadding();
        }
    }

    public void addConversationListTopPadding() {
        Resources resources = this.conversationList.getResources();
        int extraTopPadding = resources.getDimensionPixelSize(R.dimen.intercom_ticket_progress_row_padding);
        this.conversationList.setPadding(this.conversationList.getPaddingLeft(), this.conversationList.getPaddingTop() + extraTopPadding, this.conversationList.getPaddingRight(), this.conversationList.getPaddingBottom());
    }

    private boolean hasNonTicketParts(Conversation conversation) {
        Iterator<Part> iterator = conversation.getParts().iterator();
        boolean hasNonTicketParts = false;
        while (iterator.hasNext()) {
            Part nextPart = iterator.next();
            if (nextPart.getMessageStyle().equals("ticket_state_updated")) continue;
            hasNonTicketParts = true;
            break;
        }
        return hasNonTicketParts;
    }

    private int nonTicketPartsSize(Conversation conversation) {
        Iterator<Part> iterator = conversation.getParts().iterator();
        int size = 0;
        while (iterator.hasNext()) {
            Part nextPart = iterator.next();
            if (nextPart.getMessageStyle().equals("ticket_state_updated")) continue;
            ++size;
        }
        return size;
    }

    private Boolean hasTicket(Conversation conversation) {
        return conversation.getTicket() != Ticket.Companion.getNULL();
    }

    private void addBigTicketCard(Conversation conversation) {
        Block.Builder block = new Block.Builder();
        Part temporaryPart = new Part.Builder().withParticipantIsAdmin(true).withStyle("big_ticket").withBlocks(Collections.singletonList(block)).build();
        this.adapter.setTicket(conversation.getTicket());
        this.parts.add(temporaryPart);
    }

    private void setUpTopActionBar(@Nullable Conversation conversation) {
        ConversationHeader headerState2 = HeaderReducerKt.reduceHeader(conversation, this.appConfigProvider.get(), this.teamPresence, false);
        boolean isBotHeader = headerState2.getTeamPresenceState() instanceof TeamPresenceState.BotPresenceState;
        this.topActionBar.setAvatars(headerState2.getAvatars());
        this.topActionBar.setSubtitle(headerState2.getSubtitle());
        this.topActionBar.setSubtitleIcon(headerState2.getSubtitleIcon());
        this.topActionBar.setTitle(headerState2.getTitle());
        this.topActionBar.setAIBot(headerState2.isAIBot());
        this.topActionBar.setActive(headerState2.isActive());
        this.updateTopBarColors(isBotHeader);
    }

    void setUpTopActionBar() {
        this.setUpTopActionBar(null);
    }

    private void updateTopBarColors(boolean isBotHeader) {
        if (isBotHeader) {
            this.topActionBar.setBgColor("#FFFFFF");
            this.topActionBar.setContentColor("#1A1A1A");
            this.topActionBar.setSubtitleColor("#737373");
        } else {
            this.topActionBar.setBgColor(null);
            this.topActionBar.setContentColor(null);
            this.topActionBar.setSubtitleColor(null);
        }
        this.updateStatusBarColor.invoke((Object)isBotHeader);
    }

    void addTemporaryExpectationsBannerIfNeeded(Boolean shouldNotifyAdapter) {
        if (this.shouldShowTemporaryExpectationBanner()) {
            Block.Builder block = new Block.Builder().withText(this.appConfigProvider.get().getTemporaryExpectationsMessage());
            Part temporaryPart = new Part.Builder().withStyle("temporary_expectations_style").withBlocks(Collections.singletonList(block)).build();
            this.parts.add(0, temporaryPart);
            if (shouldNotifyAdapter.booleanValue()) {
                this.adapter.notifyItemInserted(0);
            }
        }
    }

    private boolean shouldShowTemporaryExpectationBanner() {
        ActiveBot activeBot = this.teamPresence.getActiveBot();
        boolean isBotHandlingNewConversations = activeBot != null && activeBot.getUseBotUx();
        String temporaryExpectationsMessage = this.appConfigProvider.get().getTemporaryExpectationsMessage();
        return !isBotHandlingNewConversations && !temporaryExpectationsMessage.isEmpty();
    }

    void addTeamPresencePart() {
        this.addTeamPresencePart(true, null);
    }

    void addTeamPresencePart(Boolean shouldNotifyAdapter, @Nullable Conversation conversation) {
        TeamPresenceState teamPresenceState = TeamPresenceReducer.INSTANCE.getTeamPresenceState(conversation, this.teamPresence, this.appConfigProvider.get());
        Part teamPresencePart = new Part.Builder().withStyle("team_presence_style").build();
        this.adapter.setTeamPresenceState(teamPresenceState);
        this.parts.add(teamPresencePart);
        if (shouldNotifyAdapter.booleanValue()) {
            this.adapter.notifyItemInserted(this.parts.indexOf(teamPresencePart));
        }
    }

    private void removeSendingPartsIfNeeded() {
        Iterator<Part> iterator = this.sendingParts.iterator();
        while (iterator.hasNext()) {
            Part sendingPart = iterator.next();
            if (sendingPart.getUpload() == null) {
                iterator.remove();
                continue;
            }
            this.parts.add(sendingPart);
        }
    }

    @Subscribe
    public void onUserContentSeenByAdmin(UserContentSeenByAdminEvent event) {
        if (event.getConversationId().equals(this.conversationId) && !this.parts.isEmpty()) {
            boolean markedAsSeen = false;
            for (int i = this.parts.size() - 1; i >= 0; --i) {
                Part part = this.parts.get(i);
                if (!markedAsSeen && !part.isAdmin()) {
                    part.setSeenByAdmin("seen");
                    markedAsSeen = true;
                    continue;
                }
                part.setSeenByAdmin("hide");
            }
            this.adapter.notifyDataSetChanged();
        }
    }

    public void cleanup() {
        this.conversationList.removeCallbacks(this.replyDeliveredUpdater);
    }

    @Subscribe
    public void newConversationSuccess(NewConversationEvent event) {
        if (!this.parts.isEmpty() && this.parts.get(this.parts.size() - 1).getId().equals(event.getPartId())) {
            this.onNewConversation(event);
            this.host.onConversationCreated(event.getConversation());
        }
    }

    @Subscribe
    public void newTriggerConversationSuccess(NewTriggerConversationEvent event) {
        this.updateSendPartOpsMetric();
        Conversation conversation = event.getConversation();
        this.conversationId = conversation.getId();
        this.parts.clear();
        this.sendingParts.clear();
        this.addTemporaryExpectationsBannerIfNeeded(false);
        this.addTeamPresencePart(false, conversation);
        for (int i = 0; i < conversation.getParts().size(); ++i) {
            this.addViewForPart(conversation.getParts().get(i));
            this.parts.add(conversation.getParts().get(i));
        }
        this.adapter.setConversationId(this.conversationId);
        this.adapter.notifyDataSetChanged();
        this.host.onConversationCreated(event.getConversation());
        this.store.dispatch(Actions.conversationMarkedAsRead(this.conversationId));
        this.nexusClient.fire(NexusEvent.getConversationSeenEvent((String)this.conversationId, (String)this.userIdentity.getIntercomId()));
    }

    @Override
    public void onQuickReplyClicked(Participant author, Part part, ReplyOption option) {
        Author.Builder authorBuilder = new Author.Builder();
        authorBuilder.withFirstName(author.getForename()).withName(author.getName()).withAvatar(author.getAvatar().getImageUrl());
        Block.Builder builder = new Block.Builder();
        builder.withText(option.text()).withAuthor(authorBuilder.build()).withType(BlockType.PARAGRAPH.getSerializedName());
        Block.Builder fakePart = builder;
        ArrayList<Block.Builder> fakeParts = new ArrayList<Block.Builder>();
        fakeParts.add(fakePart);
        Part sendingPart = this.addSendingPart(fakeParts);
        int partPosition = this.positionOfPart(this.parts.size() - 1, sendingPart.getId());
        this.api.addConversationQuickReply(this.conversationId, part, option.uuid(), partPosition, sendingPart.getId());
        this.metricTracker.clickedQuickReply(option.uuid(), this.conversationId, part.getId());
    }

    void playSoundForNewAdminPart(List<Part> newParts) {
        for (Part part : newParts) {
            if (!part.isAdmin()) continue;
            if (part.getParticipant().isBot().booleanValue()) {
                this.soundPlayer.playOperatorReceivedSound();
                break;
            }
            this.soundPlayer.playMessageReceivedSound();
            break;
        }
    }

    @Override
    public void onSuggestionClicked(Part part, Suggestion suggestion) {
        Block.Builder builder = new Block.Builder();
        builder.withText(suggestion.getText()).withType(BlockType.PARAGRAPH.getSerializedName());
        Block.Builder fakePart = builder;
        ArrayList<Block.Builder> fakeParts = new ArrayList<Block.Builder>();
        fakeParts.add(fakePart);
        Part sendingPart = this.addSendingPart(fakeParts);
        String uuid = UUID.randomUUID().toString();
        this.store.dispatch(Actions.composerSuggestionSelected(uuid));
        int partPosition = this.positionOfPart(this.parts.size() - 1, sendingPart.getId());
        this.api.triggerInboundCustomBot(sendingPart, suggestion.getUuid(), partPosition, uuid);
        this.metricTracker.clickedComposerSuggestion(suggestion.getUuid(), this.conversationId, part.getId());
    }

    public void addBotIntro() {
        this.botIntro = this.store.state().botIntroState().getBotIntro();
        int currentSize = this.parts.size();
        if (!BotIntro.BOT_INTRO_NULL.equals(this.botIntro)) {
            ArrayList<Part> botIntroParts = new ArrayList<Part>();
            List<List<Block.Builder>> botIntroBlocks = this.botIntro.getBlocks();
            for (int i = 0; i < botIntroBlocks.size(); ++i) {
                List<Block.Builder> block = botIntroBlocks.get(i);
                Part part = new Part.Builder().withBlocks(block).withCreatedAt(Injector.get().getTimeProvider().currentTimeMillis() + (long)i).build();
                part.setParticipant(this.botIntro.getBuiltParticipant());
                botIntroParts.add(part);
            }
            this.parts.addAll(botIntroParts);
            for (Part part : botIntroParts) {
                this.addViewForPart(part);
            }
            if (this.parts.size() > currentSize) {
                this.adapter.notifyItemRangeInserted(currentSize, this.parts.size() - currentSize);
            }
        }
    }

    static interface Host {
        public Conversation getConversation();

        public String getConversationId();

        public void onConversationCreated(Conversation var1);

        public void onFormSubmitted();
    }
}

