/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.GradientDrawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import com.intercom.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Attribute;
import io.intercom.android.sdk.models.ConfigModules;
import io.intercom.android.sdk.models.CountryAreaCode;
import io.intercom.android.sdk.models.CustomizationColorsModel;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.PhoneNumberValidator;
import io.intercom.android.sdk.views.BaseAttributeView;
import io.intercom.android.sdk.views.holder.ConversationListener;
import io.intercom.android.sdk.views.holder.SubmitAttributeClickListener;
import java.util.Locale;

public class TextAttributeView
extends BaseAttributeView {
    private static final String SAMPLE_NUMBER = " 123 456 7890";
    private static final int PHONE_INPUT_INSET_DP = 46;
    @VisibleForTesting
    final TextView flagView = (TextView)this.findViewById(R.id.flag_view);
    @VisibleForTesting
    EditText attributeValueInput = (EditText)this.findViewById(R.id.attribute_input);
    @VisibleForTesting
    final ImageView verifiedTick;
    @VisibleForTesting
    ImageView submitButton = (ImageView)this.findViewById(R.id.attribute_submit);
    @VisibleForTesting
    final ProgressBar loadingView;

    public TextAttributeView(Context context) {
        this(context, null);
    }

    public TextAttributeView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.verifiedTick = (ImageView)this.findViewById(R.id.attribute_verified_tick);
        this.loadingView = (ProgressBar)this.findViewById(R.id.loading_view);
    }

    @Override
    public int getLayoutRes() {
        return R.layout.intercom_view_text_attribute;
    }

    public void setOnSubmitClickListener(String partId, ConversationListener conversationListener) {
        this.submitButton.setOnClickListener((View.OnClickListener)new SubmitAttributeClickListener(this, partId, conversationListener));
    }

    public void setOnSubmitListener(View.OnClickListener listener2) {
        this.submitButton.setOnClickListener(listener2);
    }

    public void setOnFocusChangeListener(View.OnFocusChangeListener onFocusChangeListener) {
        this.attributeValueInput.setOnFocusChangeListener(onFocusChangeListener);
    }

    public String getInputValue() {
        return this.attributeValueInput.getText().toString().trim();
    }

    public void setUpAttribute(Attribute attribute, Locale locale) {
        this.setAttribute(attribute);
        this.attributeValueInput.setInputType(1);
        this.attributeValueInput.setHint(null);
        this.attributeValueInput.setText((CharSequence)"");
        if ("email".equals(attribute.getRenderType())) {
            this.setUpEmailAttribute();
        } else if ("phone".equals(attribute.getRenderType())) {
            this.setUpPhoneAttribute(locale);
        } else if ("number".equals(attribute.getRenderType())) {
            this.setUpNumberAttribute();
        } else if ("float".equals(attribute.getRenderType())) {
            this.setUpFloatAttribute();
        }
        this.updateAttributeContent();
    }

    private void updateAttributeContent() {
        if (this.getAttribute().hasValue()) {
            this.displayVerifiedState();
        } else {
            this.displayEmptyState();
        }
    }

    public void updateSubmitButtonColor(AppConfig appConfig2) {
        int iconColor;
        int backgroundColor;
        ConfigModules modules = appConfig2.getConfigModules();
        if (modules != null) {
            CustomizationColorsModel actionColorsContrastWhite = modules.getCustomization().getActionContrastWhite();
            CustomizationColorsModel actionColors = actionColorsContrastWhite == null ? modules.getCustomization().getAction() : actionColorsContrastWhite;
            backgroundColor = Color.parseColor((String)actionColors.getBackgroundColor());
            iconColor = Color.parseColor((String)actionColors.getForegroundColor());
        } else {
            backgroundColor = -16777216;
            iconColor = -1;
        }
        this.submitButton.getBackground().setColorFilter(backgroundColor, PorterDuff.Mode.SRC_IN);
        ColorUtils.setImageSrcColor(this.submitButton, iconColor);
    }

    public void displayLoadingState() {
        this.updateTextInputStrokeColor(R.color.intercom_attribute_input_outline);
        this.loadingView.setVisibility(0);
        this.submitButton.setImageDrawable(null);
        this.hideErrorView();
    }

    @Override
    public void displayErrorState(String message) {
        this.updateTextInputStrokeColor(R.color.intercom_attribute_collector_error);
        this.setError(message);
        this.submitButton.setImageResource(R.drawable.intercom_attribute_submit_arrow);
        this.loadingView.setVisibility(8);
    }

    @Override
    public void displayEmptyState() {
        this.updateTextInputStrokeColor(R.color.intercom_attribute_input_outline);
        this.attributeValueInput.setEnabled(true);
        this.submitButton.setImageResource(R.drawable.intercom_attribute_submit_arrow);
        this.submitButton.setVisibility(0);
        this.verifiedTick.setVisibility(8);
        this.hideErrorView();
    }

    private void displayVerifiedState() {
        this.attributeValueInput.setText((CharSequence)this.getAttribute().getValue());
        this.attributeValueInput.setEnabled(false);
        this.attributeValueInput.setKeyListener(null);
        this.submitButton.setVisibility(8);
        this.verifiedTick.setVisibility(0);
        this.loadingView.setVisibility(8);
        this.updateTextInputStrokeColor(R.color.intercom_attribute_input_outline);
        this.hideErrorView();
    }

    private void updateTextInputStrokeColor(@ColorRes int colorRes) {
        Context context = this.attributeValueInput.getContext();
        int errorColor = ContextCompat.getColor((Context)context, (int)colorRes);
        GradientDrawable drawable2 = (GradientDrawable)this.attributeValueInput.getBackground();
        drawable2.setStroke(ScreenUtils.dpToPx((float)1.0f, (Context)context), errorColor);
    }

    private void setUpEmailAttribute() {
        this.attributeValueInput.setInputType(32);
        this.attributeValueInput.setHint((CharSequence)"email@domain.com");
    }

    private void setUpNumberAttribute() {
        this.attributeValueInput.setInputType(4098);
    }

    private void setUpFloatAttribute() {
        this.attributeValueInput.setInputType(12290);
    }

    private void setUpPhoneAttribute(Locale locale) {
        this.attributeValueInput.setInputType(3);
        PhoneNumberValidator.loadCountryAreaCodes(this.getContext());
        CountryAreaCode countryAreaCode = PhoneNumberValidator.getCountryAreaCodeFromLocale(locale.getCountry());
        if (countryAreaCode.equals(CountryAreaCode.UNKNOWN)) {
            this.attributeValueInput.setHint((CharSequence)"+1 123 456 7890");
        } else {
            String prefix = "+" + countryAreaCode.getDialCode();
            this.attributeValueInput.setHint((CharSequence)(prefix + SAMPLE_NUMBER));
            this.attributeValueInput.setText((CharSequence)prefix);
        }
        this.updateFlag(countryAreaCode);
    }

    private void updateFlag(CountryAreaCode countryAreaCode) {
        this.flagView.setVisibility(0);
        this.flagView.setText((CharSequence)countryAreaCode.getEmoji());
        this.attributeValueInput.setPadding(ScreenUtils.dpToPx((float)46.0f, (Context)this.getContext()), this.attributeValueInput.getPaddingTop(), this.attributeValueInput.getPaddingRight(), this.attributeValueInput.getPaddingBottom());
        this.attributeValueInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable text) {
                String number = PhoneNumberValidator.normalizeNumber(text.toString());
                number = PhoneNumberValidator.stripPrefix(number);
                CountryAreaCode typingCode = PhoneNumberValidator.getCountryAreaCodeFromNumber(number);
                TextAttributeView.this.flagView.setText((CharSequence)typingCode.getEmoji());
            }
        });
    }
}

