/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import androidx.activity.ComponentActivity;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014J\b\u0010\f\u001a\u00020\u0004H\u0014\u00a8\u0006\r"}, d2={"Lio/intercom/android/sdk/activities/IntercomBaseComponentActivity;", "Landroidx/activity/ComponentActivity;", "()V", "attachBaseContext", "", "newBase", "Landroid/content/Context;", "localizedContext", "context", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "intercom-sdk-base_release"})
public abstract class IntercomBaseComponentActivity
extends ComponentActivity {
    protected void attachBaseContext(@NotNull Context newBase) {
        Intrinsics.checkNotNullParameter((Object)newBase, (String)"newBase");
        super.attachBaseContext(this.localizedContext(newBase));
    }

    private final Context localizedContext(Context context) {
        AppConfig appConfig = Injector.get().getAppConfigProvider().get();
        Configuration localisedConfiguration = new Configuration(context.getResources().getConfiguration());
        Locale newLocale = ContextLocaliser.convertToLocale(appConfig.getLocale());
        localisedConfiguration.setLocale(newLocale);
        Context context2 = context.createConfigurationContext(localisedConfiguration);
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.createConfigurat\u2026t(localisedConfiguration)");
        return context2;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector.get().getActivityFinisher().register((Activity)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        Injector.get().getActivityFinisher().unregister((Activity)this);
    }
}

