/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.tickets;

import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.tickets.TicketDetailReducerKt;
import io.intercom.android.sdk.tickets.TicketDetailState;
import io.intercom.android.sdk.tickets.TicketDetailViewModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 BA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\b\u0010\u001f\u001a\u00020\u001cH\u0014R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/intercom/android/sdk/tickets/TicketDetailViewModel;", "Landroidx/lifecycle/ViewModel;", "ticket", "Lio/intercom/android/sdk/models/Ticket;", "conversationId", "", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "user", "Lio/intercom/android/sdk/identity/UserIdentity;", "bus", "Lcom/squareup/otto/Bus;", "metricTracker", "Lio/intercom/android/sdk/metrics/MetricTracker;", "(Lio/intercom/android/sdk/models/Ticket;Ljava/lang/String;Lio/intercom/android/sdk/models/TeamPresence;Lio/intercom/android/sdk/identity/UserIdentity;Lcom/squareup/otto/Bus;Lio/intercom/android/sdk/metrics/MetricTracker;)V", "_stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/intercom/android/sdk/tickets/TicketDetailState;", "activeAdminsAvatars", "", "Lio/intercom/android/sdk/m5/components/avatar/AvatarWrapper;", "getActiveAdminsAvatars", "()Ljava/util/List;", "stateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "conversationSuccess", "", "event", "Lio/intercom/android/sdk/models/events/ConversationEvent;", "onCleared", "Companion", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nTicketDetailViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TicketDetailViewModel.kt\nio/intercom/android/sdk/tickets/TicketDetailViewModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n1549#2:68\n1620#2,3:69\n*S KotlinDebug\n*F\n+ 1 TicketDetailViewModel.kt\nio/intercom/android/sdk/tickets/TicketDetailViewModel\n*L\n32#1:68\n32#1:69,3\n*E\n"})
public final class TicketDetailViewModel
extends ViewModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String conversationId;
    @NotNull
    private final TeamPresence teamPresence;
    @NotNull
    private final UserIdentity user;
    @NotNull
    private final Bus bus;
    @NotNull
    private final MetricTracker metricTracker;
    @NotNull
    private final MutableStateFlow<TicketDetailState> _stateFlow;
    @NotNull
    private final StateFlow<TicketDetailState> stateFlow;

    public TicketDetailViewModel(@NotNull Ticket ticket, @NotNull String conversationId, @NotNull TeamPresence teamPresence, @NotNull UserIdentity user, @NotNull Bus bus, @NotNull MetricTracker metricTracker) {
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        Intrinsics.checkNotNullParameter((Object)conversationId, (String)"conversationId");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)bus, (String)"bus");
        Intrinsics.checkNotNullParameter((Object)metricTracker, (String)"metricTracker");
        this.conversationId = conversationId;
        this.teamPresence = teamPresence;
        this.user = user;
        this.bus = bus;
        this.metricTracker = metricTracker;
        this._stateFlow = StateFlowKt.MutableStateFlow((Object)TicketDetailState.Initial.INSTANCE);
        this.stateFlow = (StateFlow)this._stateFlow;
        this._stateFlow.setValue((Object)TicketDetailReducerKt.computeTicketViewState(ticket, this.user, this.getActiveAdminsAvatars()));
        this.bus.register((Object)this);
        this.metricTracker.viewedTicketDetails(ticket.getTicketTypeId(), this.conversationId, ticket.getCurrentStatus().getType());
    }

    public /* synthetic */ TicketDetailViewModel(Ticket ticket, String string2, TeamPresence teamPresence, UserIdentity userIdentity, Bus bus, MetricTracker metricTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ticket = Injector.get().getStore().state().ticketLegacyState().getTicket();
        }
        if ((n & 2) != 0) {
            String string3 = Injector.get().getStore().state().activeConversationState().getConversationId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"get().store.state()\n    \u2026ionState().conversationId");
            string2 = string3;
        }
        if ((n & 4) != 0) {
            TeamPresence teamPresence2 = Injector.get().getStore().state().teamPresence();
            Intrinsics.checkNotNullExpressionValue((Object)teamPresence2, (String)"get().store.state().teamPresence()");
            teamPresence = teamPresence2;
        }
        if ((n & 8) != 0) {
            UserIdentity userIdentity2 = Injector.get().getUserIdentity();
            Intrinsics.checkNotNullExpressionValue((Object)userIdentity2, (String)"get().userIdentity");
            userIdentity = userIdentity2;
        }
        if ((n & 0x10) != 0) {
            Bus bus2 = Injector.get().getBus();
            Intrinsics.checkNotNullExpressionValue((Object)bus2, (String)"get().bus");
            bus = bus2;
        }
        if ((n & 0x20) != 0) {
            MetricTracker metricTracker2 = Injector.get().getMetricTracker();
            Intrinsics.checkNotNullExpressionValue((Object)metricTracker2, (String)"get().metricTracker");
            metricTracker = metricTracker2;
        }
        this(ticket, string2, teamPresence, userIdentity, bus, metricTracker);
    }

    @NotNull
    public final StateFlow<TicketDetailState> getStateFlow() {
        return this.stateFlow;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AvatarWrapper> getActiveAdminsAvatars() {
        void $this$mapTo$iv$iv;
        List<Participant> list = this.teamPresence.getActiveAdmins();
        Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence.activeAdmins");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Participant participant = (Participant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Avatar avatar = it.getAvatar();
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"it.avatar");
            Boolean bl2 = it.isBot();
            Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"it.isBot");
            collection.add(new AvatarWrapper(avatar, bl2, null, false, false, 28, null));
        }
        return (List)destination$iv$iv;
    }

    @Subscribe
    public final void conversationSuccess(@NotNull ConversationEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)event.getResponse().getId(), (Object)this.conversationId)) {
            Ticket ticket = event.getResponse().getTicket();
            Intrinsics.checkNotNullExpressionValue((Object)ticket, (String)"event.response.ticket");
            this._stateFlow.setValue((Object)TicketDetailReducerKt.computeTicketViewState(ticket, this.user, this.getActiveAdminsAvatars()));
        }
    }

    protected void onCleared() {
        super.onCleared();
        this.bus.unregister((Object)this);
    }

    public TicketDetailViewModel() {
        this(null, null, null, null, null, null, 63, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003*\u0001\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\r\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lio/intercom/android/sdk/tickets/TicketDetailViewModel$Companion;", "", "()V", "create", "Lio/intercom/android/sdk/tickets/TicketDetailViewModel;", "owner", "Landroidx/lifecycle/ViewModelStoreOwner;", "factory", "io/intercom/android/sdk/tickets/TicketDetailViewModel$Companion$factory$1", "()Lio/intercom/android/sdk/tickets/TicketDetailViewModel$Companion$factory$1;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TicketDetailViewModel create(@NotNull ViewModelStoreOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return (TicketDetailViewModel)new ViewModelProvider(owner, (ViewModelProvider.Factory)this.factory()).get(TicketDetailViewModel.class);
        }

        private final factory.1 factory() {
            return new ViewModelProvider.Factory(){

                @NotNull
                public <T extends ViewModel> T create(@NotNull Class<T> modelClass) {
                    Intrinsics.checkNotNullParameter(modelClass, (String)"modelClass");
                    return (T)((Object)new TicketDetailViewModel(null, null, null, null, null, null, 63, null));
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

