/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.tickets;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.m5.components.avatar.AvatarWrapper;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.tickets.TicketDetailState;
import io.intercom.android.sdk.tickets.TicketStatus;
import io.intercom.android.sdk.tickets.TicketTimelineCardState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\f\u0010\r\u001a\u00020\n*\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u000b*\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"computeTicketViewState", "Lio/intercom/android/sdk/tickets/TicketDetailState$TicketDetailContentState;", "ticket", "Lio/intercom/android/sdk/models/Ticket;", "user", "Lio/intercom/android/sdk/identity/UserIdentity;", "activeAdminsAvatars", "", "Lio/intercom/android/sdk/m5/components/avatar/AvatarWrapper;", "isDone", "", "Lio/intercom/android/sdk/tickets/TicketStatus;", "currentTicketStatus", "isUnassignedOrBot", "Lio/intercom/android/sdk/models/Participant;", "toTicketStatus", "Lio/intercom/android/sdk/models/Ticket$Status;", "intercom-sdk-base_release"})
@SourceDebugExtension(value={"SMAP\nTicketDetailReducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TicketDetailReducer.kt\nio/intercom/android/sdk/tickets/TicketDetailReducerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,79:1\n1549#2:80\n1620#2,3:81\n766#2:84\n857#2,2:85\n*S KotlinDebug\n*F\n+ 1 TicketDetailReducer.kt\nio/intercom/android/sdk/tickets/TicketDetailReducerKt\n*L\n31#1:80\n31#1:81,3\n48#1:84\n48#1:85,2\n*E\n"})
public final class TicketDetailReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TicketDetailState.TicketDetailContentState computeTicketViewState(@NotNull Ticket ticket, @NotNull UserIdentity user, @NotNull List<AvatarWrapper> activeAdminsAvatars) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Ticket.TicketAttribute it;
        Collection<TicketTimelineCardState.ProgressSection> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(activeAdminsAvatars, (String)"activeAdminsAvatars");
        String string2 = ticket.getTitle();
        Participant participant = ticket.getAssignee().build();
        Intrinsics.checkNotNullExpressionValue((Object)participant, (String)"ticket.assignee.build()");
        if (TicketDetailReducerKt.isUnassignedOrBot(participant) && !((Collection)activeAdminsAvatars).isEmpty()) {
            list = CollectionsKt.take((Iterable)activeAdminsAvatars, (int)3);
        } else {
            Avatar avatar = ticket.getAssignee().build().getAvatar();
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"ticket.assignee.build().avatar");
            list = CollectionsKt.listOf((Object)new AvatarWrapper(avatar, false, null, false, false, 30, null));
        }
        Iterable iterable = ticket.getStatusList();
        long l = TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus()).getColor-0d7_KjU();
        String string3 = "";
        String string4 = ticket.getCurrentStatus().getStatusDetail();
        List list2 = list;
        String string5 = string2;
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Ticket.Status status = (Ticket.Status)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TicketTimelineCardState.ProgressSection(TicketDetailReducerKt.isDone(TicketDetailReducerKt.toTicketStatus((Ticket.Status)((Object)it)), TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus())), TicketDetailReducerKt.toTicketStatus((Ticket.Status)((Object)it)) == TicketStatus.WaitingOnCustomer ? (TicketTimelineCardState.ActualStringOrRes)new TicketTimelineCardState.ActualStringOrRes.StringRes(R.string.intercom_tickets_status_in_progress) : (TicketTimelineCardState.ActualStringOrRes)new TicketTimelineCardState.ActualStringOrRes.ActualString(((Ticket.Status)((Object)it)).getTitle()), TicketDetailReducerKt.toTicketStatus((Ticket.Status)((Object)it)) == TicketStatus.InProgress || TicketDetailReducerKt.toTicketStatus((Ticket.Status)((Object)it)) == TicketStatus.WaitingOnCustomer ? 0L : ((Ticket.Status)((Object)it)).getCreatedDate(), ((Ticket.Status)((Object)it)).isCurrentStatus()));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        Integer n = TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus()) == TicketStatus.WaitingOnCustomer ? Integer.valueOf(R.string.intercom_tickets_status_waiting_on_you) : null;
        Collection<TicketTimelineCardState.ProgressSection> collection2 = collection;
        long l2 = l;
        String string6 = string3;
        String string7 = string4;
        List list3 = list2;
        $this$map$iv = ticket.getAttributes();
        TicketTimelineCardState ticketTimelineCardState = new TicketTimelineCardState(list3, string7, string6, l2, (List)collection2, n, defaultConstructorMarker);
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Ticket.TicketAttribute)element$iv$iv;
            boolean bl = false;
            if (!it.hasValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list4 = (List)destination$iv$iv;
        String string8 = user.getEmail();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"user.email");
        String string9 = string8;
        List list5 = list4;
        TicketTimelineCardState ticketTimelineCardState2 = ticketTimelineCardState;
        String string10 = string5;
        return new TicketDetailState.TicketDetailContentState(string10, ticketTimelineCardState2, list5, string9);
    }

    public static /* synthetic */ TicketDetailState.TicketDetailContentState computeTicketViewState$default(Ticket ticket, UserIdentity userIdentity, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return TicketDetailReducerKt.computeTicketViewState(ticket, userIdentity, list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUnassignedOrBot(Participant $this$isUnassignedOrBot) {
        if (Intrinsics.areEqual((Object)$this$isUnassignedOrBot, (Object)Participant.create("", "", "user", "", Avatar.create("", ""), false))) return true;
        Boolean bl = $this$isUnassignedOrBot.isBot();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"this.isBot");
        if (bl == false) return false;
        return true;
    }

    public static final boolean isDone(@NotNull TicketStatus $this$isDone, @NotNull TicketStatus currentTicketStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isDone), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)currentTicketStatus), (String)"currentTicketStatus");
        return currentTicketStatus.ordinal() >= $this$isDone.ordinal();
    }

    @NotNull
    public static final TicketStatus toTicketStatus(@NotNull Ticket.Status $this$toTicketStatus) {
        TicketStatus ticketStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toTicketStatus, (String)"<this>");
        switch ($this$toTicketStatus.getType()) {
            case "submitted": {
                ticketStatus = TicketStatus.Submitted;
                break;
            }
            case "in_progress": {
                ticketStatus = TicketStatus.InProgress;
                break;
            }
            case "waiting_on_customer": {
                ticketStatus = TicketStatus.WaitingOnCustomer;
                break;
            }
            case "resolved": {
                ticketStatus = TicketStatus.Resolved;
                break;
            }
            default: {
                ticketStatus = TicketStatus.Submitted;
            }
        }
        return ticketStatus;
    }
}

