/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.Window;
import androidx.annotation.VisibleForTesting;
import androidx.fragment.app.Fragment;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.activities.IntercomConversationActivity;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.helpcenter.articles.ArticleStatsArguments;
import io.intercom.android.sdk.models.ConfigModules;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ApplyStatusBarColorKt;
import io.intercom.android.sdk.utilities.ColorUtils;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0012\u0010\u000f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016R?\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/intercom/android/sdk/activities/IntercomConversationActivity;", "Lio/intercom/android/sdk/activities/IntercomBaseActivity;", "Lio/intercom/android/sdk/conversation/ConversationFragment$Listener;", "()V", "store", "Lio/intercom/android/sdk/store/Store;", "Lio/intercom/android/sdk/state/State;", "kotlin.jvm.PlatformType", "getStore", "()Lio/intercom/android/sdk/store/Store;", "store$delegate", "Lkotlin/Lazy;", "onBackClicked", "", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onStartAnotherConversation", "closedConversationId", "", "onToolbarCloseClicked", "Companion", "intercom-sdk-base_release"})
public final class IntercomConversationActivity
extends IntercomBaseActivity
implements ConversationFragment.Listener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy store$delegate = LazyKt.lazy((Function0)store.2.INSTANCE);
    @NotNull
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    @NotNull
    private static final String PARCEL_INITIAL_MESSAGE = "parcel_initial_message";
    @NotNull
    private static final String SHOW_HOME_SCREEN = "showHomeScreen";
    @NotNull
    private static final String SHOW_INBOX = "showInbox";
    @NotNull
    private static final String ARTICLE_ARGS = "articleArgs";
    @NotNull
    private static final String LAST_PARTICIPANT = "last_participant";

    private final Store<State> getStore() {
        Lazy lazy = this.store$delegate;
        return (Store)lazy.getValue();
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Bundle data;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_conversation_view);
        ConfigModules configModules = Injector.get().getAppConfigProvider().get().getConfigModules();
        if (configModules != null) {
            ConfigModules it = configModules;
            boolean bl = false;
            Window window = this.getWindow();
            Intrinsics.checkNotNullExpressionValue((Object)window, (String)"window");
            ApplyStatusBarColorKt.applyStatusBarColor(window, ColorUtils.parseColor(it.getCustomization().getHeader().getBackgroundColor()));
        }
        Bundle bundle = data = this.getIntent().getExtras();
        Intrinsics.checkNotNull((Object)bundle);
        bundle.setClassLoader(Part.class.getClassLoader());
        String conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
        LastParticipatingAdmin lastParticipatingAdmin = data.containsKey(LAST_PARTICIPANT) ? (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT) : null;
        String initialMessage = data.getString(PARCEL_INITIAL_MESSAGE, "");
        ArticleStatsArguments articleArgs = data.containsKey(ARTICLE_ARGS) ? (ArticleStatsArguments)data.getParcelable(ARTICLE_ARGS) : null;
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, (Fragment)ConversationFragment.newInstance(conversationId, lastParticipatingAdmin, false, initialMessage, CollectionsKt.emptyList(), "", articleArgs)).commit();
        this.overridePendingTransition(R.anim.intercom_fade_in, R.anim.intercom_fade_out);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.overridePendingTransition(R.anim.intercom_fade_in, R.anim.intercom_fade_out);
    }

    @Override
    public void onToolbarCloseClicked() {
        this.onBackPressed();
    }

    @Override
    public void onBackClicked() {
        this.onBackPressed();
    }

    @Override
    public void onStartAnotherConversation(@NotNull String closedConversationId) {
        Intrinsics.checkNotNullParameter((Object)closedConversationId, (String)"closedConversationId");
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, (Fragment)ConversationFragment.newInstance("", LastParticipatingAdmin.NULL, false, "", CollectionsKt.emptyList(), closedConversationId, null)).commit();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004J\u0016\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001c\u0010\t\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\u0006R\u001c\u0010\f\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lio/intercom/android/sdk/activities/IntercomConversationActivity$Companion;", "", "()V", "ARTICLE_ARGS", "", "getARTICLE_ARGS", "()Ljava/lang/String;", "LAST_PARTICIPANT", "getLAST_PARTICIPANT", "PARCEL_CONVERSATION_ID", "getPARCEL_CONVERSATION_ID$annotations", "getPARCEL_CONVERSATION_ID", "PARCEL_INITIAL_MESSAGE", "getPARCEL_INITIAL_MESSAGE$annotations", "getPARCEL_INITIAL_MESSAGE", "SHOW_HOME_SCREEN", "getSHOW_HOME_SCREEN", "SHOW_INBOX", "getSHOW_INBOX", "openComposer", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "initialMessage", "openComposerFromArticle", "articleArgs", "Lio/intercom/android/sdk/helpcenter/articles/ArticleStatsArguments;", "openConversation", "conversationId", "lastParticipatingAdmin", "Lio/intercom/android/sdk/models/LastParticipatingAdmin;", "intercom-sdk-base_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPARCEL_CONVERSATION_ID() {
            return PARCEL_CONVERSATION_ID;
        }

        @VisibleForTesting
        public static /* synthetic */ void getPARCEL_CONVERSATION_ID$annotations() {
        }

        @NotNull
        public final String getPARCEL_INITIAL_MESSAGE() {
            return PARCEL_INITIAL_MESSAGE;
        }

        @VisibleForTesting
        public static /* synthetic */ void getPARCEL_INITIAL_MESSAGE$annotations() {
        }

        @NotNull
        public final String getSHOW_HOME_SCREEN() {
            return SHOW_HOME_SCREEN;
        }

        @NotNull
        public final String getSHOW_INBOX() {
            return SHOW_INBOX;
        }

        @NotNull
        public final String getARTICLE_ARGS() {
            return ARTICLE_ARGS;
        }

        @NotNull
        public final String getLAST_PARTICIPANT() {
            return LAST_PARTICIPANT;
        }

        @NotNull
        public final Intent openConversation(@NotNull Context context, @Nullable String conversationId, @Nullable LastParticipatingAdmin lastParticipatingAdmin) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent intent = new Intent(context, IntercomConversationActivity.class).setFlags(0x10000000).putExtra(this.getSHOW_INBOX(), false);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, Intercom\u2026tExtra(SHOW_INBOX, false)");
            Intent intent2 = intent;
            if (!TextUtils.isEmpty((CharSequence)conversationId)) {
                intent2.putExtra(this.getPARCEL_CONVERSATION_ID(), conversationId);
            }
            if (!LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
                intent2.putExtra(this.getLAST_PARTICIPANT(), (Parcelable)lastParticipatingAdmin);
            }
            intent2.setExtrasClassLoader(LastParticipatingAdmin.class.getClassLoader());
            return intent2;
        }

        @NotNull
        public final Intent openComposer(@NotNull Context context, @NotNull String initialMessage) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)initialMessage, (String)"initialMessage");
            Intent intent = new Intent(context, IntercomConversationActivity.class).setFlags(0x10000000).putExtra(this.getSHOW_INBOX(), false);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(context, Intercom\u2026tExtra(SHOW_INBOX, false)");
            Intent intent2 = intent;
            if (!TextUtils.isEmpty((CharSequence)initialMessage)) {
                intent2.putExtra(this.getPARCEL_INITIAL_MESSAGE(), initialMessage);
            }
            return intent2;
        }

        @NotNull
        public final Intent openComposerFromArticle(@NotNull Context context, @NotNull ArticleStatsArguments articleArgs) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)articleArgs, (String)"articleArgs");
            Intent $this$openComposerFromArticle_u24lambda_u240 = intent = new Intent(context, IntercomConversationActivity.class);
            boolean bl = false;
            $this$openComposerFromArticle_u24lambda_u240.setFlags(0x10000000);
            $this$openComposerFromArticle_u24lambda_u240.putExtra(Companion.getARTICLE_ARGS(), (Parcelable)articleArgs);
            $this$openComposerFromArticle_u24lambda_u240.putExtra(Companion.getSHOW_INBOX(), false);
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

