/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.conversation.reducers.TeamPresenceReducer;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.m5.conversation.states.ConversationHeader;
import io.intercom.android.sdk.m5.conversation.utils.ConversationExtensionsKt;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.views.holder.TeamPresenceState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"reduceHeader", "Lio/intercom/android/sdk/m5/conversation/states/ConversationHeader;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "appConfig", "Lio/intercom/android/sdk/identity/AppConfig;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "intercom-sdk-base_release"})
public final class HeaderReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConversationHeader reduceHeader(@NotNull ConversationClientState clientState, @NotNull AppConfig appConfig, @NotNull TeamPresence teamPresence) {
        ConversationHeader conversationHeader;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)appConfig, (String)"appConfig");
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Conversation conversation = clientState.getConversation();
        if (conversation == null) {
            String string2 = appConfig.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"appConfig.name");
            conversationHeader = new ConversationHeader(string2, null, null, null, false, 0, null, TeamPresenceReducer.INSTANCE.getTeamPresenceState(null, teamPresence, appConfig), 126, null);
        } else {
            ConversationHeader.TicketProgressRowState ticketProgressRowState;
            List<Participant> list = conversation.getGroupConversationParticipants();
            Intrinsics.checkNotNullExpressionValue(list, (String)"conversation.groupConversationParticipants");
            int altParticipants = ((Collection)list).size();
            LastParticipatingAdmin lastParticipatingAdmin = conversation.getLastParticipatingAdmin();
            Intrinsics.checkNotNullExpressionValue((Object)lastParticipatingAdmin, (String)"conversation.lastParticipatingAdmin");
            LastParticipatingAdmin admin = lastParticipatingAdmin;
            ConversationHeader.TicketProgressRowState ticketProgressRowState2 = !Intrinsics.areEqual((Object)conversation.getTicket(), (Object)Ticket.Companion.getNULL()) && ConversationExtensionsKt.hasNonTicketParts(conversation) | !clientState.getPendingMessages().isEmpty() ? new ConversationHeader.TicketProgressRowState(conversation.getTicket().getTitle(), conversation.getTicket().getCurrentStatus().getTitle()) : (ticketProgressRowState = (ConversationHeader.TicketProgressRowState)null);
            if (LastParticipatingAdmin.isNull(admin)) {
                void $this$mapTo$iv$iv;
                String string3 = appConfig.getName();
                String string4 = teamPresence.getExpectedResponseDelayShortText();
                List<Participant> list2 = teamPresence.getActiveAdmins();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"teamPresence.activeAdmins");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Participant participant = (Participant)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getAvatar());
                }
                List list3 = (List)destination$iv$iv;
                int n = R.drawable.intercom_clock;
                TeamPresenceState teamPresenceState = TeamPresenceReducer.INSTANCE.getTeamPresenceState(conversation, teamPresence, appConfig);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                conversationHeader = new ConversationHeader(string3, string4, n, list3, false, altParticipants, ticketProgressRowState, teamPresenceState, 16, null);
            } else {
                String string5 = admin.getFirstName();
                boolean bl = admin.isActive();
                List list4 = CollectionsKt.listOf((Object)admin.getAvatar());
                TeamPresenceState teamPresenceState = TeamPresenceReducer.INSTANCE.getTeamPresenceState(conversation, teamPresence, appConfig);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"firstName");
                conversationHeader = new ConversationHeader(string5, null, null, list4, bl, altParticipants, ticketProgressRowState, teamPresenceState, 6, null);
            }
        }
        return conversationHeader;
    }
}

