/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Activity;
import com.intercom.composer.ComposerFragment;
import com.intercom.input.gallery.GalleryInput;
import io.intercom.android.sdk.Intercom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00040\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/intercom/android/sdk/utilities/ActivityUtils;", "", "()V", "COMPOSER_INPUT_PACKAGE_NAME", "", "kotlin.jvm.PlatformType", "COMPOSER_PACKAGE_NAME", "INTERCOM_PACKAGES", "", "[Ljava/lang/String;", "PACKAGE_NAME", "isHostActivity", "", "activity", "Landroid/app/Activity;", "isInHostAppPackage", "activityName", "intercom-sdk-base_release"})
public final class ActivityUtils {
    @NotNull
    public static final ActivityUtils INSTANCE = new ActivityUtils();
    private static final String PACKAGE_NAME = Intercom.class.getPackage().getName();
    private static final String COMPOSER_PACKAGE_NAME = ComposerFragment.class.getPackage().getName();
    private static final String COMPOSER_INPUT_PACKAGE_NAME = GalleryInput.class.getPackage().getName();
    @NotNull
    private static final String[] INTERCOM_PACKAGES;

    private ActivityUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isHostActivity(@Nullable Activity activity) {
        if (activity == null) return false;
        String string2 = activity.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.javaClass.name");
        if (!INSTANCE.isInHostAppPackage(string2)) return false;
        return true;
    }

    private final boolean isInHostAppPackage(String activityName) {
        for (String packageName : INTERCOM_PACKAGES) {
            Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
            if (!StringsKt.startsWith$default((String)activityName, (String)packageName, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    static {
        String[] stringArray = new String[]{PACKAGE_NAME, COMPOSER_PACKAGE_NAME, COMPOSER_INPUT_PACKAGE_NAME};
        INTERCOM_PACKAGES = stringArray;
    }
}

