/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.intercom.twig.Twig;
import com.squareup.otto.Bus;
import com.squareup.otto.Subscribe;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomCarouselActivity;
import io.intercom.android.sdk.activities.IntercomConversationActivity;
import io.intercom.android.sdk.activities.IntercomNoteActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.m5.ConversationScreenOpenerKt;
import io.intercom.android.sdk.m5.IntercomRootActivityLauncher;
import io.intercom.android.sdk.m5.IntercomScreenScenario;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.carousel.Carousel;
import io.intercom.android.sdk.models.events.ConfigUpdateEvent;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.DefaultLauncherPresenter;
import io.intercom.android.sdk.overlay.InAppNotificationPresenter;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.survey.model.SurveyData;
import io.intercom.android.sdk.survey.ui.IntercomSurveyActivity;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.ViewUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OverlayPresenter
implements InAppNotificationPresenter.Listener,
Store.Subscriber2<Integer, OverlayState> {
    final DefaultLauncherPresenter launcherPresenter;
    final InAppNotificationPresenter inAppNotificationPresenter;
    private final MetricTracker metricTracker;
    private final Store<State> store;
    private final Provider<AppConfig> appConfigProvider;
    private final Handler handler;
    private final UserIdentity userIdentity;
    private final Twig twig = LumberMill.getLogger();
    private final Set<String> viewedPartIds = new HashSet<String>();

    public OverlayPresenter(Application application, Bus bus, Store<State> store2, Provider<AppConfig> appConfigProvider2, MetricTracker metricTracker, UserIdentity userIdentity) {
        this.appConfigProvider = appConfigProvider2;
        this.store = store2;
        this.metricTracker = metricTracker;
        this.userIdentity = userIdentity;
        LayoutInflater inflater = LayoutInflater.from((Context)application);
        this.handler = new Handler(Looper.getMainLooper());
        this.inAppNotificationPresenter = new InAppNotificationPresenter(inflater, this.handler, this, metricTracker, appConfigProvider2, new ContextLocaliser(appConfigProvider2), this.hostActivity());
        LauncherOpenBehaviour launcherOpenBehaviour = new LauncherOpenBehaviour(store2, LauncherOpenBehaviour.LauncherType.DEFAULT, metricTracker, appConfigProvider2);
        this.launcherPresenter = new DefaultLauncherPresenter(inflater, launcherOpenBehaviour, metricTracker);
        bus.register((Object)this);
        store2.subscribeToChanges(Selectors.UNREAD_COUNT, Selectors.OVERLAY, this);
    }

    @Override
    public void onStateChange(Integer unreadCount, OverlayState overlayState) {
        Intercom.Visibility inAppVisibility = overlayState.notificationVisibility();
        Activity activity = overlayState.resumedHostActivity();
        List<Conversation> conversations = overlayState.conversations();
        SurveyData survey = overlayState.survey();
        Carousel carousel = overlayState.carousel();
        this.launcherPresenter.setBottomPadding(overlayState.bottomPadding());
        this.inAppNotificationPresenter.setBottomPadding(overlayState.bottomPadding());
        if (activity == null || activity.isFinishing() || activity.isDestroyed()) {
            return;
        }
        if (this.shouldDisplaySurvey(survey, activity)) {
            this.openSurvey(activity);
        } else if (this.shouldDisplayCarousel(carousel, activity)) {
            this.openCarousel(activity);
        } else if (this.shouldDisplayNotifications(conversations, inAppVisibility, activity)) {
            this.preloadAvatarThenDisplayNotifications(conversations, inAppVisibility, activity, this.userIdentity.getFingerprint());
        } else if (this.shouldDisplayLauncher(conversations, inAppVisibility, overlayState.launcherVisibility(), activity)) {
            ViewGroup root = this.getRootView(activity);
            ViewUtils.waitForViewAttachment((View)root, () -> {
                this.inAppNotificationPresenter.reset(root);
                this.launcherPresenter.setUnreadCount(unreadCount);
                this.launcherPresenter.displayLauncherOnAttachedRoot(root, this.appConfigProvider.get());
            });
        } else {
            this.removeOverlaysIfPresent(activity);
        }
    }

    public void softReset() {
        this.cancelAnimations();
        Activity hostActivity = this.hostActivity();
        if (hostActivity != null) {
            this.removeOverlaysIfPresent(hostActivity);
        }
    }

    @Subscribe
    public void configUpdated(ConfigUpdateEvent event) {
        OverlayState state = this.store.select(Selectors.OVERLAY);
        Activity hostActivity = state.resumedHostActivity();
        if (this.shouldDisplayLauncher(state.conversations(), state.notificationVisibility(), state.launcherVisibility(), hostActivity)) {
            ViewGroup root = this.getRootView(hostActivity);
            ViewUtils.waitForViewAttachment((View)root, () -> this.launcherPresenter.displayLauncherOnAttachedRoot(root, this.appConfigProvider.get()));
        } else {
            this.launcherPresenter.setLauncherBackgroundColor(this.appConfigProvider.get());
        }
    }

    public void cancelAnimations() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public void removeOverlaysIfPresent(Activity activity) {
        View root = activity.findViewById(R.id.intercom_overlay_root);
        activity.runOnUiThread(() -> {
            if (root != null) {
                this.launcherPresenter.removeLauncher();
                this.inAppNotificationPresenter.reset((ViewGroup)root);
                if (root.getParent() != null) {
                    ((ViewGroup)root.getParent()).removeView(root);
                }
            }
        });
    }

    void preloadAvatarThenDisplayNotifications(List<Conversation> conversations, Intercom.Visibility notificationVisibility, Activity activity, String fingerprint) {
        AvatarUtils.preloadAvatar(conversations.get(0).getLastAdmin().getAvatar(), () -> {
            if (fingerprint.equals(this.userIdentity.getFingerprint()) && this.shouldDisplayNotifications(conversations, notificationVisibility, activity)) {
                this.displayNotifications(conversations, activity);
            }
        }, activity);
    }

    void displayNotifications(final List<Conversation> conversations, Activity activity) {
        final ViewGroup rootView = this.getRootView(activity);
        Conversation conversation = conversations.get(0);
        String messageStyle = conversation.getLastPart().getMessageStyle();
        Part.DeliveryOption deliveryOption = conversation.getLastPart().getDeliveryOption();
        if (conversations.size() > 1 || this.inAppNotificationPresenter.isDisplaying() || deliveryOption == Part.DeliveryOption.SUMMARY || deliveryOption == Part.DeliveryOption.FULL && "chat".equals(messageStyle)) {
            if (this.launcherPresenter.isDisplaying()) {
                final DefaultLauncher defaultLauncher = this.launcherPresenter.getAndUnsetLauncher();
                if (conversations.size() == 1) {
                    defaultLauncher.pulseForTransformation((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                public void onAnimationEnd(Animator animation) {
                                    defaultLauncher.removeView();
                                }
                            });
                            OverlayPresenter.this.inAppNotificationPresenter.displayNotifications(rootView, conversations);
                        }
                    });
                } else {
                    defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.removeView();
                            OverlayPresenter.this.inAppNotificationPresenter.displayNotifications(rootView, conversations);
                        }
                    });
                }
            } else {
                this.inAppNotificationPresenter.displayNotifications(rootView, conversations);
            }
        } else if (deliveryOption == Part.DeliveryOption.FULL) {
            if ("post".equals(messageStyle)) {
                this.trackInAppView(conversation.getId(), conversation.getLastPart().getId(), 1);
                this.openPost(conversation);
            } else if ("note".equals(messageStyle)) {
                this.trackInAppView(conversation.getId(), conversation.getLastPart().getId(), 1);
                this.openNote(conversation);
            }
        }
    }

    @Override
    public ViewGroup getRootView() {
        Activity activity = this.hostActivity();
        if (activity == null) {
            throw new NullPointerException();
        }
        return this.getRootView(activity);
    }

    private ViewGroup getRootView(Activity activity) {
        ViewGroup root = (ViewGroup)activity.findViewById(R.id.intercom_overlay_root);
        if (root == null) {
            root = new FrameLayout((Context)activity);
            root.setClipChildren(false);
            root.setClipToPadding(false);
            root.setFitsSystemWindows(true);
            root.setId(R.id.intercom_overlay_root);
            activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 80));
        }
        return root;
    }

    @Override
    public void markAsDismissed(Conversation conversation) {
        this.store.dispatch(Actions.conversationMarkedAsDismissed(conversation));
    }

    @Override
    public void openNotification(Conversation conversation) {
        Part lastPart = conversation.getLastAdminPart();
        String messageStyle = lastPart.getMessageStyle();
        if ("post".equals(messageStyle)) {
            this.trackInAppView(conversation.getId(), conversation.getLastPart().getId(), 0);
            this.openPost(conversation);
        } else if ("note".equals(messageStyle)) {
            this.trackInAppView(conversation.getId(), conversation.getLastPart().getId(), 0);
            this.openNote(conversation);
        } else {
            this.openMessenger(conversation);
            if ("chat".equals(messageStyle) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption()) {
                this.metricTracker.openedConversationFromFull(conversation.getId(), lastPart.getId());
            } else {
                this.metricTracker.openedConversationFromSnippet(conversation.getId(), lastPart.getId());
            }
        }
    }

    private void openMessenger(Conversation conversation) {
        Activity activity = this.hostActivity();
        if (activity != null) {
            TaskStackBuilder stackBuilderInstance = TaskStackBuilder.create((Context)activity);
            stackBuilderInstance.addNextIntent(activity.getIntent());
            stackBuilderInstance.addNextIntent(IntercomRootActivityLauncher.INSTANCE.getIntentForScenario((Context)activity, IntercomScreenScenario.MessagesScreen.INSTANCE));
            if (ConversationScreenOpenerKt.getNewConversationScreenEnabled()) {
                stackBuilderInstance.addNextIntent(IntercomRootActivityLauncher.INSTANCE.getIntentForScenario((Context)activity, new IntercomScreenScenario.ConversationScreen(conversation.getId())));
            } else {
                stackBuilderInstance.addNextIntent(IntercomConversationActivity.Companion.openConversation((Context)activity, conversation.getId(), conversation.getLastParticipatingAdmin()));
            }
            stackBuilderInstance.startActivities();
        }
    }

    private void openPost(Conversation conversation) {
        Activity activity = this.hostActivity();
        if (activity != null) {
            activity.startActivity(IntercomPostActivity.buildPostIntent((Context)activity, conversation.getLastPart(), conversation.getId(), conversation.getLastParticipatingAdmin(), conversation.getComposerState().isVisible(), true));
        }
    }

    private void openNote(Conversation conversation) {
        try {
            Activity activity = this.hostActivity();
            if (activity != null) {
                activity.startActivity(IntercomNoteActivity.buildNoteIntent((Context)activity, conversation.getLastPart(), conversation.getId(), conversation.getLastParticipatingAdmin(), conversation.getComposerState().isVisible()));
            }
        }
        catch (IllegalArgumentException e) {
            this.twig.internal("Overlay", "Error loading the note " + e.getMessage());
        }
    }

    private void openSurvey(@NonNull Activity activity) {
        activity.startActivity(IntercomSurveyActivity.buildIntent((Context)activity));
    }

    private void openCarousel(@NonNull Activity activity) {
        activity.startActivity(new Intent((Context)activity, IntercomCarouselActivity.class));
    }

    @Nullable
    private Activity hostActivity() {
        return this.store.select(Selectors.OVERLAY).resumedHostActivity();
    }

    private void trackInAppView(String conversationId, String partId, @MetricTracker.InAppMessageViewContext int context) {
        if (this.viewedPartIds.contains(partId)) {
            return;
        }
        this.viewedPartIds.add(partId);
        this.metricTracker.viewedInApp(conversationId, partId, context);
    }

    @VisibleForTesting
    boolean shouldDisplaySurvey(SurveyData survey, @Nullable Activity hostActivity) {
        return !SurveyData.Companion.getNULL().equals(survey) && !this.userIdentity.isSoftReset() && hostActivity != null;
    }

    @VisibleForTesting
    boolean shouldDisplayCarousel(Carousel carousel, @Nullable Activity hostActivity) {
        return !Carousel.NULL.equals(carousel) && !this.userIdentity.isSoftReset() && hostActivity != null;
    }

    boolean shouldDisplayNotifications(List<Conversation> conversations, Intercom.Visibility notificationVisibility, @Nullable Activity hostActivity) {
        return notificationVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && !conversations.isEmpty() && hostActivity != null;
    }

    boolean shouldDisplayLauncher(List<Conversation> conversations, Intercom.Visibility notificationVisibility, Intercom.Visibility launcherVisibility, @Nullable Activity hostActivity) {
        if (notificationVisibility == Intercom.Visibility.VISIBLE) {
            for (Conversation c : conversations) {
                if (Part.DeliveryOption.BADGE == c.getLastPart().getDeliveryOption()) continue;
                return false;
            }
        }
        return launcherVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && this.userIdentity.identityExists() && this.appConfigProvider.get().isReceivedFromServer() && hostActivity != null;
    }

    public void refreshStateBecauseUserIdentityIsNotInStoreYet() {
        this.onStateChange(this.store.select(Selectors.UNREAD_COUNT), this.store.select(Selectors.OVERLAY));
    }
}

