/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import android.app.Application;
import android.content.Context;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.SocialAccount;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.GroupConversationTextFormatter;
import io.intercom.android.sdk.views.holder.GroupParticipants;
import io.intercom.android.sdk.views.holder.TeamPresenceState;
import io.intercom.android.sdk.views.holder.TeamPresenceViewHolderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lio/intercom/android/sdk/m5/conversation/reducers/TeamPresenceReducer;", "", "()V", "getGroupConversationAvatars", "", "Lio/intercom/android/sdk/models/Avatar;", "participants", "Lio/intercom/android/sdk/models/Participant;", "getGroupParticipants", "Lio/intercom/android/sdk/views/holder/GroupParticipants;", "conversation", "Lio/intercom/android/sdk/models/Conversation;", "getTeamPresenceState", "Lio/intercom/android/sdk/views/holder/TeamPresenceState;", "teamPresence", "Lio/intercom/android/sdk/models/TeamPresence;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "intercom-sdk-base_release"})
public final class TeamPresenceReducer {
    @NotNull
    public static final TeamPresenceReducer INSTANCE = new TeamPresenceReducer();

    private TeamPresenceReducer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TeamPresenceState getTeamPresenceState(@Nullable Conversation conversation, @NotNull TeamPresence teamPresence, @NotNull AppConfig config) {
        TeamPresenceState teamPresenceState;
        Intrinsics.checkNotNullParameter((Object)teamPresence, (String)"teamPresence");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (conversation == null || LastParticipatingAdmin.isNull(conversation.getLastParticipatingAdmin())) {
            void $this$mapTo$iv$iv;
            List<Participant> list = teamPresence.getActiveAdmins();
            Intrinsics.checkNotNullExpressionValue(list, (String)"teamPresence.activeAdmins");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Participant participant = (Participant)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getAvatar());
            }
            SocialAccount socialAccount = null;
            GroupParticipants groupParticipants = null;
            String string2 = null;
            String string3 = null;
            String string4 = config.getTeamProfileBio();
            String string5 = teamPresence.getExpectedResponseDelayLongText();
            List list2 = (List)destination$iv$iv;
            teamPresenceState = new TeamPresenceState(list2, string5, string4, string3, string2, groupParticipants, socialAccount);
        } else {
            LastParticipatingAdmin lastParticipatingAdmin = conversation.getLastParticipatingAdmin();
            if (lastParticipatingAdmin.isBot()) {
                Avatar avatar = lastParticipatingAdmin.getAvatar();
                Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"lastParticipatingAdmin.avatar");
                String string6 = lastParticipatingAdmin.getFirstName();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"lastParticipatingAdmin.firstName");
                String string7 = lastParticipatingAdmin.getIntro();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"lastParticipatingAdmin.intro");
                teamPresenceState = TeamPresenceViewHolderKt.getBotTeamPresence(avatar, string6, string7, this.getGroupParticipants(conversation));
            } else {
                Avatar avatar = lastParticipatingAdmin.getAvatar();
                Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"lastParticipatingAdmin.avatar");
                String string8 = lastParticipatingAdmin.getFirstName();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"lastParticipatingAdmin.firstName");
                String string9 = lastParticipatingAdmin.getJobTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"lastParticipatingAdmin.jobTitle");
                String string10 = lastParticipatingAdmin.getLocation().getCityName();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"lastParticipatingAdmin.location.cityName");
                String string11 = lastParticipatingAdmin.getLocation().getCountryName();
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"lastParticipatingAdmin.location.countryName");
                String string12 = lastParticipatingAdmin.getIntro();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"lastParticipatingAdmin.intro");
                teamPresenceState = TeamPresenceViewHolderKt.getAdminTeamPresence(avatar, string8, string9, string10, string11, string12, this.getGroupParticipants(conversation), lastParticipatingAdmin.getTwitter());
            }
        }
        return teamPresenceState;
    }

    private final GroupParticipants getGroupParticipants(Conversation conversation) {
        GroupParticipants groupParticipants = null;
        List<Participant> list = conversation.getGroupConversationParticipants();
        Intrinsics.checkNotNullExpressionValue(list, (String)"conversation.groupConversationParticipants");
        if (!((Collection)list).isEmpty()) {
            List<Participant> list2 = conversation.getGroupConversationParticipants();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"conversation.groupConversationParticipants");
            List<Avatar> list3 = this.getGroupConversationAvatars(list2);
            Application application = Injector.get().getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"get().application");
            Context context = (Context)application;
            List<Participant> list4 = conversation.getGroupConversationParticipants();
            Intrinsics.checkNotNullExpressionValue(list4, (String)"conversation.groupConversationParticipants");
            groupParticipants = new GroupParticipants(list3, ((Object)GroupConversationTextFormatter.groupConversationLabel(context, list4)).toString());
        }
        return groupParticipants;
    }

    private final List<Avatar> getGroupConversationAvatars(List<? extends Participant> participants) {
        List avatars = new ArrayList();
        for (Participant participant : participants) {
            Avatar avatar = participant.getAvatar();
            Intrinsics.checkNotNullExpressionValue((Object)avatar, (String)"participant.avatar");
            avatars.add(avatar);
        }
        return avatars;
    }
}

