/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.reducers;

import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.m5.conversation.states.ComposerUiState;
import io.intercom.android.sdk.m5.conversation.states.ConversationClientState;
import io.intercom.android.sdk.models.ComposerSuggestions;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.extensions.AppConfigExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"reduceComposerState", "Lio/intercom/android/sdk/m5/conversation/states/ComposerUiState;", "clientState", "Lio/intercom/android/sdk/m5/conversation/states/ConversationClientState;", "config", "Lio/intercom/android/sdk/identity/AppConfig;", "composerSuggestions", "Lio/intercom/android/sdk/models/ComposerSuggestions;", "intercom-sdk-base_release"})
public final class ComposerStateReducerKt {
    @NotNull
    public static final ComposerUiState reduceComposerState(@NotNull ConversationClientState clientState, @NotNull AppConfig config, @NotNull ComposerSuggestions composerSuggestions) {
        ComposerUiState composerUiState;
        Intrinsics.checkNotNullParameter((Object)clientState, (String)"clientState");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)composerSuggestions, (String)"composerSuggestions");
        Conversation conversation = clientState.getConversation();
        ComposerUiState.ConversationEnded conversationEndedState = new ComposerUiState.ConversationEnded(AppConfigExtensionsKt.canStartNewConversation(config));
        if (conversation == null) {
            composerUiState = composerSuggestions.isComposerDisabled() ? (ComposerUiState)ComposerUiState.Hidden.INSTANCE : clientState.getComposerUiState();
        } else {
            boolean hasReactions;
            boolean bl = hasReactions = !ReactionReply.isNull(conversation.getLastPart().getReactionReply());
            composerUiState = conversation.shouldPreventEndUserReplies() ? (ComposerUiState)conversationEndedState : (conversation.getComposerState().isVisible() && !hasReactions ? clientState.getComposerUiState() : (ComposerUiState)(hasReactions ? ComposerUiState.Hidden.INSTANCE : ComposerUiState.Hidden.INSTANCE));
        }
        return composerUiState;
    }
}

