/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.tickets;

import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.Ticket;
import io.intercom.android.sdk.survey.ui.questiontype.choice.SingleChoiceQuestionKt;
import io.intercom.android.sdk.tickets.TicketAttribute;
import io.intercom.android.sdk.tickets.TicketDetailState;
import io.intercom.android.sdk.tickets.TicketStatus;
import io.intercom.android.sdk.tickets.TicketTimelineCardState;
import io.intercom.android.sdk.utilities.TimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u001a\f\u0010\r\u001a\u00020\n*\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u000b*\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"computeTicketViewState", "Lio/intercom/android/sdk/tickets/TicketDetailState$TicketDetailContentState;", "ticket", "Lio/intercom/android/sdk/models/Ticket;", "user", "Lio/intercom/android/sdk/identity/UserIdentity;", "activeAdminsAvatars", "", "Lio/intercom/android/sdk/models/Avatar;", "isDone", "", "Lio/intercom/android/sdk/tickets/TicketStatus;", "currentTicketStatus", "isUnassignedOrBot", "Lio/intercom/android/sdk/models/Participant;", "toTicketStatus", "Lio/intercom/android/sdk/models/Ticket$Status;", "intercom-sdk-base_release"})
public final class TicketDetailReducerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final TicketDetailState.TicketDetailContentState computeTicketViewState(@NotNull Ticket ticket, @NotNull UserIdentity user, @NotNull List<? extends Avatar> activeAdminsAvatars) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Collection<TicketTimelineCardState.ProgressSection> collection;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)ticket, (String)"ticket");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter(activeAdminsAvatars, (String)"activeAdminsAvatars");
        String string2 = ticket.getTitle();
        Participant participant = ticket.getAssignee().build();
        Intrinsics.checkNotNullExpressionValue((Object)participant, (String)"ticket.assignee.build()");
        Iterable iterable = ticket.getStatusList();
        long l = TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus()).getColor-0d7_KjU();
        String string3 = "";
        String string4 = ticket.getCurrentStatus().getStatusDetail();
        List list = TicketDetailReducerKt.isUnassignedOrBot(participant) && !((Collection)activeAdminsAvatars).isEmpty() ? CollectionsKt.take((Iterable)activeAdminsAvatars, (int)3) : CollectionsKt.listOf((Object)ticket.getAssignee().build().getAvatar());
        String string5 = string2;
        boolean $i$f$map = false;
        void var5_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Ticket.Status)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new TicketTimelineCardState.ProgressSection(TicketDetailReducerKt.isDone(TicketDetailReducerKt.toTicketStatus((Ticket.Status)it), TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus())), TicketDetailReducerKt.toTicketStatus((Ticket.Status)it) == TicketStatus.WaitingOnCustomer ? (TicketTimelineCardState.ActualStringOrRes)new TicketTimelineCardState.ActualStringOrRes.StringRes(R.string.intercom_tickets_status_in_progress) : (TicketTimelineCardState.ActualStringOrRes)new TicketTimelineCardState.ActualStringOrRes.ActualString(it.getTitle()), TicketDetailReducerKt.toTicketStatus((Ticket.Status)it) == TicketStatus.InProgress || TicketDetailReducerKt.toTicketStatus((Ticket.Status)it) == TicketStatus.WaitingOnCustomer ? 0L : it.getCreatedDate(), it.isCurrentStatus()));
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        Integer n = TicketDetailReducerKt.toTicketStatus(ticket.getCurrentStatus()) == TicketStatus.WaitingOnCustomer ? Integer.valueOf(R.string.intercom_tickets_status_waiting_on_you) : null;
        Collection<TicketTimelineCardState.ProgressSection> collection2 = collection;
        long l2 = l;
        String string6 = string3;
        String string7 = string4;
        List list2 = list;
        $this$map$iv = ticket.getAttributes();
        TicketTimelineCardState ticketTimelineCardState = new TicketTimelineCardState(list2, string7, string6, l2, (List)collection2, n, defaultConstructorMarker);
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            TicketAttribute ticketAttribute;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            Ticket.TicketAttribute it = (Ticket.TicketAttribute)element$iv$iv;
            boolean bl2 = false;
            if (((CharSequence)it.getValue()).length() > 0) {
                TicketTimelineCardState.ActualStringOrRes actualStringOrRes;
                if (Intrinsics.areEqual((Object)it.getType(), (Object)"datetime")) {
                    String string8 = TimeFormatter.formatTimeInMillisAsDate(Long.parseLong(it.getValue()) * (long)1000, "dd-MM-yyy, HH:mm");
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"formatTimeInMillisAsDate\u20261000, \"dd-MM-yyy, HH:mm\")");
                    actualStringOrRes = new TicketTimelineCardState.ActualStringOrRes.ActualString(string8);
                } else {
                    actualStringOrRes = Intrinsics.areEqual((Object)it.getType(), (Object)"boolean") ? (TicketTimelineCardState.ActualStringOrRes)new TicketTimelineCardState.ActualStringOrRes.StringRes(SingleChoiceQuestionKt.booleanToQuestion(it.getValue())) : (TicketTimelineCardState.ActualStringOrRes)new TicketTimelineCardState.ActualStringOrRes.ActualString(it.getValue());
                }
                TicketTimelineCardState.ActualStringOrRes description = actualStringOrRes;
                ticketAttribute = new TicketAttribute(it.getName(), description);
            } else {
                ticketAttribute = null;
            }
            if (ticketAttribute == null) continue;
            TicketAttribute it$iv$iv = ticketAttribute;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        String string9 = user.getEmail();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"user.email");
        String string10 = string9;
        List list4 = list3;
        TicketTimelineCardState ticketTimelineCardState2 = ticketTimelineCardState;
        String string11 = string5;
        return new TicketDetailState.TicketDetailContentState(string11, ticketTimelineCardState2, list4, string10);
    }

    public static /* synthetic */ TicketDetailState.TicketDetailContentState computeTicketViewState$default(Ticket ticket, UserIdentity userIdentity, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return TicketDetailReducerKt.computeTicketViewState(ticket, userIdentity, list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUnassignedOrBot(Participant $this$isUnassignedOrBot) {
        if (Intrinsics.areEqual((Object)$this$isUnassignedOrBot, (Object)Participant.create("", "", "user", "", Avatar.create("", ""), false))) return true;
        Boolean bl = $this$isUnassignedOrBot.isBot();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"this.isBot");
        if (bl == false) return false;
        return true;
    }

    public static final boolean isDone(@NotNull TicketStatus $this$isDone, @NotNull TicketStatus currentTicketStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isDone), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)currentTicketStatus), (String)"currentTicketStatus");
        return currentTicketStatus.ordinal() >= $this$isDone.ordinal();
    }

    @NotNull
    public static final TicketStatus toTicketStatus(@NotNull Ticket.Status $this$toTicketStatus) {
        TicketStatus ticketStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toTicketStatus, (String)"<this>");
        switch ($this$toTicketStatus.getType()) {
            case "submitted": {
                ticketStatus = TicketStatus.Submitted;
                break;
            }
            case "in_progress": {
                ticketStatus = TicketStatus.InProgress;
                break;
            }
            case "waiting_on_customer": {
                ticketStatus = TicketStatus.WaitingOnCustomer;
                break;
            }
            case "resolved": {
                ticketStatus = TicketStatus.Resolved;
                break;
            }
            default: {
                ticketStatus = TicketStatus.Submitted;
            }
        }
        return ticketStatus;
    }
}

