/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.m5.conversation.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import androidx.exifinterface.media.ExifInterface;
import io.intercom.android.sdk.m5.conversation.ui.components.composer.MediaData;
import io.intercom.android.sdk.m5.conversation.utils.UtilsKt;
import io.intercom.android.sdk.utilities.TimeFormatterExtKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001aG\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010\u000b\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0011"}, d2={"buildImageDataFromCursor", "Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "queryUri", "selection", "", "selectionArgs", "", "(Landroid/content/Context;Landroid/net/Uri;Landroid/net/Uri;Ljava/lang/String;[Ljava/lang/String;)Lio/intercom/android/sdk/m5/conversation/ui/components/composer/MediaData$Media;", "isDownloadsDocument", "", "isGooglePhotosUri", "isMediaDocument", "getImageData", "intercom-sdk-base_release"})
public final class URIExtensionsKt {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final MediaData.Media getImageData(@NotNull Uri $this$getImageData, @NotNull Context context) {
        MediaData.Media media;
        Intrinsics.checkNotNullParameter((Object)$this$getImageData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (UtilsKt.isPhotoPickerAvailable()) {
            media = URIExtensionsKt.buildImageDataFromCursor$default(context, $this$getImageData, null, null, null, 28, null);
        } else if (URIExtensionsKt.isMediaDocument($this$getImageData)) {
            Uri uri;
            void $this$toTypedArray$iv;
            List list;
            String[] it;
            Collection $this$dropLastWhile$iv;
            String docId = DocumentsContract.getDocumentId((Uri)$this$getImageData);
            Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
            Object object = docId;
            Regex regex = new Regex(":");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    it = (String[])iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            String[] split = stringArray;
            if (Intrinsics.areEqual((Object)split[0], (Object)"video")) {
                Uri uri2 = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                uri = uri2;
                Intrinsics.checkNotNullExpressionValue((Object)uri2, (String)"EXTERNAL_CONTENT_URI");
            } else {
                Uri uri3 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                uri = uri3;
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"EXTERNAL_CONTENT_URI");
            }
            Uri contentUri = uri;
            String selection = "_id=?";
            it = new String[]{split[1]};
            String[] selectionArgs = it;
            media = URIExtensionsKt.buildImageDataFromCursor(context, $this$getImageData, contentUri, selection, selectionArgs);
        } else if (URIExtensionsKt.isGooglePhotosUri($this$getImageData)) {
            media = URIExtensionsKt.buildImageDataFromCursor$default(context, $this$getImageData, null, null, null, 28, null);
        } else {
            if (URIExtensionsKt.isDownloadsDocument($this$getImageData)) {
                MediaData.Media media2;
                MediaData.Media uploadImageData;
                String docId = DocumentsContract.getDocumentId((Uri)$this$getImageData);
                String filePath = null;
                if (docId != null && StringsKt.startsWith$default((String)docId, (String)"raw:", (boolean)false, (int)2, null)) {
                    String string2 = docId.substring(4);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    filePath = string2;
                }
                Uri contentUri = $this$getImageData;
                String selection = null;
                String[] selectionArgs = null;
                if (filePath == null) {
                    void $this$toTypedArray$iv;
                    List list;
                    Collection $this$dropLastWhile$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)docId, (String)"docId");
                    Object bl = docId;
                    Regex regex = new Regex(":");
                    int n = 0;
                    bl = regex.split((CharSequence)bl, n);
                    boolean $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            String it = (String)iterator$iv.previous();
                            boolean bl2 = false;
                            if (((CharSequence)it).length() == 0) continue;
                            list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        list = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = list;
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    String[] stringArray = thisCollection$iv.toArray(new String[0]);
                    Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    String[] split = stringArray;
                    Uri uri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"EXTERNAL_CONTENT_URI");
                    contentUri = uri;
                    selection = "_id=?";
                    String[] stringArray2 = new String[]{split[1]};
                    selectionArgs = stringArray2;
                }
                MediaData.Media media3 = uploadImageData = URIExtensionsKt.buildImageDataFromCursor(context, $this$getImageData, contentUri, selection, selectionArgs);
                if (media3 != null) {
                    MediaData.Media it = media3;
                    boolean bl = false;
                    if (filePath != null) {
                        return MediaData.Media.copy$default(it, 0, 0, null, 0, null, filePath, null, null, 223, null);
                    }
                    media2 = it;
                } else {
                    media2 = null;
                }
                return media2;
            }
            media = URIExtensionsKt.buildImageDataFromCursor$default(context, $this$getImageData, null, null, null, 28, null);
        }
        return media;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final MediaData.Media buildImageDataFromCursor(Context context, Uri uri, Uri queryUri, String selection, String[] selectionArgs) {
        MediaData.Media media;
        ContentResolver contentResolver = context.getContentResolver();
        Cursor cursor = contentResolver.query(queryUri, null, selection, selectionArgs, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                MediaData.Media media2;
                Cursor cursor2 = (Cursor)closeable;
                boolean bl = false;
                cursor2.moveToFirst();
                if (cursor2.getCount() <= 0) {
                    media2 = null;
                } else {
                    ExifInterface exif;
                    ExifInterface exifInterface;
                    InputStream inputStream;
                    String string2;
                    String string3;
                    if (cursor2.getColumnIndex("_display_name") != -1) {
                        string3 = cursor2.getString(cursor2.getColumnIndexOrThrow("_display_name"));
                    } else {
                        String string4 = uri.getPath();
                        Intrinsics.checkNotNull((Object)string4);
                        string3 = new File(string4).getName();
                    }
                    String fileName = string3;
                    String mimeType = cursor2.getString(cursor2.getColumnIndexOrThrow("mime_type"));
                    int size = cursor2.getInt(cursor2.getColumnIndexOrThrow("_size"));
                    if (cursor2.getColumnIndex("_data") != -1) {
                        string2 = cursor2.getString(cursor2.getColumnIndexOrThrow("_data"));
                    } else {
                        String string5 = uri.getPath();
                        string2 = string5;
                        Intrinsics.checkNotNull((Object)string5);
                    }
                    String filePath = string2;
                    InputStream inputStream2 = inputStream = contentResolver.openInputStream(uri);
                    if (inputStream2 != null) {
                        InputStream it = inputStream2;
                        boolean bl2 = false;
                        exifInterface = new ExifInterface(it);
                    } else {
                        exifInterface = null;
                    }
                    ExifInterface exifInterface2 = exif = exifInterface;
                    int width = exifInterface2 != null ? exifInterface2.getAttributeInt("ImageWidth", 640) : 640;
                    ExifInterface exifInterface3 = exif;
                    int height = exifInterface3 != null ? exifInterface3.getAttributeInt("ImageLength", 480) : 480;
                    long videoDurationInMs = cursor2.getLong(cursor2.getColumnIndexOrThrow("duration"));
                    String string6 = TimeFormatterExtKt.millisecondsToFormatTime(videoDurationInMs);
                    Intrinsics.checkNotNullExpressionValue((Object)mimeType, (String)"mimeType");
                    Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                    Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
                    media2 = new MediaData.Media(width, height, mimeType, size, fileName, filePath, uri, string6);
                }
                MediaData.Media media3 = media2;
                media = media3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            media = null;
        }
        return media;
    }

    static /* synthetic */ MediaData.Media buildImageDataFromCursor$default(Context context, Uri uri, Uri uri2, String string2, String[] stringArray, int n, Object object) {
        if ((n & 4) != 0) {
            uri2 = uri;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            stringArray = null;
        }
        return URIExtensionsKt.buildImageDataFromCursor(context, uri, uri2, string2, stringArray);
    }

    private static final boolean isMediaDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.media.documents", (Object)uri.getAuthority());
    }

    private static final boolean isGooglePhotosUri(Uri uri) {
        return Intrinsics.areEqual((Object)"com.google.android.apps.photos.contentprovider", (Object)uri.getAuthority());
    }

    private static final boolean isDownloadsDocument(Uri uri) {
        return Intrinsics.areEqual((Object)"com.android.providers.downloads.documents", (Object)uri.getAuthority());
    }
}

